/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.V3GetSalekhjeDao;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.request.SaleReturnIn;
import com.efuture.business.javaPos.struct.request.V3SaleGoodsDefReq;
import com.efuture.business.javaPos.struct.request.V3SaleHeadDefReq;
import com.efuture.business.javaPos.struct.request.V3SalePayDefReq;
import com.efuture.business.javaPos.struct.response.V3GetSalekhjeResp;
import com.efuture.business.javaPos.struct.response.V3SendSaleDataCRMResp;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.localize.CalcPopSaleBSImpl_WSLF;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcPopSaleBSImpl_ZZBH
extends CalcPopSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(CalcPopSaleBSImpl_ZZBH.class);
    @Resource
    V3GetSalekhjeDao v3GetSalekhjeDao;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;

    public RespBase saleReturn(ServiceSession session, ResqVo vo) {
        RespBase resp;
        CacheModel cacheModel = vo.getCacheModel();
        JSONObject paramsObject = vo.getJsonObject();
        SaleReturnIn salesReturnIn = (SaleReturnIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnIn.class);
        String obj = this.redisUtil.get(RedisKey.CACHEID + salesReturnIn.getShopCode() + salesReturnIn.getTerminalNo());
        obj = this.reCacheMode(obj, paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List sysparaOut = modeDetailsVo.getSyspara();
        String thMode = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"KHTH");
        String khPayCode = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"V3Q3");
        String v3jygs = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)khPayCode) || StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        V3SaleHeadDefReq saleHead = this.AssemblySaleHeadDef(cacheModel.getOrder(), cacheModel.getSyjmain().getSyjgroup());
        saleHead.setJygs(v3jygs);
        saleHead.setBc(Character.valueOf('#'));
        saleHead.setMkt(cacheModel.getOrder().getOriginShopCode());
        List saleGoods = this.getSaleGoodsFromCacheMode(cacheModel, saleHead);
        List salePayment = this.getSalePaymentsFromCacheMode(cacheModel);
        JSONObject saleHeadjson = (JSONObject)JSONObject.toJSON((Object)saleHead);
        JSONArray saleGoodsjson = (JSONArray)JSONArray.toJSON((Object)saleGoods);
        JSONArray salePaymentjson = (JSONArray)JSONArray.toJSON((Object)salePayment);
        JSONObject json = new JSONObject();
        json.put("salehead", (Object)saleHeadjson.toString());
        json.put("salegoods", (Object)saleGoodsjson.toString());
        json.put("salepayment", (Object)salePaymentjson.toString());
        V3SendSaleDataCRMResp v3SendSaleDataCRMResp = this.v3GetSalekhjeDao.sendSaleDataCRMResp(json.toString(), saleHead.getFlow_no());
        if (v3SendSaleDataCRMResp.getRecode() != 0) {
            return Code.CODE_30128.getRespBase(new Object[]{"retcode:" + v3SendSaleDataCRMResp.getRecode() + "," + v3SendSaleDataCRMResp.getRemsg()});
        }
        JSONObject jsonGetSaleKhje = new JSONObject();
        jsonGetSaleKhje.put("mkt", (Object)saleHead.mkt);
        jsonGetSaleKhje.put("jygs", (Object)saleHead.getJygs());
        jsonGetSaleKhje.put("syjh", (Object)saleHead.getSyjh());
        jsonGetSaleKhje.put("fphm", (Object)saleHead.fphm);
        jsonGetSaleKhje.put("flowNo", (Object)saleHead.getFlow_no());
        V3GetSalekhjeResp v3GetSalekhjeResp = this.v3GetSalekhjeDao.getSalekhje(jsonGetSaleKhje);
        if (v3GetSalekhjeResp.getRecode() != 0) {
            return Code.CODE_30129.getRespBase(new Object[]{"retcode:" + v3SendSaleDataCRMResp.getRecode() + "," + v3GetSalekhjeResp.getRemsg()});
        }
        if (v3GetSalekhjeResp.getJfkhje() > 0.0) {
            if ("N".equals(thMode)) {
                return Code.CODE_30123.getRespBase(new Object[]{"\u672c\u7b14\u8ba2\u5355\u5b58\u5728\u6263\u56de\u4e0d\u5141\u8bb8\u9000\u8d27"});
            }
            if (ManipulatePrecision.doubleCompare((double)v3GetSalekhjeResp.getJfkhje(), (double)cacheModel.getOrder().getRemainValue(), (int)2) > 0) {
                return Code.CODE_30123.getRespBase(new Object[]{"CRM\u6263\u56de\u8d85\u51fa\u9000\u8d27\u91d1\u989d\u4e0d\u5141\u8bb8\u9000\u8d27"});
            }
            JSONObject jsonObject = vo.getJsonObject();
            jsonObject.put("v3returnje", (Object)v3GetSalekhjeResp.getJfkhje());
            vo.setJsonObject(jsonObject);
        }
        if (null != (resp = super.saleReturn(session, vo)) && Code.SUCCESS.getIndex() == resp.getRetflag() && v3GetSalekhjeResp.getJfkhje() > 0.0) {
            ResqVo resqVoOld = (ResqVo)resp.getData();
            CacheModel cacheModelOld = resqVoOld.getCacheModel();
            JSONObject jsonObjectOld = resqVoOld.getJsonObject();
            if (!"99".equals(jsonObjectOld.getString("resultMode")) && !"0".equals(jsonObjectOld.getString("resultMode"))) {
                return resp;
            }
            Payment sp = new Payment();
            sp.setPayCode(khPayCode);
            sp.setPayName("\u79ef\u5206\u6263\u56de");
            sp.setAmount(ManipulatePrecision.doubleConvert((double)v3GetSalekhjeResp.getJfkhje()));
            sp.setMoney(sp.getAmount());
            sp.setRate(1.0);
            sp.setPayType("2");
            sp.setFlag("1");
            sp.setPuid(String.valueOf(UniqueID.getUniqueID()));
            sp.setRownoId(sp.getPuid());
            sp.setIsAutoDelOnly(true);
            sp.setIsAllowCharge("N");
            sp.setIsOverage("N");
            sp.setRowno(cacheModelOld.getPayments().size() + 1);
            cacheModelOld.getPayments().add(sp);
            cacheModelOld = this.posLogicCompoment.calcPayBalance(cacheModelOld);
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModelOld, (JSONObject)jsonObjectOld);
            return new RespBase(Code.SUCCESS, (Object)resqVo, "CALCULATERETURNCERTIFY");
        }
        return resp;
    }

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initializationRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    public List<V3SaleGoodsDefReq> getSaleGoodsFromCacheMode(CacheModel cacheModel, V3SaleHeadDefReq saleHead) {
        ArrayList<V3SaleGoodsDefReq> saleGoodsDefReqs = new ArrayList<V3SaleGoodsDefReq>();
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods goods = (Goods)cacheModel.getGoodsList().get(i);
            saleGoodsDefReqs.add(this.AssemblySaleGoodsDef(goods, saleHead));
        }
        return saleGoodsDefReqs;
    }

    public List<V3SalePayDefReq> getSalePaymentsFromCacheMode(CacheModel cacheModel) {
        ArrayList<V3SalePayDefReq> salePayDefReqs = new ArrayList<V3SalePayDefReq>();
        for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
            Payment payment = (Payment)cacheModel.getPayments().get(i);
            salePayDefReqs.add(this.AssemblySalePayDef(payment));
        }
        return salePayDefReqs;
    }

    public V3SaleHeadDefReq AssemblySaleHeadDef(Order order, String syjgroup) {
        if (order == null) {
            return null;
        }
        V3SaleHeadDefReq saleHead = new V3SaleHeadDefReq();
        saleHead.flow_no = order.getFlowNo();
        saleHead.billno = this.getEmptyStr(order.getYpopBillNo());
        saleHead.syjh = this.getEmptyStr(order.getTerminalNo());
        saleHead.fphm = Long.parseLong(order.getTerminalSno());
        saleHead.djlb = this.getEmptyStr(order.getOrderType());
        saleHead.mkt = this.getEmptyStr(order.getShopCode());
        saleHead.bc = Character.valueOf(order.getScheduleCode() == null ? (char)'?' : order.getScheduleCode().charAt(0));
        saleHead.syyh = this.getEmptyStr(order.getTerminalOperator());
        saleHead.rqsj = this.getEmptyStr(order.getSaleDate());
        saleHead.hykh = this.getEmptyStr(order.getConsumersData().getConsumersCard());
        saleHead.jfkh = this.getEmptyStr(order.getConsumersData().getConsumersId());
        saleHead.thsq = this.getEmptyStr(order.getRefundAuthzCardNo());
        saleHead.ghsq = this.getEmptyStr(order.getTerminalOperatorAuthzCardNo());
        saleHead.hysq = this.getEmptyStr(order.getMemberAuthzCardNo());
        saleHead.sqkh = this.getEmptyStr(order.getTotalDiscAuthzCardNo());
        saleHead.sqktype = Character.valueOf(order.getTotalDiscAuthzCardType() != null ? order.getTotalDiscAuthzCardType().charAt(0) : (char)'1');
        saleHead.sqkzkfd = order.getTotalDiscAuthzCardShare();
        saleHead.ysje = ManipulatePrecision.doubleConvert((double)(order.getOughtPay() + order.getRoundUpOverageValue()));
        saleHead.sjfk = order.getExistPay();
        saleHead.zl = CastUtil.castDouble((Object)order.getChangeValue());
        saleHead.sswr_sysy = -ManipulatePrecision.doubleConvert((double)order.getRoundUpOverageValue(), (int)4, (int)1);
        saleHead.fk_sysy = order.getOverageValue() + order.getPayOverageValue();
        saleHead.hjzje = ManipulatePrecision.doubleConvert((double)order.getSaleValue());
        saleHead.hjzsl = order.getQty();
        saleHead.hjzke = order.getTotalDiscountValue();
        saleHead.hyzke = order.getMemberDiscAmount();
        saleHead.yhzke = order.getPreferentialDiscAmount();
        saleHead.lszke = order.getTemporaryDiscAmount();
        saleHead.netbz = Character.valueOf('Y');
        saleHead.printbz = Character.valueOf('N');
        saleHead.hcbz = Character.valueOf('N');
        saleHead.buyerinfo = "";
        saleHead.jdfhdd = "";
        saleHead.salefphm = "";
        saleHead.printnum = 0;
        saleHead.bcjf = 0.0;
        saleHead.memo = "";
        saleHead.saleflg = 0;
        saleHead.str1 = "";
        saleHead.str2 = "";
        saleHead.str3 = "";
        saleHead.str4 = "";
        saleHead.str5 = "";
        saleHead.str6 = "";
        saleHead.str7 = "";
        saleHead.str8 = "";
        saleHead.str9 = "";
        saleHead.str10 = "";
        saleHead.str11 = this.getEmptyStr(order.getErpCode());
        saleHead.setJygs(this.getEmptyStr(order.getErpCode()));
        saleHead.num1 = 0.0;
        saleHead.num2 = 0.0;
        saleHead.num3 = 0.0;
        saleHead.num4 = 0.0;
        saleHead.num5 = 0.0;
        saleHead.num6 = 0.0;
        saleHead.num7 = 0.0;
        saleHead.num8 = 0.0;
        saleHead.num9 = 0.0;
        saleHead.num10 = 0.0;
        saleHead.hykname = this.getEmptyStr(order.getConsumersData().getConsumersCName());
        saleHead.yfphm = order.getOriginTerminalSno();
        saleHead.ysyjh = this.getEmptyStr(order.getOriginTerminalNo());
        saleHead.channel = this.getEmptyStr(order.getChannel());
        saleHead.str1 = this.getEmptyStr(syjgroup);
        return saleHead;
    }

    public V3SaleGoodsDefReq AssemblySaleGoodsDef(Goods goods, V3SaleHeadDefReq saleHead) {
        if (goods == null) {
            return null;
        }
        V3SaleGoodsDefReq saleGoodsDef = new V3SaleGoodsDefReq();
        saleGoodsDef.syjh = this.getEmptyStr(saleHead.syjh);
        saleGoodsDef.fphm = saleHead.fphm;
        saleGoodsDef.rowno = goods.getFlowId();
        saleGoodsDef.yyyh = this.getEmptyStr(goods.getAssistantId());
        saleGoodsDef.barcode = this.getEmptyStr(goods.getBarNo());
        saleGoodsDef.code = this.getEmptyStr(goods.getGoodsCode());
        int type = 49;
        if ("2".equals(goods.getGoodsType())) {
            type = 67;
        } else if ("12".equals(goods.getGoodsType())) {
            type = 55;
        } else if ("14".equals(goods.getGoodsType())) {
            type = 90;
        } else if ("41".equals(goods.getGoodsType())) {
            type = 84;
        } else if ("11".equals(goods.getGoodsType())) {
            type = 57;
        }
        saleGoodsDef.type = Character.valueOf((char)type);
        saleGoodsDef.gz = this.getEmptyStr(goods.getOrgCode());
        saleGoodsDef.catid = this.getEmptyStr(goods.getCategoryCode());
        saleGoodsDef.ppcode = this.getEmptyStr(goods.getBrandCode());
        saleGoodsDef.uid = this.getEmptyStr(goods.getGoodsUid());
        saleGoodsDef.yhdjbh = "";
        saleGoodsDef.name = this.getEmptyStr(goods.getGoodsName() == null ? "" : goods.getGoodsName().trim());
        saleGoodsDef.unit = this.getEmptyStr(goods.getSaleUnit());
        saleGoodsDef.bzhl = goods.getPartsNum();
        saleGoodsDef.sl = ManipulatePrecision.doubleConvert((double)goods.getQty(), (int)4, (int)1);
        saleGoodsDef.lsj = goods.getListPrice();
        saleGoodsDef.jg = ManipulatePrecision.doubleConvert((double)goods.getSalePrice(), (int)2, (int)1);
        saleGoodsDef.hjzk = goods.getTotalDiscountValue();
        saleGoodsDef.hjje = goods.getSaleValue();
        saleGoodsDef.hyzke = goods.getCustomDiscountValue();
        saleGoodsDef.hyzkfd = goods.getVipfdzkfd();
        saleGoodsDef.yhzke = goods.getPopDiscountValue();
        saleGoodsDef.yhzkfd = 1.0;
        saleGoodsDef.lszke = 0.0;
        saleGoodsDef.lszre = 0.0;
        saleGoodsDef.lszzk = goods.getAdjustDiscountValue();
        saleGoodsDef.lszzr = 0.0;
        saleGoodsDef.plzke = 0.0;
        saleGoodsDef.plzkfd = 1.0;
        saleGoodsDef.zszke = 0.0;
        saleGoodsDef.sqkh = this.getEmptyStr(goods.getHandmadeNumber());
        saleGoodsDef.sqktype = Character.valueOf('1');
        saleGoodsDef.sqkzkfd = 1.0;
        saleGoodsDef.isvipzk = Character.valueOf('N');
        saleGoodsDef.xxtax = goods.getOutputTax();
        saleGoodsDef.goodssxm = "00";
        int flag = 52;
        if (StringUtils.isEmpty((String)goods.getFlag())) {
            flag = 32;
        } else {
            if ("1".equals(goods.getFlag())) {
                flag = 52;
            } else if ("0".equals(goods.getFlag())) {
                flag = 49;
            }
            if ("Y".equals(goods.getEscaleFlag())) {
                flag = 50;
            }
        }
        saleGoodsDef.flag = (char)flag;
        saleGoodsDef.isdzc = Character.valueOf("Y".equals(goods.getEscaleFlag()) ? (char)'Y' : 'N');
        saleGoodsDef.guid = this.getEmptyStr(goods.getGuid());
        saleGoodsDef.inputbarcode = this.getEmptyStr(goods.getGoodsNo());
        saleGoodsDef.ysyjh = this.getEmptyStr(saleHead.getYsyjh());
        saleGoodsDef.yfphm = Long.parseLong(saleHead.getYfphm());
        saleGoodsDef.fhdd = "";
        saleGoodsDef.memo = "";
        saleGoodsDef.str1 = "N";
        saleGoodsDef.str2 = "";
        saleGoodsDef.num1 = 0.0;
        saleGoodsDef.num2 = goods.getOriginalFlowId();
        return saleGoodsDef;
    }

    public V3SalePayDefReq AssemblySalePayDef(Payment payment) {
        if (payment == null) {
            return null;
        }
        V3SalePayDefReq salepay = new V3SalePayDefReq();
        salepay.paycode = this.getEmptyStr(payment.getPayCode());
        salepay.payname = this.getEmptyStr(payment.getPayName());
        salepay.paytype = this.getEmptyStr(payment.getPayType());
        salepay.hl = payment.getRate();
        salepay.payno = this.getEmptyStr(payment.getPayNo());
        salepay.ybje = payment.getAmount();
        salepay.je = payment.getMoney();
        salepay.memo = this.getEmptyStr(payment.getPayMemo());
        salepay.batch = this.getEmptyStr(payment.getBatchNo());
        salepay.flag = Character.valueOf(payment.getFlag() == null ? (char)' ' : payment.getFlag().charAt(0));
        salepay.consumers_id = this.getEmptyStr(payment.getConsumersId());
        salepay.coupon_type = this.getEmptyStr(payment.getCouponType());
        salepay.accnt_no = this.getEmptyStr(payment.getAccntNo());
        salepay.num1 = payment.getOverPay();
        salepay.guid = this.getEmptyStr(payment.getPuid());
        return salepay;
    }

    public String getEmptyStr(String obj) {
        if (obj == null) {
            return "";
        }
        return obj;
    }

    public String getReturnTerminalOperator(String strTerminalOperator) {
        return "";
    }

    public RespBase calSaleReturnKhje(double khje, String tip, double remianValue, ResqVo vo) {
        try {
            double v3khje = 0.0;
            JSONObject paramsObject = vo.getJsonObject();
            if (paramsObject.containsKey((Object)"v3returnje")) {
                v3khje = ManipulatePrecision.doubleConvert((double)paramsObject.getDouble("v3returnje"));
            }
            if (ManipulatePrecision.doubleCompare((double)(khje + v3khje), (double)remianValue, (int)2) > 0) {
                return Code.CODE_30123.getRespBase(new Object[]{tip + "\u91d1\u989d" + khje + " V3\u6263\u56de\u91d1\u989d" + v3khje + "\u7684\u5408\u8ba1" + ManipulatePrecision.doubleConvert((double)(khje + v3khje)) + ",\u8d85\u51fa\u9000\u8d27\u91d1\u989d" + remianValue + "\u4e0d\u5141\u8bb8\u9000\u8d27"});
            }
            return Code.SUCCESS.getRespBase(new Object[]{""});
        }
        catch (Exception e) {
            return Code.FAIL.getRespBase(new Object[]{"\u8ba1\u7b97V3\u6263\u56de\u5f02\u5e38"});
        }
    }
}

