/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.local.roc.omg;

import com.efuture.business.local.roc.Db3ConnPath;
import com.efuture.business.local.roc.LocalDatabaseUtil;
import com.efuture.business.local.roc.omg.Omg_DataLoadToMemory;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleExceptGoods;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleJoinCustomer;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleJoinGoods;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleJoinGrade;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleJoinGroup;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleJoinGroupDetail;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleJoinStore;
import com.efuture.roc.omf.model.onsalecalc.BeanOnSaleSheet;
import com.efuture.roc.omf.model.onsalecalc.Jvm_BeanOnSaleJoinStore;
import com.efuture.roc.omf.model.onsalecalc.Jvm_BeanOnSaleSheet;
import com.efuture.roc.omf.service.impl.onsalecalc.calc.OnSaleGlobalVar;
import com.efuture.roc.omf.service.impl.onsalecalc.calc.OnSaleRule;
import com.efuture.roc.omf.service.impl.onsalecalc.calcutil.TypeUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class Omg_DataLoadToMemory {
    private boolean isConnect;
    private Connection conn = null;
    private Db3ConnPath db3ConnPath = new Db3ConnPath();

    private void setSqlite() throws FileNotFoundException, Exception {
        this.isConnect = false;
        this.db3ConnPath.getInitParameters();
        if (!new File(Db3ConnPath.Db3con).exists() || new File(Db3ConnPath.Db3con).isDirectory()) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }

    private boolean getConnect() {
        if (this.isConnect) {
            return true;
        }
        return this.getConnect(null, null);
    }

    private boolean getConnect(String user, String pwd) {
        try {
            this.setSqlite();
            Class.forName("org.sqlite.JDBC");
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + Db3ConnPath.Db3con, user, pwd);
            this.isConnect = true;
        }
        catch (Exception e) {
            this.isConnect = false;
            return false;
        }
        return true;
    }

    private void closeConnect() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isConnect = false;
    }

    private void addOnSaleGradeToGoods(BeanOnSaleJoinGoods oneGoods, List<BeanOnSaleJoinGrade> allOnSaleGrade) {
        oneGoods.joinGrade = new ArrayList();
        for (int i = 0; i < allOnSaleGrade.size(); ++i) {
            BeanOnSaleJoinGrade oneGrade = allOnSaleGrade.get(i);
            if (oneGoods.sheet_serial < oneGrade.sheet_serial) {
                return;
            }
            if (oneGoods.sheet_serial != oneGrade.sheet_serial || oneGoods.serial_id != oneGrade.serial_id) continue;
            oneGoods.joinGrade.add(oneGrade);
            allOnSaleGrade.remove(i);
            --i;
        }
    }

    private void addOnSaleGradeToGroup(BeanOnSaleJoinGroup oneGroup, List<BeanOnSaleJoinGrade> allOnSaleGrade) {
        oneGroup.joinGrade = new ArrayList();
        for (int i = 0; i < allOnSaleGrade.size(); ++i) {
            BeanOnSaleJoinGrade oneGrade = allOnSaleGrade.get(i);
            if (oneGroup.sheet_serial < oneGrade.sheet_serial) {
                return;
            }
            if (oneGroup.sheet_serial != oneGrade.sheet_serial || oneGroup.serial_id != oneGrade.serial_id) continue;
            oneGroup.joinGrade.add(oneGrade);
            allOnSaleGrade.remove(i);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap<Long, List<BeanOnSaleJoinGroupDetail>> loadOnSaleGroupDetail() {
        if (!this.getConnect()) {
            return null;
        }
        ResultSet rs_GroupDetail = null;
        Vector allGroupDetail = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select * from FRAM_ONSALE_GROUP_DETAIL Order By GROUP_ID,GROUP_SERIAL asc";
            rs_GroupDetail = stmt.executeQuery(sql);
            allGroupDetail = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_GroupDetail, BeanOnSaleJoinGroupDetail.class);
            stmt.close();
            rs_GroupDetail.close();
        }
        catch (SQLException e) {
            TreeMap<Long, List<BeanOnSaleJoinGroupDetail>> treeMap = null;
            return treeMap;
        }
        finally {
            this.closeConnect();
        }
        TreeMap<Long, List<BeanOnSaleJoinGroupDetail>> allGroup = new TreeMap<Long, List<BeanOnSaleJoinGroupDetail>>();
        block5: while (allGroupDetail.size() > 0) {
            Long group_id = ((BeanOnSaleJoinGroupDetail)allGroupDetail.get((int)0)).group_id;
            ArrayList<BeanOnSaleJoinGroupDetail> oneGroup = new ArrayList<BeanOnSaleJoinGroupDetail>();
            allGroup.put(group_id, oneGroup);
            for (int i = 0; i < allGroupDetail.size(); ++i) {
                BeanOnSaleJoinGroupDetail oneDetail = (BeanOnSaleJoinGroupDetail)allGroupDetail.get(i);
                if (group_id == oneDetail.group_id) {
                    oneGroup.add(oneDetail);
                    allGroupDetail.remove(i);
                    --i;
                    continue;
                }
                if (group_id < oneDetail.group_id) continue block5;
            }
        }
        return allGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BeanOnSaleJoinGrade> loadOnSaleJoinGrade() {
        if (!this.getConnect()) {
            return null;
        }
        ResultSet rs_OnSaleGrade = null;
        Vector allOnSaleGrade = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select * from FRAM_ONSALE_JOIN_GRADE Order By SHEET_SERIAL,SERIAL_ID,GRADE_SERIAL asc";
            rs_OnSaleGrade = stmt.executeQuery(sql);
            allOnSaleGrade = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_OnSaleGrade, BeanOnSaleJoinGrade.class);
            stmt.close();
            rs_OnSaleGrade.close();
        }
        catch (SQLException e) {
            List<BeanOnSaleJoinGrade> list = null;
            return list;
        }
        finally {
            this.closeConnect();
        }
        return allOnSaleGrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadOnSaleJoinGoods(List<BeanOnSaleSheet> allOnSaleSheetList, List<BeanOnSaleJoinGrade> allOnSaleGrade) {
        if (!this.getConnect()) {
            return false;
        }
        ResultSet rs_OnSaleGoods = null;
        Vector allOnSaleGoods = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select * from FRAM_ONSALE_JOIN_GOODS Order By SHEET_SERIAL,SERIAL_ID asc";
            rs_OnSaleGoods = stmt.executeQuery(sql);
            allOnSaleGoods = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_OnSaleGoods, BeanOnSaleJoinGoods.class);
            stmt.close();
            rs_OnSaleGoods.close();
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnect();
        }
        block5: for (BeanOnSaleSheet oneList : allOnSaleSheetList) {
            oneList.joinGoods = new ArrayList();
            for (int i = 0; i < allOnSaleGoods.size(); ++i) {
                BeanOnSaleJoinGoods oneGoods = (BeanOnSaleJoinGoods)allOnSaleGoods.get(i);
                if (oneList.sheet_serial < oneGoods.sheet_serial) continue block5;
                if (oneList.sheet_serial != oneGoods.sheet_serial) continue;
                this.addOnSaleGradeToGoods(oneGoods, allOnSaleGrade);
                oneList.joinGoods.add(oneGoods);
                allOnSaleGoods.remove(i);
                --i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadOnSaleJoinGroup(List<BeanOnSaleSheet> allOnSaleSheetList, List<BeanOnSaleJoinGrade> allOnSaleGrade, TreeMap<Long, List<BeanOnSaleJoinGroupDetail>> allGroupDetail) {
        if (!this.getConnect()) {
            return false;
        }
        ResultSet rs_OnSaleGroup = null;
        Vector allOnSaleGroup = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select * from FRAM_ONSALE_JOIN_GROUP Order By SHEET_SERIAL,SERIAL_ID asc";
            rs_OnSaleGroup = stmt.executeQuery(sql);
            allOnSaleGroup = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_OnSaleGroup, BeanOnSaleJoinGroup.class);
            stmt.close();
            rs_OnSaleGroup.close();
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnect();
        }
        block5: for (BeanOnSaleSheet oneList : allOnSaleSheetList) {
            oneList.joinGroup = new ArrayList();
            for (int i = 0; i < allOnSaleGroup.size(); ++i) {
                List<BeanOnSaleJoinGroupDetail> oneGroupDetail;
                BeanOnSaleJoinGroup oneGroup = (BeanOnSaleJoinGroup)allOnSaleGroup.get(i);
                if (oneList.sheet_serial < oneGroup.sheet_serial) continue block5;
                if (oneList.sheet_serial != oneGroup.sheet_serial) continue;
                this.addOnSaleGradeToGroup(oneGroup, allOnSaleGrade);
                oneGroup.groupDetail = oneGroupDetail = allGroupDetail.get(oneGroup.group_id);
                oneList.joinGroup.add(oneGroup);
                allOnSaleGroup.remove(i);
                --i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadOnSaleJoinStore(List<BeanOnSaleSheet> allOnSaleSheetList) {
        if (!this.getConnect()) {
            return false;
        }
        ResultSet rs_OnSaleStore = null;
        ArrayList<BeanOnSaleJoinStore> allOnSaleStore = new ArrayList<BeanOnSaleJoinStore>();
        Vector allStore = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select SHEET_ID, SHEET_SERIAL, SERIAL_ID, SHOPID,ONSALE_DATE_START ONSALE_DATE_STARTS, ONSALE_DATE_END ONSALE_DATE_ENDS, ONSALE_WEEKLIST, ONSALE_TIME_START, ONSALE_TIME_END from FRAM_ONSALE_JOIN_STORE Order By SHEET_SERIAL,SERIAL_ID asc";
            rs_OnSaleStore = stmt.executeQuery(sql);
            allStore = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_OnSaleStore, Jvm_BeanOnSaleJoinStore.class);
            stmt.close();
            rs_OnSaleStore.close();
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnect();
        }
        for (Jvm_BeanOnSaleJoinStore bean : allStore) {
            BeanOnSaleJoinStore nbean = new BeanOnSaleJoinStore();
            LocalDatabaseUtil.beanCopyByTargetBeanAnnotation((Object)bean, (Object)nbean);
            try {
                nbean.onsale_date_start = TypeUtils.castToDate((Object)bean.onsale_date_starts, (String)"yyyy-MM-dd");
                nbean.onsale_date_end = TypeUtils.castToDate((Object)bean.onsale_date_ends, (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            allOnSaleStore.add(nbean);
        }
        block8: for (BeanOnSaleSheet oneList : allOnSaleSheetList) {
            oneList.joinStore = new ArrayList();
            for (int i = 0; i < allOnSaleStore.size(); ++i) {
                BeanOnSaleJoinStore oneStore = (BeanOnSaleJoinStore)allOnSaleStore.get(i);
                if (oneList.sheet_serial < oneStore.sheet_serial) continue block8;
                if (oneList.sheet_serial != oneStore.sheet_serial) continue;
                oneList.joinStore.add(oneStore);
                allOnSaleStore.remove(i);
                --i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadOnSaleJoinCustomer(List<BeanOnSaleSheet> allOnSaleSheetList) {
        if (!this.getConnect()) {
            return false;
        }
        ResultSet rs_OnSaleCustomer = null;
        Vector allOnSaleCustomer = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select * from FRAM_ONSALE_JOIN_CUSTOMER Order By SHEET_SERIAL,SERIAL_ID asc";
            rs_OnSaleCustomer = stmt.executeQuery(sql);
            allOnSaleCustomer = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_OnSaleCustomer, BeanOnSaleJoinCustomer.class);
            stmt.close();
            rs_OnSaleCustomer.close();
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnect();
        }
        block5: for (BeanOnSaleSheet oneList : allOnSaleSheetList) {
            oneList.joinCustomer = new ArrayList();
            for (int i = 0; i < allOnSaleCustomer.size(); ++i) {
                BeanOnSaleJoinCustomer oneCustomer = (BeanOnSaleJoinCustomer)allOnSaleCustomer.get(i);
                if (oneList.sheet_serial < oneCustomer.sheet_serial) continue block5;
                if (oneList.sheet_serial != oneCustomer.sheet_serial) continue;
                oneList.joinCustomer.add(oneCustomer);
                allOnSaleCustomer.remove(i);
                --i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadOnSaleExceptGoods(List<BeanOnSaleSheet> allOnSaleSheetList) {
        if (!this.getConnect()) {
            return false;
        }
        ResultSet rs_OnSaleExceptGoods = null;
        Vector allOnSaleExceptGoods = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select * from FRAM_ONSALE_EXCEPT_GOODS Order By SHEET_SERIAL,SERIAL_ID asc";
            rs_OnSaleExceptGoods = stmt.executeQuery(sql);
            allOnSaleExceptGoods = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_OnSaleExceptGoods, BeanOnSaleExceptGoods.class);
            stmt.close();
            rs_OnSaleExceptGoods.close();
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnect();
        }
        block5: for (BeanOnSaleSheet oneList : allOnSaleSheetList) {
            oneList.exceptGoods = new ArrayList();
            for (int i = 0; i < allOnSaleExceptGoods.size(); ++i) {
                BeanOnSaleExceptGoods oneExceptGoods = (BeanOnSaleExceptGoods)allOnSaleExceptGoods.get(i);
                if (oneList.sheet_serial < oneExceptGoods.sheet_serial) continue block5;
                if (oneList.sheet_serial != oneExceptGoods.sheet_serial) continue;
                oneList.exceptGoods.add(oneExceptGoods);
                allOnSaleExceptGoods.remove(i);
                --i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BeanOnSaleSheet> loadOnSaleSheetList() {
        if (!this.getConnect()) {
            return null;
        }
        ResultSet rs_OnSaleSheetList = null;
        ArrayList<BeanOnSaleSheet> allOnSaleSheetList = new ArrayList<BeanOnSaleSheet>();
        Vector allList = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            String sql = "select PERIOD_NUM, PERIOD_TITLE, SHEET_ID, SHEET_SERIAL, ONSALE_CHANNEL, ONSALE_TITLE, ONSALE_WEIGHT, ONSALE_TYPE, ONSALE_TYPE_NAME,ONSALE_DATE_START ONSALE_DATE_STARTS,ONSALE_DATE_END ONSALE_DATE_ENDS, ONSALE_WEEKLIST, ONSALE_TIME_START, ONSALE_TIME_END, ONSALE_CUSTOMER_RANGE_TYPE, ONSALE_CONDITION_SOURCE, ONSALE_CONDITION_TYPE, ONSALE_CONDITION_RULE, ONSALE_CALCULATE_FUNCTION, ONSALE_COUPON_TYPE, ONSALE_GRADE_RULE, ONSALE_IS_MULTIPLE, ONSALE_IS_EXCLUSION, ONSALE_EXECUTE_TIMES, NUM1, NUM2, NUM3, NUM4, NUM5, STR1, STR2, STR3, STR4, STR5 from FRAM_ONSALE_SHEET Order By SHEET_SERIAL asc";
            rs_OnSaleSheetList = stmt.executeQuery(sql);
            allList = LocalDatabaseUtil.resultSetToBean((ResultSet)rs_OnSaleSheetList, Jvm_BeanOnSaleSheet.class);
            stmt.close();
            rs_OnSaleSheetList.close();
        }
        catch (SQLException e) {
            List<BeanOnSaleSheet> list = null;
            return list;
        }
        finally {
            this.closeConnect();
        }
        for (Jvm_BeanOnSaleSheet bean : allList) {
            BeanOnSaleSheet nbean = new BeanOnSaleSheet();
            LocalDatabaseUtil.beanCopyByTargetBeanAnnotation((Object)bean, (Object)nbean);
            try {
                nbean.onsale_date_start = TypeUtils.castToDate((Object)bean.onsale_date_starts, (String)"yyyy-MM-dd");
                nbean.onsale_date_end = TypeUtils.castToDate((Object)bean.onsale_date_ends, (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            allOnSaleSheetList.add(nbean);
        }
        return allOnSaleSheetList;
    }

    private Map<String, Map<Integer, List<BeanOnSaleSheet>>> convertByOnSaleNodeGroup(List<BeanOnSaleSheet> allOnSaleSheetList) {
        sortOnSellList comparator = new sortOnSellList(this);
        TreeMap<String, Map<Integer, List<BeanOnSaleSheet>>> allOnSale = new TreeMap<String, Map<Integer, List<BeanOnSaleSheet>>>();
        OnSaleRule onSaleRule = OnSaleGlobalVar.calcRule;
        List nodes = onSaleRule.getNodeList();
        for (String node : nodes) {
            TreeMap oneNode = new TreeMap();
            List groups = onSaleRule.getGroupIdListByNode(node);
            for (Integer group : groups) {
                ArrayList<BeanOnSaleSheet> oneGroup = new ArrayList<BeanOnSaleSheet>();
                List saleTypesByOneGroup = onSaleRule.getOnSaleTypeListByGroup(node, group);
                for (int i = 0; i < allOnSaleSheetList.size(); ++i) {
                    BeanOnSaleSheet onSale = allOnSaleSheetList.get(i);
                    if (!saleTypesByOneGroup.contains(onSale.onsale_type)) continue;
                    oneGroup.add(onSale);
                    allOnSaleSheetList.remove(i);
                    --i;
                }
                Collections.sort(oneGroup, comparator);
                oneNode.put(group, oneGroup);
            }
            allOnSale.put(node, oneNode);
        }
        return allOnSale;
    }

    public Map<String, Map<Integer, List<BeanOnSaleSheet>>> loadToMemory() {
        long t0 = System.currentTimeMillis();
        int rows = 0;
        List allOnSaleGrade = this.loadOnSaleJoinGrade();
        TreeMap allGroupDetail = this.loadOnSaleGroupDetail();
        List allOnSaleSheetList = null;
        allOnSaleSheetList = this.loadOnSaleSheetList();
        rows = allOnSaleSheetList.size();
        if (!this.loadOnSaleJoinGoods(allOnSaleSheetList, allOnSaleGrade)) {
            return null;
        }
        if (!this.loadOnSaleJoinGroup(allOnSaleSheetList, allOnSaleGrade, allGroupDetail)) {
            return null;
        }
        if (!this.loadOnSaleJoinStore(allOnSaleSheetList)) {
            return null;
        }
        if (!this.loadOnSaleJoinCustomer(allOnSaleSheetList)) {
            return null;
        }
        if (!this.loadOnSaleExceptGoods(allOnSaleSheetList)) {
            return null;
        }
        Map allOnSaleMap = this.convertByOnSaleNodeGroup(allOnSaleSheetList);
        long period = System.currentTimeMillis() - t0;
        if (rows > 0) {
            // empty if block
        }
        return allOnSaleMap;
    }
}

