/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.cust;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.SellType;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.model.SaveTradeParam;
import com.efuture.business.model.TradePaymentParam;
import com.efuture.business.model.TradeProduct;
import com.efuture.business.service.PromotionOfHDService;
import com.efuture.business.util.AmountUtil;
import com.efuture.business.util.moho.MohoHttpRequest;
import com.efuture.business.util.moho.MohoHttpRequestEnum;
import com.product.model.ServiceSession;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PromotionOfHDServiceImpl
implements PromotionOfHDService {
    private static final Logger log = LoggerFactory.getLogger(PromotionOfHDServiceImpl.class);

    public RespBase saveTrade(ServiceSession session, CacheModel cacheModel) {
        SaveTradeParam request = this.getRequest(cacheModel);
        String response = null;
        try {
            log.info("\u8bf7\u6c42\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)request));
            response = MohoHttpRequest.doRequest((MohoHttpRequestEnum)MohoHttpRequestEnum.SAVETRADE, (String)JSONObject.parseObject((String)JSONObject.toJSONString((Object)request)).toJSONString());
            log.info("\u8bf7\u6c42\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u51fa\u53c2<=={}", (Object)response);
            if (StringUtils.isBlank((String)response)) {
                return Code.CODE_51000.getRespBase(new Object[]{"300", "\u8bf7\u6c42\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u8d85\u65f6"});
            }
            JSONObject responseJson = JSONObject.parseObject((String)response);
            if (!"0000".equals(responseJson.getString("status"))) {
                return Code.CODE_51000.getRespBase(new Object[]{"302", responseJson.getString("message")});
            }
        }
        catch (Exception e) {
            log.info("\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u5f02\u5e38", (Throwable)e);
            return Code.CODE_51000.getRespBase(new Object[]{"301", "\u8bf7\u6c42\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u5165\u53c2\u5f02\u5e38"});
        }
        return new RespBase(Code.SUCCESS, response);
    }

    private SaveTradeParam getRequest(CacheModel cacheModel) {
        int i;
        SaveTradeParam saveTradeParam = new SaveTradeParam();
        Order order = cacheModel.getOrder();
        try {
            saveTradeParam.setAmount(Integer.valueOf(AmountUtil.changeY2F((Double)order.getOughtPay()).intValue()));
        }
        catch (Exception e) {
            log.info("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
        if (StringUtils.isNotBlank((String)order.getCreateDate())) {
            saveTradeParam.setConsumptionTime(order.getCreateDate());
        } else {
            String currentTime = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            saveTradeParam.setConsumptionTime(currentTime);
        }
        saveTradeParam.setMemberId(order.getConsumersData().getConsumersId());
        saveTradeParam.setOriginTransNo(order.getOriginFlowNo());
        saveTradeParam.setProjectCode(order.getShopCode());
        saveTradeParam.setVerification(true);
        saveTradeParam.setSerialNo(order.getTerminalNo());
        saveTradeParam.setSerialNumber(order.getTerminalSno());
        saveTradeParam.setTradeType(Integer.valueOf(SellType.ISBACK((String)order.getOrderType()) ? 1 : 0));
        saveTradeParam.setTransactionNo(order.getFlowNo());
        LinkedList<TradePaymentParam> list = new LinkedList<TradePaymentParam>();
        LinkedList<TradeProduct> tradeProductList = new LinkedList<TradeProduct>();
        List paymentList = cacheModel.getPayments();
        for (i = 0; i < paymentList.size(); ++i) {
            Payment p = (Payment)paymentList.get(i);
            TradePaymentParam tradePaymentParam = new TradePaymentParam();
            tradePaymentParam.setAmount(Integer.valueOf(AmountUtil.changeY2F((Double)p.getAmount()).intValue()));
            tradePaymentParam.setPayment("01");
            list.add(tradePaymentParam);
        }
        for (i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods goods = (Goods)cacheModel.getGoodsList().get(i);
            TradeProduct tradeProduct = new TradeProduct();
            tradeProduct.setAmount(Integer.valueOf(AmountUtil.changeY2F((Double)goods.getSaleValue()).intValue()));
            tradeProduct.setCode(goods.getBarNo());
            tradeProduct.setId(String.valueOf(i + 1));
            tradeProduct.setName(goods.getGoodsName());
            tradeProduct.setStoreCode(order.getShopCode());
            tradeProduct.setSrcLine(String.valueOf(i + 1));
            tradeProductList.add(tradeProduct);
        }
        saveTradeParam.setPayments(list);
        saveTradeParam.setProducts(tradeProductList);
        return saveTradeParam;
    }
}

