/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.klxy.BillGoods;
import com.efuture.business.javaPos.struct.klxy.KlxyRespVo;
import com.efuture.business.javaPos.struct.klxy.RefundTrialIn;
import com.efuture.business.service.localize.CalcPopSaleBSImpl_WSLF;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcPopSaleBSImpl_KLXY
extends CalcPopSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(CalcPopSaleBSImpl_KLXY.class);

    public RespBase saleReturn(ServiceSession session, ResqVo vo) {
        RespBase respBase = this.refundTrial(session, vo);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        return super.saleReturn(session, vo);
    }

    public RespBase refundTrial(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("shopCode", (Object)order.getShopCode());
        paramsObject.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initializationRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_60028.getRespBase(new Object[]{"\u9000\u8d27\u8bd5\u7b97\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        RefundTrialIn paraIn = this.loadRefundRequestPara(cacheModel);
        paraIn.setMallId(mallId);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/external/refundTrial", session, JSON.toJSONString((Object)paraIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u9000\u8d27\u8bd5\u7b97", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                JSONObject body = res1.getBody();
                Integer canRefund = body.getInteger("canRefund");
                if (0 == canRefund) {
                    JSONArray list = body.getJSONArray("lackCouponInfoList");
                    if (null != list && list.size() > 0) {
                        cacheModel.getOrder().setYhqkh(true);
                        return new RespBase(Code.SUCCESS, (Object)cacheModel);
                    }
                    String lackCredit = body.getString("lackCredit");
                    return Code.CODE_60028.getRespBase(new Object[]{"\u8be5\u8ba2\u5355\u4e0d\u80fd\u9000\u8d27,\u8fd8\u9700\u989d\u5916\u8865\u8db3\u79ef\u5206:" + lackCredit});
                }
                if (2 == canRefund) {
                    return Code.CODE_60028.getRespBase(new Object[]{"\u539f\u5355\u5df2\u9000\u8d27\uff0c\u4e0d\u80fd\u518d\u6b21\u9000\u8d27!"});
                }
                return new RespBase(Code.SUCCESS, (Object)cacheModel);
            }
            if ("EXTERNALAPI-00017".equals(res1.getErrorCode())) {
                return new RespBase(Code.SUCCESS, (Object)cacheModel);
            }
            if ("EXTERNALAPI-00021".equals(res1.getErrorCode())) {
                return new RespBase(Code.SUCCESS, (Object)cacheModel);
            }
            return Code.CODE_60028.getRespBase(new Object[]{"\u9000\u8d27\u8bd5\u7b97\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_60028.getRespBase(new Object[]{"\u9000\u8d27\u8bd5\u7b97\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    private RefundTrialIn loadRefundRequestPara(CacheModel cacheModel) {
        RefundTrialIn in = new RefundTrialIn();
        Order order = cacheModel.getOrder();
        in.setFlowNo(order.getFlowNo());
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getConsumersCard())) {
            in.setCardNo(order.getConsumersData().getConsumersCard());
        }
        in.setOriginFlowNo(order.getOriginFlowNo());
        in.setExternalShopId("00");
        in.setOrderTime(Long.valueOf(System.currentTimeMillis()));
        in.setTradeAmount(String.valueOf(order.getOughtPay()));
        if (null != cacheModel.getGoodsList() && cacheModel.getGoodsList().size() > 0) {
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods goods = (Goods)cacheModel.getGoodsList().get(i);
                BillGoods billGoodsList = new BillGoods();
                billGoodsList.setGoodsCode(goods.getGoodsCode());
                billGoodsList.setGoodsCount((int)goods.getQty());
                billGoodsList.setGoodsName(goods.getGoodsName());
                billGoodsList.setGoodsAmount(String.valueOf(goods.getSaleAmount()));
                in.getTrialGoodsList().add(billGoodsList);
            }
        }
        return in;
    }

    protected CacheModel combineSameGoods(CacheModel cacheModel) {
        cacheModel.setGoodsList(this.goodsTransfer.combineSameGoods(cacheModel.getGoodsList(), false));
        return cacheModel;
    }
}

