/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.WorkLogType;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.posManager.request.SendCancelOrderLogIn;
import com.efuture.business.javaPos.struct.posManager.request.SendWorkLogIn;
import com.efuture.business.service.FunctionRemoteService;
import com.efuture.business.util.TimeZoneUtil;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class PromotionTask {
    private static final Logger log = LoggerFactory.getLogger(PromotionTask.class);
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @SoaAnnotation(value="/apiFunctionRemoteService.do")
    public FunctionRemoteService FunctionRemoteService;

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type) {
        this.sendWorkLog(session, order, type, null, null);
    }

    @Async
    public void sendOrderDiscWorkLog(ServiceSession session, Order order, String type, double amount) {
        this.sendWorkLog(session, order, type, null, 0.0, amount, null, null, true);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, 0.0, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, null, count, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount) {
        this.sendWorkLog(session, order, type, null, count, amount, null, null);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, info, count, amount, goodsName, goodsCode, false);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode, boolean isOrderDisc) {
        try {
            SendWorkLogIn in = new SendWorkLogIn();
            in.setErpCode(order.getErpCode());
            in.setMkt(order.getShopCode());
            in.setSyjh(order.getTerminalNo());
            in.setSyyh(order.getTerminalOperator());
            in.setBillno(order.getTerminalSno());
            in.setEntid(Long.valueOf(order.getEntId()));
            in.setGoodsName(goodsName);
            in.setGoodsCode(goodsCode);
            in.setLogtype(type);
            in.setLogdesc(info);
            in.setCount(count);
            in.setAmount(amount);
            if (!WorkLogType.regMember.equals(type)) {
                if (WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type)) {
                    if (!StringUtils.isBlank((String)order.getRefundAuthzCardNo()) && !order.getTerminalOperator().equals(order.getRefundAuthzCardNo())) {
                        in.setAuthorizeGh(order.getRefundAuthzCardNo());
                    }
                } else if (isOrderDisc && StringUtils.isNotBlank((String)order.getTotalDiscAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTotalDiscAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTotalDiscAuthzCardNo());
                } else if (!StringUtils.isBlank((String)order.getTerminalOperatorAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTerminalOperatorAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTerminalOperatorAuthzCardNo());
                }
            }
            if (WorkLogType.delGoods.equals(type) || WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type)) {
                in.setRowno(order.getFlowNo());
            }
            switch (type) {
                case "3": {
                    in.setLogdesc("\u6536\u94f6\u673a\u521d\u59cb\u5316\u5c0f\u7968");
                    break;
                }
                case "23": {
                    in.setLogdesc("\u5220\u9664\u5355\u54c1");
                    break;
                }
                case "24": {
                    in.setLogdesc("\u6574\u5355\u53d6\u6d88");
                    break;
                }
                case "34": {
                    in.setLogdesc("\u6539\u4ef7");
                    break;
                }
                case "38": {
                    in.setLogdesc("\u7ea2\u51b2");
                    break;
                }
                case "39": {
                    in.setLogdesc("\u9000\u8d27");
                    break;
                }
                case "41": {
                    in.setLogdesc("\u4fee\u6539\u6570\u91cf");
                    break;
                }
                case "42": {
                    in.setLogdesc("\u6298\u6263");
                    break;
                }
                case "45": {
                    in.setLogdesc("\u5f55\u4f1a\u5458");
                    break;
                }
                case "46": {
                    in.setLogdesc("\u5361\u8865\u5f55");
                    break;
                }
                case "50": {
                    in.setLogdesc("\u7535\u5b50\u5f00\u7968");
                    break;
                }
                case "51": {
                    in.setLogdesc("\u76d8\u70b9");
                }
            }
            String nowDateTime = TimeZoneUtil.ConvertTimeByTimeZone1((Date)new Date(), (String)order.getTimeZone(), (Boolean)this.localcache);
            if (StringUtils.isBlank((String)nowDateTime)) {
                LocalDateTime dateTime = LocalDateTime.now();
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                nowDateTime = dateTime.format(df);
            }
            in.setRqsj(nowDateTime);
            in.setUpdateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)new Date(), (String)order.getTimeZone(), (Boolean)this.localcache));
            this.FunctionRemoteService.posWorkLog(session, (JSONObject)JSON.toJSON((Object)in));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return;
        }
    }

    @Async
    public void sendCancelOrderLog(ServiceSession session, Order order, List<Goods> goodsList, String type, String info) {
        try {
            SendCancelOrderLogIn in = new SendCancelOrderLogIn();
            in.setDelOrder(new ArrayList());
            SendWorkLogIn inData = new SendWorkLogIn();
            inData.setErpCode(order.getErpCode());
            inData.setMkt(order.getShopCode());
            inData.setSyjh(order.getTerminalNo());
            inData.setSyyh(order.getTerminalOperator());
            inData.setBillno(order.getTerminalSno());
            inData.setLogtype(type);
            inData.setLogdesc(info);
            if (!StringUtils.isBlank((String)order.getTerminalOperatorAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTerminalOperatorAuthzCardNo())) {
                inData.setAuthorizeGh(order.getTerminalOperatorAuthzCardNo());
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            inData.setRqsj(nowDateTime);
            for (Goods sg : goodsList) {
                SendWorkLogIn realData = (SendWorkLogIn)inData.clone();
                realData.setGoodsName(sg.getGoodsName());
                realData.setGoodsCode(sg.getGoodsCode());
                realData.setAmount(sg.getSaleAmount());
                realData.setCount(sg.getQty());
                in.getDelOrder().add(realData);
            }
            this.FunctionRemoteService.posWorkLog(session, (JSONObject)JSON.toJSON((Object)in));
            return;
        }
        catch (Exception e) {
            return;
        }
    }
}

