/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.cust;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ExceptPay;
import com.efuture.business.javaPos.struct.Gift;
import com.efuture.business.javaPos.struct.GiftTemp;
import com.efuture.business.javaPos.struct.GiftsGroup;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.posManager.RebateCodeHead;
import com.efuture.business.javaPos.struct.posManager.RebateRemoveCat;
import com.efuture.business.javaPos.struct.posManager.request.ActivityDetailSerchIn;
import com.efuture.business.javaPos.struct.posManager.response.ActivityDetailSerchOut;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponReverse;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcCancelOrderIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcafFirmIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalSaleReturnOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcafFirmOut;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.javaPos.struct.request.SaleReturnIn;
import com.efuture.business.javaPos.struct.response.SaleReturnOut;
import com.efuture.business.microBase.ServiceResponse;
import com.efuture.business.microBase.ServiceSession;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.GoodsRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.PromotionBaseService;
import com.efuture.business.service.PromotionOfHDService;
import com.efuture.business.service.PromotionOfMssService;
import com.efuture.business.service.RebateCodeHeadRemoteService;
import com.efuture.business.service.cust.PromotionBaseServiceImpl;
import com.efuture.business.service.cust.PromotionCentreService;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class PromotionBaseServiceImpl
implements PromotionBaseService {
    private static final Logger log = LoggerFactory.getLogger(PromotionBaseServiceImpl.class);
    @Autowired
    protected PromotionOfMssService promotionOfMssService;
    @Autowired
    protected PromotionOfHDService promotionOfHDService;
    @Autowired
    public PromotionCentreService promotionCentreService;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    public GoodsTransfer goodsTransfer;
    @Autowired
    public PosLogicCompoment posLogicCompoment;
    @Autowired
    protected PosLogicService posLogicService;
    @SoaAnnotation(value="/apiGoodsRemoteService.do")
    protected GoodsRemoteService goodsRemoteService;
    @SoaAnnotation(value="/apiRebateCodeHeadRemoteService.do")
    private RebateCodeHeadRemoteService rebateCodeHeadRemoteService;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initializationRemoteService;
    @Autowired
    protected RedisUtil redisUtil;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    protected RestTemplate restTemplate;
    private static String SEARCHSHOPSTOCK = "stock.oms.shopStock.searchShopStockInfo";

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initializationRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    public RespBase<ResqVo> countAll(ServiceSession session, ResqVo resqVo, CountAllIn countAllIn) {
        CacheModel cacheModel = resqVo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_1003.getRespBase(new Object[]{countAllIn.getFlowNo()});
        }
        if (SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy())) {
            return new RespBase(Code.SUCCESS, (Object)resqVo);
        }
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            return Code.CODE_30125.getRespBase(new Object[]{"\u8ba2\u5355\u6ca1\u6709\u5546\u54c1\uff0c\u8bf7\u6dfb\u52a0\u5546\u54c1\u540e\u8ba1\u7b97\u4f18\u60e0"});
        }
        String roundingMode = cacheModel.getOrder().getSysPara().getOverageMode();
        if (StringUtils.isBlank((String)roundingMode)) {
            roundingMode = "0";
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getStaffNo()) && !cacheModel.getOrder().getStaffSale() && cacheModel.getOrder().getTempZzr() == 0.0 && (cacheModel.getOrder().getTempZzk() == 100.0 || cacheModel.getOrder().getTempZzk() == 0.0)) {
            log.info("\u4fee\u6539\u5458\u5de5\u5361\u6807\u8bc6\uff0c\u6ca1\u6709\u624b\u5de5\u6298\u6263,\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u53ef\u7528");
            cacheModel.getOrder().setStaffSale(true);
        }
        log.info(">>>>>>\u5355\u636e\u7c7b\u522b:{}", (Object)cacheModel.getOrder().getOrderType());
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            log.info("\u5e94\u4ed8\u91d1\u989d:{},\u9000\u8d27\u6743\u9650\u91d1\u989d:{}", (Object)cacheModel.getOrder().getOughtPay(), (Object)cacheModel.getCurGrant().getPrivthje());
            if (cacheModel.getOrder().getOughtPay() > cacheModel.getCurGrant().getPrivthje()) {
                return Code.CODE_20077.getRespBase(new Object[0]);
            }
        }
        if ("0".equals(countAllIn.getCalcMode()) && null != cacheModel.getBakGoods() && cacheModel.getBakGoods().size() > 0 && 2 != cacheModel.getPopMode()) {
            cacheModel.backGoodsAndPayments();
        }
        if ("0".equals(countAllIn.getCalcMode())) {
            if (countAllIn.getCount() != countAllIn.getGuidList().size() || countAllIn.getCount() != cacheModel.getGoodsList().size()) {
                resqVo.setCacheModel(cacheModel);
                log.info("cacheModel.getGoodsList()===>{}", (Object)JSONArray.toJSONString((Object)cacheModel.getGoodsList()));
                log.info("\u5546\u54c1\u6570\u91cf\u4e0d\u4e00\u81f40");
                return Code.CODE_30051.getRespBase(new Object[0]);
            }
            int num = 0;
            double qty = 0.0;
            int qty1forDzc = 0;
            for (Goods g : cacheModel.getGoodsList()) {
                boolean flag = false;
                for (String guid : countAllIn.getGuidList()) {
                    if (!guid.equals(g.getGuid())) continue;
                    ++num;
                    if (!"97".equals(g.getGoodsType())) {
                        qty += g.getQty();
                        qty1forDzc = "Y".equals(g.getEscaleFlag()) && !this.posLogicCompoment.checkEscaleEditFlag(g) || (double)((int)g.getQty()) != g.getQty() ? ++qty1forDzc : (int)((double)qty1forDzc + g.getQty());
                    }
                    flag = true;
                }
                if (flag) continue;
                resqVo.setCacheModel(cacheModel);
                log.info("\u5546\u54c1\u6570\u91cf\u4e0d\u4e00\u81f41");
                return new RespBase(Code.CODE_30051.getIndex(), "\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u6574\u5355\u8ba1\u7b97\u5931\u8d251", (Object)resqVo);
            }
            log.info("qty=" + qty + ",qtys=" + countAllIn.getQty() + ",num=" + num + ",nums=" + countAllIn.getCount());
            if (ManipulatePrecision.doubleCompare((double)qty, (double)countAllIn.getQty(), (int)4) != 0 && ManipulatePrecision.doubleCompare((double)qty1forDzc, (double)countAllIn.getQty(), (int)0) != 0 || ManipulatePrecision.doubleCompare((double)num, (double)countAllIn.getCount(), (int)0) != 0) {
                resqVo.setCacheModel(cacheModel);
                log.info("\u5546\u54c1\u6570\u91cf\u4e0d\u4e00\u81f42");
                return new RespBase(Code.CODE_30051.getIndex(), "\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u6574\u5355\u8ba1\u7b97\u5931\u8d252", (Object)resqVo);
            }
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + countAllIn.getShopCode() + countAllIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String isHH = modeDetailsVo.getSyjmain().getIsHH();
        log.info("isHH:" + isHH);
        String orderDiscMode = "";
        String jyms = "";
        String fkcxs = "";
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaList.size() != 0) {
            for (int i = 0; i < sysParaList.size(); ++i) {
                Syspara sys = (Syspara)sysParaList.get(i);
                if ("ZKSX".equals(sys.getCode())) {
                    orderDiscMode = sys.getParavalue();
                }
                if ("JYMS".equals(sys.getCode())) {
                    jyms = sys.getParavalue();
                }
                if ("41".equals(sys.getCode())) {
                    fkcxs = sys.getParavalue();
                }
                if (orderDiscMode.length() > 0 && jyms.length() > 0 && fkcxs.length() > 0) break;
            }
        }
        if (StringUtils.isBlank((String)orderDiscMode)) {
            orderDiscMode = "0";
        }
        boolean isRemoveAdjustDisc = true;
        if ("1".equals(orderDiscMode) || "2".equals(orderDiscMode)) {
            isRemoveAdjustDisc = false;
        }
        if (null == cacheModel.getBakGoods() || cacheModel.getBakGoods().size() <= 0 || cacheModel.getPopMode() == 2) {
            cacheModel.backGoodsAndPayments();
            if (!(cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && 4 != cacheModel.getPopMode() || "T1".equals(cacheModel.getOrder().getOrderType()) || "T4".equals(cacheModel.getOrder().getOrderType()) || "N".equals(isHH))) {
                cacheModel = this.combineSameGoods(cacheModel);
                cacheModel = this.workBeforeCountAll(cacheModel);
            }
        }
        cacheModel.setErrCode("");
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            if (StringUtils.isNotEmpty((String)(cacheModel = this.validateJDStock(session, cacheModel)).getErrCode()) && !"0".equals(cacheModel.getErrCode())) {
                return Code.CODE_20101.getRespBase(new Object[]{cacheModel.getErrMsg()});
            }
            cacheModel.setErrMsg("");
        }
        if (this.checkMaxLineCount(cacheModel, modeDetailsVo)) {
            return Code.CODE_30125.getRespBase(new Object[]{"\u8ba2\u5355\u8d85\u8fc7\u6700\u5927\u884c\u6570!\u8bf7\u5220\u9664\u5546\u54c1\u540e\u5206\u5355\u9500\u552e"});
        }
        if (!("-1".equals(countAllIn.getCalcMode()) || "-2".equals(countAllIn.getCalcMode()) || "-3".equals(countAllIn.getCalcMode()))) {
            cacheModel.getOrder().setCalcMarketingMode(countAllIn.getCalcMode());
        }
        cacheModel.setLimitedPayCodes(CountAllIn.gainLimitedPayCodes((CacheModel)cacheModel, (CountAllIn)countAllIn));
        log.info("\u4ece\u7aef\u83b7\u53d6\u9664\u5916\u4ed8\u6b3e\u4e4b\u524dLimitedPayCodes=[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getLimitedPayCodes()));
        if ("-2".equals(countAllIn.getCalcMode())) {
            if (countAllIn.getNoPriceGiftList().size() != cacheModel.getChoiceGiftsHaveNoPrice().size()) {
                return Code.CODE_30050.getRespBase(new Object[]{"\u4f20\u53c2\u6709\u8bef\uff0c\u4f20\u5165\u7684\u8d60\u54c1\u6761\u6570\u4e0d\u5339\u914d"});
            }
            cacheModel = this.setNoPriceGifts(cacheModel, countAllIn.getNoPriceGiftList());
        }
        if ("4".equals(countAllIn.getCalcMode()) && countAllIn.getGiftList() != null && countAllIn.getGiftList().size() > 0) {
            RespBase respAfterGifts = this.choiceGifts(session, resqVo, countAllIn.getGiftList(), fkcxs);
            if (Code.CODE_30071.getIndex() == respAfterGifts.getRetflag()) {
                respAfterGifts.setRetflag(Code.SUCCESS.getIndex());
                resqVo = (ResqVo)respAfterGifts.getData();
                cacheModel = resqVo.getCacheModel();
                cacheModel.setCalcResult(100001);
                resqVo.setCacheModel(cacheModel);
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
            if (Code.SUCCESS.getIndex() != respAfterGifts.getRetflag()) {
                return respAfterGifts;
            }
            resqVo = (ResqVo)respAfterGifts.getData();
            cacheModel = resqVo.getCacheModel();
            cacheModel.setCalcResult(0);
        }
        if (("-1".equals(countAllIn.getCalcMode()) || "3".equals(countAllIn.getCalcMode()) || "2".equals(countAllIn.getCalcMode())) && cacheModel.getPayments().size() > 0 && "EXCEPT".equals(((Payment)cacheModel.getPayments().get(0)).getPayMemo())) {
            cacheModel.getPayments().remove(0);
            PayUtil.sortPayments((List)cacheModel.getPayments());
        }
        if ("3".equals(countAllIn.getCalcMode()) && countAllIn.getDiscountPayCode() != null && countAllIn.getDiscountPayType() != null) {
            ExceptPay exceptPay = null;
            for (int i = 0; i < cacheModel.getExceptPayDetails().size(); ++i) {
                exceptPay = (ExceptPay)cacheModel.getExceptPayDetails().get(i);
                if (countAllIn.getDiscountPayCode().equals(exceptPay.getPayCode())) continue;
                cacheModel.getExceptPayDetails().remove(i);
                --i;
            }
            if (cacheModel.getExceptPayDetails().size() == 0) {
                return Code.CODE_30090.getRespBase(new Object[]{"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ffd\u9001\u89c4\u5219"});
            }
            cacheModel.setDiscountPayCode(countAllIn.getDiscountPayCode());
            Payment p = new Payment();
            p.setPuid(String.valueOf(UniqueID.getUniqueID()));
            p.setPayCode(countAllIn.getDiscountPayCode());
            p.setPayType(countAllIn.getDiscountPayType());
            p.setPayName("\u652f\u4ed8\u6298\u6263");
            p.setCouponEventId(exceptPay.getEventId());
            p.setCouponPolicyId(exceptPay.getPolicyId());
            p.setTerminalNo(cacheModel.getOrder().getTerminalNo());
            p.setTerminalSno(cacheModel.getOrder().getTerminalSno());
            p.setRate(0.0);
            p.setAmount(0.0);
            p.setMoney(0.0);
            p.setPayNo("");
            p.setIsAutoDelOnly(true);
            p.setFlag("1");
            cacheModel.getPayments().add(p);
        }
        if (StringUtils.isNotEmpty((String)(cacheModel = this.appendJdCoupon(session, cacheModel)).getErrCode()) && !"0".equals(cacheModel.getErrCode())) {
            return Code.CODE_20101.getRespBase(new Object[]{cacheModel.getErrMsg()});
        }
        String calcMode = "";
        calcMode = countAllIn.getCalcMode();
        if ("99".equals(countAllIn.getCalcMode())) {
            if (-1 == (cacheModel = this.workBeforePayDisc1(cacheModel, countAllIn, session)).getCalcResult()) {
                return new RespBase(CastUtil.castInt((Object)cacheModel.getErrCode()), cacheModel.getErrMsg());
            }
            calcMode = "7";
        }
        if (StringUtils.isNotBlank((String)countAllIn.getCalcMode()) && "-4".equals(countAllIn.getCalcMode()) && ManipulatePrecision.doubleCompare((double)cacheModel.getOrder().getRemainValue(), (double)0.0, (int)2) > 0) {
            if (99 == (cacheModel = this.workBeforePayDisc2(cacheModel, session)).getCalcResult()) {
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
            if (-1 == cacheModel.getCalcResult()) {
                return new RespBase(Code.FAIL, (Object)resqVo, "");
            }
            calcMode = "7";
        }
        log.info("\u5546\u54c1\u6570\u91cf\uff1a" + cacheModel.getGoodsList().size());
        if (!(SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 4)) {
            if (!"-1".equals(countAllIn.getCalcMode())) {
                if (!"T1".equals(cacheModel.getOrder().getOrderType()) && !"T4".equals(cacheModel.getOrder().getOrderType())) {
                    cacheModel.getOrder().setOutSideGiftsInfo("");
                }
                if ("-2".equals(calcMode)) {
                    calcMode = "4";
                }
                cacheModel = "0".equals(calcMode) ? this.promotionOfMssService.calcOrderPop(session, calcMode, cacheModel, true, true, isRemoveAdjustDisc) : this.promotionOfMssService.calcOrderPop(session, calcMode, cacheModel, true, false, isRemoveAdjustDisc);
                log.info("goodsList==>{}", (Object)JSONArray.toJSONString((Object)cacheModel.getGoodsList()));
                if (cacheModel.getCalcResult() == -1) {
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        String errCode = cacheModel.getErrCode();
                        return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg());
                    }
                    return Code.CODE_30050.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
            }
            if ("-1".equals(calcMode) || 0 == cacheModel.getCalcResult()) {
                if ("-1".equals(calcMode) || "2".equals(calcMode)) {
                    cacheModel.setDiscountPayCode("");
                    for (int i = 0; i < cacheModel.getLimitedPayDetails().size(); ++i) {
                        ExceptPay pay = (ExceptPay)cacheModel.getLimitedPayDetails().get(i);
                        if (!StringUtils.isNotBlank((String)pay.getCopType()) && !StringUtils.isNotBlank((String)pay.getCrdBegin()) && !StringUtils.isNotBlank((String)pay.getCrdEnd()) && pay.getCrdLength() <= 0L) continue;
                        cacheModel.getLimitedPayCodes().remove(pay.getPayCode());
                        cacheModel.getLimitedPayDetails().remove(i);
                        --i;
                    }
                    cacheModel.getExceptPayDetails().clear();
                }
                if ("0".equals(orderDiscMode)) {
                    double beforeCalcAdjust = cacheModel.getOrder().getTotalDiscountValue();
                    log.info("TotalDiscountValue before ={}", (Object)beforeCalcAdjust);
                    cacheModel = this.posLogicCompoment.calcAdjustDiscAfterOrder(cacheModel);
                    log.info("TotalDiscountValue afler ={}", (Object)cacheModel.getOrder().getTotalDiscountValue());
                    if (beforeCalcAdjust != cacheModel.getOrder().getTotalDiscountValue() && (cacheModel = this.promotionOfMssService.calcOrderPop(session, "6", cacheModel, false, false, false)).getCalcResult() == -1) {
                        String errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return Code.CODE_30050.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                }
                if (!SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) && countAllIn.isCalcaffirm()) {
                    CalcafFirmIn calcafFirmIn = new CalcafFirmIn();
                    calcafFirmIn.setType("0");
                    calcafFirmIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
                    ServiceResponse response = this.promotionOfMssService.calcaffirm(session, calcafFirmIn);
                    if (!"0".equals(response.getReturncode())) {
                        return new RespBase(Code.CODE_30121, (Object)resqVo, "");
                    }
                    CalcafFirmOut calcafFirmOut = (CalcafFirmOut)response.getData();
                    if (!"0".equals(calcafFirmOut.getCalcResult())) {
                        return new RespBase(Code.CODE_30122, (Object)resqVo, "");
                    }
                }
                this.posLogicCompoment.calcOrderAmount(cacheModel);
                cacheModel.setCalcResult(0);
                if ("0".equals(roundingMode) && ManipulatePrecision.doubleCompare((double)cacheModel.getOrder().getRoundUpOverageValue(), (double)0.0, (int)2) > 0) {
                    if ((cacheModel = this.addOveragePopDetail(session, cacheModel, true)).getCalcResult() == -1) {
                        String errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return Code.CODE_30050.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    log.info(">>>>>>>>>>>>>countAllIn.isCalcaffirm()...>{}", (Object)countAllIn.isCalcaffirm());
                    if (countAllIn.isCalcaffirm()) {
                        cacheModel.getOrder().setAllowEditGoods(false);
                    }
                } else {
                    log.info(">>>>>>countAllIn.isCalcaffirm()...>{}", (Object)countAllIn.isCalcaffirm());
                    if (countAllIn.isCalcaffirm()) {
                        cacheModel.getOrder().setAllowEditGoods(false);
                    }
                    cacheModel.setCalcResult(0);
                    calcMode = "99999";
                }
            }
        } else {
            this.posLogicCompoment.calcOrderAmount(cacheModel);
        }
        if (cacheModel.getCalcResult() == -1) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
        }
        if (("-1".equals(calcMode) || "-3".equals(calcMode)) && !this.posLogicCompoment.checkBalance(cacheModel)) {
            return Code.CODE_30050.getRespBase(new Object[]{cacheModel.getErrMsg()});
        }
        this.posLogicCompoment.calcPayBalance(cacheModel);
        if (cacheModel.getOrder().isDepositSale() && (SellType.ISSALE((String)cacheModel.getOrder().getOrderType()) && ("-1".equals(calcMode) || "-3".equals(calcMode) || "99999".equals(calcMode)) || SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && "-1".equals(calcMode))) {
            double tempje;
            log.info("\u6821\u9a8c\u8ba2\u91d1\u91d1\u989d");
            if (ManipulatePrecision.doubleCompare((double)cacheModel.getOrder().getDepositValue(), (double)cacheModel.getOrder().getOughtPay(), (int)2) > 0) {
                return Code.CODE_30126.getRespBase(new Object[]{"\u8ba2\u91d1\u91d1\u989d" + cacheModel.getOrder().getDepositValue() + "\u5927\u4e8e\u4f18\u60e0\u540e\u5e94\u4ed8\u91d1\u989d" + cacheModel.getOrder().getOughtPay() + "\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u8ba2\u91d1"});
            }
            if (ManipulatePrecision.doubleCompare((double)cacheModel.getOrder().getExistPay(), (double)cacheModel.getOrder().getDepositValue(), (int)2) > 0) {
                return Code.CODE_30126.getRespBase(new Object[]{"\u5df2\u652f\u4ed8\u91d1\u989d" + cacheModel.getOrder().getExistPay() + "\u8d85\u51fa\u8ba2\u91d1\u91d1\u989d" + cacheModel.getOrder().getDepositValue() + "\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u8ba2\u91d1"});
            }
            log.info("Syspara DJQE:" + modeDetailsVo.getSysparainfo().getDjqe());
            if ("Y".equals(modeDetailsVo.getSysparainfo().getDjqe())) {
                cacheModel.getOrder().setDepositValue(cacheModel.getOrder().getOughtPay());
            }
            if ((tempje = ManipulatePrecision.doubleConvert((double)(cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getDepositValue()), (int)2, (int)1)) <= 0.0) {
                cacheModel.getOrder().setTailMoneyPay(true);
            } else {
                log.info("\u751f\u6210\u5c3e\u6b3e\u652f\u4ed8\u884c");
                this.posLogicService.calcTailPayments(cacheModel);
            }
        }
        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
    }

    public boolean checkMaxLineCount(CacheModel cacheModel, ModeDetailsVo modeDetailsVo) {
        return false;
    }

    protected CacheModel combineSameGoods(CacheModel cacheModel) {
        cacheModel.setGoodsList(this.goodsTransfer.combineSameGoods(cacheModel.getGoodsList()));
        return cacheModel;
    }

    protected CacheModel appendJdCoupon(ServiceSession session, CacheModel cacheModel) {
        return cacheModel;
    }

    protected CacheModel validateJDStock(ServiceSession session, CacheModel cacheModel) {
        return cacheModel;
    }

    protected CacheModel workBeforeCountAll(CacheModel cacheModel) {
        return cacheModel;
    }

    protected CacheModel workBeforePayDisc1(CacheModel cacheModel, CountAllIn countAllIn, ServiceSession session) {
        ActivityDetailSerchIn searchIn = new ActivityDetailSerchIn();
        searchIn.setHid(countAllIn.getHid());
        searchIn.setPdcode(countAllIn.getPdcode());
        log.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{cacheModel.getFlowNo(), "\u67e5\u8be2\u5b66\u5b50\u5361\u6d3b\u52a8\u4fc3\u9500", JSONObject.toJSONString((Object)searchIn)});
        RespBase resp = this.rebateCodeHeadRemoteService.detail(session, (JSONObject)JSONObject.toJSON((Object)searchIn));
        log.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{cacheModel.getFlowNo(), "\u67e5\u8be2\u5b66\u5b50\u5361\u6d3b\u52a8\u4fc3\u9500", JSONObject.toJSONString((Object)resp)});
        if (0 != resp.getRetflag()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(Code.CODE_30100.getIndex()));
            cacheModel.setErrMsg(resp.getRetmsg());
            return cacheModel;
        }
        JSONObject jsonObj = (JSONObject)resp.getData();
        ActivityDetailSerchOut detailOut = (ActivityDetailSerchOut)JSONObject.toJavaObject((JSON)jsonObj, ActivityDetailSerchOut.class);
        if (null == detailOut.getRebatecodedetail() || detailOut.getRebatecodedetail().size() == 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(Code.CODE_30110.getIndex()));
            cacheModel.setErrMsg(Code.CODE_30110.getMsg());
            return cacheModel;
        }
        if (null == detailOut.getRebatecodedetail() || detailOut.getRebatecodehead().size() != 1) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(Code.CODE_30110.getIndex()));
            cacheModel.setErrMsg(Code.CODE_30120.getMsg());
            return cacheModel;
        }
        List removeCatList = detailOut.getRebateremovecat();
        List cacheGoods = cacheModel.getGoodsList();
        log.info("[{}]\u5b66\u5b50\u5361\u5224\u65ad\uff0c\u8ba2\u5355\u5546\u54c1\u884c[{}]", (Object)cacheModel.getFlowNo(), (Object)JSONObject.toJSONString((Object)cacheGoods, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("[{}]\u5b66\u5b50\u5361\u5224\u65ad\uff0c\u6392\u9664\u5546\u54c1\u7c7b\u522b[{}]", (Object)cacheModel.getFlowNo(), (Object)JSONObject.toJSONString((Object)removeCatList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        for (Goods goods : cacheGoods) {
            if (this.promotionOfMssService.isHaveDiscount(goods)) continue;
            if (null != removeCatList && removeCatList.size() > 0) {
                boolean isremove = false;
                for (RebateRemoveCat removeCat : removeCatList) {
                    if (!removeCat.getRccatid().equals(goods.getCategoryCode())) continue;
                    isremove = true;
                    break;
                }
                if (isremove) continue;
            }
            double saleValue = goods.getSaleValue();
            double disCountRate = ((RebateCodeHead)detailOut.getRebatecodehead().get(0)).getRhrate();
            double studentCardDiscount = saleValue * (1.0 - disCountRate);
            double studentCardDiscountValue = ManipulatePrecision.doubleConvert((double)studentCardDiscount, (int)2, (int)1);
            goods.setStudentCardDiscountValue(studentCardDiscountValue);
            log.info("\u8ba1\u7b97\u5b66\u5b50\u5361\u6298\u6263 guid=[{}],saleValue=[{}] ,disCountRate=[{}],otherDiscount=[{}],otherDiscountValue=[{}]", new Object[]{goods.getGuid(), saleValue, disCountRate, studentCardDiscount, studentCardDiscountValue});
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        cacheModel.setCalcResult(7);
        return cacheModel;
    }

    protected CacheModel workBeforePayDisc2(CacheModel cacheModel, ServiceSession session) {
        if (this.promotionOfMssService.isNeedcalcXZK(cacheModel, session)) {
            this.posLogicCompoment.calcOrderAmount(cacheModel);
            cacheModel.setCalcResult(99);
        }
        return cacheModel;
    }

    public RespBase<ResqVo> calcSinglePop(ServiceSession session, String calcMode, String guid, Goods goods, ResqVo resqVo, List<PopDetail> popDetails, boolean isAdd, boolean isRefreshBillId) {
        return this.calcSinglePop(session, calcMode, guid, goods, resqVo, popDetails, isAdd, isRefreshBillId, false);
    }

    public RespBase<ResqVo> calcSinglePop(ServiceSession session, String calcMode, String guid, Goods goods, ResqVo resqVo, List<PopDetail> popDetails, boolean isAdd, boolean isRefreshBillId, boolean isNeedPopDetail) {
        log.info("calcSinglePop===============> begin ");
        log.info("goods 783===>popFlag={}", (Object)goods.getPopFlag());
        CacheModel cacheModel = this.promotionOfMssService.calcSinglePop(session, calcMode, guid, goods, resqVo.getCacheModel(), popDetails, isAdd, isRefreshBillId, isNeedPopDetail);
        log.info("calcSinglePop===============> end");
        if (-1 == cacheModel.getCalcResult()) {
            int code = Code.CODE_30006.getIndex();
            if (StringUtils.isNotEmpty((String)cacheModel.getErrCode())) {
                code = Integer.parseInt(cacheModel.getErrCode());
            }
            return new RespBase(code, cacheModel.getErrMsg());
        }
        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
    }

    public RespBase<ResqVo> calcSinglePopAfterVip(ServiceSession session, ResqVo resqVo, boolean needCalcDisc, boolean isMember) {
        CacheModel cacheModel = this.promotionOfMssService.calcSinglePopMember(session, resqVo.getCacheModel(), needCalcDisc, isMember);
        resqVo.setCacheModel(cacheModel);
        if (-1 == cacheModel.getCalcResult()) {
            int code = Code.CODE_40000.getIndex();
            if (StringUtils.isNotEmpty((String)cacheModel.getErrCode())) {
                code = Integer.parseInt(cacheModel.getErrCode());
            }
            return new RespBase(code, cacheModel.getErrMsg());
        }
        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
    }

    public RespBase saleReturn(ServiceSession session, ResqVo vo) {
        MohoReturnCoupon mohoReturnCoupon;
        CalSaleReturnOut calSaleReturnOut;
        ServiceResponse sr;
        String calcMode;
        JSONObject paramsObject = vo.getJsonObject();
        SaleReturnIn salesReturnIn = (SaleReturnIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + salesReturnIn.getShopCode() + salesReturnIn.getTerminalNo());
        obj = this.reCacheMode(obj, paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        if (trainingMode) {
            if (null != cacheModel.getReturnPayments() && cacheModel.getReturnPayments().size() > 0) {
                for (Payment p : cacheModel.getReturnPayments()) {
                    if (!StringUtils.isNotBlank((String)p.getPayMemo()) || !"COUPON".equals(p.getPayMemo()) && !"POINT".equals(p.getPayMemo())) continue;
                    p.setIsSuccess(true);
                    cacheModel.getPayments().add(p);
                    cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel);
                }
            }
            SaleReturnOut out = new SaleReturnOut(cacheModel, this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "CALCULATERETURNCERTIFY");
        }
        List sysparaOut = modeDetailsVo.getSyspara();
        if (StringUtils.isBlank((String)salesReturnIn.getGiftMode())) {
            salesReturnIn.setGiftMode("0");
        }
        String roundingMode = "";
        String paraValue = "";
        String khMode = "";
        String payCode = "0666";
        roundingMode = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"SYMS");
        paraValue = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"KHTH");
        khMode = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"KHMS");
        payCode = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"Q3");
        if (StringUtils.isBlank((String)roundingMode)) {
            roundingMode = "0";
        }
        if (StringUtils.isBlank((String)payCode)) {
            payCode = "0666";
        }
        String thMode = "Y";
        if (StringUtils.isNotBlank((String)paraValue)) {
            thMode = paraValue;
        }
        if (null == cacheModel.getBakGoods() || cacheModel.getBakGoods().size() <= 0) {
            cacheModel.backGoodsAndPayments();
        }
        if ("0".equals(calcMode = paramsObject.getString("calcMode")) && !SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) && !SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType()) && !SellType.isDfSale((String)cacheModel.getOrder().getOrderType()) && cacheModel.getPopMode() != 0) {
            sr = this.promotionOfMssService.calSaleReturn(session, cacheModel, salesReturnIn, khMode, true);
            if (!"0".equals(sr.getReturncode()) && !this.isCancelFlag(sr)) {
                log.info("\u8425\u9500\u9000\u8d27\u8ba2\u5355\u8ba1\u7b97\u5931\u8d25!==>{}", JSONObject.toJSON((Object)sr));
                return Code.CODE_30123.getRespBase(new Object[]{sr.getData().toString()});
            }
            if (!"nopop".equals(sr.getData().toString()) && !this.isCancelFlag(sr)) {
                calSaleReturnOut = (CalSaleReturnOut)sr.getData();
                if ((cacheModel = this.posLogicCompoment.calcOrderAfterCheckReturnMode0(cacheModel, calSaleReturnOut, salesReturnIn.getNotYpopPayCodes(), session)).getCalcResult() == -1) {
                    log.info("\u8c03\u7528\u8425\u9500\u8ba1\u7b97\u540e\u7684\u65b9\u6cd5\u5931\u8d25:{}", (Object)cacheModel.getErrMsg());
                    return Code.CODE_30123.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                cacheModel.getOrder().setSeqNo(calSaleReturnOut.getCalcBilid());
            }
        }
        if (!("99".equals(calcMode) || "2".equals(calcMode) || "-1".equals(calcMode) || cacheModel.getRefundGiftList().size() > 0 || cacheModel.getDeductedCoupons().size() > 0)) {
            calcMode = "99";
        }
        if ("1".equals(calcMode)) {
            if ("1".equals(salesReturnIn.getCalcMode())) {
                if ((cacheModel = this.posLogicCompoment.calcOrderAfterCheckReturnMode1(cacheModel, salesReturnIn.getGiftList(), salesReturnIn.getAutoBackPayCode(), salesReturnIn.getGiftMode(), thMode)).getCalcResult() == -1) {
                    log.info("posLogicCompoment.CalcOrderAfterCheckReturnMode1 \u8c03\u7528\u5931\u8d25:{}", (Object)cacheModel.getErrMsg());
                    return Code.CODE_30123.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                sr = this.promotionOfMssService.calSaleReturn(session, cacheModel, salesReturnIn, khMode, false);
                if (!"0".equals(sr.getReturncode()) && !this.isCancelFlag(sr)) {
                    log.info("\u8425\u9500\u9000\u8d27\u8ba2\u5355\u8ba1\u7b97\u5931\u8d25!==>{}", JSONObject.toJSON((Object)sr));
                    return Code.CODE_30123.getRespBase(new Object[]{sr.getData().toString()});
                }
                calSaleReturnOut = (CalSaleReturnOut)sr.getData();
                if ((cacheModel = this.posLogicCompoment.calcOrderAfterCheckReturnMode0(cacheModel, calSaleReturnOut, salesReturnIn.getNotYpopPayCodes(), session)).getCalcResult() == -1) {
                    log.info("\u8c03\u7528\u8425\u9500\u8ba1\u7b97\u540e\u7684\u65b9\u6cd5\u5931\u8d25:{}", (Object)cacheModel.getErrMsg());
                    return Code.CODE_30123.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
            }
            if ("0".equals(salesReturnIn.getGiftMode())) {
                Goods sg;
                double zpkhAmount = 0.0;
                for (int i = cacheModel.getGoodsList().size() - 1; i > 0 && (sg = (Goods)cacheModel.getGoodsList().get(i)).getIsNoBackGift(); --i) {
                    for (PopDetail pop : sg.getPopDetailsInfo()) {
                        if (!(pop.getDiscountAmount() > 0.0) || !YPopStatusType.pop_policy_group_gift.equals(pop.getPopPolicyGroup())) continue;
                        zpkhAmount = ManipulatePrecision.add((double)zpkhAmount, (double)pop.getDiscountAmount());
                    }
                }
                if (zpkhAmount > 0.0) {
                    if ("N".equals(thMode)) {
                        return Code.CODE_30137.getRespBase(new Object[0]);
                    }
                    if (ManipulatePrecision.doubleCompare((double)zpkhAmount, (double)cacheModel.getOrder().getRemainValue(), (int)2) > 0) {
                        return Code.CODE_30128.getRespBase(new Object[0]);
                    }
                    RespBase respCalSaleReturnKhje = this.calSaleReturnKhje(zpkhAmount, "\u8d60\u54c1\u6263\u56de", cacheModel.getOrder().getRemainValue(), vo);
                    if (respCalSaleReturnKhje != null && 0 != respCalSaleReturnKhje.getRetflag()) {
                        return respCalSaleReturnKhje;
                    }
                    Payment sp = new Payment();
                    sp.setPayCode(payCode);
                    sp.setPayName("\u8d60\u54c1\u6263\u56de");
                    sp.setAmount(zpkhAmount);
                    sp.setMoney(sp.getAmount());
                    sp.setRate(1.0);
                    sp.setFlag("1");
                    sp.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    sp.setRownoId(sp.getPuid());
                    sp.setIsAutoDelOnly(true);
                    sp.setIsAllowCharge("N");
                    sp.setIsOverage("N");
                    sp.setRowno(cacheModel.getPayments().size() + 1);
                    cacheModel.getPayments().add(sp);
                }
            }
            if (cacheModel.getDeductedCoupons().size() > 0) {
                calcMode = "3";
            }
        }
        if ("2".equals(calcMode)) {
            PaymentMode payMode = null;
            if (obj != null) {
                payMode = PayModeUtils.getPayMode((String)payCode, (JSONObject)JSONObject.parseObject((String)obj));
            }
            double khAmount = 0.0;
            for (SellCouponReverse couponReverse : cacheModel.getDeductedCoupons()) {
                if (couponReverse.getIsReverse() || "05".equals(couponReverse.getCouponGroup())) continue;
                if (ManipulatePrecision.doubleCompare((double)(khAmount = ManipulatePrecision.add((double)khAmount, (double)(couponReverse.getRemainAmount() * couponReverse.getReturnRate()))), (double)cacheModel.getOrder().getRemainValue(), (int)2) > 0) {
                    return Code.CODE_30139.getRespBase(new Object[0]);
                }
                RespBase respCalSaleReturnKhje = this.calSaleReturnKhje(khAmount, "\u6263\u56de", cacheModel.getOrder().getRemainValue(), vo);
                if (respCalSaleReturnKhje != null && 0 != respCalSaleReturnKhje.getRetflag()) {
                    return respCalSaleReturnKhje;
                }
                Payment p = new Payment();
                p.setFlag("1");
                p.setPayMemo("YKH");
                p.setPayCode(payCode);
                p.setPuid(String.valueOf(UniqueID.getUniqueID()));
                p.setRownoId(p.getPuid());
                p.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                p.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                p.setMoney(ManipulatePrecision.mul((double)couponReverse.getRemainAmount(), (double)couponReverse.getReturnRate()));
                p.setRate(couponReverse.getReturnRate());
                if (0.0 == couponReverse.getReturnRate()) {
                    couponReverse.setReturnRate(1.0);
                }
                p.setAmount(couponReverse.getRemainAmount());
                p.setPayName(couponReverse.getCouponName());
                p.setPayNo(couponReverse.getOriAccntNo());
                p.setCouponType(couponReverse.getCouponType());
                p.setCouponGroup(couponReverse.getCouponGroup());
                p.setIsAutoDelOnly(true);
                p.setPayType("FQKH");
                if (null != payMode) {
                    p.setPrcutMode(payMode.getSswrfs());
                    p.setPrecision("" + payMode.getSswrjd());
                    p.setIsOverage(payMode.getIsyy());
                    p.setIsAllowCharge(payMode.getIszl());
                } else {
                    p.setPrcutMode("0");
                    p.setPrecision("2");
                    p.setIsOverage("N");
                    p.setIsAllowCharge("N");
                }
                p.setRowno(cacheModel.getPayments().size() + 1);
                cacheModel.getPayments().add(p);
            }
        }
        if ((cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2) && "2".equals(cacheModel.getOrder().getOrderType())) {
            log.info("\u7ea2\u51b2\u5f00\u59cb");
            cacheModel = this.cancelOrder(session, cacheModel);
            if (-1 == cacheModel.getCalcResult()) {
                log.info("\u8c03\u7528\u8425\u9500\u63a5\u53e3\u5f02\u5e38!");
                return new RespBase(50000, cacheModel.getErrMsg(), cacheModel.getFlowNo());
            }
        }
        cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel);
        if ("0".equals(roundingMode) && ManipulatePrecision.doubleCompare((double)cacheModel.getOrder().getRoundUpOverageValue(), (double)0.0, (int)2) > 0) {
            try {
                cacheModel = this.addOveragePopDetail(session, cacheModel, false);
            }
            catch (Exception e) {
                return new RespBase(e.hashCode(), e.getMessage(), salesReturnIn.getFlowNo());
            }
        }
        if (null != cacheModel.getRefundGiftList() && cacheModel.getRefundGiftList().size() > 0 && StringUtils.isBlank((String)((Goods)cacheModel.getRefundGiftList().get(0)).getSkuId())) {
            for (Goods goods : cacheModel.getRefundGiftList()) {
                String artCode = "";
                String serchType = "1";
                GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                getGoodsDetailIn.setEntId(cacheModel.getOrder().getEntId());
                getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                getGoodsDetailIn.setCode(goods.getBarNo());
                getGoodsDetailIn.setSearchType(serchType);
                getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                String splitcode = "posshop:log:" + getGoodsDetailIn.getShopCode();
                if (this.redisUtil.hasKey(splitcode)) {
                    String splitodevalue = (String)this.redisUtil.hget(splitcode, "splitCode");
                    if (null == splitodevalue) {
                        splitodevalue = "";
                    }
                    getGoodsDetailIn.setSplitCode(splitodevalue);
                } else {
                    getGoodsDetailIn.setSplitCode("");
                }
                RespBase resp = this.goodsRemoteService.getGoodsFromMDM(session, (JSONObject)JSON.toJSON((Object)getGoodsDetailIn));
                if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                    return Code.CODE_60023.getRespBase(new Object[]{"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25"});
                }
                JSONObject gifJson = (JSONObject)resp.getData();
                GetGoodsDetailOut goodsDetailOut = (GetGoodsDetailOut)JSONObject.toJavaObject((JSON)gifJson, GetGoodsDetailOut.class);
                if (goodsDetailOut.getGoods() == null || goodsDetailOut.getGoods().size() <= 0) continue;
                GoodsInfo goodsInfo = (GoodsInfo)goodsDetailOut.getGoods().get(0);
                goods.setSkuId(goodsInfo.getSkuId());
            }
        }
        if ((mohoReturnCoupon = new MohoReturnCoupon(this, cacheModel, obj).invoke()).is()) {
            return Code.CODE_60023.getRespBase(new Object[]{"\u539f\u5355\u4f7f\u7528\u4e86\u4f18\u60e0\u5238,\u4e0d\u5141\u8bb8\u90e8\u5206\u9000\u8d27!"});
        }
        cacheModel = mohoReturnCoupon.getCacheModel();
        SaleReturnOut out = new SaleReturnOut(cacheModel, this.orderTransfer.toOrderForPos(cacheModel));
        if ("99".equals(calcMode)) {
            out.setResultMode("99");
        } else if ("-1".equals(calcMode)) {
            cacheModel.getOrder().setAllowEditGoods(false);
        } else {
            if (out.getGifts() != null && out.getGifts().size() > 0) {
                out.setResultMode("1");
            } else if (!"2".equals(calcMode) && out.getCoupons() != null && out.getCoupons().size() > 0 && !"1".equals(out.getResultMode())) {
                out.setResultMode("2");
            }
            if ("0".equals(out.getResultMode())) {
                cacheModel.getOrder().setAllowEditGoods(false);
            }
        }
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "CALCULATERETURNCERTIFY");
    }

    public CacheModel cancelOrder(ServiceSession session, CacheModel cacheModel) throws Exception {
        log.info("cancelOrder begin");
        CalcCancelOrderIn cancelOrderIn = new CalcCancelOrderIn();
        cancelOrderIn.setBillno(cacheModel.getOrder().getOriginFlowNo());
        cancelOrderIn.setChannel(cacheModel.getOrder().getChannel());
        cancelOrderIn.setType("0");
        double discountAmount = this.posLogicService.CalcPopDetail(cacheModel);
        ServiceResponse response = this.promotionCentreService.orderCancle(this.restTemplate, session, cancelOrderIn);
        if (!"0".equals(response.getReturncode()) && !SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType())) {
            if (!"60003".equals(response.getReturncode())) {
                cancelOrderIn.setType("1");
                this.promotionCentreService.orderCancle(this.restTemplate, session, cancelOrderIn);
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(response.getReturncode());
            cacheModel.setErrMsg(response.getData().toString());
            if (null != response.getData()) {
                cacheModel.setErrMsg(response.getData().toString());
            }
            return cacheModel;
        }
        log.info("\u8425\u9500\u53d6\u6d88\u5b8c\u6bd5");
        return cacheModel;
    }

    public RespBase<CacheModel> calcSinglePopAll(ServiceSession session, String calcMode, CacheModel cacheModel, boolean needCalcDisc) {
        this.promotionOfMssService.calcSinglePopAll(session, calcMode, cacheModel, needCalcDisc);
        if (-1 == cacheModel.getCalcResult()) {
            int code = Code.CODE_30124.getIndex();
            if (StringUtils.isNotEmpty((String)cacheModel.getErrCode())) {
                code = Integer.parseInt(cacheModel.getErrCode());
            }
            return new RespBase(code, cacheModel.getErrMsg());
        }
        return new RespBase(Code.SUCCESS, (Object)cacheModel, "");
    }

    public RespBase<CacheModel> calcCouponGain(ServiceSession session, CacheModel cacheModel, String netType, String newTerminalSno) {
        this.promotionOfMssService.calcCouponGain(session, cacheModel, netType, newTerminalSno);
        if (-1 == cacheModel.getCalcResult()) {
            int code = Code.CODE_30124.getIndex();
            if (StringUtils.isNotEmpty((String)cacheModel.getErrCode())) {
                code = Integer.parseInt(cacheModel.getErrCode());
            }
            return new RespBase(code, cacheModel.getErrMsg());
        }
        return new RespBase(Code.SUCCESS, (Object)cacheModel, "");
    }

    public RespBase<CacheModel> saveTrade(ServiceSession session, CacheModel cacheModel) {
        RespBase respBase = this.promotionOfHDService.saveTrade(session, cacheModel);
        return respBase;
    }

    public CacheModel addOveragePopDetail(ServiceSession session, CacheModel cacheModel, boolean isNeedCalc) {
        int maxDiscRow = 0;
        int maxAmountRow = 0;
        double maxAmount = 0.0;
        double maxDisc = 0.0;
        int i = 0;
        int j = cacheModel.getGoodsList().size();
        for (i = 0; i < j; ++i) {
            if (((Goods)cacheModel.getGoodsList().get(i)).getTotalDiscountValue() > maxDisc && ((Goods)cacheModel.getGoodsList().get(i)).getSaleAmount() > cacheModel.getOrder().getRoundUpOverageValue()) {
                maxDisc = ((Goods)cacheModel.getGoodsList().get(i)).getTotalDiscountValue();
                maxDiscRow = i;
            }
            if (!(((Goods)cacheModel.getGoodsList().get(i)).getSaleAmount() > maxAmount) || !(((Goods)cacheModel.getGoodsList().get(i)).getSaleAmount() > cacheModel.getOrder().getRoundUpOverageValue())) continue;
            maxAmount = ((Goods)cacheModel.getGoodsList().get(i)).getSaleAmount();
            maxAmountRow = i;
        }
        if (maxDisc > 0.0) {
            PopDetail pop = new PopDetail();
            pop.setDiscountAmount(cacheModel.getOrder().getRoundUpOverageValue());
            pop.setPopMode("0");
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
            pop.setPopPolicyType(YPopStatusType.pop_type_overage);
            pop.setPopDescribe("[ROUNDING]");
            pop.setGoodsRow((long)(maxDiscRow + 1));
            Goods good = (Goods)cacheModel.getGoodsList().get(maxDiscRow);
            good.getPopDetails().add(pop);
            good.setPopDiscountValue(ManipulatePrecision.doubleConvert((double)(good.getPopDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue()), (int)2, (int)1));
            good.setTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(good.getTotalDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue()), (int)2, (int)1));
            good.setSaleAmount(good.getSaleAmount() - cacheModel.getOrder().getRoundUpOverageValue());
            cacheModel.getGoodsList().set(maxDiscRow, good);
        } else if (maxAmount > 0.0) {
            PopDetail pop = new PopDetail();
            pop.setDiscountAmount(cacheModel.getOrder().getRoundUpOverageValue());
            pop.setPopMode("0");
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
            pop.setPopPolicyType(YPopStatusType.pop_type_overage);
            pop.setPopDescribe("[ROUNDING]");
            pop.setGoodsRow((long)(maxAmountRow + 1));
            Goods good = (Goods)cacheModel.getGoodsList().get(maxAmountRow);
            good.getPopDetails().add(pop);
            good.setPopDiscountValue(good.getPopDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue());
            good.setTotalDiscountValue(good.getTotalDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue());
            good.setSaleAmount(good.getSaleAmount() - cacheModel.getOrder().getRoundUpOverageValue());
            cacheModel.getGoodsList().set(maxAmountRow, good);
        } else {
            Collections.sort(cacheModel.getGoodsList(), Goods.saleAmountComparator);
            double overage = cacheModel.getOrder().getRoundUpOverageValue();
            for (Goods sg : cacheModel.getGoodsList()) {
                PopDetail pop;
                if (overage > sg.getSaleAmount()) {
                    pop = new PopDetail();
                    pop.setDiscountAmount(sg.getSaleAmount());
                    pop.setPopMode("0");
                    pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
                    pop.setPopPolicyType(YPopStatusType.pop_type_overage);
                    pop.setPopDescribe("[ROUNDING]");
                    pop.setGoodsRow((long)sg.getFlowId());
                    overage -= sg.getSaleAmount();
                    sg.getPopDetails().add(pop);
                    sg.setPopDiscountValue(sg.getPopDiscountValue() + sg.getSaleAmount());
                    sg.setTotalDiscountValue(sg.getTotalDiscountValue() + sg.getSaleAmount());
                    sg.setSaleAmount(0.0);
                    continue;
                }
                pop = new PopDetail();
                pop.setDiscountAmount(overage);
                pop.setPopMode("0");
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
                pop.setPopPolicyType(YPopStatusType.pop_type_overage);
                pop.setPopDescribe("[ROUNDING]");
                pop.setGoodsRow((long)sg.getFlowId());
                sg.getPopDetails().add(pop);
                sg.setPopDiscountValue(sg.getPopDiscountValue() + sg.getSaleAmount());
                sg.setTotalDiscountValue(sg.getTotalDiscountValue() + sg.getSaleAmount());
                sg.setSaleAmount(sg.getSaleAmount() - overage);
                break;
            }
            Collections.sort(cacheModel.getGoodsList(), Goods.flowIdComparator);
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        if (isNeedCalc) {
            cacheModel = this.promotionOfMssService.calcOrderPop(session, "6", cacheModel, true, false, false);
        }
        return cacheModel;
    }

    public RespBase choiceGifts(ServiceSession session, ResqVo resqVo, List<GiftTemp> choiceList, String fkcxs) {
        ArrayList<Gift> gifts = new ArrayList<Gift>();
        CacheModel cacheModel = resqVo.getCacheModel();
        cacheModel.getChoiceGiftsHaveNoPrice().clear();
        cacheModel.getChoiceGiftsHavePrice().clear();
        for (GiftTemp gift : choiceList) {
            Boolean flag = true;
            if (cacheModel.getGiftsGroup().size() < gift.getGroupId()) {
                return Code.CODE_30050.getRespBase(new Object[]{"\u4f20\u53c2\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u5206\u7ec4\uff0c\u8d60\u54c1code[ " + gift.getGoodsCode() + "]"});
            }
            GiftsGroup giftGroup = (GiftsGroup)cacheModel.getGiftsGroup().get(gift.getGroupId() - 1);
            if (giftGroup.getGroupId() != gift.getGroupId()) {
                return Code.CODE_30050.getRespBase(new Object[]{"\u4f20\u53c2\u6709\u8bef\uff0c\u5206\u7ec4ID\u9519\u8bef\uff0c\u8d60\u54c1code[" + gift.getGoodsCode() + "]"});
            }
            log.info("=-====giftGroup.getGiftGroup()=====>{}", (Object)JSONArray.toJSONString((Object)giftGroup.getGiftGroup()));
            for (Gift gift2 : giftGroup.getGiftGroup()) {
                if (!gift.getGuid().equalsIgnoreCase(gift2.getGuid())) continue;
                gift2.setQty(gift.getQty());
                gifts.add(gift2);
                gift2.setInfo1(gift.getInfo1());
                gift2.setInfo2(gift.getInfo2());
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            return Code.CODE_30050.getRespBase(new Object[]{"\u8d60\u54c1\u9009\u62e9\u6709\u8bef\uff0c\u8d60\u54c1code[" + gift.getGoodsCode() + "]"});
        }
        int flowId = cacheModel.getGoodsList().size() + 1;
        ArrayList<Goods> giftsHavePrice = new ArrayList<Goods>();
        ArrayList<Goods> giftsHaveNoPrice = new ArrayList<Goods>();
        for (Gift gift : gifts) {
            String serchType = "1";
            GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
            getGoodsDetailIn.setEntId(cacheModel.getOrder().getEntId());
            getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
            getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
            getGoodsDetailIn.setCode(gift.getCode());
            getGoodsDetailIn.setSearchType(serchType);
            getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
            String splitcode = "posshop:log:" + getGoodsDetailIn.getShopCode();
            if (this.redisUtil.hasKey(splitcode)) {
                String splitodevalue = (String)this.redisUtil.hget(splitcode, "splitCode");
                if (null == splitodevalue) {
                    splitodevalue = "";
                }
                getGoodsDetailIn.setSplitCode(splitodevalue);
            } else {
                getGoodsDetailIn.setSplitCode("");
            }
            RespBase resp = this.goodsRemoteService.getGoodsFromMDM(session, (JSONObject)JSONObject.toJSON((Object)getGoodsDetailIn));
            if (0 != resp.getRetflag()) {
                return Code.CODE_30070.getRespBase(new Object[0]);
            }
            JSONObject gifJson = (JSONObject)resp.getData();
            GetGoodsDetailOut goodsDetailOut = (GetGoodsDetailOut)JSONObject.toJavaObject((JSON)gifJson, GetGoodsDetailOut.class);
            if (goodsDetailOut.getGoods() != null && goodsDetailOut.getGoods().size() > 0) {
                GoodsInfo goodsInfo = (GoodsInfo)goodsDetailOut.getGoods().get(0);
                Goods goods = this.posLogicService.CalcGoodsAmountBeforeSingle(goodsInfo, this.getReturnTerminalOperator(cacheModel.getOrder().getTerminalOperator()), false, 0.0, 0.0, cacheModel.getEleCodeMode(), gift.getCode(), 1.0, false, cacheModel.getPopMode().intValue());
                if (goods == null) continue;
                if ("1".equals(gift.getMode())) {
                    goods.setFlag("8");
                } else if ("2".equals(gift.getMode())) {
                    goods.setFlag("1");
                } else {
                    goods.setFlag("0");
                }
                goods.setQty(gift.getQty());
                goods.setSaleValue(ManipulatePrecision.doubleConvert((double)(goods.getQty() * goods.getSalePrice()), (int)2, (int)1));
                goods.setSaleAmount(goods.getSaleValue());
                ArrayList popList = new ArrayList();
                goods.setPopDetails(popList);
                goods.setGuid(gift.getGuid());
                if (ManipulatePrecision.doubleConvert((double)goods.getSalePrice(), (int)2, (int)1) == 0.0) {
                    giftsHaveNoPrice.add(goods);
                    continue;
                }
                giftsHavePrice.add(goods);
                continue;
            }
            return Code.CODE_30080.getRespBase(new Object[]{"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u4e0d\u5230\u8d60\u54c1code[" + gift.getCode() + "]\u7684\u4fe1\u606f"});
        }
        if (giftsHaveNoPrice.size() > 0) {
            cacheModel.setChoiceGiftsHaveNoPrice(giftsHaveNoPrice);
            cacheModel.setChoiceGiftsHavePrice(giftsHavePrice);
            resqVo.setCacheModel(cacheModel);
            return new RespBase(Code.CODE_30071, (Object)resqVo, "");
        }
        HashSet<String> goodscodes = new HashSet<String>();
        for (Goods good : giftsHavePrice) {
            good.setFlowId(flowId);
            cacheModel.getGoodsList().add(good);
            ++flowId;
            if (!"N".equals(fkcxs) || 0 != good.getIsExcessSale() || !"1".equals(good.getGbmanamode())) continue;
            goodscodes.add(good.getGoodsCode());
        }
        if (goodscodes.size() > 0) {
            RespBase respBase = this.goodsRemoteService.searchShopStock(session, cacheModel, goodscodes);
            if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                return respBase;
            }
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        resqVo.setCacheModel(cacheModel);
        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
    }

    public CacheModel setNoPriceGifts(CacheModel cacheModel, List<Goods> noPriceGiftList) {
        List giftsHavePrice = cacheModel.getChoiceGiftsHavePrice();
        List giftsHaveNoPrice = cacheModel.getChoiceGiftsHaveNoPrice();
        block0: for (Goods good : noPriceGiftList) {
            for (Goods goodTemp : giftsHaveNoPrice) {
                if (!goodTemp.getGuid().equals(good.getGuid())) continue;
                Goods newsg = (Goods)goodTemp.clone();
                newsg.setPopDetails(new ArrayList());
                for (PopDetail pop : goodTemp.getPopDetails()) {
                    PopDetail newPop = (PopDetail)pop.clone();
                    newsg.getPopDetails().add(newPop);
                }
                newsg.setSalePrice(good.getSalePrice());
                newsg.setSaleValue(ManipulatePrecision.doubleConvert((double)(newsg.getQty() * newsg.getSalePrice()), (int)2, (int)1));
                newsg.setSaleAmount(newsg.getSaleValue());
                giftsHavePrice.add(newsg);
                continue block0;
            }
        }
        if (giftsHavePrice.size() > 0) {
            int flowId = cacheModel.getGoodsList().size() + 1;
            for (Goods good : giftsHavePrice) {
                good.setFlowId(flowId);
                cacheModel.getGoodsList().add(good);
                ++flowId;
            }
        }
        cacheModel.getChoiceGiftsHaveNoPrice().clear();
        cacheModel.getChoiceGiftsHavePrice().clear();
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    public String getReturnTerminalOperator(String strTerminalOperator) {
        return strTerminalOperator;
    }

    public RespBase calSaleReturnKhje(double khje, String tip, double remianValue, ResqVo vo) {
        return Code.SUCCESS.getRespBase(new Object[]{""});
    }

    public boolean isCancelFlag(ServiceResponse sr) {
        return false;
    }

    public RespBase returnCouponReverse(ServiceSession session, ResqVo resqVO) {
        return Code.SUCCESS.getRespBase(new Object[]{""});
    }
}

