/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.javaPos.struct.request.SkpResqVo;
import com.efuture.business.javaPos.struct.response.SkpRespVo;
import com.efuture.business.model.SkpVipDef;
import com.efuture.business.model.request.SkpVipLoginReq;
import com.efuture.business.model.response.SkpVipLoginRes;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.SkpVipSaleBS;
import com.efuture.business.service.SkpVipService;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SkpVipSaleBSImpl
implements SkpVipSaleBS {
    private static final Logger log = LoggerFactory.getLogger(SkpVipSaleBSImpl.class);
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    private CalcPopRemoteService calcPopRemoteService;
    @Autowired
    private PosLogicCompoment posLogicCompoment;
    @Autowired
    private SkpVipService skpVipService;
    @Autowired
    protected RedisUtil redisUtil;

    public RespBase getCardinfo(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("login ==>{}", (Object)paramsObject.toJSONString());
        String certifyType = paramsObject.getString("certifyType");
        if (StringUtils.isBlank((String)certifyType)) {
            return new RespBase(Code.CODE_40005.getIndex(), "\u4f1a\u5458\u767b\u9646\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u67e5\u8be2\u7c7b\u578b]");
        }
        SkpVipLoginReq paraIn = (SkpVipLoginReq)JSONObject.toJavaObject((JSON)paramsObject, SkpVipLoginReq.class);
        String obj = this.redisUtil.get(RedisKey.CACHEID + paraIn.getShopCode() + paraIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String czkdz = modeDetailsVo.getSyjmain().getCzkdz();
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = null;
        Order order = null;
        if (StringUtils.isNotBlank((String)flowNo)) {
            cacheModel = vo.getCacheModel();
            order = cacheModel.getOrder();
        }
        if (certifyType.equalsIgnoreCase("CANCEL") && StringUtils.isNotBlank((String)flowNo)) {
            order = cacheModel.getOrder();
            order.setTotalPoint(0.0);
            order.setConsumersData(null);
            cacheModel.setOrder(order);
            vo.setCacheModel(cacheModel);
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
            }
            RespBase rep = new RespBase();
            rep.setRetflag(0);
            rep.setData((Object)cacheModel);
            return rep;
        }
        SkpResqVo req = new SkpResqVo((Object)paraIn);
        ServiceResponse resp = this.skpVipService.execute(czkdz, session, JSON.toJSONString((Object)req), "\u4f1a\u5458\u4fe1\u606f\u67e5\u8be2", "BFPLAT.CRM.VIP.CARDINFO2");
        if ("0".equals(resp.getReturncode())) {
            SkpRespVo res = (SkpRespVo)resp.getData();
            if ("0".equals(res.getRetCode())) {
                SkpVipLoginRes queryOut = (SkpVipLoginRes)JSON.toJavaObject((JSON)res.getData(), SkpVipLoginRes.class);
                SkpVipDef skpVipDef = (SkpVipDef)queryOut.getVipCardInfos().get(0);
                BaseOutModel out = new BaseOutModel();
                ConsumersData custData = new ConsumersData();
                custData.setConsumersCard(skpVipDef.getVipCode());
                custData.setConsumersId(String.valueOf(skpVipDef.getVipId()));
                custData.setConsumersCName(skpVipDef.getVipName());
                custData.setConsumersType(String.valueOf(skpVipDef.getVipCardType()));
                custData.setConsumsersStatus(skpVipDef.getStatus());
                custData.setPoint(skpVipDef.getValidPoint());
                if (StringUtils.isBlank((String)flowNo)) {
                    OrderForPos ofs = new OrderForPos();
                    ofs.setTotalPoint(skpVipDef.getValidPoint());
                    ofs.setPointCardNo(skpVipDef.getVipCode());
                    ofs.setConsumersData(custData);
                    out.setOrder(ofs);
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    log.info("\u67e5\u627e\u4f1a\u5458\u51fa\u53c2:" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "MEMBERLOGIN")));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "MEMBERLOGIN");
                }
                order.setConsumersData(custData);
                cacheModel.setOrder(order);
                if (order.getStaffSale()) {
                    return new RespBase(Code.CODE_40000, "\u5df2\u5237\u5458\u5de5\u5361\u4e0d\u5141\u8bb8\u5237\u4f1a\u5458\u5361!");
                }
                if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0 && !SellType.isGroupbuy((String)order.getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy())) {
                    try {
                        vo.setCacheModel(cacheModel);
                        cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
                    }
                    if (cacheModel.getCalcResult() == -1) {
                        String errCode = "100000";
                        if (cacheModel.getErrCode().length() > 0) {
                            errCode = cacheModel.getErrCode();
                        }
                        return new RespBase(Code.CODE_40000, errCode + cacheModel.getErrMsg());
                    }
                }
                log.info("\u4f1a\u5458\u4fe1\u606f\uff1a[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getOrder().getConsumersData()));
                return new RespBase(Code.SUCCESS, (Object)cacheModel, flowNo);
            }
            return Code.CODE_40000.getRespBase(new Object[]{res.getRetMsg()});
        }
        return Code.CODE_40000.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
    }

    public CacheModel calcAfterMemberLoginOrCancel(CacheModel cacheModel, JSONObject paramsObject, ServiceSession session, ResqVo vo) {
        cacheModel.callMarketClear();
        cacheModel.getOrder().setSeqNo(null);
        vo.setCacheModel(cacheModel);
        if (cacheModel.getPopMode() == 1) {
            RespBase respBase = null;
            try {
                respBase = this.calcPopRemoteService.calcSinglePopAfterVipService(session, vo, true);
                if (0 == respBase.getRetflag()) {
                    cacheModel = ((ResqVo)respBase.getData()).getCacheModel();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
            }
        } else if (cacheModel.getPopMode() == 2) {
            String calcMode = "0";
            cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, paramsObject);
        }
        cacheModel = this.posLogicCompoment.CalcAdjustDiscAfterOrder(cacheModel);
        return cacheModel;
    }

    private CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, ResqVo vo, JSONObject paramsObject) {
        RespBase resp = new RespBase();
        CountAllIn countAllIn = new CountAllIn();
        countAllIn = (CountAllIn)countAllIn.transfer(paramsObject);
        countAllIn.setCalcMode(calcMode);
        List limitedPayCodes = CountAllIn.gainLimitedPayCodes((CacheModel)cacheModel, (CountAllIn)countAllIn);
        countAllIn.setLimitedPayCodes(limitedPayCodes);
        try {
            countAllIn = (CountAllIn)JSON.parseObject((String)paramsObject.toJSONString(), CountAllIn.class);
        }
        catch (Exception e) {
            resp.setData((Object)cacheModel);
        }
        RespBase respBase = null;
        try {
            log.info("\u4f1a\u5458\u8c03\u7528\u8425\u95002countall==>{}", JSONObject.toJSON((Object)countAllIn));
            respBase = this.calcPopRemoteService.calcAllPop(session, vo, countAllIn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f1a\u5458\u8c03\u7528\u6574\u5355\u8ba1\u7b97\u5f02\u5e38:" + e);
        }
        ResqVo resqVo = (ResqVo)respBase.getData();
        cacheModel = resqVo.getCacheModel();
        return cacheModel;
    }
}

