/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.javaPos.struct.request.ZBMemberConfirmIn;
import com.efuture.business.local.ZBRSAConfig;
import com.efuture.business.model.request.BaseRequest;
import com.efuture.business.model.request.ZhongBaio2oIn;
import com.efuture.business.model.request.Zhongbaio2oDataIn;
import com.efuture.business.model.response.ZbBaseResponse;
import com.efuture.business.model.response.ZhongbaiData;
import com.efuture.business.model.response.ZhongbaiUsr;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.ZBVipSaleBS;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.RSAUtil;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ZBVipSaleBSImpl
implements ZBVipSaleBS {
    private static final Logger log = LoggerFactory.getLogger(ZBVipSaleBSImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ZBVipSaleBSImpl.class);
    @Autowired
    private PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    private CalcPopRemoteService calcPopRemoteService;
    @Resource(name="ZBRSAConfig")
    public ZBRSAConfig ZBRSAConfig;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RespBase memberLogin(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        Order order;
        String flowNo;
        log.info("memberLogin ==>{}", (Object)paramsObject.toJSONString());
        ZBMemberConfirmIn paraIn = (ZBMemberConfirmIn)JSONObject.toJavaObject((JSON)paramsObject, ZBMemberConfirmIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (paraIn.getCertifyType() != null && paraIn.getCertifyType().equalsIgnoreCase("CANCEL") && StringUtils.isNotBlank((String)(flowNo = paramsObject.getString("flowNo")))) {
            Order order2 = cacheModel.getOrder();
            order2.setTotalPoint(0.0);
            order2.setThisTimePoint(0.0);
            order2.setConsumersData(null);
            cacheModel.setOrder(order2);
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0 && !SellType.isGroupbuy((String)order2.getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy())) {
                cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
            }
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos((CacheModel)cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            LOGGER.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKPAY")));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKPAY");
        }
        String ZBMCID = cacheModel.getOrder().getSysPara().outErpCode;
        if (StringUtils.isEmpty((String)ZBMCID)) {
            return new RespBase(Code.CODE_40000, "\u4ece\u603b\u90e8\u83b7\u53d6\u5546\u6237\u7ecf\u8425\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.ZBRSAConfig.setMcId(ZBMCID);
        ServiceResponse response = null;
        ZhongBaio2oIn in = new ZhongBaio2oIn();
        Zhongbaio2oDataIn dataIn = new Zhongbaio2oDataIn();
        try {
            dataIn.setTransDate(paraIn.getTransDate());
            dataIn.setPayCode(paraIn.getConsumersCard());
            dataIn.setListNo(paraIn.getTerminalSno());
            if ("002".equals(paraIn.getErpCode())) {
                dataIn.setStoreCode(paraIn.getShopCode().substring(0, 4));
            } else {
                dataIn.setStoreCode(paraIn.getShopCode());
            }
            dataIn.setPosId(paraIn.getTerminalNo());
            dataIn.setCashier(paraIn.getTerminalOperator());
            in.setData(dataIn);
            in.setTraceId(UUIDUtils.buildGuid());
            in.setVersion(this.ZBRSAConfig.getVersion());
            in.setMcId(this.ZBRSAConfig.getMcId());
            in.setPactId(this.ZBRSAConfig.getPactId());
            in.setService(BaseRequest.ZBServiceType.TransTypeQuery.code());
        }
        catch (Exception e) {
            LOGGER.info("[\u4f1a\u5458\u5165\u53c2\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38]");
            e.printStackTrace();
        }
        String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
        String flowNo2 = paramsObject.getString("flowNo");
        if (null == flowNo2 || "".equals(flowNo2)) {
            log.info("\u4e2d\u767e\u4f1a\u5458\u8bf7\u6c421==>{}", JSONObject.toJSON((Object)in));
            response = this.execute(session, JSON.toJSONString((Object)in), BaseRequest.ZBServiceType.TransTypeQuery.desc(), serviceUrl);
            log.info("\u4e2d\u767e\u4f1a\u5458\u8fd4\u56de1==>{}", JSONObject.toJSON((Object)response));
            if (!"0".equals(response.getReturncode())) return new RespBase(Code.CODE_40000, "\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25!");
            ZbBaseResponse res = (ZbBaseResponse)response.getData();
            if (!"SUCCESS".equals(res.getResultCode()) || null == res.getData()) return new RespBase(Code.CODE_40000, "\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25:" + res.getErrMsg());
            ZhongbaiData zbData = res.getData();
            ZhongbaiUsr usr = zbData.getUsr();
            if (null != usr) {
                BaseOutModel out = new BaseOutModel();
                OrderForPos ofs = new OrderForPos();
                ConsumersData custData = new ConsumersData();
                custData.setConsumersCard(usr.getUserCode());
                custData.setConsumersId(usr.getUserId());
                custData.setConsumersCName(usr.getUserName());
                custData.setConsumersType(zbData.getCodeType());
                custData.setConsumersLevel(usr.getGrade());
                custData.setPoint(usr.getPoint());
                ofs.setTotalPoint(usr.getPoint());
                ofs.setThisTimePoint(usr.getBcjf());
                ofs.setConsumersData(custData);
                out.setOrder(ofs);
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                LOGGER.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKPAY")));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKPAY");
            }
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            for (Goods sg : cacheModel.getGoodsList()) {
                if (!(sg.getElectronicStamp() > 0.0) && !(sg.getPhysicalStamp() > 0.0)) continue;
                return new RespBase(Code.CODE_40000, "\u5df2\u5b58\u5728\u6362\u8d2d\u4e0d\u5141\u8bb8\u518d\u5237\u4f1a\u5458\u5361!");
            }
        }
        if ((order = cacheModel.getOrder()).getStaffSale()) {
            return new RespBase(Code.CODE_40000, "\u5df2\u5237\u5458\u5de5\u5361\u4e0d\u5141\u8bb8\u5237\u4f1a\u5458\u5361!");
        }
        log.info("\u4e2d\u767e\u4f1a\u5458\u8bf7\u6c422==>{}", JSONObject.toJSON((Object)in));
        response = this.execute(session, JSON.toJSONString((Object)in), BaseRequest.ZBServiceType.TransTypeQuery.desc(), serviceUrl);
        log.info("\u4e2d\u767e\u4f1a\u5458\u8fd4\u56de2==>{}", JSONObject.toJSON((Object)response));
        if (!"0".equals(response.getReturncode())) return new RespBase(Code.CODE_40000, "\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25!");
        ZbBaseResponse res = (ZbBaseResponse)response.getData();
        if (!"SUCCESS".equals(res.getResultCode()) || null == res.getData()) return Code.CODE_40000.getRespBase(new Object[]{res.getErrMsg()});
        ZhongbaiData zbData = res.getData();
        ZhongbaiUsr usr = zbData.getUsr();
        if (null != usr) {
            ConsumersData custData = new ConsumersData();
            custData.setConsumersCard(usr.getUserCode());
            custData.setConsumersId(usr.getUserId());
            custData.setConsumersCName(usr.getUserName());
            custData.setConsumersType(zbData.getCodeType());
            custData.setConsumersLevel(usr.getGrade());
            custData.setPoint(usr.getPoint());
            if (StringUtils.isBlank((String)custData.getConsumersType()) && "CP".equals(custData.getConsumersType())) {
                custData.setCostomerPaycode(paraIn.getConsumersCard());
            }
            order.setTotalPoint(usr.getPoint());
            order.setThisTimePoint(usr.getBcjf());
            order.setConsumersData(custData);
        }
        cacheModel.setOrder(order);
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0 && !SellType.isGroupbuy((String)order.getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy())) {
            try {
                cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (cacheModel.getErrCode().length() <= 0) return new RespBase(Code.CODE_40000, errCode + cacheModel.getErrMsg());
                errCode = cacheModel.getErrCode();
                return new RespBase(Code.CODE_40000, errCode + cacheModel.getErrMsg());
            }
        }
        LOGGER.info("\u4f1a\u5458\u4fe1\u606f\uff1a[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getOrder().getConsumersData()));
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos((CacheModel)cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        LOGGER.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "ZBVIPLOGIN")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBVIPLOGIN");
    }

    public CacheModel calcAfterMemberLoginOrCancel(CacheModel cacheModel, JSONObject paramsObject, ServiceSession session, ResqVo vo) {
        PosLogicCompoment plc = new PosLogicCompoment();
        cacheModel.callMarketClear();
        cacheModel = plc.removeAeonCouponPopDetail(cacheModel);
        cacheModel.getOrder().setSeqNo("");
        if (cacheModel.getPopMode() == 1) {
            RespBase respBase = null;
            try {
                respBase = this.calcPopRemoteService.calcSinglePopAfterVipService(session, vo, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
            }
        } else if (cacheModel.getPopMode() == 2) {
            String calcMode = "0";
            cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, paramsObject);
        } else {
            this.posLogicCompoment.calcOrderAmount(cacheModel);
        }
        cacheModel = plc.CalcAdjustDiscAfterOrder(cacheModel);
        return cacheModel;
    }

    private CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, ResqVo vo, JSONObject paramsObject) {
        RespBase resp = new RespBase();
        CountAllIn countAllIn = new CountAllIn();
        countAllIn = (CountAllIn)countAllIn.transfer(paramsObject);
        countAllIn.setCalcMode(calcMode);
        List limitedPayCodes = CountAllIn.gainLimitedPayCodes((CacheModel)cacheModel, (CountAllIn)countAllIn);
        countAllIn.setLimitedPayCodes(limitedPayCodes);
        try {
            countAllIn = (CountAllIn)JSON.parseObject((String)paramsObject.toJSONString(), CountAllIn.class);
        }
        catch (Exception e) {
            resp.setData((Object)cacheModel);
            log.info("\u4f1a\u5458\u6574\u5355\u8ba1\u7b97\u5165\u53c2\u8f6c\u6362\u5f02\u5e38CountAllIn ==>{}", (Object)e.toString());
        }
        RespBase respBase = null;
        try {
            respBase = this.calcPopRemoteService.calcAllPop(session, vo, countAllIn);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("\u4f1a\u5458\u8c03\u7528\u6574\u5355\u8ba1\u7b97\u5f02\u5e38:" + e);
        }
        ResqVo resqVo = (ResqVo)respBase.getData();
        cacheModel = resqVo.getCacheModel();
        return cacheModel;
    }

    public ServiceResponse execute(ServiceSession session, String inStr, String serviceType, String RemoteServiceUrl) {
        RSAUtil.getPrivateKey((String)this.ZBRSAConfig.getRSAPrivateKey());
        RSAUtil.getPublicKey((String)this.ZBRSAConfig.getRSAPublicKey());
        if (StringUtils.isEmpty((String)RemoteServiceUrl)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u5238\u5e73\u53f0\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a!");
        }
        HttpUtils httpUtils = new HttpUtils();
        ServiceResponse resp = httpUtils.zhongbaiDataCenterPost(null, HttpUtils.RemoteService.ZHONGBAI_DATACENTER, RemoteServiceUrl, session, inStr, ZbBaseResponse.class, "\u4e2d\u767e\u5238\u5e73\u53f0", serviceType);
        return resp;
    }
}

