/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.VipSaleDao_GZYY;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.gzyy.request.GZYYMemberConfirmIn;
import com.efuture.business.javaPos.struct.gzyy.response.VipInfoProcessOut;
import com.efuture.business.javaPos.struct.gzyy.response.VipLoginProcessOut;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.model.gzyy.FindVipIn;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.impl.VipSaleBSImpl;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceSession;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class VipSaleBSImpl_GZYY
extends VipSaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(VipSaleBSImpl_GZYY.class);
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    private CalcPopRemoteService calcPopRemoteService;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;
    @Autowired
    private PosLogicCompoment posLogicCompoment;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private VipSaleDao_GZYY vipSaleDao_gzyy;
    @Autowired
    private GlobalInfo globalInfo;

    public RespBase login(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel;
        block32: {
            log.info("login1 ==>{}", (Object)paramsObject.toJSONString());
            if (!paramsObject.containsKey((Object)"consumersCard") || paramsObject.getString("consumersCard").isEmpty()) {
                return new RespBase(Code.CODE_40005.getIndex(), "\u4f1a\u5458\u767b\u9646\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f1a\u5458\u53f7]");
            }
            if (!paramsObject.containsKey((Object)"certifyType") || paramsObject.getString("certifyType").isEmpty()) {
                return new RespBase(Code.CODE_40005.getIndex(), "\u4f1a\u5458\u767b\u9646\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u67e5\u8be2\u7c7b\u578b]");
            }
            GZYYMemberConfirmIn paraIn = (GZYYMemberConfirmIn)JSONObject.toJavaObject((JSON)paramsObject, GZYYMemberConfirmIn.class);
            cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return new RespBase(Code.CODE_60.getIndex(), "\u7f13\u5b58\u5df2\u5931\u6548");
            }
            String flowNo = paramsObject.getString("flowNo");
            Order order = cacheModel.getOrder();
            if (paraIn.getCertifyType() != null && paraIn.getCertifyType().equalsIgnoreCase("CANCEL") && StringUtils.isNotBlank((String)flowNo)) {
                order = cacheModel.getOrder();
                order.setTotalPoint(0.0);
                order.setConsumersData(null);
                cacheModel.setOrder(order);
                vo.setCacheModel(cacheModel);
                if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                    cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
                }
                log.info("\u4f1a\u5458\u767b\u51fa\u6ce8\u9500");
                return new RespBase(Code.SUCCESS, (Object)cacheModel, "MEMBERLOGIN");
            }
            if ("1".equals(GlobalInfo.mssLocalIsOpen)) {
                if (order == null) {
                    return new RespBase(Code.CODE_40003.getIndex(), "\u8ba2\u5355\u5df2\u5931\u6548");
                }
                if (!(paraIn.getConsumersCard().startsWith("30") && paraIn.getConsumersCard().startsWith("31") && paraIn.getConsumersCard().startsWith("10"))) {
                    return new RespBase(Code.CODE_40000.getIndex(), "\u8131\u673a\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25");
                }
                RespBase rep = new RespBase();
                ConsumersData custData = new ConsumersData();
                custData.setConsumersCard(paraIn.getConsumersCard());
                custData.setConsumersId(paraIn.getConsumersCard());
                custData.setConsumersType("30");
                custData.setConsumsersStatus("0");
                custData.setLoginMode(paraIn.getLoginMode());
                order.setConsumersData(custData);
                cacheModel.setOrder(order);
                vo.setCacheModel(cacheModel);
                log.info("\u8425\u9500\u8131\u673a\u5237\u8425\u9500\u4f1a\u5458\u8fd4\u56de==>{}", JSONObject.toJSON((Object)cacheModel));
                rep.setRetflag(0);
                if (StringUtils.isBlank((String)cacheModel.getOrder().getOriginTerminalSno()) && cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                    cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
                }
                rep.setData((Object)cacheModel);
                return rep;
            }
            RespBase respBase = null;
            JSONObject json = new JSONObject();
            json.put("vcode", (Object)paraIn.getConsumersCard());
            json.put("vmkt", (Object)paraIn.getShopCode());
            json.put("certifyType", (Object)paraIn.getCertifyType());
            try {
                if (paraIn.getCertifyType().equalsIgnoreCase("QUERYINFO")) {
                    respBase = this.findVip(session, json);
                    if (respBase.getRetflag() != 0) {
                        return respBase;
                    }
                    ConsumersData custData = (ConsumersData)respBase.getData();
                    if (StringUtils.isBlank((String)custData.getConsumersCard())) {
                        return new RespBase(Code.CODE_40001, cacheModel.getFlowNo());
                    }
                    custData.setConsumsersStatus("0");
                    custData.setLoginMode(paraIn.getLoginMode());
                    order.setTotalPoint(CastUtil.castDouble((Object)custData.getPoint()));
                    order.setPointCardNo(custData.getConsumersCard());
                    order.setExtendFt2(paraIn.getLoginMode());
                    order.setConsumersData(custData);
                    cacheModel.setOrder(order);
                    vo.setCacheModel(cacheModel);
                    log.info("\u4f1a\u5458\u67e5\u8be2\u51fa\u53c2:" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)cacheModel, "MEMBERLOGIN")));
                    return new RespBase(Code.SUCCESS, (Object)cacheModel, "MEMBERLOGIN");
                }
                if (paraIn.getCertifyType().equalsIgnoreCase("PAYQUERY")) {
                    respBase = this.findVip(session, json);
                    if (respBase.getRetflag() != 0) {
                        return respBase;
                    }
                    ConsumersData custData = (ConsumersData)respBase.getData();
                    if (StringUtils.isBlank((String)custData.getConsumersCard())) {
                        return new RespBase(Code.CODE_40001, cacheModel.getFlowNo());
                    }
                    custData.setConsumsersStatus("0");
                    custData.setLoginMode(paraIn.getLoginMode());
                    order.setTotalPoint(CastUtil.castDouble((Object)custData.getPoint()));
                    order.setPointCardNo(custData.getConsumersCard());
                    order.setExtendFt2(paraIn.getLoginMode());
                    order.setConsumersData(custData);
                    cacheModel.setOrder(order);
                    vo.setCacheModel(cacheModel);
                    log.info("\u4f1a\u5458\u67e5\u8be2\u51fa\u53c2:" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)cacheModel, "MEMBERLOGIN")));
                    return new RespBase(Code.SUCCESS, (Object)cacheModel, "MEMBERLOGIN");
                }
                if (!paraIn.getCertifyType().equalsIgnoreCase("VIPLOGIN")) break block32;
                if (!StringUtils.isNotBlank((String)flowNo)) {
                    return new RespBase(40005, "\u4f1a\u5458\u8ba4\u8bc1\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7f13\u5b58\u53f7]");
                }
                if (StringUtils.isEmpty((String)paraIn.getLoginMode())) {
                    return new RespBase(40005, "\u4f1a\u5458\u8ba4\u8bc1\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u767b\u5f55\u7c7b\u578b]");
                }
                if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
                    for (Goods sg : cacheModel.getGoodsList()) {
                        if (!(sg.getElectronicStamp() > 0.0) && !(sg.getPhysicalStamp() > 0.0)) continue;
                        return new RespBase(Code.CODE_40000, "\u5df2\u5b58\u5728\u6362\u8d2d\u4e0d\u5141\u8bb8\u518d\u5237\u4f1a\u5458\u5361!");
                    }
                }
                if (order.getStaffSale()) {
                    return new RespBase(Code.CODE_40000, "\u5df2\u5237\u5458\u5de5\u5361\u4e0d\u5141\u8bb8\u5237\u4f1a\u5458\u5361!");
                }
                respBase = this.findVip(session, json);
                if (respBase.getRetflag() != 0) {
                    return respBase;
                }
                ConsumersData custData = (ConsumersData)respBase.getData();
                if (StringUtils.isBlank((String)custData.getConsumersCard())) {
                    return new RespBase(Code.CODE_40001, cacheModel.getFlowNo());
                }
                if (custData.getConsumersCName().startsWith("F")) {
                    return new RespBase(Code.CODE_40000, "\u5361\u5df2\u51bb\u7ed3");
                }
                if (custData.getConsumersCName().startsWith("Z")) {
                    return new RespBase(Code.CODE_40000, "\u5361\u5df2\u6ce8\u9500");
                }
                if (custData.getConsumersCName().startsWith("L")) {
                    return new RespBase(Code.CODE_40000, "\u5361\u5df2\u6302\u5931");
                }
                if (custData.getConsumersCName().startsWith("K")) {
                    return new RespBase(Code.CODE_40000, "\u5361\u5df2\u5931\u6548");
                }
                custData.setConsumsersStatus("0");
                custData.setLoginMode(paraIn.getLoginMode());
                order.setTotalPoint(CastUtil.castDouble((Object)custData.getPoint()));
                order.setPointCardNo(custData.getConsumersCard());
                order.setExtendFt2(paraIn.getLoginMode());
                order.setConsumersData(custData);
                cacheModel.setOrder(order);
                if (cacheModel.getGoodsList() == null || cacheModel.getGoodsList().size() <= 0 || SellType.isGroupbuy((String)order.getOrderType()) || SellType.ISBACK((String)order.getOrderType())) break block32;
                try {
                    vo.setCacheModel(cacheModel);
                    cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
                }
                if (cacheModel.getCalcResult() == -1) {
                    String errCode = "100000";
                    if (cacheModel.getErrCode().length() > 0) {
                        errCode = cacheModel.getErrCode();
                    }
                    return new RespBase(Code.CODE_40000, errCode + cacheModel.getErrMsg());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return new RespBase(Code.CODE_40000.getIndex(), "\u4f1a\u5458\u67e5\u8be2\u5931\u8d25!", null, "MEMBERLOGIN");
            }
        }
        log.info("\u4f1a\u5458\u4fe1\u606f\uff1a[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getOrder().getConsumersData()));
        return new RespBase(Code.SUCCESS, (Object)cacheModel, "MEMBERLOGIN");
    }

    public RespBase CustomerPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        return null;
    }

    public RespBase SaleCorrect(ServiceSession session, ResqVo rvo, JSONObject paramsObject) {
        return null;
    }

    public RespBase CardClear(ServiceSession session, ResqVo rvo, JSONObject paramsObject) {
        return null;
    }

    private CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, ResqVo vo, JSONObject paramsObject) {
        RespBase resp = new RespBase();
        CountAllIn countAllIn = new CountAllIn();
        countAllIn = (CountAllIn)countAllIn.transfer(paramsObject);
        countAllIn.setCalcMode(calcMode);
        List limitedPayCodes = CountAllIn.gainLimitedPayCodes((CacheModel)cacheModel, (CountAllIn)countAllIn);
        countAllIn.setLimitedPayCodes(limitedPayCodes);
        try {
            countAllIn = (CountAllIn)JSON.parseObject((String)paramsObject.toJSONString(), CountAllIn.class);
        }
        catch (Exception e) {
            resp.setData((Object)cacheModel);
            log.info("\u4f1a\u5458\u6574\u5355\u8ba1\u7b97\u5165\u53c2\u8f6c\u6362\u5f02\u5e38CountAllIn ==>{}", (Object)e.toString());
        }
        RespBase respBase = null;
        try {
            respBase = this.calcPopRemoteService.calcAllPop(session, vo, countAllIn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f1a\u5458\u8c03\u7528\u6574\u5355\u8ba1\u7b97\u5f02\u5e38:" + e);
        }
        ResqVo resqVo = (ResqVo)respBase.getData();
        cacheModel = resqVo.getCacheModel();
        return cacheModel;
    }

    public RespBase findVip(ServiceSession session, JSONObject jsonObject) {
        FindVipIn findVipIn = (FindVipIn)JSON.parseObject((String)jsonObject.toJSONString(), FindVipIn.class);
        if (StringUtils.isEmpty((String)findVipIn.getCertifyType())) {
            return Code.CODE_40002.getRespBase(new Object[]{"\u4f1a\u5458\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u67e5\u8be2\u7c7b\u578b]!"});
        }
        VipLoginProcessOut vipLoginProcessOut = this.vipSaleDao_gzyy.findVip(jsonObject.toJSONString());
        if (findVipIn.getCertifyType().equalsIgnoreCase("QUERYINFO")) {
            if (vipLoginProcessOut.getRet() == 1) {
                JSONObject json = new JSONObject();
                json.put("vcardno", (Object)vipLoginProcessOut.rcode);
                json.put("vstr1", (Object)"");
                json.put("vstr2", (Object)"");
                String jsonIn = JSON.toJSONString((Object)json);
                VipInfoProcessOut vipInfoProcessOut = this.vipSaleDao_gzyy.findVipInfo(jsonIn);
                if (vipInfoProcessOut.ret == 1) {
                    ConsumersData custData = new ConsumersData();
                    if (StringUtils.isBlank((String)vipInfoProcessOut.getRcode())) {
                        return new RespBase(Code.CODE_40001);
                    }
                    custData.setConsumersCard(vipInfoProcessOut.getRcode());
                    custData.setConsumersId(vipInfoProcessOut.getRcode());
                    custData.setConsumersCName(vipInfoProcessOut.getRname());
                    custData.setConsumersType(vipInfoProcessOut.getRtype());
                    custData.setConsumsersStatus(vipInfoProcessOut.getRstatus());
                    custData.setConsumersCardExp(vipInfoProcessOut.getRmaxdate());
                    custData.setPointByYear(Double.valueOf(vipInfoProcessOut.getRvalue1()).doubleValue());
                    custData.setPonitFL(Double.valueOf(vipInfoProcessOut.getRvalue2()).doubleValue());
                    return new RespBase(Code.SUCCESS, (Object)custData);
                }
                return new RespBase(40000, "\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
            }
            return new RespBase(40000, "\u67e5\u8be2\u4f1a\u5458\u5361\u53f7\u5931\u8d25");
        }
        if (findVipIn.getCertifyType().equalsIgnoreCase("PAYQUERY")) {
            if (vipLoginProcessOut.getRet() == 1) {
                ConsumersData custData = new ConsumersData();
                if (StringUtils.isBlank((String)vipLoginProcessOut.getRcode())) {
                    return new RespBase(Code.CODE_40001);
                }
                custData.setConsumersCard(vipLoginProcessOut.getRcode());
                custData.setConsumersId(vipLoginProcessOut.getRcode());
                custData.setConsumersCName(vipLoginProcessOut.getRname());
                custData.setConsumersType(vipLoginProcessOut.getRtype());
                custData.setZkl(CastUtil.castDouble((Object)vipLoginProcessOut.getRzkl()) / 100.0);
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue1())) {
                    custData.setPoint(Double.valueOf(vipLoginProcessOut.getRvalue1()).doubleValue());
                }
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue2())) {
                    custData.setPointMoneyJF(Double.valueOf(vipLoginProcessOut.getRvalue2()).doubleValue());
                }
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue3())) {
                    custData.setPointMoney(Double.valueOf(vipLoginProcessOut.getRvalue3()).doubleValue());
                }
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue4())) {
                    custData.setPonitMoneyRuleNum(Double.valueOf(vipLoginProcessOut.getRvalue4()).doubleValue());
                }
                return new RespBase(Code.SUCCESS, (Object)custData);
            }
            return new RespBase(40000, "\u4f1a\u5458\u79ef\u5206\u67e5\u8be2\u5931\u8d25");
        }
        if (findVipIn.getCertifyType().equalsIgnoreCase("VIPLOGIN")) {
            if (vipLoginProcessOut.getRet() == 1) {
                if (StringUtils.isBlank((String)vipLoginProcessOut.getRcode())) {
                    return new RespBase(Code.CODE_40001);
                }
                ConsumersData custData = new ConsumersData();
                custData.setConsumersCard(vipLoginProcessOut.getRcode());
                custData.setConsumersId(vipLoginProcessOut.getRcode());
                custData.setConsumersCName(vipLoginProcessOut.getRname());
                custData.setConsumersType(vipLoginProcessOut.getRtype());
                custData.setZkl(CastUtil.castDouble((Object)vipLoginProcessOut.getRzkl()) / 100.0);
                custData.setConsumsersStatus("0");
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue1())) {
                    custData.setPoint(Double.valueOf(vipLoginProcessOut.getRvalue1()).doubleValue());
                }
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue2())) {
                    custData.setPointMoneyJF(Double.valueOf(vipLoginProcessOut.getRvalue2()).doubleValue());
                }
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue3())) {
                    custData.setPointMoney(Double.valueOf(vipLoginProcessOut.getRvalue3()).doubleValue());
                }
                if (!StringUtils.isEmpty((String)vipLoginProcessOut.getRvalue4())) {
                    custData.setPonitMoneyRuleNum(Double.valueOf(vipLoginProcessOut.getRvalue4()).doubleValue());
                }
                return new RespBase(Code.SUCCESS, (Object)custData);
            }
            return new RespBase(40000, "\u4f1a\u5458\u8ba4\u8bc1\u5931\u8d25");
        }
        return null;
    }

    public CacheModel calcAfterMemberLoginOrCancel(CacheModel cacheModel, JSONObject paramsObject, ServiceSession session, ResqVo vo) {
        cacheModel.callMarketClear();
        cacheModel.getOrder().setSeqNo(null);
        vo.setCacheModel(cacheModel);
        double tempzzk = cacheModel.getOrder().getTempZzk();
        double tempzzr = cacheModel.getOrder().getTempZzr();
        List goodsList = cacheModel.getGoodsList();
        for (Goods goods : goodsList) {
            this.resetErpcustdiscount(cacheModel.getOrder().getConsumersData(), goods);
        }
        if (cacheModel.getPopMode() == 1) {
            RespBase respBase = null;
            try {
                respBase = this.calcPopRemoteService.calcSinglePopAfterVipService(session, vo, true);
                if (0 == respBase.getRetflag()) {
                    cacheModel = ((ResqVo)respBase.getData()).getCacheModel();
                }
            }
            catch (Exception e) {
                log.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
            }
        } else if (cacheModel.getPopMode() == 2) {
            String calcMode = "0";
            cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, paramsObject);
        }
        cacheModel.getOrder().setTempZzk(tempzzk);
        cacheModel.getOrder().setTempZzr(tempzzr);
        cacheModel = this.posLogicCompoment.CalcAdjustDiscAfterOrder(cacheModel);
        return cacheModel;
    }

    public Goods resetErpcustdiscount(ConsumersData consumersData, Goods goods) {
        String precisionMode;
        if ("Y".equals(goods.getNoPricing())) {
            return goods;
        }
        if (null == consumersData || StringUtils.isEmpty((String)consumersData.getConsumersType())) {
            goods.setBarcodeDiscount(0.0);
            goods.setDisMode(0);
            goods.setDiscType("");
            goods.setDisValue(0.0);
            if (null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
                for (int i = 0; i < goods.getPopDetailsInfo().size(); ++i) {
                    PopDetail pop = (PopDetail)goods.getPopDetailsInfo().get(i);
                    if (!YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) continue;
                    goods.getPopDetailsInfo().remove(i);
                    --i;
                }
            }
            goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(PosLogicCompoment.getZZK((Goods)goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            return goods;
        }
        if ("2".equals(consumersData.getLoginMode())) {
            return goods;
        }
        double marketzk = 0.0;
        if ("10".equals(consumersData.getConsumersType()) && !"1".equals(goods.getDiscountFlag()) && goods.getMemberPrice() > 0.0) {
            precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
            goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSalePrice() - goods.getMemberPrice()), (String)precisionMode));
            goods.setDisMode(3);
            goods.setDisValue(goods.getMemberPrice());
            goods.setDiscType("0");
            marketzk = goods.getShareDiscount2();
        }
        if (("30".equals(consumersData.getConsumersType()) || "32".equals(consumersData.getConsumersType())) && !"1".equals(goods.getDiscountFlag()) && goods.getBulkPrice() > 0.0) {
            precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
            goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSalePrice() - goods.getBulkPrice()), (String)precisionMode));
            goods.setDisMode(3);
            goods.setDisValue(goods.getBulkPrice());
            goods.setDiscType("0");
            marketzk = goods.getShareDiscount1();
        }
        goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
        goods.setTotalDiscountValue(PosLogicCompoment.getZZK((Goods)goods));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        goods.setFdmode("3");
        goods.setVipfdzkfd(ManipulatePrecision.doubleConvert((double)(marketzk / 100.0)));
        return goods;
    }

    public RespBase giveOrReverse(ServiceSession session, ResqVo rvo, JSONObject paramsObject) {
        return null;
    }

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initializationRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }
}

