package com.efuture.ocp.common.distributedLock;

public interface DistributedLockHandle
{

    /**
     * 获取分布式锁
     *
     * @param key             锁Key
     * @param lockExpire      锁的缓存时间（单位：秒）
     * @param waitMillSeconds
     * @return boolean
     */
    DLockInfo tryLock(String key, int lockExpire, int waitMillSeconds);

    /**
     * 释放锁
     *
     * @param key 锁Key
     */
    void unlock(String key, int lockExpire);

    void unlock(String key);

    void unlock(DLockInfo lockInfo);

    /**
     * 到期续约
     *
     * @param lockInfo
     */
    void renewal(DLockInfo lockInfo);
}
