package com.efuture.ocp.common.distributedLock;

import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.distributedLock.exception.DistributedLockCacheException;
import com.efuture.ocp.common.distributedLock.exception.DistributedLockIsExistException;
import com.efuture.ocp.common.exception.ResponseCode;

import java.util.concurrent.Callable;

public class LockTemplate {

    DistributedLockHandle lockHandle;

    public LockTemplate(DistributedLockHandle lockHandle) {
        this.lockHandle = lockHandle;
    }

    public Object lock(String lockKey, int lockExpire, int waitMillSeconds, Callable call) {
        DLockInfo lock;

        try {
            lock = lockHandle.tryLock(lockKey, lockExpire, waitMillSeconds);
        } catch (Exception e) {
            ServiceLogs.errLog("DistributedLock", e, "获取锁失败[{0}]");
            throw new DistributedLockCacheException(ResponseCode.EXCEPTION, "获取锁失败[{0}]", lockKey);
        }

        if (lock == null) {
            throw new DistributedLockIsExistException(ResponseCode.EXCEPTION, "获取锁失败[{0}]", lockKey);
        }
        Object rtn = null;
        try {
            rtn = call.call();
        } catch (Throwable e) {
            throw e;
        } finally {
            lockHandle.unlock(lock);
            return rtn;
        }

    }

    public Object lock(String lockKey, Callable call) {
        return lock(lockKey, 120, 0, call);
    }
}
