/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.callnumber;

import cn.hutool.core.thread.ExecutorBuilder;
import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.callnumber.CallNumberHandle;
import com.efuture.ocp.common.callnumber.NumberInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class CallNumberExecutor {
    CallNumberHandle handle;
    ConcurrentMap<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();
    ConcurrentMap<String, List<CallNumberRuner>> workers = new ConcurrentHashMap<String, List<CallNumberRuner>>();

    public CallNumberExecutor(CallNumberHandle handle) {
        this.handle = handle;
    }

    public void submit(String bizName, int maxNum, int maxWorker, Consumer<NumberInfo> worker) {
        ExecutorService executorService = this.executors.computeIfAbsent(bizName, key -> ExecutorBuilder.create().setMaxPoolSize(maxWorker).setCorePoolSize(0).build());
        List workList = this.workers.computeIfAbsent(bizName, key -> {
            ArrayList<CallNumberRuner> runers = new ArrayList<CallNumberRuner>();
            for (int i = 0; i < maxWorker; ++i) {
                CallNumberRuner run = new CallNumberRuner((String)key, maxNum, i - 1, worker);
                runers.add(run);
            }
            return runers;
        });
        if (workList.size() < maxWorker) {
            for (int i = workList.size() - 1; i < maxWorker; ++i) {
                CallNumberRuner run = new CallNumberRuner(bizName, maxNum, i, worker);
                workList.add(run);
            }
        }
        for (CallNumberRuner runer : workList) {
            executorService.submit(runer);
        }
    }

    public boolean watchPrint(String bizName) {
        List workList = (List)this.workers.get(bizName);
        boolean ibRun = false;
        for (CallNumberRuner runer : workList) {
            ibRun = runer.isRunning();
            ServiceLogs.truedebuglog((String)"watchPrint", (String)runer.watch(), (long)0L, (Object[])new Object[0]);
        }
        return ibRun;
    }

    public CallNumberRuner call(String bizName, int maxNumer, Consumer<NumberInfo> worker) {
        CallNumberRuner run = new CallNumberRuner(bizName, maxNumer, 0, worker);
        run.run();
        return run;
    }

    public NumberInfo getNumber(String bizName, int maxNum, int waitSecond) {
        NumberInfo num = new NumberInfo(bizName, maxNum, -99);
        int rtn = this.handle.next(num, waitSecond);
        if (rtn < 0) {
            return null;
        }
        return num;
    }

    public int getNextNumber(NumberInfo num, int waitSecond) {
        if (num.isRunning()) {
            this.handle.complete(num);
        }
        return this.handle.next(num, waitSecond);
    }

    public void destroy() {
        for (ExecutorService service : this.executors.values()) {
            service.shutdown();
        }
    }

    private class CallNumberRuner
    implements Runnable {
        public String curJobKey = "";
        private NumberInfo number;
        private Consumer<NumberInfo> worker;
        private String lineSeparator = System.lineSeparator();

        public CallNumberRuner(NumberInfo number, Consumer<NumberInfo> worker) {
            this.number = number;
            this.worker = worker;
        }

        public CallNumberRuner(String bizName, int maxNum, int start, Consumer<NumberInfo> worker) {
            this.number = new NumberInfo(bizName, maxNum, start);
            this.worker = worker;
        }

        public NumberInfo getNumber() {
            return this.number;
        }

        public Consumer<NumberInfo> getWorker() {
            return this.worker;
        }

        public String watch() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.lineSeparator);
            sb.append("number:" + this.number.toString());
            sb.append(this.lineSeparator);
            sb.append("isRuning:" + this.number.isRunning());
            return sb.toString();
        }

        public boolean isRunning() {
            return this.number.isRunning();
        }

        @Override
        public void run() {
            this.curJobKey = Thread.currentThread().getName() + "-" + this.number.toString();
            ServiceLogs.setCurLogKey((String)this.curJobKey);
            ServiceLogs.info((String)"CallNumberRuner", (String)"\u5f00\u59cb\u8fd0\u884c[{0}]", (long)0L, (Object[])new Object[]{this.number.toString()});
            if (this.number.isRunning()) {
                ServiceLogs.info((String)"CallNumberRuner", (String)"\u5f53\u524d\u5e8f\u53f7[{0}]\u6b63\u5728\u6267\u884c,\u4e0d\u7ee7\u7eed\u6267\u884c", (long)0L, (Object[])new Object[]{this.number.toString()});
                return;
            }
            int num = -99;
            do {
                try {
                    num = CallNumberExecutor.this.handle.next(this.number, 10);
                    if (num >= 0) {
                        ServiceLogs.info((String)"CallNumberRuner", (String)"\u5f00\u59cb\u6267\u884c[{0}]", (long)0L, (Object[])new Object[]{this.number.toString()});
                        this.worker.accept(this.number);
                        continue;
                    }
                    ServiceLogs.info((String)"CallNumberRuner", (String)"\u5f00\u59cb\u6267\u884c[{0}]", (long)0L, (Object[])new Object[]{this.number.toString()});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    CallNumberExecutor.this.handle.complete(this.number);
                }
            } while (num >= 0);
        }
    }
}

