/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import cn.hutool.extra.spring.SpringUtil;
import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.distributedLock.DLockInfo;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.distributedLock.LockWatchdog;
import java.util.HashMap;

public abstract class AbstractDistributedLockHandle
implements DistributedLockHandle {
    private final ThreadLocal<HashMap<String, DLockInfo>> LocalTrans = new ThreadLocal();
    LockWatchdog dog;

    protected DLockInfo newTransId(String key, int lockExpire) {
        return new DLockInfo(key, lockExpire * 1000);
    }

    protected DLockInfo getThisTransId(String key) {
        HashMap<String, DLockInfo> trans = this.LocalTrans.get();
        if (trans == null) {
            return null;
        }
        return trans.get(key);
    }

    protected void setThisTransId(String key, DLockInfo id) {
        HashMap<String, DLockInfo> trans = this.LocalTrans.get();
        if (trans == null) {
            trans = new HashMap();
            this.LocalTrans.set(trans);
        }
        trans.put(key, id);
    }

    public void addWatchdog(DLockInfo lockInfo) {
        if (this.dog == null) {
            this.dog = (LockWatchdog)SpringUtil.getBean(LockWatchdog.class);
        }
        if (this.dog == null) {
            return;
        }
        this.dog.add(lockInfo);
    }

    public void removeWatchdog(DLockInfo lockInfo) {
        if (this.dog == null) {
            this.dog = (LockWatchdog)SpringUtil.getBean(LockWatchdog.class);
        }
        if (this.dog == null) {
            return;
        }
        this.dog.remove(lockInfo);
    }

    @Override
    public DLockInfo tryLock(String key, int lockExpire, int waitMillSeconds) {
        DLockInfo lockInfo = this.getThisTransId(key);
        if (lockInfo != null) {
            return lockInfo;
        }
        lockInfo = this.newTransId(key, lockExpire);
        boolean ok = this.doNaiveCachePut(key, lockInfo, lockExpire, waitMillSeconds);
        if (!ok) {
            return null;
        }
        this.setThisTransId(key, lockInfo);
        this.addWatchdog(lockInfo);
        return lockInfo;
    }

    public abstract boolean doNaiveCachePut(String var1, DLockInfo var2, int var3, int var4);

    public abstract boolean doNaiveCacheRenewal(DLockInfo var1);

    @Override
    public void renewal(DLockInfo lockInfo) {
        String key = lockInfo.getKey();
        try {
            this.doNaiveCacheRenewal(lockInfo);
        }
        catch (Exception e) {
            ServiceLogs.errLog((String)"DistributedLock", (Exception)e, (String)"\u5ef6\u671f\u65f6\u5931\u8d25,key[{0}]", (Object[])new Object[]{key});
        }
    }

    @Override
    public void unlock(String key, int lockExpire) {
        DLockInfo lockInfo = this.getThisTransId(key);
        if (lockInfo == null) {
            ServiceLogs.debuglog((String)"DistributedLock", (String)("\u89e3\u9501\u65f6key[" + key + "]\u7684\u7ebf\u7a0b\u53d8\u91cf\u6570\u636e\u4e0d\u5b58\u5728,\u4e0d\u6267\u884c\u89e3\u9501"), (long)0L);
            return;
        }
        this.unlock(lockInfo);
    }

    @Override
    public void unlock(String key) {
        this.unlock(key, 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(DLockInfo lockInfo) {
        String key = lockInfo.getKey();
        try {
            long value = this.doNaiveCacheGet(key);
            long id = lockInfo.getLockKey();
            if (id == value && value != 0L) {
                this.doNaiveCacheDelete(key);
            } else {
                ServiceLogs.debuglog((String)"DistributedLock", (String)("\u89e3\u9501\u65f6key[" + key + "]\u7684\u7f13\u5b58ID\u4e0d\u5339\u914d,\u4e0d\u505a\u5904\u7406,[" + id + "]-[" + value + "]"), (long)0L);
            }
        }
        catch (Exception e) {
            ServiceLogs.errLog((String)"DistributedLock", (Exception)e, (String)"\u89e3\u9501\u662f\u5931\u8d25,key[{0}]", (Object[])new Object[]{key});
        }
        finally {
            this.clearThisTransId(key);
            this.removeWatchdog(lockInfo);
        }
    }

    protected void clearThisTransId(String key) {
        HashMap<String, DLockInfo> trans = this.LocalTrans.get();
        if (null != trans) {
            trans.remove(key);
            if (trans.isEmpty()) {
                this.LocalTrans.remove();
            }
        }
    }

    public abstract void doNaiveCacheDelete(String var1);

    public abstract long doNaiveCacheGet(String var1);
}

