/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import com.efuture.ocp.common.distributedLock.DLockInfo;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.distributedLock.LockWatchdog;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LockWatchdogImpl
implements LockWatchdog {
    ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new ThreadPoolExecutor.AbortPolicy());
    ConcurrentHashMap<String, DLockInfo> locks = new ConcurrentHashMap();
    DistributedLockHandle lockHandle;

    public LockWatchdogImpl(DistributedLockHandle lockHandle) {
        this.lockHandle = lockHandle;
    }

    @Override
    public void add(DLockInfo lockInfo) {
        this.locks.put(lockInfo.getKey(), lockInfo);
        this.executorService.schedule(() -> this.watch(lockInfo), 10L, TimeUnit.MINUTES);
    }

    @Override
    public void remove(DLockInfo lockInfo) {
        this.locks.remove(lockInfo.getKey());
    }

    public void watch(DLockInfo lockInfo) {
        if (lockInfo == null) {
            return;
        }
        if (this.locks.get(lockInfo.getKey()) != null) {
            this.lockHandle.renewal(lockInfo);
        }
    }
}

