package com.efuture.common.utils;


import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.web.session.GlobSessionThreadLocal;
import com.efuture.common.web.session.ServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.MessageFormat;
import java.util.Date;

public class ServiceLogs
{

    public static String logFormat = "JSON";
    static Logger logger = LoggerFactory.getLogger(ServiceLogs.class);

    public static void setCurLogKey(String logKey)
    {
        ServiceSession sessionobj = getSessionobj();
        sessionobj.setLogkey(logKey);
    }

    public static ServiceSession getSessionobj()
    {
        ServiceSession sessionobj = GlobSessionThreadLocal.get();

        if (sessionobj == null || StringUtils.isEmpty(sessionobj.getRootkey())) {
            String tname = Thread.currentThread().getName();
            String rootkey = String.valueOf((new Date()).getTime());

            if (tname.startsWith("rootkey")) {
                rootkey = tname.substring(7);
            }

            sessionobj = new ServiceSession();
            sessionobj.setUser_name("ASYNC");
            sessionobj.setRootkey(rootkey);
            sessionobj.setLogkey(String.valueOf((new Date()).getTime()));
            sessionobj.setParentkey(rootkey);
            GlobSessionThreadLocal.set(sessionobj);
        }

        return sessionobj;
    }

    public static void logResponse(String logmsg, String rtncode)
    {
        ServiceSession session = getSessionobj();
        session.setReturncode(rtncode);
        info(LOGTYPE.RESPONSE, logmsg, session.getStarttime());
    }

    public static void logRequest(String logmsg)
    {
        info(LOGTYPE.REQUEST, logmsg, 0);
    }

    public static void logCallStart(String url, String method, String request)
    {
        JSONObject logmsg = new JSONObject();
        logmsg.put("call_method", method);
        logmsg.put("call_url", url);
        logmsg.put("call_request", request);
        info(LOGTYPE.CALL_REQUEST, logmsg.toString(), 0);
    }

    public static void logCallError(String url, String method, String errcode, String errmsg, long starttime)
    {
        //ServiceSession sessionobj = getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("call_method", method);
        logmsg.put("call_url", url);
        logmsg.put("call_returncode", errcode);
        logmsg.put("call_response", errmsg);
        error(LOGTYPE.CALL_RESPONSE, null, logmsg.toString(), starttime);
    }

    public static void logCallSuccess(String url, String method, long starttime)
    {
        JSONObject logmsg = new JSONObject();
        logmsg.put("call_method", method);
        logmsg.put("call_url", url);
        logmsg.put("call_returncode", "0");
        info(LOGTYPE.CALL_RESPONSE, logmsg.toString(), starttime);
    }

    public static void logConsumeMqStart(String topic, String key, String othermsg)
    {
        //ServiceSession sessionobj = getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", topic);
        logmsg.put("keyvalue", key);
        logmsg.put("othermsg", othermsg);
        info(LOGTYPE.MQCONSUMER_start, logmsg.toString(), 0);
    }

    public static void logConsumeMqError(String topic, String key, String errcode, String othermsg, long starttime)
    {
        //ServiceSession sessionobj = getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", topic);
        logmsg.put("keyvalue", key);
        logmsg.put("othermsg", othermsg);
        logmsg.put("mq_returncode", errcode);
        //sessionobj.setReturncode(errcode);
        error(LOGTYPE.MQCONSUMER_error, logmsg.toString(), starttime);
    }

    public static void logConsumeMqSuccess(String topic, String key, String othermsg, long starttime)
    {
        //ServiceSession sessionobj = getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", topic);
        logmsg.put("keyvalue", key);
        logmsg.put("othermsg", othermsg);
        logmsg.put("mq_returncode", "0");
        info(LOGTYPE.MQCONSUMER_succ, logmsg.toString(), starttime);
    }

    public static void logSendMqStart(String topic, String key, String othermsg)
    {
        //ServiceSession sessionobj = getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", topic);
        logmsg.put("keyvalue", key);
        logmsg.put("othermsg", othermsg);
        info(LOGTYPE.MQSEND_start, logmsg.toString(), 0);
    }

    public static void logSendMqError(String topic, String key, String errcode, String sendresult, String othermsg,
                                      long starttime)
    {
        ServiceSession sessionobj = getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", topic);
        logmsg.put("keyvalue", key);
        logmsg.put("othermsg", othermsg);
        logmsg.put("sendresult", sendresult);
        logmsg.put("mq_returncode", errcode);
        sessionobj.setReturncode(errcode);
        error(LOGTYPE.MQSEND_error, logmsg.toString(), starttime);
    }

    public static void logSendMqSuccess(String topic, String key, String sendresult, String othermsg, long starttime)
    {
        ServiceSession sessionobj = getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", topic);
        logmsg.put("keyvalue", key);
        logmsg.put("othermsg", othermsg);
        logmsg.put("sendresult", sendresult);
        logmsg.put("mq_returncode", "0");
        info(LOGTYPE.MQSEND_succ, logmsg.toString(), starttime);
    }

    public static void logFitlerSucc(String logmsg)
    {
        //ServiceSession sessionobj = getSessionobj();
        info(LOGTYPE.FILTER_SUCC, logmsg.toString(), 0);
    }

    public static void logFitlerFail(String logmsg)
    {
        //ServiceSession sessionobj = getSessionobj();
        error(LOGTYPE.FILTER_FAIL, logmsg.toString(), 0);
    }

    private static String getDefaultFormatstr(ServiceSession sessionobj, String logtype, final Throwable e, String logmsg,
            long starttime)
    {
        StringBuffer sb = new StringBuffer();
        sb.append("rootkey: ");
        sb.append(sessionobj.getRootkey());

        if (logtype.equalsIgnoreCase(LOGTYPE.REQUEST)) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append("REQUEST  : ");
            sb.append(logmsg);
            sb.append(" , entid : ");
            sb.append(sessionobj.getEnt_id());
        }
        else if (logtype.equalsIgnoreCase(LOGTYPE.RESPONSE)) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append("ELAPSED  : " + (System.currentTimeMillis() - starttime) + " ms , ");
            sb.append("RESPONSE : ");
            sb.append(logmsg);
        }
        else {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append(logtype + "  : ");

            if (starttime > 0L) {
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - starttime) + " ms , ");
            }

            sb.append(logmsg);
            sb.append(" , url : ");
            sb.append(sessionobj.getUrl());
        }

        if (e != null) {
            StackTraceElement[] stackTrace = e.getStackTrace();

            for (int i = 0; i < stackTrace.length; i++) {
                // System.out.println("key = " + stackTrace[i]);
                if (i == 0) {
                    sb.append("exception : [" + stackTrace[i]);
                }
                else {
                    sb.append(stackTrace[i]);
                }
            }

            sb.append("]");
        }

        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable)
    {
        return ExceptionUtil.stacktraceToOneLineString(throwable, 200);
    }

    public static JSONObject getLogJson(ServiceSession sessionobj)
    {
        JSONObject session = (JSONObject) JSONObject.toJSON(sessionobj);
        JSONObject rtn = new JSONObject();
        String format = sessionobj.getLogFormat();

        for (String key : session.keySet()) {
            if (format.indexOf(key) > -1 && !StringUtils.isEmpty(session.get(key))) {
                rtn.put(key, session.get(key));
            }
        }

        return rtn;
    }

    private static String getJsonFormatstr(final ServiceSession sessionobj, final String logtype, final Throwable e,
                                           final String logmsg, final long starttime)
    {
        JSONObject rtn = getLogJson(sessionobj);
        rtn.put("logtype", logtype);
        rtn.put("logmsg", logmsg);

        if (e != null) {
            String msg = ExceptionUtil.getMessage(e);
            rtn.put("exception", getStackTrace(e));

            if (null == logmsg) {
                rtn.put("logmsg", msg);
            }
            else {
                rtn.put("logmsg", logmsg + " errMsg:" + msg);
            }
        }

        if (starttime != 0) {
            rtn.put("elapsed", System.currentTimeMillis() - starttime);
        }

        return rtn.toString();
    }

    //    public static void info(ServiceSession sessionobj, String logtype, String logmsg, long starttime,
    //                            boolean iserr)
    //    {
    //        String msg = logmsg;
    //        msg = getJsonFormatstr(sessionobj, logtype, null, logmsg, starttime);
    //
    //        // String msg =getIns().getJsonFormatstr(sessionobj, logtype, logmsg,
    //        // starttime);
    //        if (iserr) {
    //            logger.error(msg);
    //        }
    //        else {
    //            logger.info(msg);
    //        }
    //    }

    //    public static void info(String logtype, String logmsg, long starttime)
    //    {
    //        info(logtype, logmsg, starttime, null);
    //    }


    //    public static void info(String logtype, String logmsg, Object... arguments) {
    //        info(logtype, logmsg, 0, arguments);
    //    }

    public static void info(String logtype, String logmsg, long starttime, Object... arguments)
    {
        info(logger, logtype, logmsg, starttime, arguments);
    }

    public static void info(Logger log, String logtype, String logmsg, long starttime, Object... arguments)
    {
        if (log.isInfoEnabled()) {
            String msg = formatMsg(logtype, null, logmsg, starttime, arguments);
            ServiceSession session = getSessionobj();

            if (isCanAddMsg(logtype)) {
                session.addMsg("info", msg);
            }

            logger.info(msg);
        }
    }

    public static void warn(String logtype, String logmsg, long starttime, Object... arguments)
    {
        warn(logger, logtype, logmsg, starttime, arguments);
    }

    public static void warn(Logger log, String logtype, String logmsg, long starttime, Object... arguments)
    {
        if (log.isWarnEnabled()) {
            String msg = formatMsg(logtype, null, logmsg, starttime, arguments);
            ServiceSession session = getSessionobj();

            if (isCanAddMsg(logtype)) {
                session.addMsg("warn", msg);
            }

            logger.warn(msg);
        }
    }

    private static String formatMsg(String logtype, Throwable e, String logmsg, long starttime, Object... arguments)
    {
        ServiceSession sessionobj = getSessionobj();
        String logFromat = "json";
        String fmsg = format(logmsg, arguments);
        String msg = fmsg;

        if (logFromat.equalsIgnoreCase("json")) {
            msg = getJsonFormatstr(sessionobj, logtype, e, fmsg, starttime);
        }
        else {
            msg = getDefaultFormatstr(sessionobj, logtype, e, fmsg, starttime);
        }

        return msg;
    }

    // public static void truedebuglog(String logtype, String logmsg, long
    // starttime) {
    // ServiceSession sessionobj = getSessionobj();
    // String msg = logmsg;
    // String logFromat = "json";
    //
    // if (logFromat.equalsIgnoreCase("json")) {
    // msg = getJsonFormatstr(sessionobj, logtype, logmsg, starttime);
    // } else {
    // msg = getDefaultFormatstr(sessionobj, logtype, logmsg, starttime);
    // }
    //
    // logger.debug(msg);
    // }

    //    public static void error(String logtype, Exception e, String logmsg, Object... arguments) {
    //        String msg = formatMsg(logtype, e, logmsg, 0, arguments);
    //        logger.error(msg);
    //    }


    public static void error(String logtype, Throwable throwable, String logmsg, long starttime, Object... arguments)
    {
        error(logger, logtype, throwable, logmsg, starttime, arguments);
    }

    public static void error(String logtype, String logmsg, long starttime, Object... arguments)
    {
        error(logger, logtype, null, logmsg, starttime, arguments);
    }

    public static void error(Logger log, String logtype, Throwable throwable, String logmsg, long starttime, Object... arguments)
    {
        if (log.isErrorEnabled()) {
            String msg = formatMsg(logtype, throwable, logmsg, starttime, arguments);
            ServiceSession session = getSessionobj();
            session.addMsg("error", msg);
            log.error(msg);
        }
    }

    public static void debug(String logtype, String logmsg, long starttime, Object... arguments)
    {
        debug(logger, logtype, logmsg, starttime, arguments);
    }

    public static void debug(Logger log, String logtype, String logmsg, long starttime, Object... arguments)
    {
        ServiceSession session = getSessionobj();

        if (log.isDebugEnabled() || session.isDebugEnble()) {
            String msg = formatMsg(logtype, null, logmsg, starttime, arguments);

            if (session.isDebugEnble()) {
                if (isCanAddMsg(logtype)) {
                    session.addMsg("debug", msg);
                }
            }

            if (log.isDebugEnabled()) {
                logger.debug(msg);
            }
            else {
                logger.info(msg);
            }
        }
    }


    private static boolean isCanAddMsg(String logtype)
    {
        return !("request,response".indexOf(logtype) > -1);
    }
    public static String format(String msg, Object... args)
    {
        if (args == null || args.length <= 0) {
            return msg;
        }

        // format String
        for (int i = 0; args != null && i < args.length; i++) {
            if (args[i] instanceof String) {
                continue;
            }

            args[i] = StringUtils.isEmpty(args[i]) ? "" : args[i].toString();
        }

        return MessageFormat.format(msg, args);
    }

    public interface LOGTYPE
    {
        public String INFO = "info";
        public String RESPONSE = "response";
        public String REQUEST = "request";
        public String DBSTART = "db_start";
        public String DBSUCC = "db_succ";
        public String DBERROR = "db_error";
        public String CALL_REQUEST = "call_request";
        public String CALL_RESPONSE = "call_response";
        public String MQSEND_start = "mqsend_start";
        public String MQSEND_error = "mqsend_error";
        public String MQSEND_succ = "mqsend_succ";
        public String MQCONSUMER_start = "mqconsumer_start";
        public String MQCONSUMER_error = "mqconsumer_error";
        public String MQCONSUMER_succ = "mqconsumer_succ";
        public String FILTER_SUCC = "filter_succ";
        public String FILTER_FAIL = "filter_fail";
    }
}
