package com.efuture.common.utils;

import cn.hutool.core.util.HashUtil;

/**
 * 切片机
 * 使用场景
 * 场景一.数据先保存，然后再按分片查询并处理
 * 1.数据保存时,得到插槽id然后再存入数据库[getSlotId]
 * 2.得到要处理的分片id--使用叫号器
 * 3.根据分片id和分片总数 得到要处理的插槽的范围[getSliceScope]
 * 4.根据插槽范围查找数据并处理
 * 场景二.先读取数据，然后再按分片分配线程处理
 * 1.读取数据
 * 2.根据分片字段得到插槽id[getSlotId]
 * 3.根据插槽id和分片总数 得到是属于分片id[getSliceId]
 * 4.把数据发送到要处理此分片id的程序或者进程
 */
public class Slicer
{

    public static Slicer instance = new Slicer();
    public int slotCount = 16383; //插槽

    public static Slicer getInstance()
    {
        return instance;
    }

    public static void main(String args[])
    {
        int sliceNum = 16383;
        getInstance().getSliceId(2047, sliceNum);
        int slotId = getInstance().getSlotId("0:NUM:dcc001:2018-12-13#002#003#POS#000107:#");
        System.out.println("slotId:" + slotId);
        System.out.println("sliceNum:" + sliceNum);
        System.out.println("slice:0:" + getInstance().getSliceScope(0, sliceNum));
        System.out.println("slice:1:" + getInstance().getSliceScope(1, sliceNum));
        System.out.println("slice:2:" + getInstance().getSliceScope(2, sliceNum));
        System.out.println("slice:3:" + getInstance().getSliceScope(3, sliceNum));
        System.out.println("slice:4:" + getInstance().getSliceScope(4, sliceNum));
        System.out.println("slice:5:" + getInstance().getSliceScope(5, sliceNum));
        System.out.println("slice:6:" + getInstance().getSliceScope(6, sliceNum));
        System.out.println("slice:7:" + getInstance().getSliceScope(7, sliceNum));
        System.out.println("slice:0:" + getInstance().getSliceId(0, sliceNum));
        System.out.println("slice:1:" + getInstance().getSliceId(2048, sliceNum));
        System.out.println("slice:2:" + getInstance().getSliceId(5343, sliceNum));
        System.out.println("slice:3:" + getInstance().getSliceId(6157, sliceNum));
        System.out.println("slice:4:" + getInstance().getSliceId(10220, sliceNum));
        System.out.println("slice:5:" + getInstance().getSliceId(10255, sliceNum));
        System.out.println("slice:6:" + getInstance().getSliceId(14328, sliceNum));
        System.out.println("slice:7:" + getInstance().getSliceId(16382, sliceNum));
    }

    /**
     * 得到分片范围
     *
     * @param sliceId  分片id 从0开始 eg:0,1,2,3......
     * @param sliceNum 分片数
     * @return 分片范围 20:100  开始:结束
     */
    public String getSliceScope(int sliceId, int sliceNum)
    {
        int slotNum = (int) Math.ceil(slotCount / (double) sliceNum);//每个分片插槽的数据量
        int start = slotNum * sliceId;
        int end = slotNum * (sliceId + 1) - 1;

        if (sliceId == sliceNum - 1) {
            end = slotCount - 1;
        }

        return start + ":" + end;
    }

    public int getSliceId(int slotId, int sliceNum)
    {
        int slotNum = (int) Math.ceil(slotCount / (double) sliceNum); //
        double id = slotId  / (double) slotNum;
        int sliceId = (int) Math.floor(id) ;
        return sliceId;
    }

    /**
     * 得到插槽id
     *
     * @return
     */
    public int getSlotId(Object key)
    {
        int hash = HashUtil.fnvHash(key.toString());
        int id = hash;

        if (hash > slotCount) {
            id = hash % slotCount;
        }

        return id;
    }

}
