package com.efuture.common.utils;


import java.util.LinkedHashSet;
import java.util.Set;

public interface SysParameterDefinition
{

    String getKey();

    String getDesc();

    String getPreParaStr();

    String getDefaultVal();

default public int getDefaultIntVal() {
        if (getDefaultVal() != null) {
            return Integer.valueOf(getDefaultVal());
        }
        else {
            return 0;
        }
    }

    /**
     * 按优先级获取参数，带企业号的参数优先
     *
     * @param entId
     * @param key
     * @return
     */
default Set<String> getPriorityKeyList(long entId, String key) {
        LinkedHashSet<String> rtn = new LinkedHashSet<>();

        if (entId != 0) {
            rtn.add(entId + "." + key);
        }

        rtn.add(key);
        return rtn;
    }

    String getValByNative(String key);

default String getEnvPra(long entId, String key, String defaultVal) {
        Set<String> keyList = getPriorityKeyList(entId, key);
        String rtn = null;

        for (String skey : keyList) {
            rtn = getValByNative(skey);

            if (!StringUtils.isEmpty(rtn)) {
                return rtn;
            }
        }

        if (StringUtils.isEmpty(rtn)) {
            return defaultVal;
        }

        return rtn;
    }

default String getVal(long entId) {
        String key = this.getPreParaStr() + "." + this.getKey();
        return getEnvPra(entId, key.toLowerCase(), this.getDefaultVal());
    }

default int convertToint(String val) {
        if (val != null) {
            return Integer.valueOf(val);
        }
        else {
            return 0;
        }
    }

default int getIntVal(long entId) {
        String val = getVal(entId);
        return convertToint(val);
    }


default int getIntVal(long entId, String postfix, String defaultVal) {
        String val = getVal(entId, postfix, defaultVal);
        return convertToint(val);
    }

default int getIntVal(long entId, String postfix) {
        String val = getVal(entId, postfix);
        return convertToint(val);
    }

default String getVal(long entId, String postfix, String defaultVal) {
        String key = this.getPreParaStr() + "." + this.getKey() + "." + postfix;
        return getEnvPra(entId, key.toLowerCase(), defaultVal);
    }

default String getVal(long entId, String postfix) {
        String key = this.getPreParaStr() + "." + this.getKey() + "." + postfix;
        return getEnvPra(entId, key.toLowerCase(), this.getDefaultVal());
    }

}
