package com.efuture.common.utils;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UniqueUtils
{

    static Map<String, Snowflake> snowflakes = new ConcurrentHashMap<>();

    /**
     * 生成key
     *
     * @return
     */
    public static long genPhKey()
    {
        return initId("phKey").nextId();
    }

    /**
     * 生成id
     * @param idKey
     * @return
     */
    public static long genid(String idKey)
    {
        return initId("phKey").nextId();
    }

    private static Map getUniIdConfig(String idKey)
    {
        Map<String, String> rtn = new HashMap();
        rtn.put("workerId", "1");
        rtn.put("datacenterId", "1");
        return rtn;
    }

    private static Snowflake initId(String idKey)
    {
        snowflakes.computeIfAbsent(idKey, key -> {
            Map<String, String> config = getUniIdConfig(key);
            int workerId = Integer.valueOf(config.getOrDefault("workerId", "1"));
            int datacenterId = Integer.valueOf(config.getOrDefault("datacenterId", "1"));
            Snowflake snowflake = IdUtil.getSnowflake(workerId, datacenterId);
            return snowflake;
        });
        return snowflakes.get(idKey);
    }


}
