/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	SessionInfo.java
 * Author:		亮
 * Date:		2014-3-27 上午10:12:58
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 */
package com.efuture.common.web.session;


import com.efuture.common.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 亮
 * @description 服务Session信息
 */
public class ServiceSession
{
    protected long ent_id;
    protected long user_id;
    protected String user_code;
    protected String user_name;
    protected String usercodename;
    protected String locale;
    protected String debug_status;
    protected String token;
    protected String postid;
    protected String deptrealcode;
    protected String deptcode;
    protected String rootkey;//调用的【根日志序号】
    protected String parentkey;//调用的【上级日志序号】
    protected String logkey;//本级调用的【日志序号】
    protected long elapsed;//调用耗时 毫秒
    protected String method;//调用的方法
    protected String remoteaddr;//调用IP地址
    protected String url;//调用url
    protected String http_uri;     //服务请求的URI

    protected String returncode;   //返回值

    protected String dataRangeId;  //数据范围id,新的portal使用
    // Slice

    protected String market;    //门店

    protected String slice;    //分片

    protected long stationId;//岗位id,新portal使用

    protected List<String> msgList;
    protected long starttime;
    protected String roleid;
    protected String rolecode;

    protected String logFormat;

    public String getReturncode()
    {
        return returncode;
    }

    public void setReturncode(String returncode)
    {
        this.returncode = returncode;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getRootkey()
    {
        return rootkey;
    }

    public void setRootkey(String rootkey)
    {
        this.rootkey = rootkey;
    }

    public String getParentkey()
    {
        return parentkey;
    }

    public void setParentkey(String parentkey)
    {
        this.parentkey = parentkey;
    }

    public String getLogkey()
    {
        return logkey;
    }

    public void setLogkey(String logkey)
    {
        this.logkey = logkey;
    }

    public long getStarttime()
    {
        return starttime;
    }

    public void setStarttime(long starttime)
    {
        this.starttime = starttime;
    }

    public long getElapsed()
    {
        return elapsed;
    }

    public void setElapsed(long elapsed)
    {
        this.elapsed = elapsed;
    }

    public String getMethod()
    {
        return method;
    }

    public void setMethod(String method)
    {
        this.method = method;
    }

    public String getRemoteaddr()
    {
        return remoteaddr;
    }

    public void setRemoteaddr(String remoteaddr)
    {
        this.remoteaddr = remoteaddr;
    }

    public String getDeptrealcode()
    {
        return deptrealcode;
    }

    public void setDeptrealcode(String deptrealcode)
    {
        this.deptrealcode = deptrealcode;
    }

    public String getToken()
    {
        return token;
    }

    public void setToken(String token)
    {
        this.token = token;
    }

    public String getPostid()
    {
        return postid;
    }

    public void setPostid(String postid)
    {
        this.postid = postid;
    }

    /**
     * @return ent_id
     */
    public long getEnt_id()
    {
        return ent_id;
    }

    /**
     * @param ent_id 要设置的 ent_id
     */
    public void setEnt_id(long ent_id)
    {
        this.ent_id = ent_id;
    }

    /**
     * @return user_id
     */
    public long getUser_id()
    {
        return user_id;
    }

    /**
     * @param user_id 要设置的 user_id
     */
    public void setUser_id(long user_id)
    {
        this.user_id = user_id;
    }

    /**
     * @return user_code
     */
    public String getUser_code()
    {
        if (StringUtils.isEmpty(user_code)) {
            return String.valueOf(user_id);
        }
        else {
            return user_code;
        }
    }

    /**
     * @param user_code 要设置的 user_code
     */
    public void setUser_code(String user_code)
    {
        this.user_code = user_code;
    }

    /**
     * @return user_name
     */
    public String getUser_name()
    {
        return user_name;
    }

    /**
     * @param user_name 要设置的 user_name
     */
    public void setUser_name(String user_name)
    {
        this.user_name = user_name;
    }

    public String getUsercodename()
    {
        return "[" + user_code + "]" + user_name;
    }

    /**
     * @return locale
     */
    public String getLocale()
    {
        return locale;
    }

    /**
     * @param locale 要设置的 locale
     */
    public void setLocale(String locale)
    {
        this.locale = locale;
    }

    /**
     * @return debug_status
     */
    public String getDebug_status()
    {
        return debug_status;
    }

    /**
     * @param debug_status 要设置的 debug_status
     */
    public void setDebug_status(String debug_status)
    {
        this.debug_status = debug_status;
    }

    public String getDeptcode()
    {
        return deptcode;
    }

    public void setDeptcode(String deptcode)
    {
        this.deptcode = deptcode;
    }

    public String getRoleid()
    {
        return roleid;
    }

    public void setRoleid(String roleid)
    {
        this.roleid = roleid;
    }

    public String getRolecode()
    {
        return rolecode;
    }

    public void setRolecode(String rolecode)
    {
        this.rolecode = rolecode;
    }

    public String getDataRangeId()
    {
        return dataRangeId;
    }

    public void setDataRangeId(String dataRangeId)
    {
        this.dataRangeId = dataRangeId;
    }

    public String getMarket()
    {
        return market;
    }

    public void setMarket(String market)
    {
        this.market = market;
    }

    public String getEntMarket()
    {
        if (StringUtils.isEmpty(market)) {
            return null;
        }

        return String.valueOf(ent_id).concat("-").concat(market);
    }

    public String getSlice()
    {
        return slice;
    }

    public void setSlice(String slice)
    {
        this.slice = slice;
    }

    public long getStationId()
    {
        return stationId;
    }

    public void setStationId(long stationId)
    {
        this.stationId = stationId;
    }

    /**
     * @return http_uri
     */
    public String getHttp_uri()
    {
        return http_uri;
    }

    /**
     * @param http_uri 要设置的 http_uri
     */
    public void setHttp_uri(String http_uri)
    {
        this.http_uri = http_uri;
    }

    public boolean isDebugEnble()
    {
        return "Y".equalsIgnoreCase(getDebug_status());
    }

    public void addMsg(String type, String msg)
    {
        if (isDebugEnble()) {
            if (msgList == null) {
                msgList = new ArrayList<>();
            }

            int size = msgList.size() + 1;
            String newMsg = size + ":" + type + ":" + msg;
            msgList.add(newMsg);
        }
    }

    public List<String> getMsgs()
    {
        return msgList;
    }

    public String getLogFormat()
    {
        if (StringUtils.isEmpty(logFormat)) {
            return "logkey,logmsg,rootkey,parentkey,http_uri,url";
        }

        return logFormat;
    }

    public void setLogFormat(String logFormat)
    {
        this.logFormat = logFormat;
    }

    @Override
    public String toString()
    {
        return "ServiceSession{" +
               "ent_id=" + ent_id +
               ", user_id=" + user_id +
               ", user_code='" + user_code + '\'' +
               ", user_name='" + user_name + '\'' +
               ", usercodename='" + usercodename + '\'' +
               ", locale='" + locale + '\'' +
               ", debug_status='" + debug_status + '\'' +
               ", token='" + token + '\'' +
               ", postid='" + postid + '\'' +
               ", deptrealcode='" + deptrealcode + '\'' +
               ", deptcode='" + deptcode + '\'' +
               ", rootkey='" + rootkey + '\'' +
               ", parentkey='" + parentkey + '\'' +
               ", logkey='" + logkey + '\'' +
               ", elapsed=" + elapsed +
               ", method='" + method + '\'' +
               ", remoteaddr='" + remoteaddr + '\'' +
               ", url='" + url + '\'' +
               ", http_uri='" + http_uri + '\'' +
               ", returncode='" + returncode + '\'' +
               ", dataRangeId='" + dataRangeId + '\'' +
               ", market='" + market + '\'' +
               ", slice='" + slice + '\'' +
               ", stationId=" + stationId +
               ", starttime=" + starttime +
               ", roleid='" + roleid + '\'' +
               ", rolecode='" + rolecode + '\'' +
               '}';
    }
}
