/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.utils.StringUtils;
import com.efuture.common.web.session.GlobSessionThreadLocal;
import com.efuture.common.web.session.ServiceSession;
import java.text.MessageFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLogs {
    public static String logFormat = "JSON";
    static Logger logger = LoggerFactory.getLogger(ServiceLogs.class);

    public static void setCurLogKey(String logKey) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        sessionobj.setLogkey(logKey);
    }

    public static ServiceSession getSessionobj() {
        ServiceSession sessionobj = GlobSessionThreadLocal.get();
        if (sessionobj == null || StringUtils.isEmpty((CharSequence)sessionobj.getRootkey())) {
            String tname = Thread.currentThread().getName();
            String rootkey = String.valueOf(new Date().getTime());
            if (tname.startsWith("rootkey")) {
                rootkey = tname.substring(7);
            }
            sessionobj = new ServiceSession();
            sessionobj.setUser_name("ASYNC");
            sessionobj.setRootkey(rootkey);
            sessionobj.setLogkey(String.valueOf(new Date().getTime()));
            sessionobj.setParentkey(rootkey);
            GlobSessionThreadLocal.set(sessionobj);
        }
        return sessionobj;
    }

    public static void logResponse(String logmsg, String rtncode) {
        ServiceSession session = ServiceLogs.getSessionobj();
        session.setReturncode(rtncode);
        ServiceLogs.info("response", logmsg, session.getStarttime(), new Object[0]);
    }

    public static void logRequest(String logmsg) {
        ServiceLogs.info("request", logmsg, 0L, new Object[0]);
    }

    public static void logCallStart(String url, String method, String request) {
        JSONObject logmsg = new JSONObject();
        logmsg.put("call_method", (Object)method);
        logmsg.put("call_url", (Object)url);
        logmsg.put("call_request", (Object)request);
        ServiceLogs.info("call_request", logmsg.toString(), 0L, new Object[0]);
    }

    public static void logCallError(String url, String method, String errcode, String errmsg, long starttime) {
        JSONObject logmsg = new JSONObject();
        logmsg.put("call_method", (Object)method);
        logmsg.put("call_url", (Object)url);
        logmsg.put("call_returncode", (Object)errcode);
        logmsg.put("call_response", (Object)errmsg);
        ServiceLogs.error("call_response", null, logmsg.toString(), starttime, new Object[0]);
    }

    public static void logCallSuccess(String url, String method, long starttime) {
        JSONObject logmsg = new JSONObject();
        logmsg.put("call_method", (Object)method);
        logmsg.put("call_url", (Object)url);
        logmsg.put("call_returncode", (Object)"0");
        ServiceLogs.info("call_response", logmsg.toString(), starttime, new Object[0]);
    }

    public static void logConsumeMqStart(String topic, String key, String othermsg) {
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        ServiceLogs.info("mqconsumer_start", logmsg.toString(), 0L, new Object[0]);
    }

    public static void logConsumeMqError(String topic, String key, String errcode, String othermsg, long starttime) {
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("mq_returncode", (Object)errcode);
        ServiceLogs.error("mqconsumer_error", logmsg.toString(), starttime, new Object[0]);
    }

    public static void logConsumeMqSuccess(String topic, String key, String othermsg, long starttime) {
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("mq_returncode", (Object)"0");
        ServiceLogs.info("mqconsumer_succ", logmsg.toString(), starttime, new Object[0]);
    }

    public static void logSendMqStart(String topic, String key, String othermsg) {
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        ServiceLogs.info("mqsend_start", logmsg.toString(), 0L, new Object[0]);
    }

    public static void logSendMqError(String topic, String key, String errcode, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("mq_returncode", (Object)errcode);
        sessionobj.setReturncode(errcode);
        ServiceLogs.error("mqsend_error", logmsg.toString(), starttime, new Object[0]);
    }

    public static void logSendMqSuccess(String topic, String key, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("mq_returncode", (Object)"0");
        ServiceLogs.info("mqsend_succ", logmsg.toString(), starttime, new Object[0]);
    }

    public static void logFitlerSucc(String logmsg) {
        ServiceLogs.info("filter_succ", logmsg.toString(), 0L, new Object[0]);
    }

    public static void logFitlerFail(String logmsg) {
        ServiceLogs.error("filter_fail", logmsg.toString(), 0L, new Object[0]);
    }

    private static String getDefaultFormatstr(ServiceSession sessionobj, String logtype, Throwable e, String logmsg, long starttime) {
        StringBuffer sb = new StringBuffer();
        sb.append("rootkey: ");
        sb.append(sessionobj.getRootkey());
        if (logtype.equalsIgnoreCase("request")) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append("REQUEST  : ");
            sb.append(logmsg);
            sb.append(" , entid : ");
            sb.append(sessionobj.getEnt_id());
        } else if (logtype.equalsIgnoreCase("response")) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append("ELAPSED  : " + (System.currentTimeMillis() - starttime) + " ms , ");
            sb.append("RESPONSE : ");
            sb.append(logmsg);
        } else {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append(logtype + "  : ");
            if (starttime > 0L) {
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - starttime) + " ms , ");
            }
            sb.append(logmsg);
            sb.append(" , url : ");
            sb.append(sessionobj.getUrl());
        }
        if (e != null) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                if (i == 0) {
                    sb.append("exception : [" + stackTrace[i]);
                    continue;
                }
                sb.append(stackTrace[i]);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        return ExceptionUtil.stacktraceToOneLineString((Throwable)throwable, (int)200);
    }

    public static JSONObject getLogJson(ServiceSession sessionobj) {
        JSONObject session = (JSONObject)JSONObject.toJSON((Object)sessionobj);
        JSONObject rtn = new JSONObject();
        String format = sessionobj.getLogFormat();
        for (String key : session.keySet()) {
            if (format.indexOf(key) <= -1 || StringUtils.isEmpty(session.get((Object)key))) continue;
            rtn.put(key, session.get((Object)key));
        }
        return rtn;
    }

    private static String getJsonFormatstr(ServiceSession sessionobj, String logtype, Throwable e, String logmsg, long starttime) {
        JSONObject rtn = ServiceLogs.getLogJson(sessionobj);
        rtn.put("logtype", (Object)logtype);
        rtn.put("logmsg", (Object)logmsg);
        if (e != null) {
            String msg = ExceptionUtil.getMessage((Throwable)e);
            rtn.put("exception", (Object)ServiceLogs.getStackTrace(e));
            if (null == logmsg) {
                rtn.put("logmsg", (Object)msg);
            } else {
                rtn.put("logmsg", (Object)(logmsg + " errMsg:" + msg));
            }
        }
        if (starttime != 0L) {
            rtn.put("elapsed", (Object)(System.currentTimeMillis() - starttime));
        }
        return rtn.toString();
    }

    public static void info(String logtype, String logmsg, long starttime, Object ... arguments) {
        ServiceLogs.info(logger, logtype, logmsg, starttime, arguments);
    }

    public static void info(Logger log, String logtype, String logmsg, long starttime, Object ... arguments) {
        if (log.isInfoEnabled()) {
            String msg = ServiceLogs.formatMsg(logtype, null, logmsg, starttime, arguments);
            ServiceSession session = ServiceLogs.getSessionobj();
            if (ServiceLogs.isCanAddMsg(logtype)) {
                session.addMsg("info", msg);
            }
            logger.info(msg);
        }
    }

    public static void warn(String logtype, String logmsg, long starttime, Object ... arguments) {
        ServiceLogs.warn(logger, logtype, logmsg, starttime, arguments);
    }

    public static void warn(Logger log, String logtype, String logmsg, long starttime, Object ... arguments) {
        if (log.isWarnEnabled()) {
            String msg = ServiceLogs.formatMsg(logtype, null, logmsg, starttime, arguments);
            ServiceSession session = ServiceLogs.getSessionobj();
            if (ServiceLogs.isCanAddMsg(logtype)) {
                session.addMsg("warn", msg);
            }
            logger.warn(msg);
        }
    }

    private static String formatMsg(String logtype, Throwable e, String logmsg, long starttime, Object ... arguments) {
        String fmsg;
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        String logFromat = "json";
        String msg = fmsg = ServiceLogs.format(logmsg, arguments);
        msg = logFromat.equalsIgnoreCase("json") ? ServiceLogs.getJsonFormatstr(sessionobj, logtype, e, fmsg, starttime) : ServiceLogs.getDefaultFormatstr(sessionobj, logtype, e, fmsg, starttime);
        return msg;
    }

    public static void error(String logtype, Throwable throwable, String logmsg, long starttime, Object ... arguments) {
        ServiceLogs.error(logger, logtype, throwable, logmsg, starttime, arguments);
    }

    public static void error(String logtype, String logmsg, long starttime, Object ... arguments) {
        ServiceLogs.error(logger, logtype, null, logmsg, starttime, arguments);
    }

    public static void error(Logger log, String logtype, Throwable throwable, String logmsg, long starttime, Object ... arguments) {
        if (log.isErrorEnabled()) {
            String msg = ServiceLogs.formatMsg(logtype, throwable, logmsg, starttime, arguments);
            ServiceSession session = ServiceLogs.getSessionobj();
            session.addMsg("error", msg);
            log.error(msg);
        }
    }

    public static void debug(String logtype, String logmsg, long starttime, Object ... arguments) {
        ServiceLogs.debug(logger, logtype, logmsg, starttime, arguments);
    }

    public static void debug(Logger log, String logtype, String logmsg, long starttime, Object ... arguments) {
        ServiceSession session = ServiceLogs.getSessionobj();
        if (log.isDebugEnabled() || session.isDebugEnble()) {
            String msg = ServiceLogs.formatMsg(logtype, null, logmsg, starttime, arguments);
            if (session.isDebugEnble() && ServiceLogs.isCanAddMsg(logtype)) {
                session.addMsg("debug", msg);
            }
            if (log.isDebugEnabled()) {
                logger.debug(msg);
            } else {
                logger.info(msg);
            }
        }
    }

    private static boolean isCanAddMsg(String logtype) {
        return "request,response".indexOf(logtype) <= -1;
    }

    public static String format(String msg, Object ... args) {
        if (args == null || args.length <= 0) {
            return msg;
        }
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = StringUtils.isEmpty(args[i]) ? "" : args[i].toString();
        }
        return MessageFormat.format(msg, args);
    }

    public static interface LOGTYPE {
        public static final String INFO = "info";
        public static final String RESPONSE = "response";
        public static final String REQUEST = "request";
        public static final String DBSTART = "db_start";
        public static final String DBSUCC = "db_succ";
        public static final String DBERROR = "db_error";
        public static final String CALL_REQUEST = "call_request";
        public static final String CALL_RESPONSE = "call_response";
        public static final String MQSEND_start = "mqsend_start";
        public static final String MQSEND_error = "mqsend_error";
        public static final String MQSEND_succ = "mqsend_succ";
        public static final String MQCONSUMER_start = "mqconsumer_start";
        public static final String MQCONSUMER_error = "mqconsumer_error";
        public static final String MQCONSUMER_succ = "mqconsumer_succ";
        public static final String FILTER_SUCC = "filter_succ";
        public static final String FILTER_FAIL = "filter_fail";
    }
}

