package com.efuture.common.web.controller;


import com.efuture.common.web.exception.ServiceException;
import com.efuture.ocp.common.exception.ResponseCode;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;

/**
 * 全局异常处理
 */
@RestControllerAdvice
public class ExceptionControllerAdvice
{

    @ExceptionHandler
    public ResultVO<String> exceptionHandler(HttpServletRequest request, Exception e)
    {
        if (e instanceof ServiceException) {
            return serviceExceptionHandler((ServiceException) e);
        }
        else if (e instanceof MethodArgumentNotValidException) {
            try {
                return methodArgumentNotValidExceptionHandler((MethodArgumentNotValidException) e);
            }
            catch (NoSuchFieldException e1) {
                return othersExceptionHandler(e);
            }
        }
        else {
            return othersExceptionHandler(e);
        }
    }

    public ResultVO<String> othersExceptionHandler(Exception e)
    {
        return ResultVO.failure(e.getMessage());
    }

    public ResultVO<String> serviceExceptionHandler(ServiceException e)
    {
        return ResultVO.failure(e.getMessage());
    }


    public ResultVO<String> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) throws NoSuchFieldException
    {
        // 从异常对象中拿到错误信息
        String defaultMessage = e.getBindingResult().getAllErrors().get(0).getDefaultMessage();
        // 参数的Class对象，等下好通过字段名称获取Field对象
        Class<?> parameterType = e.getParameter().getParameterType();
        // 拿到错误的字段名称
        String fieldName = e.getBindingResult().getFieldError().getField();
        Field field = parameterType.getDeclaredField(fieldName);
        // 获取Field对象上的自定义注解
        FieldValidatorExceptionCode annotation = field.getAnnotation(FieldValidatorExceptionCode.class);

        // 有注解的话就返回注解的响应信息
        if (annotation != null) {
            return ResultVO.failure(annotation.value(), annotation.message());
        }

        // 没有注解就提取错误提示信息进行返回统一错误码
        return ResultVO.failure(ResponseCode.VALIDATE_FAILED, defaultMessage);
    }
}
