package com.efuture.common.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;


@RestController
public class GlobalExceptionController extends AbstractErrorController
{
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionController.class);
    private static final String ERROR_PATH = "/error";

    public GlobalExceptionController(ErrorAttributes errorAttributes)
    {
        super(errorAttributes);
    }

    @Override
    public String getErrorPath()
    {
        return ERROR_PATH;
    }

    @RequestMapping(value = ERROR_PATH)
    public ResultVO<String> error(HttpServletRequest request)
    {
        //WebRequest webRequest = new ServletWebRequest(request);
        Map<String, Object> attributes = getErrorAttributes(request, ErrorAttributeOptions.defaults());
        Object timestamp = attributes.get("timestamp");
        Object status = attributes.get("status");
        String error = attributes.get("error").toString();
        Object path = attributes.get("path");
        LOGGER.error("status {} error {} path{} timestamp {}", status, error, path, timestamp);
        return ResultVO.failure(status.toString(), error);
        //        //Throwable e = getError(webRequest);
        //        if (e == null) {
        //            Map<String, Object> attributes = getErrorAttributes(request, ErrorAttributeOptions.defaults());
        //            Object timestamp = attributes.get("timestamp");
        //            Object status = attributes.get("status");
        //            String error = attributes.get("error").toString();
        //            Object path = attributes.get("path");
        //            LOGGER.error("status {} error {} path{} timestamp {}", status, error, path, timestamp);
        //            return ResultVO.failure(status.toString(), error);
        //        } else {
        //            return ResultVO.failure("系统繁忙,请稍后再试");
        //        }
    }

    //    private Throwable getError(WebRequest webRequest) {
    //        return (Throwable) this.getAttribute(webRequest, "javax.servlet.error.exception");
    //    }
    //    private Object getAttribute(RequestAttributes requestAttributes, String name) {
    //        return requestAttributes.getAttribute(name, 0);
    //    }
}
