/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	ServiceException.java
 * Author:		亮
 * Date:		2014-4-14 下午5:13:03
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 */
package com.efuture.common.web.exception;

import org.springframework.util.StringUtils;

import java.text.MessageFormat;

/**
 * @author 亮
 * @description
 *
 */
public class ServiceException extends RuntimeException
{
    /**
     * @description
     */
    private static final long serialVersionUID = 1L;

    private String errGroup;
    private String errCode;
    private Object[] errArgs;

    public ServiceException(String errCode, String errmsg, Object... args)
    {
        super(format(errmsg, args));
        this.errCode = errCode;
        this.errArgs = args;
    }

    private static String format(String errMsg, Object... args)
    {
        if (args == null || args.length <= 0) {
            return errMsg;
        }

        // format String
        for (int i = 0; args != null && i < args.length; i++) {
            if (args[i] instanceof String) {
                continue;
            }

            args[i] = StringUtils.isEmpty(args[i]) ? "" : args[i].toString();
        }

        return MessageFormat.format(errMsg, args);
    }

    public static ServiceException newGroupServiceException(String errGroup, String errcode, String errmsg, Object... args)
    {
        ServiceException rtn = new ServiceException(errcode, errmsg, args);
        rtn.errGroup = errGroup;
        return rtn;
    }

    public String getErrGroup()
    {
        return errGroup;
    }

    public String getErrorCode()
    {
        return errCode;
    }

    public Object[] getErrorArgs()
    {
        return errArgs;
    }

    public interface ERR_GROUP
    {
        String UNKNOWN = "unknown";
        String DATABASE = "database";
        String NETWORK = "network";
        String DATA = "data";
        String SERVICE = "service";
        String IGNORE = "ignore";
    }
}
