/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.tms.component;

import com.product.exception.ServiceRuntimeException;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FMybatisTemplate;
import com.shiji.core.annotation.KeepTransient;
import com.shiji.core.util.ReflectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

public class MyBatisDataAccess
extends FMybatisTemplate {
    private static final Logger log = LoggerFactory.getLogger(MyBatisDataAccess.class);
    private final String SQL_SELECT = "mybatis.sql.select";
    private final String SQL_INSERT = "mybatis.sql.insert";
    private final String SQL_UPDATE = "mybatis.sql.update";
    private final String SQL_DELETE = "mybatis.sql.delete";

    public MyBatisDataAccess(SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public MyBatisDataAccess(SqlSessionFactory sqlSessionFactory, String characterSet) {
        super(sqlSessionFactory, characterSet);
    }

    public MyBatisDataAccess(SqlSessionFactory sqlSessionFactory, ExecutorType executorType) {
        super(sqlSessionFactory, executorType);
    }

    public MyBatisDataAccess(SqlSessionFactory sqlSessionFactory, ExecutorType executorType, String characterSet) {
        super(sqlSessionFactory, executorType, characterSet);
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        return super.getSqlSessionTemplate();
    }

    public void insert(Object objectToSave) {
        if (objectToSave == null) {
            throw new ServiceRuntimeException("objectToSave \u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap map = new HashMap();
        if (objectToSave instanceof Map) {
            map.putAll((Map)objectToSave);
        } else {
            map.putAll(BeanMap.create((Object)objectToSave));
        }
        Set<String> transientFields = this.getIgnoreInsertSet(objectToSave.getClass());
        for (String key : transientFields) {
            map.remove(key);
        }
        HashMap map2 = new HashMap();
        map2.putAll(map);
        for (Object key : map2.keySet()) {
            Object value = map2.get(key);
            if (null != value) continue;
            map.remove(key);
        }
        super.insert(map, this.fetchAnnotationTableName(objectToSave.getClass()));
    }

    public <T> void batchInsert(List<T> entryList) {
        for (T entry : entryList) {
            this.insert(entry);
        }
    }

    private Set<String> getIgnoreInsertSet(Class<?> clazz) {
        HashSet<String> filedSet = new HashSet<String>();
        List fields = ReflectUtils.getAllFields(clazz);
        ArrayList<Field> transientFieldList = new ArrayList<Field>();
        for (Field field : fields) {
            Transient tt = field.getAnnotation(Transient.class);
            KeepTransient keeptt = field.getAnnotation(KeepTransient.class);
            if (tt == null && keeptt == null) continue;
            transientFieldList.add(field);
        }
        for (Field field : transientFieldList) {
            filedSet.add(field.getName());
        }
        return filedSet;
    }

    private String fetchAnnotationTableName(Class<?> cl) {
        Annotation[] annos;
        for (Annotation ann : annos = cl.getAnnotations()) {
            if (!(ann instanceof Document)) continue;
            Document doc = (Document)ann;
            return doc.collection();
        }
        String name = cl.getName();
        return (name = name.substring(name.lastIndexOf(".") + 1).toLowerCase()).endsWith("bean") ? name.substring(0, name.length() - 4) : name;
    }
}

