/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.tms.report.vo;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DailyTimelyRate
implements Serializable {
    @JSONField(serialize=false)
    private String teamId;
    private String teamName;
    private Long unfinishedBoxQty = 0L;
    private Long finishedBoxQty = 0L;
    private BigDecimal rate;

    public DailyTimelyRate() {
    }

    public DailyTimelyRate(String teamId, String teamName) {
        this.teamId = teamId;
        this.teamName = teamName;
    }

    public void addFinished(Long boxQty) {
        this.finishedBoxQty = this.finishedBoxQty + boxQty;
    }

    public void addUnfinished(Long boxQty) {
        this.unfinishedBoxQty = this.unfinishedBoxQty + boxQty;
    }

    public void calculateRate() {
        BigDecimal allQty = BigDecimal.valueOf(this.unfinishedBoxQty + this.finishedBoxQty);
        this.rate = allQty.equals(BigDecimal.ZERO) ? BigDecimal.valueOf(100.0) : BigDecimal.valueOf(this.finishedBoxQty).multiply(BigDecimal.valueOf(100L)).divide(allQty, 2, RoundingMode.HALF_UP);
    }

    public String getTeamId() {
        return this.teamId;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public Long getUnfinishedBoxQty() {
        return this.unfinishedBoxQty;
    }

    public Long getFinishedBoxQty() {
        return this.finishedBoxQty;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void setUnfinishedBoxQty(Long unfinishedBoxQty) {
        this.unfinishedBoxQty = unfinishedBoxQty;
    }

    public void setFinishedBoxQty(Long finishedBoxQty) {
        this.finishedBoxQty = finishedBoxQty;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DailyTimelyRate)) {
            return false;
        }
        DailyTimelyRate other = (DailyTimelyRate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$unfinishedBoxQty = this.getUnfinishedBoxQty();
        Long other$unfinishedBoxQty = other.getUnfinishedBoxQty();
        if (this$unfinishedBoxQty == null ? other$unfinishedBoxQty != null : !((Object)this$unfinishedBoxQty).equals(other$unfinishedBoxQty)) {
            return false;
        }
        Long this$finishedBoxQty = this.getFinishedBoxQty();
        Long other$finishedBoxQty = other.getFinishedBoxQty();
        if (this$finishedBoxQty == null ? other$finishedBoxQty != null : !((Object)this$finishedBoxQty).equals(other$finishedBoxQty)) {
            return false;
        }
        String this$teamId = this.getTeamId();
        String other$teamId = other.getTeamId();
        if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
            return false;
        }
        String this$teamName = this.getTeamName();
        String other$teamName = other.getTeamName();
        if (this$teamName == null ? other$teamName != null : !this$teamName.equals(other$teamName)) {
            return false;
        }
        BigDecimal this$rate = this.getRate();
        BigDecimal other$rate = other.getRate();
        return !(this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DailyTimelyRate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $unfinishedBoxQty = this.getUnfinishedBoxQty();
        result = result * 59 + ($unfinishedBoxQty == null ? 43 : ((Object)$unfinishedBoxQty).hashCode());
        Long $finishedBoxQty = this.getFinishedBoxQty();
        result = result * 59 + ($finishedBoxQty == null ? 43 : ((Object)$finishedBoxQty).hashCode());
        String $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
        String $teamName = this.getTeamName();
        result = result * 59 + ($teamName == null ? 43 : $teamName.hashCode());
        BigDecimal $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        return result;
    }

    public String toString() {
        return "DailyTimelyRate(teamId=" + this.getTeamId() + ", teamName=" + this.getTeamName() + ", unfinishedBoxQty=" + this.getUnfinishedBoxQty() + ", finishedBoxQty=" + this.getFinishedBoxQty() + ", rate=" + this.getRate() + ")";
    }
}

