/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.aop;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.annotation.RreventReSubmit;
import com.efuture.common.transaction.event.RedisLockEvent;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.ResubmitException;
import com.product.model.ServiceResponse;
import com.product.util.SpringContext;
import com.shiji.core.util.SpringInvoker;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class PreventReSubmitInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PreventReSubmitInterceptor.class);
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @Pointcut(value="execution(* com..DataController.onRest(..))")
    private void reSubmitPointCut() {
    }

    @Around(value="reSubmitPointCut()")
    public Object getSessionInitAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Object methodName;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        StringBuffer urlBuffer = request.getRequestURL();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] parNames = methodSignature.getParameterNames();
        Object[] objects = joinPoint.getArgs();
        boolean isAddLock = true;
        String pmethod = "";
        for (int i = 0; i < parNames.length; ++i) {
            RreventReSubmit reSubmit;
            int index;
            String componentName;
            if (!"method".equals(parNames[i])) continue;
            pmethod = (String)objects[i];
            SpringInvoker invokerHandler = (SpringInvoker)SpringContext.getBean(SpringInvoker.class, (Object[])new Object[0]);
            Method method = invokerHandler.getComponentMethod(componentName = pmethod.substring(0, index = pmethod.lastIndexOf(".")), (String)(methodName = pmethod.substring(index + 1)));
            if (Objects.isNull(method)) {
                ExceptionUtils.raise("------[{0}]\u4e2d\u672a\u627e\u5230\u8bf7\u6c42\u65b9\u6cd5[{1}]", componentName, methodName);
            }
            if (Objects.nonNull(reSubmit = method.getAnnotation(RreventReSubmit.class)) && !(isAddLock = reSubmit.required()) || objects[i].toString().lastIndexOf("query") <= 0 && !((String)methodName).startsWith("get")) break;
            isAddLock = false;
            break;
        }
        if (!isAddLock) {
            log.info("[{}]---->\u4e0d\u9650\u5236\u91cd\u590d\u63d0\u4ea4\uff01", (Object)pmethod);
            return joinPoint.proceed();
        }
        String reSubmitkey = PreventReSubmitInterceptor.getReSubmitKey(parNames, objects);
        long start = System.currentTimeMillis();
        log.info("[{}]---->\u9632\u6b62\u91cd\u590d\u63d0\u4ea4key:{}", (Object)pmethod, (Object)reSubmitkey);
        try {
            Object rLock;
            if (StringUtils.isNotBlank((CharSequence)reSubmitkey)) {
                rLock = this.redissonClient.getLock(reSubmitkey);
                if (rLock.tryLock()) {
                    methodName = joinPoint.proceed();
                    return methodName;
                }
                throw new ResubmitException("9999", "\u91cd\u590d\u63d0\u4ea4:[" + reSubmitkey + "]");
            }
            log.info("[{}]---->\u9632\u6b62\u91cd\u590d\u63d0\u4ea4key\u4e3a\u7a7a!!!!", (Object)pmethod);
            rLock = joinPoint.proceed();
            return rLock;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof ResubmitException) {
                ServiceResponse response = ServiceResponse.buildFailure(null, (String)"9999", (String)e.getMessage());
                log.info("----------======>{}", (Object)JSONObject.toJSONString((Object)response));
                String string = JSONObject.toJSONString((Object)response);
                return string;
            }
            throw e;
        }
        finally {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                String finalPmethod = pmethod;
                this.eventPublisher.publishEvent((ApplicationEvent)new RedisLockEvent(() -> {
                    RLock lock = this.redissonClient.getLock(reSubmitkey);
                    if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                        lock.unlock();
                        log.info("[{}]\u65b9\u6cd5\u6267\u884c\u8017\u65f6[{}]---->transaction\u540e\u91ca\u653e\u9501[\u9632\u6b62\u91cd\u590d\u63d0\u4ea4]", (Object)finalPmethod, (Object)(System.currentTimeMillis() - start));
                    }
                }));
            } else {
                RLock lock = this.redissonClient.getLock(reSubmitkey);
                if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                    log.info("[{}]\u65b9\u6cd5\u6267\u884c\u8017\u65f6[{}]---->[\u9632\u6b62\u91cd\u590d\u63d0\u4ea4]", (Object)pmethod, (Object)(System.currentTimeMillis() - start));
                }
            }
        }
    }

    public static String getReSubmitKey(String[] parNames, Object[] parValues) {
        int i;
        StringBuffer reSubmitkey = new StringBuffer();
        for (i = 0; i < parNames.length; ++i) {
            if (!"method".equals(parNames[i])) continue;
            String pmethod = (String)parValues[i];
            reSubmitkey.append(pmethod);
            break;
        }
        for (i = 0; i < parNames.length; ++i) {
            if (!"param".equals(parNames[i])) continue;
            if (StringUtils.isNotEmpty((CharSequence)reSubmitkey)) {
                reSubmitkey.append(":");
            }
            reSubmitkey.append(parValues[i].toString().replace(":", "-"));
            break;
        }
        return reSubmitkey.toString();
    }
}

