/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.rocketmq.producer;

import com.alibaba.fastjson.JSON;
import com.efuture.common.rocketmq.transaction.model.TransactionBackCheck;
import com.product.util.SpringContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Component
public class MQProducerService {
    private static final Logger log = LoggerFactory.getLogger(MQProducerService.class);
    private static final String prefix = ":";
    public static final String sessionKey = "session";
    @Value(value="${rocketmq.producer.send-message-timeout}")
    private Integer messageTimeOut;
    @Autowired
    @Lazy
    private RocketMQTemplate rocketMQTemplate;

    public void send(Object msg) {
        this.rocketMQTemplate.convertAndSend((Object)"ISCE_WMS_INOUT_TOPIC", msg);
    }

    public SendResult sendSyncMsg(Object msgBody) {
        return this.sendSyncMsg(msgBody, null, null, null);
    }

    public SendResult sendSyncMsg(Object msgBody, String tag) {
        return this.sendSyncMsg(msgBody, tag, null, null);
    }

    public SendResult sendSyncMsg(Object msgBody, String key, String topic) {
        return this.sendSyncMsg(msgBody, null, key, topic);
    }

    public SendResult sendSyncMsg(Object msgBody, String tag, String key, String topic) {
        SendResult sendResult = this.rocketMQTemplate.syncSend(this.getTopic(topic, tag), this.getMessage(msgBody, key));
        log.info("\u3010sendMsg\u3011sendResult={}", (Object)JSON.toJSONString((Object)sendResult));
        return sendResult;
    }

    public SendResult sendSyncDelayMsg(Object msgBody, int delayLevel) {
        return this.sendSyncDelayMsg(msgBody, null, null, null, delayLevel);
    }

    public SendResult sendSyncDelayMsg(Object msgBody, String tag, int delayLevel) {
        return this.sendSyncDelayMsg(msgBody, tag, null, null, delayLevel);
    }

    public SendResult sendSyncDelayMsg(Object msgBody, String tag, String key, int delayLevel) {
        return this.sendSyncDelayMsg(msgBody, tag, key, null, delayLevel);
    }

    public SendResult sendSyncDelayMsg(Object msgBody, String tag, String key, String topic, int delayLevel) {
        SendResult sendResult = this.rocketMQTemplate.syncSend(this.getTopic(topic, tag), this.getMessage(msgBody, key), (long)this.messageTimeOut.intValue(), delayLevel);
        log.info("\u3010sendMsg\u3011sendResult={}", (Object)JSON.toJSONString((Object)sendResult));
        return sendResult;
    }

    public void sendAsyncMsg(Object msgBody) {
        this.sendAsyncMsg(msgBody, null, null, null, null);
    }

    public void sendAsyncMsg(Object msgBody, SendCallback callback) {
        this.sendAsyncMsg(msgBody, null, null, null, callback);
    }

    public void sendAsyncMsg(Object msgBody, String topic, SendCallback callback) {
        this.sendAsyncMsg(msgBody, null, null, topic, callback);
    }

    public void sendAsyncMsg(Object msgBody, String tag, String key, SendCallback callback) {
        this.sendAsyncMsg(msgBody, tag, key, null, callback);
    }

    public void sendAsyncMsg(Object msgBody, String tag, String key, String topic, SendCallback callback) {
        this.rocketMQTemplate.asyncSend(this.getTopic(topic, tag), this.getMessage(msgBody, key), callback);
    }

    public void sendAsyncDelayMsg(Object msgBody, int delayLevel, SendCallback sendCallback) {
        this.sendAsyncDelayMsg(msgBody, null, null, null, delayLevel, sendCallback);
    }

    public void sendAsyncDelayMsg(Object msgBody, String tag, int delayLevel, SendCallback sendCallback) {
        this.sendAsyncDelayMsg(msgBody, tag, null, null, delayLevel, sendCallback);
    }

    public void sendAsyncDelayMsg(Object msgBody, String tag, String key, int delayLevel, SendCallback sendCallback) {
        this.sendAsyncDelayMsg(msgBody, tag, key, null, delayLevel, sendCallback);
    }

    public void sendAsyncDelayMsg(Object msgBody, String tag, String key, String topic, int delayLevel, SendCallback sendCallback) {
        this.rocketMQTemplate.asyncSend(this.getTopic(topic, tag), this.getMessage(msgBody, key), sendCallback, (long)this.messageTimeOut.intValue(), delayLevel);
    }

    public void sendOneWayMsg(Object msgBody) {
        this.sendOneWayMsg(msgBody, null, null, null);
    }

    public void sendOneWayMsg(Object msgBody, String tag) {
        this.sendOneWayMsg(msgBody, tag, null, null);
    }

    public void sendOneWayMsg(Object msgBody, String tag, String key) {
        this.sendOneWayMsg(msgBody, tag, key, null);
    }

    public void sendOneWayMsg(Object msgBody, String tag, String key, String topic) {
        this.rocketMQTemplate.sendOneWay(this.getTopic(topic, tag), this.getMessage(msgBody, key));
    }

    public TransactionSendResult sendInTransactionMsg(TransactionBackCheck msgBody, Object arg) {
        return this.sendInTransactionMsg(msgBody, null, null, null, arg);
    }

    public TransactionSendResult sendInTransactionMsg(TransactionBackCheck msgBody, String tag, Object arg) {
        return this.sendInTransactionMsg(msgBody, null, tag, null, arg);
    }

    public TransactionSendResult sendInTransactionMsg(TransactionBackCheck msgBody, String tag, String key, Object arg) {
        return this.sendInTransactionMsg(msgBody, tag, key, null, arg);
    }

    public TransactionSendResult sendInTransactionMsg(TransactionBackCheck msgBody, String tag, String key, String topic, Object arg) {
        return this.rocketMQTemplate.sendMessageInTransaction(this.getTopic(topic, tag), this.getMessage(msgBody, key), arg);
    }

    private String getTopic(String topic, String tag) {
        StringBuilder res = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)topic)) {
            res.append("ISCE_WMS_INOUT_TOPIC");
        } else {
            res.append(topic);
        }
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            res.append(prefix).append(tag);
        }
        return res.toString();
    }

    private Message getMessage(Object msgBody, String key) {
        String checkService = null;
        String checkMethod = null;
        if (msgBody instanceof TransactionBackCheck) {
            TransactionBackCheck backCheck = (TransactionBackCheck)msgBody;
            msgBody = backCheck.getMessage();
            checkService = backCheck.getCheckService();
            checkMethod = backCheck.getCheckMethod();
        }
        String sessionStr = JSON.toJSONString((Object)SpringContext.getSession());
        log.info("----------\u300b\u6d88\u606f\u53d1\u9001\u65f6session:{}", (Object)sessionStr);
        MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)msgBody).setHeader(sessionKey, (Object)sessionStr);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            messageBuilder.setHeader("KEYS", (Object)key);
        }
        if (StringUtils.isNotBlank((CharSequence)checkService)) {
            messageBuilder.setHeader("SERVICE", (Object)checkService);
        }
        if (StringUtils.isNotBlank((CharSequence)checkMethod)) {
            messageBuilder.setHeader("METHOD", (Object)checkMethod);
        }
        return messageBuilder.build();
    }
}

