/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.model.Account;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.RestUtils;
import com.product.util.SpringContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountUtils {
    private static final Logger log = LoggerFactory.getLogger(AccountUtils.class);

    public static List<Account> getAccountByUserCode(String userCode) {
        List<Account> accountList = new ArrayList<Account>();
        JSONObject param = new JSONObject();
        param.put("page_no", (Object)1);
        param.put("page_size", (Object)10000);
        param.put("userCode", (Object)(StringUtils.isNotBlank((CharSequence)userCode) ? userCode : "N"));
        ServiceSession token = SpringContext.getSession();
        String accountUrl = "http://amp-user/rest?method=usercenter.account.search";
        try {
            log.info("------\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)param.toJSONString());
            String res = RestUtils.doPost((String)accountUrl, (String)param.toString());
            log.info("\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)res);
            if (!StringUtils.isEmpty((CharSequence)res)) {
                JSONObject obj = JSON.parseObject((String)res);
                JSONArray jsonArray = obj.getJSONObject("data").getJSONArray("account");
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01{}", (Object)param.toJSONString());
                } else {
                    accountList = JSONObject.parseArray((String)jsonArray.toString(), Account.class);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return accountList;
    }

    public static List<Account> getAccountList() {
        List<Account> accountList = new ArrayList<Account>();
        JSONObject param = new JSONObject();
        param.put("page_no", (Object)1);
        param.put("page_size", (Object)10000);
        ServiceSession token = SpringContext.getSession();
        String accountUrl = "http://amp-user/rest?method=usercenter.account.search";
        try {
            log.info("------\u83b7\u53d6\u6240\u6709\u8d26\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)param.toJSONString());
            String res = RestUtils.doPost((String)accountUrl, (String)param.toString());
            log.info("\u83b7\u53d6\u6240\u6709\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)res);
            if (!StringUtils.isEmpty((CharSequence)res)) {
                JSONObject obj = JSON.parseObject((String)res);
                JSONArray jsonArray = obj.getJSONObject("data").getJSONArray("account");
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    log.info("\u67e5\u8be2\u6240\u6709\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01{}", (Object)param.toJSONString());
                } else {
                    accountList = JSONObject.parseArray((String)jsonArray.toString(), Account.class);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return accountList;
    }

    public static ServiceResponse checkAccount(String userCode, String passWord) {
        ServiceResponse response = null;
        JSONObject param = new JSONObject();
        param.put("erpCode", (Object)"");
        param.put("locale", (Object)"CN");
        param.put("password", (Object)passWord);
        param.put("tag", (Object)"*#06#");
        param.put("shopCode", (Object)"");
        param.put("userCode", (Object)(StringUtils.isNotBlank((CharSequence)userCode) ? userCode : "N"));
        String accountUrl = "http://amp-user/rest?method=usercenter.authentication.signInNoEnt";
        try {
            JSONObject obj;
            log.info("------\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)param.toJSONString());
            String res = RestUtils.doPost((String)accountUrl, (String)param.toString());
            log.info("\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)res);
            response = !StringUtils.isEmpty((CharSequence)res) ? ("0".equals((obj = JSON.parseObject((String)res)).getJSONObject("data")) ? ServiceResponse.buildSuccess((Object)obj.getJSONObject("data")) : ServiceResponse.buildFailure(null, (String)obj.getString("data"))) : ServiceResponse.buildFailure(null, (String)"\u9a8c\u8bc1\u8d26\u53f7\u9519\u8bef");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public static ServiceResponse verifyAuthority(long aid) {
        ServiceResponse response = null;
        JSONObject param = new JSONObject();
        param.put("aid", (Object)aid);
        String accountUrl = "http://amp-user/rest?method=usercenter.accountStationRef.searchStationByAid";
        try {
            log.info("------\u83b7\u53d6\u8d26\u6237\u5bf9\u5e94\u89d2\u8272\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)param.toJSONString());
            String res = RestUtils.doPost((String)accountUrl, (String)param.toString());
            log.info("\u83b7\u53d6\u8d26\u6237\u5bf9\u5e94\u89d2\u8272\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)res);
            if (!StringUtils.isEmpty((CharSequence)res)) {
                JSONObject obj = JSON.parseObject((String)res);
                JSONArray jsonArray = obj.getJSONObject("data").getJSONArray("accountStationRef");
                if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        if (!"999".equals(jsonArray.getJSONObject(i).getJSONObject("station").getString("stationCode"))) continue;
                        return ServiceResponse.buildSuccess((Object)"\u6821\u9a8c\u6210\u529f");
                    }
                    return ServiceResponse.buildFailure(null, (String)"\u8d26\u53f7\u65e0\u4e3b\u7ba1\u6743\u9650\uff0c\u8bf7\u68c0\u67e5");
                }
                log.info("\u67e5\u8be2\u6240\u6709\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01{}", (Object)param.toJSONString());
                response = ServiceResponse.buildFailure(null, (String)"\u672a\u67e5\u8be2\u5230\u8d26\u6237\u89d2\u8272\u6743\u9650");
                return ServiceResponse.buildFailure(null, (String)"\u8d26\u53f7\u65e0\u4e3b\u7ba1\u6743\u9650\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public static Map<String, String> getAccountUsernameMap() {
        List<Account> accountList = AccountUtils.getAccountList();
        return accountList.stream().collect(Collectors.toMap(Account::getUserCode, Account::getUserName));
    }
}

