/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.model.AmapModel;
import com.product.util.RestUtils;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AmapPositionUtil {
    private static final double EARTH_AVG_RADIUS = 6371000.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistanceGoogle(double longitude1, double latitude1, double longitude2, double latitude2) {
        double radLat1 = AmapPositionUtil.rad(latitude1);
        double radLat2 = AmapPositionUtil.rad(latitude2);
        double a = radLat1 - radLat2;
        double b = AmapPositionUtil.rad(longitude1) - AmapPositionUtil.rad(longitude2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6371000.0;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s;
    }

    public static Double getDistanceAmap(double longitude1, double latitude1, double longitude2, double latitude2) {
        if (longitude1 == 0.0 || latitude1 == 0.0 || latitude2 == 0.0 || longitude2 == 0.0) {
            return -1.0;
        }
        longitude2 *= 0.01745329251994329;
        latitude2 *= 0.01745329251994329;
        double var1 = Math.sin(longitude1 *= 0.01745329251994329);
        double var2 = Math.sin(latitude1 *= 0.01745329251994329);
        double var3 = Math.cos(longitude1);
        double var4 = Math.cos(latitude1);
        double var5 = Math.sin(longitude2);
        double var6 = Math.sin(latitude2);
        double var7 = Math.cos(longitude2);
        double var8 = Math.cos(latitude2);
        double[] var10 = new double[3];
        double[] var20 = new double[3];
        var10[0] = var4 * var3;
        var10[1] = var4 * var1;
        var10[2] = var2;
        var20[0] = var8 * var7;
        var20[1] = var8 * var5;
        var20[2] = var6;
        return Math.asin(Math.sqrt((var10[0] - var20[0]) * (var10[0] - var20[0]) + (var10[1] - var20[1]) * (var10[1] - var20[1]) + (var10[2] - var20[2]) * (var10[2] - var20[2])) / 2.0) * 1.27420015798544E7;
    }

    public static Boolean isInArea(List<Point2D.Double> pointList, Point2D.Double point) {
        Integer across = 0;
        double precision = 2.0E-10;
        for (int i = 0; i < pointList.size(); ++i) {
            Point2D.Double p1 = pointList.get(i);
            Point2D.Double p2 = pointList.get(i + 1 >= pointList.size() ? 0 : i + 1);
            if (p1.equals(point) || p2.equals(point)) {
                return true;
            }
            if (!(point.y <= Math.max(p1.y, p2.y)) || !(point.y >= Math.min(p1.y, p2.y))) continue;
            if (point.x <= Math.max(p1.x, p2.x) && point.x >= Math.min(p1.x, p2.x)) {
                if (p1.y == p2.y && point.y == p1.y) {
                    return true;
                }
                if (p1.x == p2.x && point.x == p1.x) {
                    return true;
                }
                double xianShangY = p1.y + (point.x - p1.x) * (p2.y - p1.y) / (p2.x - p1.x);
                if (Math.abs(xianShangY - point.y) < precision) {
                    return true;
                }
            }
            if (point.x <= Math.min(p1.x, p2.x) || p1.y == p2.y || point.y == Math.min(p1.y, p2.y)) continue;
            Integer n = across;
            Integer n2 = across = Integer.valueOf(across + 1);
        }
        if (across % 2 == 0) {
            return false;
        }
        return true;
    }

    public static List<AmapModel> getGeoCoordinatesByAddress(List<AmapModel> dtoList) {
        JSONObject obj;
        JSONArray jsonArray;
        ArrayList<AmapModel> retDataList = new ArrayList<AmapModel>();
        String key = "";
        JSONObject param = new JSONObject();
        param.put("entid", (Object)"0");
        String res = null;
        try {
            res = RestUtils.doPost((String)"http://isce-mdm/rest?method=iscemdm.sysgaodeaccount.query", (String)param.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank((CharSequence)res) && CollectionUtils.isNotEmpty((Collection)(jsonArray = (obj = JSON.parseObject((String)res)).getJSONObject("data").getJSONArray("sysgaodeaccount")))) {
            key = jsonArray.getJSONObject(0).getString("webapikey");
        }
        String finalKey = key;
        dtoList.forEach(dto -> retDataList.add(AmapPositionUtil.getGeoCoordinatesByAddress(finalKey, dto)));
        return retDataList;
    }

    private static AmapModel getGeoCoordinatesByAddress(String key, AmapModel dto) {
        AmapModel retData = new AmapModel();
        BeanUtils.copyProperties((Object)dto, (Object)retData, (String[])new String[]{"longitude", "latitude", "province", "citycode", "city", "district", "adcode", "street"});
        if (StringUtils.isNotBlank((CharSequence)retData.getAddress())) {
            JSONObject geoInfo;
            String geoCodeStr;
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders httpHeaders = new HttpHeaders();
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("address", retData.getAddress());
            query.put("key", key);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
            String url = "https://restapi.amap.com/v3/geocode/geo?address={address}&output=JSON&key={key}";
            ResponseEntity responseEntity = restTemplate.getForEntity(url, JSONObject.class, query);
            if (((JSONObject)responseEntity.getBody()).getIntValue("status") == 1 && CollectionUtils.isNotEmpty((Collection)((JSONObject)responseEntity.getBody()).getJSONArray("geocodes")) && StringUtils.isNotBlank((CharSequence)(geoCodeStr = (geoInfo = ((JSONObject)responseEntity.getBody()).getJSONArray("geocodes").getJSONObject(0)).getString("location"))) && geoCodeStr.contains(",")) {
                retData.setLongitude(BigDecimal.valueOf(Double.valueOf(Arrays.stream(geoCodeStr.split(",")).toArray()[0].toString())));
                retData.setLatitude(BigDecimal.valueOf(Double.valueOf(Arrays.stream(geoCodeStr.split(",")).toArray()[1].toString())));
                retData.setProvince(geoInfo.getString("province"));
                retData.setCitycode(geoInfo.getString("citycode"));
                retData.setCity(geoInfo.getString("city"));
                retData.setDistrict(geoInfo.getString("district"));
                retData.setAdcode(geoInfo.getString("adcode"));
                retData.setStreet(geoInfo.getString("street"));
            }
        }
        return retData;
    }
}

