/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.efuture.common.model.excel.ExcelExportInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelExportUtil {
    public static void startDownload(HttpServletResponse response, ExcelExportInfo excelinfo, List<?> datalist) throws Exception {
        if (excelinfo == null || excelinfo.getColumnsinfo() == null || excelinfo.getColumnsinfo().stream().count() == 0L) {
            throw new Exception("\u67e5\u8be2\u6761\u4ef6\uff1aexcelinfo \u4e0d\u53ef\u4e3a\u7a7a");
        }
        List virtuallyColumns = excelinfo.getColumnsinfo().stream().filter(o -> o.getField() == null || o.getVisible() != null && o.getVisible() == false).collect(Collectors.toList());
        excelinfo.getColumnsinfo().removeAll(virtuallyColumns);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        excelinfo.setFilename(excelinfo.getFilename() + sdf.format(date) + ".xlsx");
        int columnsSize = excelinfo.getColumnsinfo().size();
        String[] columnFields = new String[columnsSize];
        String[] columnNames = new String[columnsSize];
        for (int i = 0; i < columnsSize; ++i) {
            columnFields[i] = excelinfo.getColumnsinfo().get(i).getField();
            columnNames[i] = excelinfo.getColumnsinfo().get(i).getTitle();
        }
        List<Map<String, Object>> list = ExcelExportUtil.createExcelRecord(datalist, columnFields);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ExcelExportUtil.createWorkBook(list, columnFields, columnNames).write((OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        response.reset();
        response.setCharacterEncoding("GB2312");
        response.setContentType("application/binary;charset=ISO8859_1");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(excelinfo.getFilename().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    private static List<Map<String, Object>> createExcelRecord(List<?> datalist, String[] columnfields) {
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sheetName", "sheet");
        listmap.add(map);
        for (int j = 0; j < datalist.size(); ++j) {
            Object project = datalist.get(j);
            HashMap<String, Object> mapValue = new HashMap<String, Object>();
            for (int i = 0; i < columnfields.length; ++i) {
                mapValue.put(columnfields[i], ExcelExportUtil.getFieldValueByName(columnfields[i], project));
            }
            listmap.add(mapValue);
        }
        return listmap;
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Workbook createWorkBook(List<Map<String, Object>> list, String[] columnfields, String[] columnnames) {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        Sheet sheet = wb.createSheet("sheet1");
        for (int i = 0; i < columnfields.length; ++i) {
            sheet.setColumnWidth((int)((short)i), 5355);
        }
        Font f = wb.createFont();
        Font f2 = wb.createFont();
        f.setFontHeightInPoints((short)10);
        f.setColor(IndexedColors.BLACK.getIndex());
        f2.setFontHeightInPoints((short)10);
        f2.setColor(IndexedColors.BLACK.getIndex());
        CellStyle cs = wb.createCellStyle();
        CellStyle cs2 = wb.createCellStyle();
        cs.setFont(f);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setBorderRight(BorderStyle.THIN);
        cs.setBorderTop(BorderStyle.THIN);
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs2.setFont(f2);
        cs2.setBorderLeft(BorderStyle.THIN);
        cs2.setBorderRight(BorderStyle.THIN);
        cs2.setBorderTop(BorderStyle.THIN);
        cs2.setBorderBottom(BorderStyle.THIN);
        cs2.setAlignment(HorizontalAlignment.CENTER);
        cs2.setVerticalAlignment(VerticalAlignment.CENTER);
        Row row = sheet.createRow(0);
        for (int i = 0; i < columnnames.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(columnnames[i]);
            cell.setCellStyle(cs);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 1; i < list.size(); ++i) {
            Row row1 = sheet.createRow(i);
            for (int j = 0; j < columnfields.length; j = (int)((short)(j + 1))) {
                Cell cell = row1.createCell(j);
                String cellValue = "";
                if (list.get(i).get(columnfields[j]) != null) {
                    cellValue = list.get(i).get(columnfields[j]) instanceof Date ? sdf.format(list.get(i).get(columnfields[j])) : list.get(i).get(columnfields[j]).toString();
                }
                cell.setCellValue(cellValue);
                cell.setCellStyle(cs2);
            }
        }
        return wb;
    }
}

