/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.mall.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
public class TaskDbConfig {
    @Autowired
    public Environment env;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();
    String DbKey = "malltask";

    private String getValue(String key, String defaultVal) {
        String val = this.env.getProperty(key);
        if (val == null || val.isEmpty()) {
            return defaultVal;
        }
        return val;
    }

    private DataSource getDs(String dbkey) {
        Properties props = new Properties();
        String prestr = "efuture.dataSource." + dbkey;
        props.put("driverClassName", this.env.getProperty(prestr + ".driverClassName"));
        props.put("url", this.env.getProperty(prestr + ".url"));
        props.put("username", this.env.getProperty(prestr + ".username"));
        props.put("password", this.env.getProperty(prestr + ".password"));
        props.put("maxActive", this.getValue(prestr + ".maxActive", "50"));
        props.put("maxWait", this.getValue(prestr + ".maxWaitMillis", "60000"));
        props.put("maxIdle", this.getValue(prestr + ".maxIdle", "20"));
        props.put("minIdle", this.getValue(prestr + ".minIdle", "3"));
        props.put("removeAbandoned", this.getValue(prestr + ".removeAbandoned", "true"));
        props.put("removeAbandonedTimeout", this.getValue(prestr + ".removeAbandonedTimeout", "600"));
        props.put("validationQuery", this.env.getProperty(prestr + ".validationQuery"));
        try {
            DruidDataSource datasource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
            datasource.setDbType(this.env.getProperty(prestr + ".dbtype"));
            return datasource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Bean(name={"datasource_task"})
    @Qualifier(value="datasource_task")
    public DataSource onDataSource_task() {
        return this.getDs(this.DbKey);
    }

    @Bean(name={"tasktransactionManager"})
    public DataSourceTransactionManager transactionManager_task(@Qualifier(value="datasource_task") DataSource datasource_task) throws Exception {
        return new DataSourceTransactionManager(datasource_task);
    }

    @Bean(name={"sqlSessionFactory_task"})
    @Qualifier(value="sqlSessionFactory_task")
    public SqlSessionFactoryBean onSqlSessionFactoryBean_task(@Qualifier(value="datasource_task") DataSource datasource_task) throws IOException {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        String dbtype = ((DruidDataSource)datasource_task).getDbType();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-" + dbtype + "-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource_task);
        return service;
    }

    @Bean(name={"StorageOperation_task"})
    @Qualifier(value="StorageOperation_task")
    public FMybatisTemplate onFMybatisTemplate_task(@Qualifier(value="sqlSessionFactory_task") SqlSessionFactory sqlSessionFactory_task) {
        return new FMybatisTemplate(sqlSessionFactory_task, ExecutorType.BATCH);
    }
}

