/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.calendar.pojo;

import com.efuture.ocp.common.calendar.pojo.CalendaristDate;
import com.efuture.ocp.common.calendar.utils.CalendaristUtils;

public class LunarDate
extends CalendaristDate {
    private int leapMonth;
    private boolean itsLeapMonth;

    public LunarDate() {
    }

    public LunarDate(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0);
    }

    public LunarDate(int year, int month, int day, int hour, int minute, int second, int millis) {
        this(year, month, day, hour, minute, second, millis, false);
    }

    public LunarDate(int year, int month, int day, int hour, int minute, int second, int millis, boolean itsLeapMonth) {
        super(year, month, day, hour, minute, second, millis);
        this.leapMonth = CalendaristUtils.leapMonth(year);
        this.itsLeapMonth = itsLeapMonth && this.leapMonth != 0 && this.leapMonth == month;
    }

    public int getLeapMonth() {
        return this.leapMonth;
    }

    public void setLeapMonth(int leapMonth) {
        this.leapMonth = leapMonth;
    }

    public boolean isItsLeapMonth() {
        return this.itsLeapMonth;
    }

    public void setItsLeapMonth(boolean itsLeapMonth) {
        this.itsLeapMonth = itsLeapMonth;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LunarDate{");
        sb.append("year=").append(this.year);
        sb.append(", month=").append(this.month);
        sb.append(", day=").append(this.day);
        sb.append(", hour=").append(this.hour);
        sb.append(", minute=").append(this.minute);
        sb.append(", second=").append(this.second);
        sb.append(", millis=").append(this.millis);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", itsLeapMonth=").append(this.itsLeapMonth);
        sb.append(", leapMonth=").append(this.leapMonth);
        sb.append('}');
        return sb.toString();
    }
}

