/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.efuture.ocp.common.autorollback.AutoRollBackService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.sysparam.PropertiesCommon;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.RestClientFactory;
import com.efuture.ocp.common.util.RestClientOverWrite;
import com.efuture.ocp.common.util.RestInfoGet;
import com.efuture.ocp.common.util.RestInfoGetFromIniFile;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class RestClientUtils {
    public ObjectPool<Client> pool;
    private String cfgFile;
    private static final String BASE_SERVICE = "RestUtils";
    private Map<String, Object> clientProperties;
    protected EnterpriseConfigBean ent;
    public Logger logger = Logger.getLogger(RestClientUtils.class);
    public RestInfoGet restinfoget;
    public String restinfogetobj = "restinfogetfromenv";
    private int poolSize;
    private long maxWait;
    private String config;
    Map<String, String> methodSvc;

    public EnterpriseConfigBean getEnt() {
        return this.ent;
    }

    public void setEnt(EnterpriseConfigBean ent) {
        this.ent = ent;
    }

    public String[] getCompressMethods() {
        String str = this.queryServiceURI("compress");
        String[] compressMethods = null;
        if (!StringUtils.isEmpty((Object)str)) {
            compressMethods = str.split("\\|");
        }
        return compressMethods;
    }

    public String getRestinfogetobj() {
        return this.restinfogetobj;
    }

    public void setRestinfogetobj(String restinfogetobj) {
        this.restinfogetobj = restinfogetobj;
    }

    public String getCfgFile() {
        return this.cfgFile;
    }

    public void setCfgFile(String cfgFile) {
        this.cfgFile = cfgFile;
    }

    public RestClientUtils() {
        this(null);
    }

    public RestClientUtils(String config) {
        this(0, 0L, config);
    }

    public RestClientUtils(int poolSize, long maxWait, String config) {
        this.poolSize = poolSize;
        this.maxWait = maxWait;
        this.config = config;
    }

    public void init() {
        GenericObjectPoolConfig poolcfg = new GenericObjectPoolConfig();
        if (this.poolSize > 0) {
            poolcfg.setMaxTotal(this.poolSize);
            poolcfg.setMaxIdle(this.poolSize);
            poolcfg.setMinIdle(this.poolSize >= 2 ? this.poolSize / 2 : this.poolSize);
        }
        if (this.maxWait > 0L) {
            poolcfg.setMaxWaitMillis(this.maxWait);
        }
        this.pool = new GenericObjectPool((PooledObjectFactory)new RestClientFactory(this.clientProperties), poolcfg);
        if (this.config != null && this.config.startsWith("OBJ:")) {
            this.restinfogetobj = this.config.substring(4);
        } else {
            this.cfgFile = this.config;
            if (this.config != null && !"".equals(this.config)) {
                this.restinfogetobj = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void initConfig() {
        if (this.restinfoget != null) {
            return;
        }
        if (!StringUtils.isEmpty((Object)this.restinfogetobj)) {
            if (!SpringBeanFactory.containsBean(this.restinfogetobj)) throw new ServiceException("50000", "\u83b7\u53d6\u5bf9\u8c61[{0}]\u9519\u8bef!", this.restinfogetobj);
            this.restinfoget = SpringBeanFactory.getBean(this.restinfogetobj, RestInfoGet.class);
        } else {
            this.restinfoget = !StringUtils.isEmpty((Object)this.cfgFile) && !"globpara".equalsIgnoreCase(this.cfgFile) ? (SpringBeanFactory.containsBean("restinfogetfrominifile") ? SpringBeanFactory.getBean("restinfogetfrominifile", RestInfoGet.class) : new RestInfoGetFromIniFile()) : (!StringUtils.isEmpty((Object)this.cfgFile) && "globpara".equalsIgnoreCase(this.cfgFile) ? (SpringBeanFactory.containsBean("restinfogetfromglobpara") ? SpringBeanFactory.getBean("restinfogetfromglobpara", RestInfoGet.class) : new RestInfoGetFromIniFile()) : (SpringBeanFactory.containsBean("restinfogetfrominifile") ? SpringBeanFactory.getBean("restinfogetfrominifile", RestInfoGet.class) : new RestInfoGetFromIniFile()));
        }
        this.restinfoget.init(this.cfgFile);
        this.initMethodSvc();
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProp) {
        this.clientProperties = clientProp;
    }

    public String queryServiceURI(long ent_id, String method) {
        if (this.restinfoget == null) {
            this.initConfig();
        }
        return this.restinfoget.queryServiceURI(ent_id, method);
    }

    public String queryServiceURI(String method) {
        if (this.restinfoget == null) {
            this.initConfig();
        }
        return this.restinfoget.queryServiceURI(method);
    }

    public String queryServiceURIbymkt(String method, String mktid) throws Exception {
        if (this.restinfoget == null) {
            this.initConfig();
        }
        return this.restinfoget.queryServiceURIbymkt(method, mktid);
    }

    public Object sendRequest(Object session, String method, Object param, requestCallback callback) throws Exception {
        return this.sendRequest(session, method, param, callback, null);
    }

    private void initClientProperties(Client client) {
    }

    public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("method", method);
        map.put("url", url);
        map.put("param", param);
        if (method.toLowerCase().startsWith("http")) {
            return map;
        }
        String OverWriteObj = method + ".overwrite";
        if (SpringBeanFactory.containsBean(OverWriteObj)) {
            RestClientOverWrite row = SpringBeanFactory.getBean(OverWriteObj, RestClientOverWrite.class);
            if (row.isCanUse()) {
                map = row.doOverWrite(session, method, url, param);
            }
            return map;
        }
        return map;
    }

    private String replaceUrl(ServiceSession ss, String url) {
        if (ss != null) {
            if (url.indexOf("{ent_id}") > 0) {
                url = url.replace("{ent_id}", String.valueOf(ss.getEnt_id()));
            }
            if (url.indexOf("{user_id}") > 0) {
                url = url.replace("{user_id}", String.valueOf(ss.getUser_id()));
            }
            if (url.indexOf("{user_code}") > 0) {
                url = url.replace("{user_code}", ss.getUser_code());
            }
            if (url.indexOf("{user_name}") > 0) {
                url = url.replace("{user_name}", ss.getUser_name());
            }
            if (url.indexOf("{locale}") > 0) {
                url = url.replace("{locale}", ss.getLocale());
            }
            if (url.indexOf("{deptcode}") > 0) {
                url = url.replace("{deptcode}", ss.getDeptcode());
            }
            if (url.indexOf("{token}") > 0 & ss.getToken() != null) {
                url = url.replace("{token}", ss.getToken());
            }
            if (url.indexOf("{postid}") > 0 && ss.getPostid() != null) {
                url = url.replace("{postid}", ss.getPostid());
            }
            if (url.indexOf("{shop_code}") > 0 && ss.getMarket() != null) {
                url = url.replace("{shop_code}", ss.getMarket());
            }
            if (!StringUtils.isEmpty((Object)ss.getExtdata())) {
                JSONObject json = JSON.parseObject((String)ss.getExtdata());
                for (String key : json.keySet()) {
                    if (url.indexOf("{" + key + "}") <= 0) continue;
                    url = url.replace("{" + key + "}", json.getString(key));
                }
            }
        }
        if (url.indexOf("{NGINX_INSIDE}") > 0) {
            url = url.replace("{NGINX_INSIDE}", PropertiesCommon.CONFIG.NGINX_INSIDE.getVal("{NGINX_INSIDE}"));
        }
        if (url.indexOf("{NGINX_ENTRY}") > 0) {
            url = url.replace("{NGINX_ENTRY}", PropertiesCommon.CONFIG.NGINX_ENTRY.getVal("{NGINX_ENTRY}"));
        }
        return url;
    }

    public String queryRealRestURI(long ent_id, String method, String mkt) throws Exception {
        String url = this.wildcardQueryServiceURI(ent_id, method, mkt);
        return this.makeProtocolUrl(url, method);
    }

    protected String uniqueQueryServiceURI(long ent_id, String method, String mkt) throws Exception {
        if (StringUtils.isEmpty((Object)mkt)) {
            return this.queryServiceURI(ent_id, method);
        }
        return this.queryServiceURIbymkt(method, mkt);
    }

    protected String wildcardQueryServiceURI(long ent_id, String method, String mkt) throws Exception {
        String servicePath = "";
        Object curservice = method;
        while (!StringUtils.isEmpty((Object)curservice)) {
            int n;
            String url = this.uniqueQueryServiceURI(ent_id, (String)curservice, mkt);
            if (url != null && !url.equals("")) {
                servicePath = url;
                break;
            }
            if (((String)curservice).equals("*")) break;
            if (((String)curservice).endsWith(".*")) {
                curservice = ((String)curservice).substring(0, ((String)curservice).lastIndexOf("."));
            }
            if ((n = ((String)curservice).lastIndexOf(".")) > 0) {
                curservice = ((String)curservice).substring(0, n) + ".*";
                continue;
            }
            curservice = "*";
        }
        if (servicePath != null) {
            servicePath = servicePath.trim();
        }
        return servicePath;
    }

    protected void initMethodSvc() {
        if (this.methodSvc != null) {
            return;
        }
        this.methodSvc = new HashMap<String, String>(){
            {
                this.put("accnt.", "ocm-accnt-webin");
                this.put("ocm.info.", "ocm-info-webin");
                this.put("mdm.", "ocm-mdm-webin");
                this.put("custgrp.", "ocm-custgrp-webin");
                this.put("tags.", "ocm-tags-webin");
                this.put("ocm.work.", "ocm-work-webin");
                this.put("omp.event.", "omp-event-webin");
                this.put("omp.model.", "omp-model-webin");
                this.put("activity.", "omp-activity-webin");
                this.put("omp.coupon.", "omp-coupon-webin");
                this.put("omp.work.", "omp-work-webin");
            }
        };
        String svckey = EnviromentUtil.getProperty("efuture.rest.method.service");
        if (!StringUtils.isEmpty((Object)svckey)) {
            String[] s;
            for (String key : s = svckey.split(",")) {
                String[] ss = key.split("\\|");
                if (ss == null || ss.length < 2) continue;
                this.methodSvc.put(ss[0], ss[1]);
            }
        }
    }

    protected String makeServiceByMethod(String method) {
        if (method.indexOf("ocm.info.paypwd") >= 0) {
            return "ocm-paypwd-webin";
        }
        if (this.methodSvc != null) {
            for (String key : this.methodSvc.keySet()) {
                if (method.indexOf(key) < 0) continue;
                return this.methodSvc.get(key);
            }
        }
        return "method_no_service";
    }

    public String makeProtocolUrl(String url, String method) {
        int p1;
        int p2;
        String prex = "nacos://";
        if (StringUtils.isEmpty((Object)url) || prex.equalsIgnoreCase((String)url)) {
            url = "nacos://{SERVICE}/rest?method=" + method + "&ent_id={ent_id}";
        }
        if (((String)url).startsWith(prex)) {
            int p = ((String)url).indexOf("/", prex.length());
            String svc = ((String)url).substring(prex.length(), p);
            String service = null;
            if (StringUtils.isEmpty((Object)svc) || "{SERVICE}".equalsIgnoreCase(svc)) {
                service = this.makeServiceByMethod(method);
            } else if (svc.indexOf("|") > 0) {
                service = svc.split("\\|")[0];
                svc = null;
            } else {
                service = svc;
            }
            try {
                Object ip = null;
                if (!PropertiesCommon.CONFIG.NGINX_FORCE.getVal(Boolean.class, false).booleanValue()) {
                    Class<?> driverImplClass = Class.forName("com.efuture.starter.nacos.NacosDiscovery");
                    Object objinst = driverImplClass.newInstance();
                    Class<?> cl = objinst.getClass();
                    Method classmethod = cl.getMethod("selectOneHealthyInstance", String.class);
                    ip = (String)classmethod.invoke(objinst, service);
                }
                url = !StringUtils.isEmpty(ip) ? (String)(StringUtils.isEmpty((Object)svc) ? ip : ip + "/" + service) + ((String)url).substring(p) : "http://{NGINX_INSIDE}/" + service + ((String)url).substring(p);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                url = "nacos_no_srv://" + service + ((String)url).substring(p);
            }
        }
        if (((String)url).indexOf(prex = "{SERVICE}") > 0) {
            String service = this.makeServiceByMethod(method);
            url = ((String)url).replace(prex, service);
        }
        if (((String)url).indexOf(prex = "{NGINX_INSIDE}") > 0) {
            url = ((String)url).replace(prex, PropertiesCommon.CONFIG.NGINX_INSIDE.getVal(prex));
        }
        if (((String)url).indexOf(prex = "{NGINX_ENTRY}") > 0) {
            url = ((String)url).replace(prex, PropertiesCommon.CONFIG.NGINX_ENTRY.getVal(prex));
        }
        if (((String)url).indexOf(prex = "{CLUSTE_INSIDE}") > 0 && (p2 = ((String)url).indexOf("/", p1 = ((String)url).indexOf("/", ((String)url).indexOf(prex)) + 1)) > p1) {
            url = ((String)url).replace(prex, ((String)url).substring(p1, p2));
        }
        if (((String)url).indexOf("{METHOD}") > 0) {
            url = ((String)url).replace("{METHOD}", method);
        }
        return url;
    }

    /*
     * Loose catch block
     */
    public Object sendRequest(Object session, String method, Object param, requestCallback callback, String traceprex) throws Exception {
        Object map;
        long start_time;
        String url;
        Client client;
        block30: {
            client = null;
            url = null;
            start_time = 0L;
            ServiceSession ss = null;
            if (session != null && session instanceof ServiceSession) {
                ss = (ServiceSession)session;
            } else if (session != null && session instanceof Long) {
                ss = new ServiceSession();
                ss.setEnt_id((Long)session);
            } else if (session != null && session instanceof Integer) {
                ss = new ServiceSession();
                ss.setEnt_id(((Integer)session).intValue());
            }
            if (method.toLowerCase().startsWith("http")) {
                url = method;
            } else if (method.toLowerCase().startsWith("nacos://")) {
                url = this.makeProtocolUrl(method, "");
            } else {
                url = this.queryRealRestURI(ss.getEnt_id(), method, null);
                if (StringUtils.isEmpty((Object)url)) {
                    throw new Exception("can't find method service url:" + method);
                }
            }
            if (!method.toLowerCase().startsWith("http")) {
                map = this.doOverWrite(session, method, url, param);
                method = map.get("method").toString();
                url = map.get("url").toString();
                param = map.get("param");
            }
            url = this.replaceUrl(ss, url);
            if (!traceprex.equals("notrace")) {
                url = this.addlogkey(url, traceprex);
            }
            if (ServiceVersion.getInstance().isLogstatus()) {
                start_time = System.currentTimeMillis();
            }
            url = Utils.getEnvValue(url);
            client = (Client)this.pool.borrowObject();
            this.initClientProperties(client);
            this.addNeedRollbackOperation(ss, method, url, param);
            ServiceLogs.logCallStart(url, method, param.toString());
            map = this.onSend(callback, method, url, client, param);
            if (client == null) break block30;
            try {
                this.pool.returnObject((Object)client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logCallSuccess(url, method, start_time);
        }
        return map;
        catch (Exception ex) {
            block31: {
                Object object;
                block32: {
                    try {
                        ex.printStackTrace();
                        Throwable e = ex;
                        if (ex instanceof ProcessingException || ex instanceof WebApplicationException) {
                            e = ex.getCause();
                        }
                        ServiceLogs.logCallError(url, method, "99", ex.getMessage(), start_time);
                        if (e == null || !(e instanceof SocketException) || !"Connection reset".equalsIgnoreCase(e.getMessage())) break block31;
                        if (client != null) {
                            this.pool.invalidateObject(client);
                        }
                        client = (Client)this.pool.borrowObject();
                        this.initClientProperties(client);
                        object = this.onSend(callback, method, url, client, param);
                        if (client == null) break block32;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                this.pool.returnObject(client);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (ServiceVersion.getInstance().isLogstatus()) {
                            ServiceLogs.logCallSuccess(url, method, start_time);
                        }
                        throw throwable;
                    }
                    try {
                        this.pool.returnObject((Object)client);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ServiceVersion.getInstance().isLogstatus()) {
                    ServiceLogs.logCallSuccess(url, method, start_time);
                }
                return object;
            }
            throw ex;
        }
    }

    private String addlogkey(String url, String traceprex) {
        if (traceprex != null && "notrace".equalsIgnoreCase(traceprex)) {
            return url;
        }
        ServiceSession session = ServiceRestReflect.getLocale().get();
        if (session != null) {
            if (session.getRootkey() != null) {
                url = (String)url + "&rootkey=" + session.getRootkey();
            }
            if (session.getLogkey() != null) {
                url = (String)url + "&parentkey=" + session.getLogkey();
            }
        }
        return url;
    }

    private void addNeedRollbackOperation(ServiceSession ss, String method, String url, Object param) {
        if (AutoRollBackService.IsEnable()) {
            AutoRollBackService.addRestOperation(ss, url, method, param);
        }
    }

    /*
     * Loose catch block
     */
    public Object sendRequestbymkt(Object session, String method, String mktid, Object param, requestCallback callback, String traceprex) throws Exception {
        Object map;
        long borro_time;
        long start_time;
        String url;
        Client client;
        block30: {
            client = null;
            url = null;
            start_time = 0L;
            borro_time = 0L;
            ServiceSession ss = null;
            if (session != null && session instanceof ServiceSession) {
                ss = (ServiceSession)session;
            } else if (session != null && session instanceof Long) {
                ss = new ServiceSession();
                ss.setEnt_id((Long)session);
            } else if (session != null && session instanceof Integer) {
                ss = new ServiceSession();
                ss.setEnt_id(((Integer)session).intValue());
            }
            if (method.toLowerCase().startsWith("http")) {
                url = method;
            } else if (method.toLowerCase().startsWith("nacos://")) {
                url = this.makeProtocolUrl(method, "");
            } else {
                url = this.queryRealRestURI(0L, method, mktid);
                if (StringUtils.isEmpty((Object)url)) {
                    throw new Exception("can't find method service url");
                }
            }
            if (!method.toLowerCase().startsWith("http")) {
                map = this.doOverWrite(session, method, url, param);
                method = map.get("method").toString();
                url = map.get("url").toString();
                param = map.get("param");
            }
            url = this.replaceUrl(ss, url);
            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                start_time = System.currentTimeMillis();
            }
            url = Utils.getEnvValue(url);
            client = (Client)this.pool.borrowObject();
            this.initClientProperties(client);
            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                borro_time = System.currentTimeMillis();
            }
            map = this.onSend(callback, method, url, client, param);
            if (client == null) break block30;
            try {
                this.pool.returnObject((Object)client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
            StringBuffer sb = new StringBuffer();
            sb.append("[" + traceprex + "]: ");
            sb.append(method + " , ");
            sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
            sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
            sb.append("REQUEST: " + param);
            this.logger.info((Object)sb.toString());
        }
        return map;
        catch (Exception ex) {
            block31: {
                Object object;
                block32: {
                    try {
                        Throwable e = ex;
                        if (ex instanceof ProcessingException || ex instanceof WebApplicationException) {
                            e = ex.getCause();
                        }
                        if (e == null || !(e instanceof SocketException) || !"Connection reset".equalsIgnoreCase(e.getMessage())) break block31;
                        StringBuffer sb = new StringBuffer();
                        sb.append("[" + ex.getMessage() + "]: ");
                        sb.append(method + " , ");
                        sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                        sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                        this.logger.info((Object)sb.toString());
                        if (client != null) {
                            this.pool.invalidateObject((Object)client);
                        }
                        client = (Client)this.pool.borrowObject();
                        this.initClientProperties(client);
                        object = this.onSend(callback, method, url, client, param);
                        if (client == null) break block32;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                this.pool.returnObject(client);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                            StringBuffer sb2 = new StringBuffer();
                            sb2.append("[" + traceprex + "]: ");
                            sb2.append(method + " , ");
                            sb2.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                            sb2.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                            sb2.append("REQUEST: " + param);
                            this.logger.info((Object)sb2.toString());
                        }
                        throw throwable;
                    }
                    try {
                        this.pool.returnObject((Object)client);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                    StringBuffer sb3 = new StringBuffer();
                    sb3.append("[" + traceprex + "]: ");
                    sb3.append(method + " , ");
                    sb3.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                    sb3.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                    sb3.append("REQUEST: " + param);
                    this.logger.info((Object)sb3.toString());
                }
                return object;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object onSend(requestCallback call, String method, String url, Client client, Object param) throws Exception {
        boolean compress = false;
        String[] compressMethods = this.getCompressMethods();
        if (compressMethods != null && call instanceof defaultRequestCallback) {
            compress = compressMethods.length == 1 && "*".equals(compressMethods[0]) ? true : Utils.stringArrayContainsKey(compressMethods, method, true);
        }
        if (compress) {
            ByteArrayOutputStream originalContent = new ByteArrayOutputStream();
            originalContent.write(param.toString().getBytes("UTF-8"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
            originalContent.writeTo(gzipOut);
            gzipOut.finish();
            param = baos.toByteArray();
        }
        Object resp = call.onSend(url, client, param);
        if (compress) {
            ByteArrayInputStream stream = new ByteArrayInputStream((byte[])resp);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            GZIPInputStream gzip = null;
            try {
                int n = 0;
                gzip = new GZIPInputStream(stream);
                while ((n = gzip.read(b)) >= 0) {
                    out.write(b, 0, n);
                }
            }
            finally {
                if (gzip != null) {
                    try {
                        gzip.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            resp = out.toString("UTF-8");
        }
        return resp;
    }

    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception {
        return this.sendRequest(session, method, param, "");
    }

    public ServiceResponse sendRequestbymkt(Object session, String method, String mktid, Object param) throws Exception {
        return this.sendRequestbymkt(session, method, mktid, param, "");
    }

    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param, new defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = JSON.parseObject((String)((String)result));
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
            if (response.getData() instanceof com.alibaba.fastjson2.JSONObject) {
                response.setData(json.getJSONObject("data"));
            } else if (response.getData() instanceof JSONArray) {
                response.setData(json.getJSONArray("data"));
            }
        }
        if (response == null) {
            throw new ServiceException("50000", (String)result, new Object[0]);
        }
        if (!"0".equals(response.getReturncode())) {
            throw new ServiceException(response.getReturncode(), (String)(StringUtils.isEmpty((Object)response.getData()) ? "returncode: " + response.getReturncode() : response.getData().toString()), new Object[0]);
        }
        return response;
    }

    public ServiceResponse sendRequestbymkt(Object session, String method, String mktid, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequestbymkt(session, method, mktid, param, new defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = JSON.parseObject((String)((String)result));
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
            if (response.getData() instanceof com.alibaba.fastjson2.JSONObject) {
                response.setData(json.getJSONObject("data"));
            } else if (response.getData() instanceof JSONArray) {
                response.setData(json.getJSONArray("data"));
            }
        }
        if (response == null) {
            throw new RuntimeException((String)result);
        }
        if (!"0".equals(response.getReturncode())) {
            throw new RuntimeException((String)(StringUtils.isEmpty((Object)response.getData()) ? "returncode: " + response.getReturncode() : response.getData().toString()));
        }
        return response;
    }

    public ServiceResponse sendRequest(ServiceSession session, String baseUrl, JSONObject param, String dataNode) throws Exception {
        return null;
    }

    public static RestClientUtils getRestUtils() {
        RestClientUtils utils = SpringBeanFactory.getBean(BASE_SERVICE, RestClientUtils.class);
        return utils;
    }

    public static RestClientUtils getRestUtils(String obj) {
        return SpringBeanFactory.getBean(obj, RestClientUtils.class);
    }

    public static RestClientUtils getRestUtils(EnterpriseConfigBean ent) {
        return RestClientUtils.getRestUtils(BASE_SERVICE, ent);
    }

    public static RestClientUtils getRestUtils(String obj, EnterpriseConfigBean ent) {
        RestClientUtils restObj = SpringBeanFactory.getBean(obj, RestClientUtils.class);
        restObj.setEnt(ent);
        return restObj;
    }

    public static interface requestCallback {
        public Object onSend(String var1, Client var2, Object var3) throws Exception;
    }

    public class defaultRequestCallback
    implements requestCallback {
        @Override
        public Object onSend(String url, Client client, Object param) throws Exception {
            WebTarget taget = client.target(url);
            Response resp = null;
            Invocation.Builder invocationBuilder = taget.request();
            if (param instanceof byte[]) {
                invocationBuilder.header("Content-Encoding", (Object)"gzip");
                resp = invocationBuilder.post(Entity.entity((Object)param, (String)"application/octet-stream"));
            } else {
                resp = param instanceof JSON ? invocationBuilder.post(Entity.entity((Object)param, (String)"application/json")) : invocationBuilder.post(Entity.entity((Object)param, (MediaType)MediaType.TEXT_PLAIN_TYPE));
            }
            String entity = (String)resp.readEntity(String.class);
            return entity;
        }
    }
}

