/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.biz.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.biz.entity.CategoryRefBean;
import com.efuture.ocp.biz.entity.GoodsMframeBean;
import com.efuture.ocp.biz.entity.OrganizationBean;
import com.efuture.ocp.biz.utils.MdmUtilService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class MdmUtils {
    public static String getLocalServerName(String serverName) {
        String[] keys = serverName.split("[.]");
        String localservername = "";
        int i = 0;
        for (String s : keys) {
            if (i < keys.length - 2) {
                localservername = localservername.concat(s).concat(".");
            }
            ++i;
        }
        return localservername.substring(0, localservername.length() - 1);
    }

    public static JSONArray getRemote(ServiceSession session, JSONObject json, String remote, String tablename) throws Exception {
        String localservername = MdmUtils.getLocalServerName("local." + remote);
        if (SpringBeanFactory.containsBean((String)localservername)) {
            MdmUtilService srv = (MdmUtilService)SpringBeanFactory.getBean((String)localservername, MdmUtilService.class);
            return srv.getRemote(session, json, remote, tablename);
        }
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest((Object)session, remote, (Object)json.toJSONString());
        if ("0".equalsIgnoreCase(resp.getReturncode())) {
            JSONObject retData = (JSONObject)resp.getData();
            JSONArray array = new JSONArray();
            if (retData != null && retData.containsKey((Object)tablename)) {
                array = retData.getJSONArray(tablename);
            }
            return array;
        }
        throw new ServiceException(resp.getReturncode(), resp.getData().toString(), new Object[0]);
    }

    public static OrganizationBean getOrg(ServiceSession session, String code) throws Exception {
        JSONArray result = MdmUtils.getRemote(session, DataUtils.newJSONObject((String)"code", (Object)code), "ocm.mdm.org.search", "organization");
        if (result == null || result.size() <= 0) {
            return null;
        }
        return (OrganizationBean)((Object)JSONObject.toJavaObject((JSON)result.getJSONObject(0), OrganizationBean.class));
    }

    public static List<OrganizationBean> getMarketList(ServiceSession session) throws Exception {
        JSONObject para = DataUtils.newJSONObject((String)"ent_id", (Object)session.getEnt_id());
        para.put("page_size", (Object)9999);
        JSONArray result = MdmUtils.getRemote(session, para, "ocm.mdm.org.search", "organization");
        if (result == null || result.size() <= 0) {
            return null;
        }
        ArrayList<OrganizationBean> list = new ArrayList<OrganizationBean>();
        for (int i = 0; i < result.size(); ++i) {
            list.add((OrganizationBean)((Object)JSONObject.toJavaObject((JSON)result.getJSONObject(i), OrganizationBean.class)));
        }
        return list;
    }

    public static List<GoodsMframeBean> getGoodsMframeByAll(ServiceSession session, String org_code, String itemList) throws Exception {
        JSONObject para = DataUtils.newJSONObject((String)"ent_id", (Object)session.getEnt_id());
        para.put("item_code", (Object)itemList);
        para.put("org_code", (Object)org_code);
        para.put("page_size", (Object)9999);
        para.put("isbatch", (Object)"Y");
        JSONArray result = MdmUtils.getRemote(session, para, "ocm.mdm.goods.searchbyall", "item_business");
        if (result == null || result.size() <= 0) {
            return null;
        }
        ArrayList<GoodsMframeBean> list = new ArrayList<GoodsMframeBean>();
        for (int i = 0; i < result.size(); ++i) {
            list.add((GoodsMframeBean)((Object)JSONObject.toJavaObject((JSON)result.getJSONObject(i), GoodsMframeBean.class)));
        }
        return list;
    }

    public static List<GoodsMframeBean> getGoodsMframeByAll(ServiceSession session, String org_code, String itemList, boolean ibbarcode) throws Exception {
        if (ibbarcode) {
            JSONObject para = DataUtils.newJSONObject((String)"ent_id", (Object)session.getEnt_id());
            para.put("barcode", (Object)itemList);
            para.put("org_code", (Object)org_code);
            para.put("page_size", (Object)9999);
            para.put("isbatch", (Object)"Y");
            JSONArray result = MdmUtils.getRemote(session, para, "ocm.mdm.goods.searchbyall", "item_business");
            if (result == null || result.size() <= 0) {
                return null;
            }
            ArrayList<GoodsMframeBean> list = new ArrayList<GoodsMframeBean>();
            for (int i = 0; i < result.size(); ++i) {
                list.add((GoodsMframeBean)((Object)JSONObject.toJavaObject((JSON)result.getJSONObject(i), GoodsMframeBean.class)));
            }
            return list;
        }
        return MdmUtils.getGoodsMframeByAll(session, org_code, itemList);
    }

    public static List<GoodsMframeBean> getGoodsMframeByBatch(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject jsonobj = (JSONObject)jsonparam.clone();
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"isbarcode"))) {
            String code = MapUtils.getString((Map)jsonparam, (String)"item_code", (String)"");
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"barcode"))) {
                code = StringUtils.isEmpty((Object)code) ? MapUtils.getString((Map)jsonparam, (String)"barcode", (String)"") : code.concat(",").concat(MapUtils.getString((Map)jsonparam, (String)"barcode", (String)""));
            }
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"code"))) {
                code = StringUtils.isEmpty((Object)code) ? MapUtils.getString((Map)jsonparam, (String)"code", (String)"") : code.concat(",").concat(MapUtils.getString((Map)jsonparam, (String)"code", (String)""));
            }
            jsonobj.remove((Object)"item_code");
            jsonobj.remove((Object)"barcode");
            jsonobj.put("code", (Object)code);
            jsonobj.put("isbatch", (Object)"Y");
            jsonobj.put("page_size", (Object)9999);
            jsonobj.put("ent_id", (Object)session.getEnt_id());
        } else {
            boolean ibbarcode = MapUtils.getString((Map)jsonparam, (String)"isbarcode", (String)"").equals("Y");
            if (ibbarcode) {
                jsonobj.remove((Object)"isbarcode");
                jsonobj.remove((Object)"item_code");
                jsonobj.remove((Object)"code");
                jsonobj.put("isbatch", (Object)"Y");
                jsonobj.put("page_size", (Object)9999);
                jsonobj.put("ent_id", (Object)session.getEnt_id());
            } else {
                jsonobj.remove((Object)"isbarcode");
                jsonobj.remove((Object)"barcode");
                jsonobj.remove((Object)"code");
                jsonobj.put("isbatch", (Object)"Y");
                jsonobj.put("page_size", (Object)9999);
                jsonobj.put("ent_id", (Object)session.getEnt_id());
            }
        }
        JSONArray result = MdmUtils.getRemote(session, jsonobj, "ocm.mdm.goods.searchbyall", "item_business");
        if (result == null || result.size() <= 0) {
            return null;
        }
        ArrayList<GoodsMframeBean> list = new ArrayList<GoodsMframeBean>();
        for (int i = 0; i < result.size(); ++i) {
            list.add((GoodsMframeBean)((Object)JSONObject.toJavaObject((JSON)result.getJSONObject(i), GoodsMframeBean.class)));
        }
        return list;
    }

    public static List<GoodsMframeBean> searchGoodsMframeByAll(ServiceSession session, String org_code, List<String> itemList, boolean ibbarcode) throws Exception {
        ArrayList<String> mktlist = new ArrayList<String>();
        ArrayList<JSONObject> goodslist = new ArrayList<JSONObject>();
        mktlist.add(org_code);
        for (int i = 0; i < itemList.size(); ++i) {
            JSONObject goods = new JSONObject();
            goods.put("rowno", (Object)(i + 1));
            goods.put("org_code", (Object)org_code);
            goods.put("bybarcode", (Object)(ibbarcode ? "Y" : "N"));
            goods.put("item_code", (Object)itemList.get(i));
            goodslist.add(goods);
        }
        JSONObject jsonpara = new JSONObject();
        jsonpara.put("mktlist", mktlist);
        jsonpara.put("goodslist", goodslist);
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest((Object)session, "ocm.mdm.goods.searchbyall", (Object)jsonpara.toJSONString());
        if ("0".equalsIgnoreCase(resp.getReturncode())) {
            JSONObject retData = (JSONObject)resp.getData();
            ArrayList<GoodsMframeBean> list = new ArrayList<GoodsMframeBean>();
            if (retData != null) {
                for (String key : retData.keySet()) {
                    list.add((GoodsMframeBean)((Object)JSONObject.toJavaObject((JSON)retData.getJSONObject(key), GoodsMframeBean.class)));
                }
            }
            return list;
        }
        throw new ServiceException(resp.getReturncode(), resp.getData().toString(), new Object[0]);
    }

    public static List<CategoryRefBean> getCatetoryRefByLeaf(ServiceSession session, String leafList) throws Exception {
        JSONObject para = DataUtils.newJSONObject((String)"leaf", (Object)leafList);
        para.put("page_size", (Object)9999);
        JSONArray result = MdmUtils.getRemote(session, para, "ocm.mdm.manacat.searchbyleaf", "categoryref");
        if (result == null || result.size() <= 0) {
            return null;
        }
        ArrayList<CategoryRefBean> list = new ArrayList<CategoryRefBean>();
        for (int i = 0; i < result.size(); ++i) {
            list.add((CategoryRefBean)JSONObject.toJavaObject((JSON)result.getJSONObject(i), CategoryRefBean.class));
        }
        return list;
    }

    static interface REST {
        public static final String GOODS_SEARCH = "ocm.mdm.goods.search";
        public static final String GOODS_BYORG = "ocm.mdm.goods.searchbyorg";
        public static final String GOODS_BYALL = "ocm.mdm.goods.searchbyall";
        public static final String MANACAT = "ocm.mdm.manacat.search";
        public static final String MANACAT_BYLEAF = "ocm.mdm.manacat.searchbyleaf";
        public static final String BRAND = "ocm.mdm.brand.search";
        public static final String ORG = "ocm.mdm.org.search";
        public static final String CHANNEL = "ocm.mdm.channel.search";
    }
}

