/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.VirtualFieldServiceImpl;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.ExcelUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.ibatis.session.RowBounds;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.StringUtils;

public class FileServiceImpl
extends BasicComponent {
    private static int rowMaxCount = 60000;
    private static int dbRowMaxCount = 20000;
    private SXSSFWorkbook xlsx = null;
    private HSSFWorkbook xls = null;
    final String ResouceBean = "amp.resource";
    private static final String STATIC_XLS = "XLS";
    private static final String STATIC_XLSX = "XLSX";
    private static final String STATIC_LEFT = "left";
    private static final String STATIC_CENTER = "center";
    private static final String STATIC_RIGHT = "right";
    private String head = "";
    private List<CellStyle> stylelist = new ArrayList<CellStyle>();
    private Map<String, Integer> fldstyle = new HashMap<String, Integer>();
    private int rowIndex = 0;
    private int cellIndex = 0;
    private int ROW_MAX = 20000;
    private int COLUMN_MAX = 106;
    private double defaultWidth = 0.67;
    private int defaultHigh = 25;
    private double defaultRangCell = 0.3;
    private double defaulttextCell = 0.1;
    private int defaultGreadCell = 0;

    public void setHead(String temp) {
        this.head = temp;
    }

    public String getFilePath() {
        return this.head;
    }

    private void exportDataToExcel(List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype) {
        Cell cell;
        SXSSFSheet sheet = null;
        CellStyle columnHeadStyle = null;
        CellStyle cellString = null;
        Font f = null;
        if (fldlst == null) {
            fldlst = new ArrayList<String>();
        }
        if (disps == null) {
            disps = new HashMap<String, String>();
        }
        if (fmts == null) {
            fmts = new HashMap<String, String>();
        }
        if (STATIC_XLSX.equals(exceltype)) {
            columnHeadStyle = this.xlsx.createCellStyle();
            cellString = this.xlsx.createCellStyle();
            f = this.xlsx.createFont();
            sheet = this.xlsx.createSheet("Sheet1");
        } else {
            columnHeadStyle = this.xls.createCellStyle();
            cellString = this.xls.createCellStyle();
            f = this.xls.createFont();
            sheet = this.xls.createSheet("Sheet1");
        }
        columnHeadStyle.setBorderBottom(BorderStyle.THIN);
        columnHeadStyle.setBorderLeft(BorderStyle.THIN);
        columnHeadStyle.setBorderRight(BorderStyle.THIN);
        columnHeadStyle.setBorderTop(BorderStyle.THIN);
        columnHeadStyle.setAlignment(HorizontalAlignment.CENTER);
        columnHeadStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        columnHeadStyle.setWrapText(true);
        f.setFontHeightInPoints((short)9);
        f.setBold(true);
        columnHeadStyle.setFont(f);
        cellString.setBorderBottom(BorderStyle.THIN);
        cellString.setBorderLeft(BorderStyle.THIN);
        cellString.setBorderRight(BorderStyle.THIN);
        cellString.setBorderTop(BorderStyle.THIN);
        columnHeadStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if (STATIC_XLSX.equals(exceltype)) {
            cellString.setDataFormat(this.xlsx.createDataFormat().getFormat("@"));
        } else {
            cellString.setDataFormat(this.xls.createDataFormat().getFormat("@"));
        }
        cellString.setAlignment(HorizontalAlignment.CENTER);
        cellString.setWrapText(true);
        this.stylelist.add(cellString);
        Row row = sheet.createRow(0);
        sheet.createFreezePane(0, 1, 0, 1);
        int i = 0;
        for (String s : fldlst) {
            cell = row.createCell(i);
            cell.setCellStyle(columnHeadStyle);
            cell.setCellValue(disps.get(s));
            sheet.setColumnWidth(i, 7000);
            ++i;
        }
        int rowIndex = 1;
        if (list != null) {
            for (int j = 0; j < list.size(); ++j) {
                row = sheet.createRow(rowIndex++);
                Map<String, Object> map = list.get(j);
                int index = 0;
                for (String s : fldlst) {
                    cell = row.createCell(index++);
                    Object obj = map.get(s);
                    String style = fmts.get(s);
                    this.setCellsValueTyle(cell, obj, s, style, exceltype);
                }
            }
        }
    }

    protected void setCellsValueTyle(Cell cell, Object obj, String fld, String style, String exceltype) {
        if (obj != null) {
            if (!StringUtils.isEmpty((Object)style)) {
                if (style.startsWith("d") || style.equalsIgnoreCase("time")) {
                    Date date = null;
                    String datestyle = "yyyy-MM-dd";
                    if (obj.toString().length() > 10) {
                        datestyle = "yyyy-MM-dd HH:mm:ss";
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(datestyle);
                    try {
                        date = sdf.parse(obj.toString());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    cell.setCellValue(date);
                    cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
                } else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    cell.setCellValue(Double.parseDouble(obj.toString()));
                    cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
                } else {
                    cell.setCellValue(obj.toString());
                    cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
                }
            } else {
                cell.setCellValue(obj.toString());
                cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
            }
        } else {
            cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
        }
    }

    protected CellStyle getCellStyle(String fld, String style, String exceltype) {
        int cellcul = -1;
        CellStyle cellStyle = null;
        if (this.fldstyle.containsKey(fld)) {
            cellcul = this.fldstyle.get(fld);
        }
        if (cellcul == -1) {
            if (!StringUtils.isEmpty((Object)style)) {
                String excelstyle = "";
                String[] dformat = style.split("=");
                HorizontalAlignment align = HorizontalAlignment.CENTER;
                if (style.startsWith("d") || style.equalsIgnoreCase("time")) {
                    align = HorizontalAlignment.CENTER;
                    excelstyle = "yyyy\u5e74m\u6708d\u65e5";
                } else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    align = HorizontalAlignment.RIGHT;
                    if (style.startsWith("n")) {
                        excelstyle = "0.00";
                    } else if (style.startsWith("c")) {
                        excelstyle = "\u00a5#,##0.00";
                    } else if (style.startsWith("p")) {
                        excelstyle = "0.00%";
                    }
                } else {
                    align = HorizontalAlignment.LEFT;
                    excelstyle = "@";
                }
                if (dformat.length > 1 && !StringUtils.isEmpty((Object)dformat[1])) {
                    excelstyle = dformat[1];
                }
                if (dformat.length > 2 && !StringUtils.isEmpty((Object)dformat[2])) {
                    if (STATIC_LEFT.equals(dformat[2].toLowerCase())) {
                        align = HorizontalAlignment.LEFT;
                    } else if (STATIC_CENTER.equals(dformat[2].toLowerCase())) {
                        align = HorizontalAlignment.CENTER;
                    } else if (STATIC_RIGHT.equals(dformat[2].toLowerCase())) {
                        align = HorizontalAlignment.RIGHT;
                    }
                }
                for (int i = 0; i < this.stylelist.size(); ++i) {
                    CellStyle styletemp = this.stylelist.get(i);
                    if (styletemp.getAlignment() != align) continue;
                    if (STATIC_XLSX.equals(exceltype)) {
                        if (styletemp.getDataFormat() != this.xlsx.createDataFormat().getFormat(excelstyle)) continue;
                        cellcul = i;
                        break;
                    }
                    if (styletemp.getDataFormat() != this.xls.createDataFormat().getFormat(excelstyle)) continue;
                    cellcul = i;
                    break;
                }
                if (cellcul == -1) {
                    if (STATIC_XLSX.equals(exceltype)) {
                        cellStyle = this.xlsx.createCellStyle();
                        cellStyle.setDataFormat(this.xlsx.createDataFormat().getFormat(excelstyle));
                    } else {
                        cellStyle = this.xls.createCellStyle();
                        cellStyle.setDataFormat(this.xls.createDataFormat().getFormat(excelstyle));
                    }
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle.setAlignment(align);
                    this.stylelist.add(cellStyle);
                    cellcul = this.stylelist.size() - 1;
                } else {
                    cellStyle = this.stylelist.get(cellcul);
                }
            } else {
                cellcul = 0;
                cellStyle = this.stylelist.get(cellcul);
            }
            this.fldstyle.put(fld, cellcul);
        } else {
            cellStyle = this.stylelist.get(cellcul);
        }
        return cellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createExcel(List<Map<String, Object>> list, String fileName, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype) throws Exception {
        String filePath = this.getFilePath();
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Object tempExcelFile = "";
        tempExcelFile = STATIC_XLSX.equals(exceltype) ? filePath + fileName + ".xlsx" : filePath + fileName + ".xls";
        int rowMemory = 100;
        FileOutputStream fos = new FileOutputStream((String)tempExcelFile);
        if (STATIC_XLSX.equals(exceltype)) {
            try {
                this.xlsx = new SXSSFWorkbook(rowMemory);
                this.exportDataToExcel(list, fldlst, disps, fmts, STATIC_XLSX);
                this.xlsx.write((OutputStream)fos);
                fos.flush();
                fos.close();
            }
            finally {
                fos.flush();
                fos.close();
                if (list != null) {
                    list.clear();
                }
            }
        }
        try {
            this.xls = new HSSFWorkbook();
            this.exportDataToExcel(list, fldlst, disps, fmts, STATIC_XLS);
            this.xls.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        finally {
            fos.flush();
            fos.close();
            list.clear();
        }
        return tempExcelFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String export(ServiceSession session, JSONObject jsonparam) throws Exception {
        String excel;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        RowBounds rowBounds = new RowBounds(0, rowMaxCount);
        ArrayList<String> filelist = new ArrayList<String>();
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = sdfymdCard.format(new Date());
        String exceltype = null;
        exceltype = StringUtils.isEmpty(map.get("filetype")) ? STATIC_XLSX : ("1".equals(excel = map.get("filetype").toString()) ? STATIC_XLS : STATIC_XLSX);
        if (VirtualFieldServiceImpl.getInstance() != null) {
            VirtualFieldServiceImpl.getInstance().checkExistVirtualField(session, jsonparam);
        }
        boolean flag = true;
        int row = 1;
        List<Map<String, Object>> list_temp = null;
        int pagenum = 1;
        do {
            List<Map<String, Object>> list;
            Object tempfileName;
            block14: {
                block15: {
                    block12: {
                        block13: {
                            tempfileName = fileName;
                            list = null;
                            if (StringUtils.isEmpty((Object)rowBounds.getOffset()) || StringUtils.isEmpty((Object)rowBounds.getLimit())) break block12;
                            if (list_temp == null || list_temp.size() >= dbRowMaxCount || list_temp.size() <= 0) break block13;
                            list = list_temp;
                            flag = false;
                            break block14;
                        }
                        if (list == null) {
                            list = new ArrayList<Map<String, Object>>();
                        }
                        if (list_temp == null || list_temp.size() != dbRowMaxCount) break block15;
                        list.addAll(list_temp);
                        list_temp = null;
                        break block15;
                    }
                    list = this.doQuery(jsonparam.getString("queryid"), map, rowBounds, null);
                    flag = false;
                    break block14;
                }
                int rowBounds_offset = rowBounds.getOffset();
                int rowBounds_limit = rowBounds.getLimit();
                while (true) {
                    rowBounds_limit = dbRowMaxCount;
                    rowBounds = new RowBounds(0, pagenum * rowBounds_limit);
                    PageHelper.startPage((int)pagenum, (int)rowBounds_limit, (boolean)false);
                    ++pagenum;
                    list_temp = this.doQuery(jsonparam.getString("queryid"), map, rowBounds, null);
                    if (list_temp == null || list_temp.size() == 0) {
                        flag = false;
                        break;
                    }
                    if (list.size() + list_temp.size() > rowMaxCount) break;
                    list.addAll(list_temp);
                    if (list_temp.size() < dbRowMaxCount) {
                        flag = false;
                    }
                    list_temp = null;
                }
            }
            if (VirtualFieldServiceImpl.getInstance() != null) {
                list = VirtualFieldServiceImpl.getInstance().handleVirtualField(list);
            }
            if (row != 1) {
                tempfileName = (String)tempfileName + "(" + row + ")";
            }
            ++row;
            String file = this.createExcel(list, (String)tempfileName, fldlst, disps, fmts, exceltype);
            filelist.add(file);
        } while (flag);
        String reFile = "";
        if (filelist.size() <= 1) return (String)filelist.get(0);
        return this.makezip(filelist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total) {
        FMybatisTemplate storage = null;
        List list = null;
        try {
            Map map;
            storage = this.getStorageOperations(FMybatisTemplate.class);
            if (param != null && (map = (Map)param).containsKey("ds")) {
                storage = this.getStorageOperations(map.get("ds").toString(), FMybatisTemplate.class);
            }
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            if (rowBounds == null) {
                List list2 = list = db.selectList(queryid, param);
                return list2;
            }
            list = db.selectList(queryid, param, rowBounds);
            if (total != null) {
                total.append(((Page)list).getTotal());
            }
            List list3 = list;
            return list3;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public String makezip(List<String> filelist) throws IOException {
        String trackkey;
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = trackkey = sdfymdCard.format(new Date());
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < filelist.size(); ++i) {
            File file = new File(filelist.get(i));
            files.add(file);
        }
        String head = this.getFilePath();
        String name = head + filename + ".rar";
        File file = new File(name);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fous = new FileOutputStream(file);
        ZipOutputStream zipOut = new ZipOutputStream(fous);
        this.zipFile(files, zipOut);
        zipOut.close();
        fous.close();
        for (File temp : files) {
            if (!temp.isFile() || !temp.exists()) continue;
            temp.delete();
        }
        return name;
    }

    private void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            this.zipFile(file, outputStream);
        }
    }

    private void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block7: {
            try {
                if (!inputFile.exists()) break block7;
                if (inputFile.isFile()) {
                    int nNumber;
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                    bins.close();
                    IN.close();
                    break block7;
                }
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        this.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String exportTemplate(ServiceSession session, JSONObject jsonparam) throws Exception {
        String excel;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        String billmoduleid = jsonparam.getString("billmoduleid");
        Map<String, String> config = ExcelUtils.getimpconfig(billmoduleid);
        Object filename = config.get("file");
        String head = config.get("head");
        ArrayList<String> fldlst = new ArrayList<String>();
        String[] headfield = head.split(",");
        HashMap<String, String> disps = new HashMap<String, String>();
        int i = 0;
        for (String s : headfield) {
            fldlst.add(String.valueOf(i));
            disps.put(String.valueOf(i), s);
            ++i;
        }
        String exceltype = null;
        exceltype = StringUtils.isEmpty((Object)jsonparam.getString("filetype")) ? STATIC_XLSX : ("1".equals(excel = jsonparam.getString("filetype")) ? STATIC_XLS : STATIC_XLSX);
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        filename = (String)filename + sdfymdCard.format(new Date());
        return this.createExcel(null, (String)filename, fldlst, disps, null, exceltype);
    }

    public String exportTxt(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        String queryid = jsonparam.getString("queryid");
        List<Map<String, Object>> list = this.doQuery(queryid, jsonparam, null, null);
        return this.createTxt(list, jsonparam.getString("filename"), jsonparam.getString("fields"));
    }

    private String createTxt(List<Map<String, Object>> list, String fileName, String fields) throws Exception {
        String filePath = this.getFilePath();
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        StringBuffer sb = new StringBuffer("");
        Object tempTxtFile = "";
        tempTxtFile = fileName + ".txt";
        this.getFileContext(list, fields, sb);
        this.saveAsFileWriterGbk(sb.toString(), (String)tempTxtFile);
        return tempTxtFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsFileWriterGbk(String content, String filename) {
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "GBK"));
            out.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsFileWriterUtf(String content, String filename) {
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            out.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private Object getValue(Object value) {
        return StringUtils.isEmpty((Object)value) ? "" : value;
    }

    private String getFileContext(List<Map<String, Object>> map, String fields, StringBuffer sb) {
        sb.setLength(0);
        String[] list = fields.split(",");
        for (Map<String, Object> temp : map) {
            for (int i = 0; i < list.length; ++i) {
                if (i + 1 == list.length) {
                    sb.append(this.getValue(temp.get(list[i])));
                    continue;
                }
                sb.append(this.getValue(temp.get(list[i]))).append("\t");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public String exportLC(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (jsonparam == null || jsonparam.equals((Object)"")) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (jsonparam.get((Object)"billno") == null || jsonparam.get((Object)"billno").equals("")) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "billno");
        }
        String billno = jsonparam.getString("billno");
        if (jsonparam.get((Object)"files") == null || jsonparam.get((Object)"files").equals("")) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "files");
        }
        JSONArray files = jsonparam.getJSONArray("files");
        ArrayList<String> filelist = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            JSONObject json = files.getJSONObject(i);
            json.put("billno", (Object)billno);
            json.put("ent_id", (Object)session.getEnt_id());
            String tempfilepath = this.exportTxt(session, json);
            filelist.add(tempfilepath);
        }
        return this.makezip(filelist);
    }

    public String exportNC(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (jsonparam == null || jsonparam.equals((Object)"")) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (jsonparam.get((Object)"billno") == null || jsonparam.get((Object)"billno").equals("")) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "billno");
        }
        String billno = jsonparam.getString("billno");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billno", jsonparam.get((Object)"billno"));
        param.put("o_filecontext", "");
        this.doQuery("select_ncdate", param, null, null);
        if ("1".equals(param.get("o_filecontext").toString())) {
            throw new ServiceException("10000", "[{0}]\u51ed\u8bc1\u6570\u636e\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!", jsonparam.get((Object)"billno"));
        }
        HashMap<String, Object> param2 = new HashMap<String, Object>();
        param2.put("billno", jsonparam.get((Object)"billno"));
        List<Map<String, Object>> list = this.doQuery("select_filecontext", param2, null, null);
        Map<String, Object> filecontext = null;
        if (list.size() == 0) {
            throw new ServiceException("10000", "[{0}]\u6ca1\u6709\u51ed\u8bc1\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!", jsonparam.get((Object)"billno"));
        }
        filecontext = list.get(0);
        if (filecontext.get("xmldata") == null || filecontext.get("xmldata").equals("")) {
            throw new ServiceException("10000", "[{0}]\u6ca1\u6709\u51ed\u8bc1\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!", jsonparam.get((Object)"billno"));
        }
        String head = this.getFilePath();
        String filename = head + billno + ".xml";
        this.saveAsFileWriterUtf(filecontext.get("xmldata").toString(), filename);
        return filename;
    }

    private HSSFSheet setSheetPaper(HSSFSheet sheet, String a4, String orientation) {
        sheet.setDisplayGridlines(false);
        if ("a4".equalsIgnoreCase(a4)) {
            this.defaultHigh = 25;
            this.defaultWidth = 4.0;
            sheet.setDefaultColumnWidth((int)((short)this.defaultWidth));
            sheet.setDefaultRowHeightInPoints((float)this.defaultHigh);
            HSSFPrintSetup printSetup = sheet.getPrintSetup();
            printSetup.setPaperSize((short)9);
            if ("\u6a2a\u5411".equalsIgnoreCase(orientation)) {
                printSetup.setLandscape(true);
                this.COLUMN_MAX = 23;
            } else {
                printSetup.setLandscape(false);
                this.COLUMN_MAX = 15;
            }
        }
        return sheet;
    }

    private void changeRow(HSSFSheet sheet, int gread) {
        HSSFRow r = sheet.getRow(this.rowIndex);
        if (r != null) {
            r.setHeightInPoints((float)this.defaultHigh);
        }
        ++this.rowIndex;
        this.cellIndex = this.defaultGreadCell * gread;
        this.defaultHigh = 25;
    }

    private HSSFRow getRow(HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(this.rowIndex);
        if (row == null) {
            row = sheet.createRow(this.rowIndex);
        }
        return row;
    }

    private HSSFCellStyle title0Style(HSSFWorkbook xls, HSSFCellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont ztFont = xls.createFont();
        ztFont.setItalic(false);
        ztFont.setColor((short)Short.MAX_VALUE);
        ztFont.setFontHeightInPoints((short)20);
        ztFont.setFontName("\u5b8b\u4f53");
        ztFont.setBold(true);
        cellStyle.setFont((Font)ztFont);
        return cellStyle;
    }

    private HSSFCellStyle title1Style(HSSFWorkbook xls, HSSFCellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont ztFont = xls.createFont();
        ztFont.setItalic(false);
        ztFont.setColor((short)Short.MAX_VALUE);
        ztFont.setFontHeightInPoints((short)12);
        ztFont.setFontName("\u5b8b\u4f53");
        ztFont.setBold(true);
        ztFont.setUnderline((byte)1);
        cellStyle.setFont((Font)ztFont);
        return cellStyle;
    }

    private Font setFont(HSSFWorkbook xls, String s) {
        HSSFFont ztFont = xls.createFont();
        switch (s) {
            case "default": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)10);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBold(false);
                break;
            }
            case "title1": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)18);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBold(true);
                break;
            }
            case "title2": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)16);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBold(true);
                break;
            }
            case "title3": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)14);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBold(true);
                break;
            }
            case "required": {
                ztFont.setItalic(false);
                ztFont.setColor(IndexedColors.BLUE.getIndex());
                ztFont.setFontHeightInPoints((short)10);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBold(false);
                break;
            }
        }
        return ztFont;
    }

    private HSSFSheet setTilte(HSSFWorkbook xls, HSSFSheet sheet, String title, int gread) {
        HSSFRow row = null;
        HSSFCell cell = null;
        if (gread == 0) {
            row = sheet.createRow(this.rowIndex);
            cell = row.createCell(0);
            sheet.addMergedRegion(new CellRangeAddress(this.rowIndex, this.rowIndex, 0, this.COLUMN_MAX));
            cell = row.getCell(this.cellIndex);
            cell.setCellValue(title);
            cell.setCellStyle(this.title0Style(xls, xls.createCellStyle()));
        } else if (gread == 1) {
            row = sheet.createRow(this.rowIndex);
            cell = row.createCell(this.cellIndex);
            sheet.addMergedRegion(new CellRangeAddress(this.rowIndex, this.rowIndex, this.cellIndex, this.COLUMN_MAX));
            cell = row.getCell(this.cellIndex);
            cell.setCellValue(title);
            cell.setCellStyle(this.title1Style(xls, xls.createCellStyle()));
        }
        return sheet;
    }

    private HSSFCellStyle setCellDataFormate(HSSFWorkbook xls, HSSFCellStyle cellStyle, String s, String formate) {
        HSSFDataFormat format = xls.createDataFormat();
        switch (s) {
            case "\u6587\u672c": {
                cellStyle.setDataFormat(format.getFormat("@"));
                break;
            }
            case "\u8d27\u5e01": {
                cellStyle.setDataFormat(format.getFormat("\u00a5#,##0.00"));
                break;
            }
            case "\u65e5\u671f": {
                cellStyle.setDataFormat(format.getFormat(formate));
                break;
            }
            case "\u767e\u5206\u6bd4": {
                cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)formate));
                break;
            }
        }
        return cellStyle;
    }

    public float getregex(String charStr) {
        if (charStr == " ") {
            return 0.5f;
        }
        if (Pattern.compile("^[A-Za-z0-9]+$").matcher(charStr).matches()) {
            return 0.5f;
        }
        if (Pattern.compile("[\u4e00-\u9fa5]+$").matcher(charStr).matches()) {
            return 1.0f;
        }
        if (Pattern.compile("[^x00-xff]").matcher(charStr).matches()) {
            return 1.0f;
        }
        return 0.5f;
    }

    private HSSFSheet autoSetHeight(HSSFSheet sheet, Cell c, int length) {
        HSSFRow row = sheet.getRow(this.rowIndex);
        float fontCountInline = length * 5;
        float defaultRowHeight = 25.0f;
        float defaultCount = 0.0f;
        String str = c.toString();
        for (int i = 0; i < str.length(); ++i) {
            float ff = this.getregex(str.substring(i, i + 1));
            defaultCount += ff;
        }
        int rwsTemp = (int)((float)((int)(defaultCount / fontCountInline)) * defaultRowHeight);
        if (this.defaultHigh < rwsTemp) {
            this.defaultHigh = rwsTemp;
            row.setHeight((short)(rwsTemp * 25));
        }
        return sheet;
    }

    private HSSFSheet setFormCell(HSSFWorkbook xls, HSSFSheet sheet, String type, JSONObject column, int length) throws ParseException {
        HSSFCell cell = this.getRow(sheet).createCell(this.cellIndex);
        if (length > 0) {
            sheet.addMergedRegion(new CellRangeAddress(this.rowIndex, this.rowIndex, this.cellIndex, this.cellIndex + length));
            cell = this.getRow(sheet).getCell(this.cellIndex);
            this.cellIndex += length;
        }
        HSSFCellStyle cellStyle = xls.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if ("text".equals(type)) {
            String required = column.getString("required");
            if (required == null || required.equalsIgnoreCase("false")) {
                cellStyle.setFont(this.setFont(xls, "default"));
            } else {
                cellStyle.setFont(this.setFont(xls, "required"));
            }
            String labelAlign = column.getString("labelAlign");
            if (labelAlign == null || labelAlign.equalsIgnoreCase(STATIC_RIGHT)) {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            } else if (labelAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
            } else if (labelAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
            } else {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            }
            cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
            cell.setCellValue(column.getString("label"));
        } else if ("value".equals(type)) {
            cellStyle.setFont(this.setFont(xls, "default"));
            String dataAlign = column.getString("dataAlign");
            if (dataAlign == null || dataAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
            } else if (dataAlign.equalsIgnoreCase("rigth")) {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            } else if (dataAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
            }
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            String fmt = column.getString("format");
            String datatype = column.getString("datatype");
            if (datatype.startsWith("s")) {
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
                cell.setCellValue(column.getString("data"));
            } else if (datatype.startsWith("d") || datatype.equalsIgnoreCase("time")) {
                Date date = null;
                String datestyle = "yyyy-MM-dd";
                if (fmt.length() > 10) {
                    datestyle = "yyyy-MM-dd HH:mm:ss";
                }
                HSSFDataFormat format = xls.createDataFormat();
                cellStyle.setDataFormat(format.getFormat(datestyle));
                SimpleDateFormat sdf = new SimpleDateFormat(datestyle);
                if (column.getString("data") != null) {
                    date = sdf.parse(column.getString("data"));
                    cell.setCellValue(date);
                }
            } else {
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
                cell.setCellValue(column.getString("data"));
            }
        }
        cell.setCellStyle(cellStyle);
        sheet = this.autoSetHeight(sheet, (Cell)cell, length + 1);
        ++this.cellIndex;
        return sheet;
    }

    private HSSFSheet setGridCell(HSSFWorkbook xls, HSSFSheet sheet, String type, JSONObject column, JSONObject data, int length) throws ParseException {
        HSSFCell cell = this.getRow(sheet).createCell(this.cellIndex);
        if (length > 0) {
            CellRangeAddress cra = new CellRangeAddress(this.rowIndex, this.rowIndex, this.cellIndex, this.cellIndex + length);
            sheet.addMergedRegion(cra);
            BorderStyle border = BorderStyle.THIN;
            RegionUtil.setBorderBottom((BorderStyle)border, (CellRangeAddress)cra, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)border, (CellRangeAddress)cra, (Sheet)sheet);
            RegionUtil.setBorderTop((BorderStyle)border, (CellRangeAddress)cra, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)border, (CellRangeAddress)cra, (Sheet)sheet);
            cell = this.getRow(sheet).getCell(this.cellIndex);
            this.cellIndex += length;
        }
        HSSFCellStyle cellStyle = xls.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if ("text".equals(type)) {
            String required = column.getString("required");
            if (required == null || required.equalsIgnoreCase("false")) {
                cellStyle.setFont(this.setFont(xls, "default"));
            } else {
                cellStyle.setFont(this.setFont(xls, "required"));
            }
            String labelAlign = column.getString("labelAlign");
            if (labelAlign == null || labelAlign.equalsIgnoreCase(STATIC_RIGHT)) {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            } else if (labelAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
            } else if (labelAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
            }
            cell.setCellValue(column.getString("label"));
            cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
        } else if ("value".equals(type)) {
            cellStyle.setFont(this.setFont(xls, "default"));
            String dataAlign = column.getString("dataAlign");
            if (dataAlign == null || dataAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
            } else if (dataAlign.equalsIgnoreCase("rigth")) {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            } else if (dataAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
            }
            String tp = column.getString("type");
            String datatype = column.getString("datatype");
            if (datatype.startsWith("s")) {
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
                if ("comboboxcolumn".equalsIgnoreCase(tp)) {
                    String s = null;
                    JSONArray j = column.getJSONArray("data");
                    for (int i = 0; i < j.size(); ++i) {
                        String ss = data.getString(column.getString("name"));
                        if (!ss.equals(j.getJSONObject(i).get((Object)"code"))) continue;
                        s = "[" + j.getJSONObject(i).get((Object)"code") + "]" + j.getJSONObject(i).get((Object)"name");
                    }
                    cell.setCellValue(s);
                } else {
                    cell.setCellValue(data.getString(column.getString("name")));
                }
            } else if (datatype.startsWith("d") || datatype.equalsIgnoreCase("time")) {
                String fmt = column.getString("format");
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u65e5\u671f", fmt.toLowerCase());
                SimpleDateFormat dateFormat = new SimpleDateFormat(fmt.toLowerCase());
                if (data.getString(column.getString("name")) != null) {
                    Date date = dateFormat.parse(data.getString(column.getString("name")));
                    cell.setCellValue(date);
                }
            } else if (datatype.startsWith("c")) {
                String fmt = column.getString("format");
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u8d27\u5e01", fmt);
                cell.setCellValue(data.getDouble(column.getString("name")).doubleValue());
            } else if (datatype.startsWith("p")) {
                String fmt = column.getString("format");
                if ("p2".equalsIgnoreCase(datatype)) {
                    fmt = "0.00%";
                } else if ("p4".equalsIgnoreCase(datatype)) {
                    fmt = "0.0000%";
                }
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u767e\u5206\u6bd4", fmt);
                cell.setCellValue(data.getDouble(column.getString("name")).doubleValue());
            }
        }
        cell.setCellStyle(cellStyle);
        sheet = this.autoSetHeight(sheet, (Cell)cell, length + 1);
        ++this.cellIndex;
        return sheet;
    }

    public String exportExcelPrint(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONArray jsona;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        this.rowIndex = 0;
        this.cellIndex = 0;
        String a4 = jsonparam.getString("pagesize") == null ? "A4" : jsonparam.getString("pagesize");
        String orientation = jsonparam.getString("orientation") == null ? "\u6a2a\u5411" : jsonparam.getString("orientation");
        HSSFWorkbook xls = new HSSFWorkbook();
        HSSFSheet sheet = xls.createSheet("\u9ed8\u8ba4");
        sheet = this.setSheetPaper(sheet, a4, orientation);
        String bigtitle = jsonparam.getString("title");
        if (bigtitle != null && bigtitle != "") {
            sheet = this.setTilte(xls, sheet, bigtitle, 0);
            this.changeRow(sheet, 1);
        }
        if ((jsona = jsonparam.getJSONArray("items")) != null && jsona.size() > 0) {
            for (int i = 0; i < jsona.size(); ++i) {
                JSONArray columns;
                JSONArray ja;
                JSONObject jsono = jsona.getJSONObject(i);
                if (jsono == null) continue;
                String type = jsono.getString("type");
                if ("formgrid".equalsIgnoreCase(type)) {
                    ja = jsono.getJSONArray("items");
                    for (int j = 0; j < ja.size(); ++j) {
                        String title = ja.getJSONObject(j).getString("title");
                        if (title != null && title != "") {
                            sheet = this.setTilte(xls, sheet, title, 1);
                            this.changeRow(sheet, 1);
                        }
                        if ((columns = ja.getJSONObject(j).getJSONArray("columns")) == null || columns.size() <= 0) continue;
                        for (int k = 0; k < columns.size(); ++k) {
                            JSONObject col = columns.getJSONObject(k);
                            String visible = col.getString("visible");
                            if (visible != null && visible.equalsIgnoreCase("false")) continue;
                            int textcnt = (int)((double)this.COLUMN_MAX * this.defaulttextCell);
                            int valuecnt = (int)((double)this.COLUMN_MAX * (this.defaultRangCell - this.defaulttextCell));
                            if (this.COLUMN_MAX - this.cellIndex - textcnt - valuecnt < 0) {
                                this.changeRow(sheet, 1);
                            }
                            sheet = this.setFormCell(xls, sheet, "text", col, textcnt);
                            sheet = this.setFormCell(xls, sheet, "value", col, valuecnt);
                            if (!"100".equalsIgnoreCase(col.getString("width"))) continue;
                            this.changeRow(sheet, 1);
                        }
                        this.changeRow(sheet, 1);
                    }
                    continue;
                }
                if ("gridbox".equalsIgnoreCase(type)) {
                    ja = jsono.getJSONArray("items");
                    String title = jsono.getString("title");
                    if (title != null && title != "") {
                        sheet = this.setTilte(xls, sheet, title, 1);
                        this.changeRow(sheet, 1);
                    }
                    for (int j = 0; j < ja.size(); ++j) {
                        columns = ja.getJSONObject(j).getJSONArray("columns");
                        if (columns != null && columns.size() > 0) {
                            for (int k = 0; k < columns.size(); ++k) {
                                JSONObject col = columns.getJSONObject(k);
                                String visible = col.getString("visible");
                                String name = col.getString("label");
                                if (visible != null && visible.equalsIgnoreCase("false") || name == null) continue;
                                int textcnt = 2;
                                sheet = this.setGridCell(xls, sheet, "text", col, null, textcnt);
                            }
                            this.changeRow(sheet, 1);
                            JSONArray data = ja.getJSONObject(j).getJSONArray("data");
                            if (data != null && data.size() > 0) {
                                for (int k = 0; k < data.size(); ++k) {
                                    for (int m = 0; m < columns.size(); ++m) {
                                        String name;
                                        JSONObject col = columns.getJSONObject(m);
                                        String visible = col.getString("visible");
                                        if (visible != null && visible.equalsIgnoreCase("false") || (name = col.getString("label")) == null) continue;
                                        int textcnt = 2;
                                        sheet = this.setGridCell(xls, sheet, "value", col, data.getJSONObject(k), textcnt);
                                    }
                                    this.changeRow(sheet, 1);
                                }
                            }
                        }
                        this.changeRow(sheet, 1);
                    }
                    continue;
                }
                throw new Exception("type \u6ca1\u6709\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        String tempExcelFilename = this.head + UniqueID.getUniqueID() + ".xls";
        FileOutputStream fos = new FileOutputStream(tempExcelFilename);
        xls.write((OutputStream)fos);
        fos.flush();
        fos.close();
        return tempExcelFilename;
    }

    static interface PageSize {

        public static interface A4 {
            public static final int crosswiseColumnCnt = 23;
            public static final int lengthwaysColumnCnt = 15;
            public static final double defaultWidth = 4.0;
            public static final int defaultHigh = 25;
        }
    }
}

