/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.ReportService;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.fileio.FileImportSrvl;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.mybatis.HashMapCase;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.StringUtils;

public class ReportServiceImpl
extends BasicComponent
implements ReportService {
    private static final String STATIC_XLS = "XLS";
    private static final String STATIC_XLSX = "XLSX";
    private static final String STATIC_LEFT = "left";
    private static final String STATIC_CENTER = "center";
    private static final String STATIC_RIGHT = "right";
    private SXSSFWorkbook xlsx = null;
    private HSSFWorkbook xls = null;
    private List<CellStyle> stylelist = new ArrayList<CellStyle>();
    private Map<String, Integer> fldstyle = new HashMap<String, Integer>();
    private Map<String, Map<String, String>> fmts_config = new HashMap<String, Map<String, String>>();
    private List<Map<String, String>> virtual_fields_config;
    private String head = "/opt/logs";

    public List<Map<String, String>> getVirtual_fields_config() {
        return this.virtual_fields_config;
    }

    public void setVirtual_fields_config(List<Map<String, String>> virtual_fields_config) {
        this.virtual_fields_config = virtual_fields_config;
    }

    public void setHead(String temp) {
        this.head = temp;
    }

    public String getFilePath() {
        return this.head;
    }

    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (!jsonparam.containsKey((Object)"ent_id")) {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
        }
        return this.query(session, jsonparam, "report");
    }

    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam, String datakey) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"queryid"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "queryid");
        }
        if (!jsonparam.containsKey((Object)"ent_id")) {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
        }
        String virtual_fields = this.getParamWithCheck(jsonparam, "virtual_fields", false, "");
        int pageno = -1;
        int pagesize = 40;
        if (jsonparam.containsKey((Object)"page_no") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"page_no"))) {
            pageno = jsonparam.getInteger("page_no");
            if (pageno <= 0) {
                pageno = 1;
            }
            jsonparam.remove((Object)"page_no");
        }
        if (jsonparam.containsKey((Object)"page_size") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"page_size"))) {
            pagesize = jsonparam.getInteger("page_size");
            if (pagesize <= 0) {
                pagesize = 40;
            }
            if (pagesize > 10000) {
                pagesize = 10000;
            }
            jsonparam.remove((Object)"page_size");
            if (pageno <= 0) {
                pageno = 1;
            }
        }
        RowBounds rowBounds = null;
        if (pageno >= 1) {
            rowBounds = new RowBounds((pageno - 1) * pagesize, pagesize);
        }
        HashMapCase map = new HashMapCase();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        StringBuffer total = new StringBuffer();
        JSONObject json = new JSONObject();
        json.put(datakey, this.doQuery(jsonparam.getString("queryid"), map, rowBounds, total));
        if (total.toString() != "") {
            json.put("total_results", (Object)total.toString());
        } else {
            json.put("total_results", (Object)"0");
        }
        this.queryReportSum(session, jsonparam.getString("queryid"), map, json);
        this.getReportTot(session, json, jsonparam, total);
        return ServiceResponse.buildSuccess(json);
    }

    public void queryReportSum(ServiceSession session, String queryid, Object param, JSONObject json) throws Exception {
        if (param instanceof Map && ((Map)param).containsKey("summary_fld")) {
            String summary_fld = ((Map)param).get("summary_fld").toString();
            String[] summary_flds = summary_fld.split(",");
            if (!StringUtils.isEmpty((Object)summary_fld)) {
                Map map;
                FMybatisTemplate storage = null;
                storage = this.getStorageOperations(FMybatisTemplate.class);
                if (param != null && (map = (Map)param).containsKey("ds")) {
                    storage = this.getStorageOperations(map.get("ds").toString(), FMybatisTemplate.class);
                }
                SqlSessionTemplate db = storage.getSqlSessionTemplate();
                MappedStatement mappedStatement = db.getConfiguration().getMappedStatement(queryid);
                BoundSql boundSql = mappedStatement.getBoundSql(param);
                Configuration configuration = mappedStatement.getConfiguration();
                String sql = this.showSql(configuration, boundSql);
                String sumcols = this.sumcol_sql(summary_fld);
                String newsql = "select " + sumcols + " from (" + sql + ") tabsummary";
                Map rs = (Map)db.selectOne("mybatis.sql.select", (Object)newsql);
                if (!StringUtils.isEmpty((Object)rs)) {
                    JSONObject jsonsum = new JSONObject();
                    for (String fld : summary_flds) {
                        jsonsum.put(fld, rs.get(fld));
                    }
                    if (!StringUtils.isEmpty((Object)jsonsum)) {
                        json.put("total_summary", (Object)jsonsum);
                    }
                }
            }
        }
    }

    public String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                }
            }
        }
        return sql;
    }

    private String getParameterValue(Object obj) {
        Object value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format((Date)obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total) {
        FMybatisTemplate storage = null;
        try {
            Map map;
            storage = this.getStorageOperations(FMybatisTemplate.class);
            if (param != null && (map = (Map)param).containsKey("ds")) {
                storage = this.getStorageOperations(map.get("ds").toString(), FMybatisTemplate.class);
            }
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            if (rowBounds == null) {
                List list;
                List list2 = list = db.selectList(queryid, param);
                return list2;
            }
            List list = db.selectList(queryid, param, rowBounds);
            if (total != null) {
                total.append(((Page)list).getTotal());
            }
            List list3 = list;
            return list3;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public String sumcol_sql(String cols) throws Exception {
        Object sumcols = "";
        for (String col : cols.split(",")) {
            sumcols = (String)sumcols + "sum(" + col + ") " + col + ",";
        }
        return ((String)sumcols).substring(0, ((String)sumcols).length() - 1);
    }

    protected void getReportTot(ServiceSession session, JSONObject json, JSONObject jsonparam, StringBuffer total) {
        try {
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"tot_cols")) && !StringUtils.isEmpty((Object)jsonparam.get((Object)"tot_queryid"))) {
                String tot_cols = jsonparam.getString("tot_cols");
                jsonparam.put("tot_cols", (Object)this.sumcol_sql(tot_cols));
                HashMapCase map = new HashMapCase();
                map.put("ent_id", session.getEnt_id());
                for (String key : jsonparam.keySet()) {
                    map.put(key, jsonparam.get((Object)key));
                }
                List<Map<String, Object>> tot_row = this.doQuery(jsonparam.getString("tot_queryid"), map, new RowBounds(0, 100), total);
                if (tot_row.size() > 0) {
                    Map<String, Object> row = tot_row.get(0);
                    for (String key : tot_cols.split(",")) {
                        json.put(key, row.get(key));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String export(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        List<Map<String, Object>> list = this.doQuery(jsonparam.getString("queryid"), map, null, null);
        return this.createExportXLS(list, fldlst, disps, fmts);
    }

    public String exportReport(ServiceSession session, JSONObject jsonparam) throws Exception {
        String excel;
        int rowMaxCount = 60000;
        long est = System.currentTimeMillis();
        if (this.fmts_config == null || this.fmts_config.size() == 0) {
            this.init();
        }
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        Map<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        if (!(fmts != null && fmts.size() != 0 || StringUtils.isEmpty(this.fmts_config.get(jsonparam.getString("queryid"))))) {
            fmts = this.fmts_config.get(jsonparam.getString("queryid"));
        }
        jsonparam.put("fields", (Object)flds.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());
        map.put("token", session.getToken());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        RowBounds rowBounds = new RowBounds(0, rowMaxCount);
        ArrayList<String> filelist = new ArrayList<String>();
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = sdfymdCard.format(new Date());
        String exceltype = null;
        exceltype = StringUtils.isEmpty(map.get("filetype")) ? STATIC_XLSX : ("1".equals(excel = map.get("filetype").toString()) ? STATIC_XLS : STATIC_XLSX);
        boolean flag = true;
        int row = 1;
        do {
            Object tempfileName = fileName;
            String msg = "\u521b\u5efa\u6587\u4ef6[" + fileName + "][" + row + "]";
            long st = System.currentTimeMillis();
            ServiceLogs.debuglog("createExcel", msg + "-->\u5f00\u59cb", 0L);
            PageHelper.startPage((int)row, (int)rowMaxCount, (boolean)false);
            List<Map<String, Object>> list = this.doQuery(jsonparam.getString("queryid"), map, null, null);
            if (list.size() < rowMaxCount) {
                if (row != 1) {
                    tempfileName = (String)tempfileName + "(" + row + ")";
                }
                file = this.createExcel(list, (String)tempfileName, fldlst, disps, fmts, exceltype);
                filelist.add(file);
                flag = false;
            } else {
                tempfileName = (String)tempfileName + "(" + row + ")";
                file = this.createExcel(list, (String)tempfileName, fldlst, disps, fmts, exceltype);
                filelist.add(file);
                rowBounds = new RowBounds((++row - 1) * rowMaxCount, rowMaxCount);
            }
            ServiceLogs.debuglog("createExcel", msg + "-->\u7ed3\u675f", st);
        } while (flag);
        String reFile = "";
        reFile = filelist.size() > 1 ? this.makezip(filelist) : (String)filelist.get(0);
        ServiceLogs.debuglog("exportReport", "\u5bfc\u51fa\u7ed3\u675f-->" + reFile, est);
        return reFile;
    }

    private void init() throws Exception {
        try {
            this.fmts_config.clear();
            FileImportSrvl fileimport = new FileImportSrvl();
            List<Map<String, Object>> outconfig = fileimport.getOutStyle();
            for (Map<String, Object> row : outconfig) {
                HashMap<String, String> fmt = new HashMap<String, String>();
                String[] flds = MapUtils.getString(row, "impfields", "").split(",");
                String[] fmts = MapUtils.getString(row, "impfields_datatype", "").split(",");
                int i = 0;
                for (String fld : flds) {
                    if (flds.length > i && fmts.length > i) {
                        fmt.put(fld, this.getfmt(fmts[i]));
                    }
                    ++i;
                }
                this.fmts_config.put(MapUtils.getString(row, "eid", ""), fmt);
            }
        }
        catch (Exception e) {
            this.fmts_config = new HashMap<String, Map<String, String>>();
        }
    }

    private String getfmt(String s) {
        String result = "";
        if (s == null || s.equals("")) {
            result = "";
        } else if (s.equalsIgnoreCase("D")) {
            result = "d";
        } else if (s.equalsIgnoreCase("N")) {
            result = "n";
        } else if (s.equalsIgnoreCase("L")) {
            result = "l";
        } else if (s.equalsIgnoreCase("S")) {
            result = "s";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createExcel(List<Map<String, Object>> list, String fileName, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype) throws Exception {
        String filePath = this.getFilePath();
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Object tempExcelFile = "";
        tempExcelFile = STATIC_XLSX.equals(exceltype) ? filePath + fileName + ".xlsx" : filePath + fileName + ".xls";
        int rowMemory = 100;
        FileOutputStream fos = new FileOutputStream((String)tempExcelFile);
        if (STATIC_XLSX.equals(exceltype)) {
            try {
                this.xlsx = new SXSSFWorkbook(rowMemory);
                this.exportDataToExcel(list, fldlst, disps, fmts, STATIC_XLSX);
                this.xlsx.write((OutputStream)fos);
                fos.flush();
                fos.close();
            }
            finally {
                fos.flush();
                fos.close();
                if (list != null) {
                    list.clear();
                }
            }
        }
        try {
            this.xls = new HSSFWorkbook();
            this.exportDataToExcel(list, fldlst, disps, fmts, STATIC_XLS);
            this.xls.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        finally {
            fos.flush();
            fos.close();
            list.clear();
        }
        return tempExcelFile;
    }

    private void exportDataToExcel(List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype) {
        Cell cell;
        SXSSFSheet sheet = null;
        CellStyle columnHeadStyle = null;
        CellStyle cellString = null;
        Font f = null;
        if (fldlst == null) {
            fldlst = new ArrayList<String>();
        }
        if (disps == null) {
            disps = new HashMap<String, String>();
        }
        if (fmts == null) {
            fmts = new HashMap<String, String>();
        }
        if (STATIC_XLSX.equals(exceltype)) {
            columnHeadStyle = this.xlsx.createCellStyle();
            cellString = this.xlsx.createCellStyle();
            f = this.xlsx.createFont();
            sheet = this.xlsx.createSheet("sheet");
        } else {
            columnHeadStyle = this.xls.createCellStyle();
            cellString = this.xls.createCellStyle();
            f = this.xls.createFont();
            sheet = this.xls.createSheet("sheet");
        }
        columnHeadStyle.setBorderBottom(BorderStyle.THIN);
        columnHeadStyle.setBorderLeft(BorderStyle.THIN);
        columnHeadStyle.setBorderRight(BorderStyle.THIN);
        columnHeadStyle.setBorderTop(BorderStyle.THIN);
        columnHeadStyle.setAlignment(HorizontalAlignment.CENTER);
        columnHeadStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        columnHeadStyle.setWrapText(true);
        f.setFontHeightInPoints((short)9);
        f.setBold(true);
        columnHeadStyle.setFont(f);
        cellString.setBorderBottom(BorderStyle.THIN);
        cellString.setBorderLeft(BorderStyle.THIN);
        cellString.setBorderRight(BorderStyle.THIN);
        cellString.setBorderTop(BorderStyle.THIN);
        cellString.setVerticalAlignment(VerticalAlignment.CENTER);
        if (STATIC_XLSX.equals(exceltype)) {
            cellString.setDataFormat(this.xlsx.createDataFormat().getFormat("@"));
        } else {
            cellString.setDataFormat(this.xls.createDataFormat().getFormat("@"));
        }
        columnHeadStyle.setAlignment(HorizontalAlignment.LEFT);
        cellString.setWrapText(true);
        this.stylelist.add(cellString);
        Row row = sheet.createRow(0);
        sheet.createFreezePane(0, 1, 0, 1);
        int i = 0;
        for (String s : fldlst) {
            cell = row.createCell(i);
            cell.setCellStyle(columnHeadStyle);
            cell.setCellValue(disps.get(s));
            sheet.setColumnWidth(i, 7000);
            ++i;
        }
        int rowIndex = 1;
        if (list != null) {
            for (int j = 0; j < list.size(); ++j) {
                row = sheet.createRow(rowIndex++);
                Map<String, Object> map = list.get(j);
                int index = 0;
                for (String s : fldlst) {
                    cell = row.createCell(index++);
                    Object obj = map.get(s);
                    String style = fmts.get(s);
                    this.setCellsValueTyle(cell, obj, s, style, exceltype);
                }
            }
        }
    }

    protected void setCellsValueTyle(Cell cell, Object obj, String fld, String style, String exceltype) {
        if (obj != null) {
            if (!StringUtils.isEmpty((Object)style)) {
                if (style.startsWith("d")) {
                    Date date = null;
                    String datestyle = "yyyy-MM-dd";
                    if (obj.toString().length() > 10) {
                        datestyle = "yyyy-MM-dd HH:mm:ss";
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(datestyle);
                    try {
                        date = sdf.parse(obj.toString());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    cell.setCellValue(date);
                    cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
                } else if (style.startsWith("l")) {
                    cell.setCellValue((double)Long.parseLong(obj.toString()));
                    cell.setCellStyle(this.getCellStyle(fld, "l", exceltype));
                } else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    cell.setCellValue(Double.parseDouble(obj.toString()));
                    cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
                } else if (style.startsWith("s")) {
                    cell.setCellValue(obj.toString());
                    cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
                } else {
                    cell.setCellValue(obj.toString());
                    cell.setCellStyle(this.getCellStyle(fld, "s", exceltype));
                }
            } else {
                cell.setCellValue(obj.toString());
                cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
            }
        } else {
            cell.setCellStyle(this.getCellStyle(fld, style, exceltype));
        }
    }

    protected CellStyle getCellStyle(String fld, String style, String exceltype) {
        int cellcul = -1;
        CellStyle cellStyle = null;
        if (this.fldstyle.containsKey(fld)) {
            cellcul = this.fldstyle.get(fld);
        }
        if (cellcul == -1) {
            if (!StringUtils.isEmpty((Object)style)) {
                String excelstyle = "";
                String[] dformat = style.split("=");
                HorizontalAlignment align = HorizontalAlignment.CENTER;
                if (style.startsWith("d")) {
                    align = HorizontalAlignment.CENTER;
                    excelstyle = "yyyy\u5e74m\u6708d\u65e5";
                } else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    align = HorizontalAlignment.RIGHT;
                    if (style.startsWith("n")) {
                        excelstyle = "0.00";
                    } else if (style.startsWith("c")) {
                        excelstyle = "\u00a5#,##0.00";
                    } else if (style.startsWith("p")) {
                        excelstyle = "0.00%";
                    }
                } else if (style.startsWith("l")) {
                    align = HorizontalAlignment.RIGHT;
                    excelstyle = "0";
                } else {
                    align = HorizontalAlignment.LEFT;
                    excelstyle = "@";
                }
                if (dformat.length > 1 && !StringUtils.isEmpty((Object)dformat[1])) {
                    excelstyle = dformat[1];
                }
                if (dformat.length > 2 && !StringUtils.isEmpty((Object)dformat[2])) {
                    if (STATIC_LEFT.equals(dformat[2].toLowerCase())) {
                        align = HorizontalAlignment.LEFT;
                    } else if (STATIC_CENTER.equals(dformat[2].toLowerCase())) {
                        align = HorizontalAlignment.CENTER;
                    } else if (STATIC_RIGHT.equals(dformat[2].toLowerCase())) {
                        align = HorizontalAlignment.RIGHT;
                    }
                }
                for (int i = 0; i < this.stylelist.size(); ++i) {
                    CellStyle styletemp = this.stylelist.get(i);
                    if (styletemp.getAlignment() != align) continue;
                    if (STATIC_XLSX.equals(exceltype)) {
                        if (styletemp.getDataFormat() != this.xlsx.createDataFormat().getFormat(excelstyle)) continue;
                        cellcul = i;
                        break;
                    }
                    if (styletemp.getDataFormat() != this.xls.createDataFormat().getFormat(excelstyle)) continue;
                    cellcul = i;
                    break;
                }
                if (cellcul == -1) {
                    if (STATIC_XLSX.equals(exceltype)) {
                        cellStyle = this.xlsx.createCellStyle();
                        cellStyle.setDataFormat(this.xlsx.createDataFormat().getFormat(excelstyle));
                    } else {
                        cellStyle = this.xls.createCellStyle();
                        cellStyle.setDataFormat(this.xls.createDataFormat().getFormat(excelstyle));
                    }
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle.setAlignment(align);
                    this.stylelist.add(cellStyle);
                    cellcul = this.stylelist.size() - 1;
                } else {
                    cellStyle = this.stylelist.get(cellcul);
                }
            } else {
                cellcul = 0;
                cellStyle = this.stylelist.get(cellcul);
            }
            this.fldstyle.put(fld, cellcul);
        } else {
            cellStyle = this.stylelist.get(cellcul);
        }
        return cellStyle;
    }

    public String makezip(List<String> filelist) throws IOException {
        String trackkey;
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = trackkey = sdfymdCard.format(new Date());
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < filelist.size(); ++i) {
            File file = new File(filelist.get(i));
            files.add(file);
        }
        String head = this.getFilePath();
        String name = head + filename + ".rar";
        File file = new File(name);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fous = new FileOutputStream(file);
        ZipOutputStream zipOut = new ZipOutputStream(fous);
        this.zipFile(files, zipOut);
        zipOut.close();
        fous.close();
        for (File temp : files) {
            if (!temp.isFile() || !temp.exists()) continue;
            temp.delete();
        }
        return name;
    }

    private void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block7: {
            try {
                if (!inputFile.exists()) break block7;
                if (inputFile.isFile()) {
                    int nNumber;
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                    bins.close();
                    IN.close();
                    break block7;
                }
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        this.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            this.zipFile(file, outputStream);
        }
    }
}

