/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class CacheUtilsRedisCluster
extends CacheUtilsRediscached
implements Serializable {
    private JedisCluster jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsRedisCluster.class);

    public CacheUtilsRedisCluster() {
        this(null);
    }

    public CacheUtilsRedisCluster(String config) {
        this(config, -1);
    }

    public CacheUtilsRedisCluster(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    @Override
    public Object getCacheType() {
        return "cluster";
    }

    private JedisCluster getJedis() {
        try {
            if (this.jedispool == null) {
                try {
                    this.jedispool = this.CreateJedisPool();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.jedispool;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void returnJedis(JedisCluster jedis) {
    }

    @Override
    public String putDataByElapsed(String key, Object object, int timeout, List<String> elapsed) {
        return this.putData(key, object, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putData(String key, Object object, int timeout) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        try {
            if (timeout < 0) {
                int n = timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            if (timeout > 0) {
                jedis.setex(this.getKey(key).getBytes(), timeout, SerializeUtil.serialize(object));
            } else {
                jedis.set(this.getKey(key).getBytes(), SerializeUtil.serialize(object));
            }
            String string = key;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Object getDataByElapsed(String key, List<String> elapsed) {
        return this.getData(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return null;
        }
        Object result = null;
        try {
            byte[] obj = jedis.get(this.getKey(key).getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        try {
            jedis.del(this.getKey(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    @Override
    public int deleteBatch(String key) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLock(String lockKey, String lockId, int timeout, int waitTime) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return false;
        }
        Long start = System.currentTimeMillis();
        try {
            while (true) {
                String script = "if (redis.call('exists', KEYS[1]) == 0) then    redis.call('hset', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then    redis.call('hincrby', KEYS[1], ARGV[2], 1);    redis.call('pexpire', KEYS[1], ARGV[1]);    return 0; end; return redis.call('pttl', KEYS[1]);";
                Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
                if ("0".equals(result.toString())) {
                    boolean bl = true;
                    return bl;
                }
                long l = System.currentTimeMillis() - start;
                if (l >= (long)waitTime) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int releaseLock(String lockKey, int timeout, String lockId) {
        JedisCluster jedis = this.getJedis();
        if (jedis == null) {
            return -1;
        }
        try {
            String script = "if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then    return 1; end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter > 0) then \tredis.call('pexpire', KEYS[1], ARGV[1]); \treturn 0; else \tredis.call('del', KEYS[1]); \treturn 1; end;return 1;";
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Arrays.asList(String.valueOf(timeout * 1000), lockId));
            int n = Integer.parseInt(result.toString());
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
        }
        return -1;
    }

    private synchronized JedisCluster CreateJedisPool() throws FileNotFoundException, IOException {
        if (this.jedispool != null) {
            return this.jedispool;
        }
        if (this.config != null) {
            String[] str_nodes;
            this.logger.info((Object)"Redis client is creating with configuration.");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(this.config.isRedisTestOnBorrow());
            poolConfig.setMaxTotal(this.config.getRedisMaxActive());
            poolConfig.setMaxIdle(this.config.getRedisMaxIdle());
            poolConfig.setMinIdle(this.config.getRedisMinIdle());
            poolConfig.setMaxWaitMillis((long)this.config.getRedisMaxWait());
            LinkedHashSet<HostAndPort> node_set = new LinkedHashSet<HostAndPort>();
            for (String str : str_nodes = this.config.getRedisNodes().split(",")) {
                String l_host = str.split(":")[0];
                int l_port = Integer.valueOf(str.split(":")[1]);
                node_set.add(new HostAndPort(l_host, l_port));
            }
            this.jedispool = new JedisCluster(node_set, this.config.getRedisTimeout(), 0, this.getConfig().getRedisMaxAttempts(), this.config.getRedisPassword(), (GenericObjectPoolConfig)poolConfig);
        } else {
            Object ini = null;
            String ini0 = null;
            if (StringUtils.isEmpty((Object)this.cfgFile)) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + "/redisCluster.ini";
                ini0 = p + "/conf/redisCluster.ini";
            } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
                p = WebPathUtils.getWebRootClassPath();
                ini = p + this.cfgFile;
                ini0 = p + "/conf" + this.cfgFile;
            } else {
                ini = this.cfgFile;
            }
            int maxActive = 100;
            int timeout = 5000;
            int maxIdle = 30;
            int minIdle = 10;
            boolean testOnBorrow = true;
            String nodes = "";
            String host = "localhost";
            int port = 6379;
            int database = 0;
            int maxWait = 5000;
            File input = new File((String)ini);
            if (ini0 != null && !input.exists()) {
                input = new File(ini0);
            }
            this.logger.info((Object)("redisCluster.ini path:" + (String)ini));
            if (input.exists()) {
                String[] str_nodes;
                String sdatabase;
                String password_prop;
                String password;
                String smaxWait;
                String sport;
                String stestOnBorrow;
                String sminIdle;
                String smaxIdle;
                String stimeout;
                String smaxActive;
                String sServer;
                FileInputStream is = new FileInputStream(input);
                Properties p = new Properties();
                p.load(is);
                ((InputStream)is).close();
                String sNodes = Utils.getEnvValue(p.getProperty("redis.nodes"));
                if (sNodes != null) {
                    nodes = sNodes.trim();
                }
                if ((sServer = Utils.getEnvValue(p.getProperty("redis.host"))) != null) {
                    host = sServer.trim();
                }
                if ((smaxActive = p.getProperty("redis.maxActive")) != null) {
                    maxActive = Integer.parseInt(smaxActive);
                }
                if ((stimeout = p.getProperty("redis.timeout")) != null) {
                    timeout = Integer.parseInt(stimeout);
                }
                if ((smaxIdle = p.getProperty("redis.maxIdle")) != null) {
                    maxIdle = Integer.parseInt(smaxIdle);
                }
                if ((sminIdle = p.getProperty("redis.minIdle")) != null) {
                    minIdle = Integer.parseInt(sminIdle);
                }
                if ((stestOnBorrow = p.getProperty("redis.testOnBorrow")) != null) {
                    boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
                }
                if ((sport = Utils.getEnvValue(p.getProperty("redis.port"))) != null) {
                    port = Integer.parseInt(sport);
                }
                if ((smaxWait = p.getProperty("redis.maxWait")) != null) {
                    maxWait = Integer.parseInt(smaxWait);
                }
                if ((password = Utils.getEnvValue(password_prop = p.getProperty("redis.password"))) != null) {
                    password = password.trim();
                }
                if ((sdatabase = Utils.getEnvValue(p.getProperty("redis.database"))) != null) {
                    database = Integer.parseInt(sdatabase);
                }
                this.logger.info((Object)("rediscached server:" + sNodes));
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                LinkedHashSet<HostAndPort> node_set = new LinkedHashSet<HostAndPort>();
                for (String str : str_nodes = nodes.split(",")) {
                    String l_host = str.split(":")[0];
                    int l_port = Integer.valueOf(str.split(":")[1]);
                    node_set.add(new HostAndPort(l_host, l_port));
                }
                this.jedispool = new JedisCluster(node_set, timeout, 0, 0, null, (GenericObjectPoolConfig)config);
            } else {
                this.logger.warn((Object)"redis.ini not exits!");
                JedisPoolConfig config = new JedisPoolConfig();
                config.setTestOnBorrow(true);
                config.setMaxTotal(maxActive);
                config.setMaxIdle(maxIdle);
                config.setMinIdle(minIdle);
                config.setMaxWaitMillis((long)maxWait);
                HostAndPort node = new HostAndPort(host, port);
                this.jedispool = new JedisCluster(node, (GenericObjectPoolConfig)config);
                System.out.println("rediscached server-\u5730\u5740:localhost:" + port);
            }
        }
        return this.jedispool;
    }
}

