/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.ocp.common.billservice.BillCommonServiceImpl;
import com.efuture.ocp.common.component.BaseServiceIntf;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.print.PrintCtx;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.ExcelUtils;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FStorageOperations;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class BasicComponentService<T extends AbstractEntityBean>
extends BasicComponent
implements BaseServiceIntf {
    static final String PARENT_ID_KEY = "parent_id";
    final Class<T> beanClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), BasicComponentService.class);

    protected Class<T> getBeanClass() {
        return this.beanClass;
    }

    protected String getBeanTable() {
        return AbstractEntityBean.fetchAnnotationTableName(this.getBeanClass());
    }

    protected String getIdKey() throws IllegalArgumentException, IllegalAccessException {
        return this.getIdKey(null);
    }

    protected String getIdKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        return (String)AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "ID_KEY").get(null);
    }

    protected String getOrderFld(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "ORDER_FLD");
        if (fld == null) {
            return null;
        }
        return (String)fld.get(null);
    }

    protected String getOrderDir(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "ORDER_DIR");
        if (fld == null) {
            return null;
        }
        return (String)fld.get(null);
    }

    protected String[] getUniqueKeys() throws IllegalArgumentException, IllegalAccessException {
        return this.getUniqueKeys(null);
    }

    protected String[] getUniqueKeys(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "UNIQUE_KEYS");
        if (fld == null) {
            return null;
        }
        return (String[])fld.get(null);
    }

    protected String[] getReturnFields() throws IllegalArgumentException, IllegalAccessException {
        return this.getReturnFields(null);
    }

    protected String[] getReturnFields(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "RETURN_FIELDS");
        if (fld == null) {
            return null;
        }
        return (String[])fld.get(null);
    }

    protected Map<String, Object> getDependency(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "DEPENDENCY");
        if (fld == null) {
            return null;
        }
        return (Map)fld.get(null);
    }

    protected Field getIdField() throws IllegalArgumentException, IllegalAccessException {
        Field idfld = AbstractEntityBean.fetchDeclaredField(this.getBeanClass(), this.getIdKey());
        return idfld;
    }

    protected void checkDependency(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys) throws Exception {
        if (storage == null) {
            return;
        }
        Map<String, Object> dependencys = this.getDependency(bean.getClass());
        if (dependencys == null) {
            return;
        }
        Set<String> depkeys = dependencys.keySet();
        for (String key : depkeys) {
            Field codefld;
            String codekey;
            Map depbean;
            Field depfld;
            Object depval;
            Object depobj = dependencys.get(key);
            if (depobj == null || keys != null && !keys.contains(key) || StringUtils.isEmpty((Object)(depval = (depfld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), key)).get(bean)))) continue;
            if ((depval instanceof Long || depval instanceof Integer) && Long.parseLong(depval.toString()) <= 0L) {
                depfld.set(bean, 0);
                continue;
            }
            String deptable = null;
            String idkey = null;
            String[] ohkey = null;
            if (depobj instanceof String) {
                String[] ss = ((String)depobj).split(":");
                if (ss.length > 0) {
                    deptable = ss[0].trim();
                }
                if (ss.length > 1) {
                    ohkey = ss[1].split(",");
                    idkey = ohkey[0].trim();
                }
            } else if (depobj instanceof Class) {
                idkey = (String)AbstractEntityBean.fetchDeclaredField((Class)depobj, "ID_KEY").get(null);
                deptable = AbstractEntityBean.fetchAnnotationTableName((Class)depobj);
            }
            if (StringUtils.isEmpty(idkey)) {
                throw new ServiceException("10005", "{0} 's dependency {1} is illegal key in {2}", key, idkey, MessageSourceHelper.getMessage(deptable, bean.getLang(), new Object[0]));
            }
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(idkey).is(depval);
            if (ohkey != null && ohkey.length > 1) {
                for (int i = 1; i < ohkey.length; ++i) {
                    String[] ss = ohkey[i].split("=");
                    if (ss.length <= 1) continue;
                    criteria = criteria.and(ss[0].trim()).is((Object)ss[1].trim());
                }
            }
            Query query = new Query((CriteriaDefinition)criteria);
            query.fields().include(idkey);
            if (key.endsWith("_id")) {
                query.fields().include("code");
                query.fields().include("name");
            }
            if ((depbean = storage.selectOne(query, deptable)) == null) {
                throw new ServiceException("10006", "{0} [{1}] does not exist with {2} of {3}", key, depval, idkey, MessageSourceHelper.getMessage(deptable, bean.getLang(), new Object[0]));
            }
            if (!key.endsWith("_id")) continue;
            if (!StringUtils.isEmpty(depbean.get("code"))) {
                codekey = key.replace("_id", "_code");
                codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
                if (codefld != null) {
                    codefld.set(bean, depbean.get("code"));
                    if (keys != null && !keys.contains(codekey)) {
                        keys.add(codekey);
                    }
                }
            }
            if (StringUtils.isEmpty(depbean.get("name"))) continue;
            codekey = key.replace("_id", "_name");
            codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
            if (codefld != null) {
                codefld.set(bean, depbean.get("name"));
                if (keys == null || keys.contains(codekey)) continue;
                keys.add(codekey);
                continue;
            }
            codekey = key.replace("_id", "");
            codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
            if (codefld == null) continue;
            codefld.set(bean, depbean.get("name"));
            if (keys == null || keys.contains(codekey)) continue;
            keys.add(codekey);
        }
    }

    protected boolean haveParentDependency() throws IllegalArgumentException, IllegalAccessException {
        Map<String, Object> dependencys = this.getDependency(null);
        return dependencys != null && dependencys.keySet().contains(PARENT_ID_KEY);
    }

    @Override
    protected void onAddValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        super.onAddValid(storage, bean, id, uniques);
        this.checkDependency(storage, bean, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse add(ServiceSession session, String param) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)param)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass());
        this.getIdField().set(bean, UniqueID.getUniqueID());
        bean.initInsertMember(session);
        String idkey = this.getIdKey();
        long id = this.doAdd(bean, idkey, this.getUniqueKeys());
        this.updateIsParent(bean);
        JSONObject respdata = new JSONObject();
        respdata.put(idkey, (Object)id);
        return ServiceResponse.buildSuccess(respdata);
    }

    @Override
    protected AbstractEntityBean onUpdateValid(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        AbstractEntityBean original = super.onUpdateValid(storage, bean, keys, id, uniques);
        this.checkDependency(storage, bean, keys);
        return original;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse update(ServiceSession session, String param) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)param)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass());
        bean.initUpdateMember(session);
        HashSet<String> keys = new HashSet<String>(JSON.parseObject((String)param).keySet());
        String idkey = this.getIdKey();
        Object id = null;
        if (this.haveParentDependency() && keys.contains(PARENT_ID_KEY)) {
            AbstractEntityBean original = this.execUpdate(bean, keys, idkey, this.getUniqueKeys());
            this.updateIsParent(bean);
            if (original != null) {
                this.updateIsParent(original);
                Field fld = bean.fetchDeclaredField(idkey);
                id = fld.getLong(original);
            }
        } else {
            id = this.doUpdate(bean, keys, idkey, this.getUniqueKeys());
        }
        JSONObject respdata = new JSONObject();
        respdata.put(idkey, id);
        return ServiceResponse.buildSuccess(respdata);
    }

    @Override
    public AbstractEntityBean onDeleteValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... keys) throws Exception {
        AbstractEntityBean original = super.onDeleteValid(storage, bean, id, keys);
        if (storage != null) {
            Map<String, Object> dependencys = this.getDependency(bean.getClass());
            if (dependencys == null || !dependencys.keySet().contains(PARENT_ID_KEY)) {
                return original;
            }
            if (original != null) {
                Field idfld = bean.fetchDeclaredField(id);
                if (bean.fetchDeclaredField("is_parent").getBoolean(original)) {
                    throw new ServiceException("10007", "{0} {1} [{2}] is parent,can not delete", MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang(), new Object[0]), id, idfld.get(bean));
                }
            }
        }
        return original;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse delete(ServiceSession session, String param) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)param)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass());
        bean.initUpdateMember(session);
        String idkey = this.getIdKey();
        Object id = null;
        if (this.haveParentDependency()) {
            AbstractEntityBean original = this.execDelete(bean, idkey, new String[0]);
            if (original != null) {
                this.updateIsParent(original);
                Field fld = bean.fetchDeclaredField(idkey);
                id = fld.getLong(original);
            }
        } else {
            id = this.doDelete(bean, idkey, new String[0]);
        }
        JSONObject respdata = new JSONObject();
        respdata.put(idkey, id);
        return ServiceResponse.buildSuccess(respdata);
    }

    protected void updateIsParent(AbstractEntityBean bean) throws Exception {
        String idkey = this.getIdKey();
        if (!this.haveParentDependency()) {
            return;
        }
        Object parent_id = bean.fetchDeclaredField(PARENT_ID_KEY).get(bean);
        if ((parent_id instanceof Long || parent_id instanceof Integer) && Long.parseLong(parent_id.toString()) <= 0L) {
            return;
        }
        if (parent_id instanceof String && StringUtils.isEmpty((Object)parent_id)) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)bean.getEnt_id());
        json.put(PARENT_ID_KEY, parent_id);
        AbstractEntityBean childbean = (AbstractEntityBean)this.doSearchOne(json, this.getBeanClass());
        json.clear();
        json.put("ent_id", (Object)bean.getEnt_id());
        json.put(idkey, parent_id);
        json.put("is_parent", (Object)(childbean != null ? 1 : 0));
        this.doUpdate((AbstractEntityBean)JSON.toJavaObject((JSON)json, this.getBeanClass()), json.keySet(), idkey, new String[0]);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse save(ServiceSession session, String param) throws Exception {
        UserDataRangeSrv.setlocalisrange(false);
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)param)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        JSONArray jsonarray = null;
        Object obj = JSON.parse((String)param);
        if (obj instanceof JSONArray) {
            jsonarray = (JSONArray)obj;
        } else if (obj instanceof JSONObject && (jsonarray = ((JSONObject)obj).getJSONArray(this.getBeanTable())) == null) {
            jsonarray = new JSONArray();
            jsonarray.add(obj);
        }
        if (jsonarray == null) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        JSONArray returnarray = this.doSave(session, jsonarray);
        return ServiceResponse.buildSuccess(returnarray);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception {
        JSONArray returnarray = new JSONArray();
        String flag = "flag";
        String idkey = this.getIdKey();
        for (int i = 0; i < jsonarray.size(); ++i) {
            Object obj;
            Field fld;
            String[] rtnfields;
            JSONObject jsn;
            JSONObject json = jsonarray.getJSONObject(i);
            if (!json.containsKey((Object)flag)) {
                returnarray.add((Object)new JSONObject());
                continue;
            }
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(json, this.getBeanClass());
            if ("I".equalsIgnoreCase(json.getString(flag))) {
                this.getIdField().set(bean, UniqueID.getUniqueID());
                bean.initInsertMember(session);
                jsn = new JSONObject();
                jsn.put(idkey, (Object)this.doAdd(bean, idkey, this.getUniqueKeys()));
                rtnfields = this.getReturnFields();
                if (!StringUtils.isEmpty((Object)rtnfields)) {
                    for (String rtnfield : rtnfields) {
                        fld = bean.fetchDeclaredField(rtnfield);
                        obj = fld.get(bean);
                        jsn.put(rtnfield, obj);
                    }
                }
                returnarray.add((Object)jsn);
                continue;
            }
            if ("U".equalsIgnoreCase(json.getString(flag))) {
                bean.initUpdateMember(session);
                this.checkBillUpdate(session, bean);
                jsn = new JSONObject();
                jsn.put(idkey, this.doUpdate(bean, json.keySet(), idkey, this.getUniqueKeys()));
                rtnfields = this.getReturnFields();
                if (!StringUtils.isEmpty((Object)rtnfields)) {
                    for (String rtnfield : rtnfields) {
                        fld = bean.fetchDeclaredField(rtnfield);
                        obj = fld.get(bean);
                        jsn.put(rtnfield, obj);
                    }
                }
                returnarray.add((Object)jsn);
                continue;
            }
            if (!"D".equalsIgnoreCase(json.getString(flag))) continue;
            bean.initUpdateMember(session);
            jsn = new JSONObject();
            jsn.put(idkey, this.doDelete(bean, idkey, new String[0]));
            returnarray.add((Object)jsn);
        }
        return returnarray;
    }

    public void checkBillUpdate(ServiceSession session, AbstractEntityBean bean) throws Exception {
    }

    @Override
    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            if (!jsonparam.containsKey((Object)idkey) || StringUtils.isEmpty((Object)jsonparam.get((Object)idkey))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            Object obj = null;
            obj = StringUtils.isEmpty((Object)jsonparam.get((Object)"fields")) ? (Object)this.doSearchOne(jsonparam, this.getBeanClass()) : this.doSearchOneForMap(jsonparam, this.getBeanClass());
            if (obj == null) {
                return ServiceResponse.buildFailure(session, "10003", "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));
            }
            obj = this.filter(obj, this.getBeanClass());
            JSONObject respdata = new JSONObject();
            respdata.put(table, obj);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    public ServiceResponse search(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            StringBuffer total = new StringBuffer();
            List<Object> list = null;
            list = StringUtils.isEmpty((Object)jsonparam.get((Object)"fields")) ? this.doSearch(jsonparam, this.getBeanClass(), total) : this.doSearchForMap(jsonparam, this.getBeanClass(), total);
            list = (List<Object>)this.filter(list, this.getBeanClass());
            JSONObject respdata = new JSONObject();
            respdata.put("total_results", (Object)Long.parseLong(total.toString()));
            respdata.put(this.getBeanTable(), (Object)list);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    protected JSON getPrintData(ServiceSession session, JSONObject jsonparam) throws Exception {
        jsonparam.put("ent_id", (Object)session.getEnt_id());
        Map<String, Object> obj = null;
        obj = StringUtils.isEmpty((Object)jsonparam.get((Object)"fields")) ? (Map<String, Object>)this.doSearchOne(jsonparam, this.getBeanClass()) : this.doSearchOneForMap(jsonparam, this.getBeanClass());
        return JSONObject.parseObject((String)JSON.toJSONString(obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    public PrintCtx print(ServiceSession session, JSONObject jsonparam) throws Exception {
        PrintCtx printCtx = new PrintCtx();
        printCtx.setBillno(jsonparam.getString("billno"));
        printCtx.setBillmoduleid(jsonparam.getString("billmoduleid"));
        printCtx.setEnt_id(session.getEnt_id());
        JSON data = null;
        try {
            data = this.getPrintData(session, jsonparam);
            printCtx.setQuerydata(data.toJSONString());
            return printCtx;
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return printCtx;
        }
    }

    @Override
    public ServiceResponse getchildren(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            if (!jsonparam.containsKey((Object)idkey) || StringUtils.isEmpty((Object)jsonparam.get((Object)idkey))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            jsonparam.put(PARENT_ID_KEY, jsonparam.get((Object)idkey));
            jsonparam.remove((Object)idkey);
            List<Object> list = null;
            list = StringUtils.isEmpty((Object)jsonparam.get((Object)"fields")) ? this.doSearch(jsonparam, this.getBeanClass(), null) : this.doSearchForMap(jsonparam, this.getBeanClass(), null);
            list = (List<Object>)this.filter(list, this.getBeanClass());
            JSONObject respdata = new JSONObject();
            respdata.put(table, (Object)list);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    public Object export(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        jsonparam.put("ent_id", (Object)session.getEnt_id());
        StringBuffer total = null;
        if (jsonparam.containsKey((Object)"page_size") && jsonparam.getInteger("page_size") < 0 || jsonparam.containsKey((Object)"page_no") && jsonparam.getInteger("page_no") < 0) {
            jsonparam.remove((Object)"page_size");
            jsonparam.remove((Object)"page_no");
        } else {
            total = new StringBuffer();
        }
        List<Map<String, Object>> list = this.doSearchForMap(jsonparam, this.getBeanClass(), total);
        return this.createExportXLS(list, fldlst, disps, fmts);
    }

    public Object importexcel(ServiceSession session, String param, List<FileImportObject> list) throws Exception {
        String outkey = "exceldata";
        String fields = null;
        long maxrow = -1L;
        if (!StringUtils.isEmpty((Object)param)) {
            JSONObject json = JSON.parseObject((String)param);
            if (!StringUtils.isEmpty((Object)json.get((Object)"outkey"))) {
                outkey = json.getString("outkey");
            }
            if (!StringUtils.isEmpty((Object)json.get((Object)"fields"))) {
                fields = json.getString("fields");
            }
            if (!StringUtils.isEmpty((Object)json.get((Object)"maxrow"))) {
                maxrow = Long.parseLong(json.get((Object)"maxrow").toString());
            }
        }
        JSONArray array = null;
        for (FileImportObject fio : list) {
            JSONArray ary = null;
            ary = fio.getFilename().toLowerCase().endsWith(".xlsx") ? ExcelUtils.XLSXtoJSONArray(fio.getStream(), fields, maxrow) : ExcelUtils.XLStoJSONArray(fio.getStream(), fields, maxrow);
            if (array != null) {
                array.addAll((Collection)ary);
                continue;
            }
            array = ary;
        }
        JSONObject json = new JSONObject();
        json.put(outkey, array);
        return json;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse copy(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONArray returnarray = new JSONArray();
        ServiceResponse response = this.get(session, jsonparam);
        JSONObject data = (JSONObject)response.getData();
        String datas = data.toJSONString();
        int s = this.getFirstMatchingIndex(datas, ":");
        String subst = datas.substring(s + 1, datas.length() - 1);
        String pass_tables = null;
        JSONObject json = JSON.parseObject((String)subst);
        JSONObject newjson = new JSONObject();
        JSONArray newJsonArray = null;
        json.remove((Object)"billno");
        json.remove((Object)"billsgno");
        json.remove((Object)"ph_key");
        json.remove((Object)"billstatus");
        json.remove((Object)"ph_timestamp");
        json.remove((Object)"auditor");
        json.remove((Object)"auditor_name");
        json.remove((Object)"auditdate");
        json.remove((Object)"canceler");
        json.remove((Object)"canceler_name");
        json.remove((Object)"canceldate");
        json.remove((Object)"inputer");
        json.remove((Object)"inputer_name");
        if (json.containsKey((Object)"tid")) {
            json.remove((Object)"tid");
            String moduleid = json.getString("billmoduleid");
            Object ruleid = null;
            if (moduleid.equals("6006002")) {
                ruleid = "mztid";
            } else if (moduleid.equals("6006003")) {
                ruleid = "lptid";
            } else if (moduleid.equals("6006004")) {
                ruleid = "zktid";
            } else if (moduleid.equals("6006005")) {
                ruleid = "mjtid";
            } else if (moduleid.equals("6006006")) {
                ruleid = "gmtid";
            } else if (moduleid.equals("6006007")) {
                ruleid = "qytid";
            } else if (moduleid.equals("6006008")) {
                ruleid = "thtid";
            } else if (moduleid.equals("6006020")) {
                ruleid = "qbtid";
            } else if (moduleid.equals("6006009")) {
                ruleid = "tctid";
            } else if (moduleid.equals("6003101")) {
                pass_tables = "coupontdetail";
            } else if (moduleid.equals("6006020")) {
                pass_tables = "baccnttypedet";
            }
            if (ruleid != null) {
                BillCommonServiceImpl billCommon = new BillCommonServiceImpl();
                String tid = billCommon.doApplyBillNo(session.getEnt_id(), (String)ruleid, moduleid, null, null);
                json.put("tid", (Object)tid);
            }
        }
        json.put("inputer", (Object)session.getUser_code());
        json.put("inputer_name", (Object)("[" + session.getUser_code() + "]" + session.getUser_name()));
        json.put("billstatus", (Object)"N");
        Set keySet = json.keySet();
        if (!StringUtils.isEmpty(pass_tables)) {
            keySet.remove(pass_tables);
        }
        for (String key : keySet) {
            String detailjson = json.get((Object)key).toString();
            if (detailjson.contains("[{")) {
                JSONArray jsonArray = JSON.parseArray((String)detailjson);
                newJsonArray = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject parseObject = JSON.parseObject((String)jsonArray.get(i).toString());
                    parseObject.remove((Object)"ph_key");
                    parseObject.remove((Object)"billno");
                    parseObject.remove((Object)"ph_timestamp");
                    parseObject.remove((Object)"cancelflag");
                    newJsonArray.add((Object)parseObject);
                }
                if (newjson.containsKey((Object)key)) continue;
                newjson.put(key, (Object)newJsonArray);
                continue;
            }
            if (newjson.containsKey((Object)key)) continue;
            newjson.put(key, json.get((Object)key));
        }
        AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(newjson, this.getBeanClass());
        String idkey = this.getIdKey();
        this.getIdField().set(bean, UniqueID.getUniqueID());
        bean.initInsertMember(session);
        JSONObject jsn = new JSONObject();
        jsn.put(idkey, (Object)this.doAdd(bean, idkey, this.getUniqueKeys()));
        String[] rtnfields = this.getReturnFields();
        if (!StringUtils.isEmpty((Object)rtnfields)) {
            for (String rtnfield : rtnfields) {
                Field fld = bean.fetchDeclaredField(rtnfield);
                Object obj = fld.get(bean);
                jsn.put(rtnfield, obj);
            }
        }
        returnarray.add((Object)jsn);
        return ServiceResponse.buildSuccess(returnarray);
    }

    private int getFirstMatchingIndex(String input, String query) {
        char[] inputChars = input.toCharArray();
        char[] queryChars = query.toCharArray();
        int inputLength = input.length();
        int queryLength = query.length();
        int inputIndex = 0;
        int queryIndex = 0;
        while (inputIndex < inputLength && queryIndex < queryLength) {
            if (inputChars[inputIndex] == queryChars[queryIndex]) {
                ++queryIndex;
                ++inputIndex;
                continue;
            }
            inputIndex = inputIndex - queryIndex + 1;
            queryIndex = 0;
        }
        int index = queryIndex == queryLength ? (queryLength > 1 ? inputIndex - queryLength : inputIndex - 1) : -1;
        return index;
    }

    protected Object filter(Object data, Class<?> clz) {
        return data;
    }
}

