/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.fileio;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.omd.storage.FMongoTemplate;
import com.efuture.omd.storage.FileObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.util.StringUtils;

public class UploadFileServiceImpl {
    private FMongoTemplate template;

    public UploadFileServiceImpl(FMongoTemplate template) {
        this.template = template;
    }

    public ServiceResponse save(ServiceSession session, String param, List<FileObject> list) {
        if (list == null) {
            return ServiceResponse.buildFailure(session, "\u6ca1\u6709\u4e0a\u4f20\u6587\u4ef6");
        }
        if (list.size() > 1) {
            return ServiceResponse.buildFailure(session, "\u53ea\u652f\u6301\u5355\u6587\u4ef6\u4e0a\u4f20");
        }
        JSONObject params = JSONObject.parseObject((String)param);
        String id_string = params.getString("uid");
        String type = params.getString("type");
        String ttl = params.getString("ttl");
        FileObject fo = list.get(0);
        boolean autodel = false;
        long ttl_seconds = -1L;
        if ("0".equals(type) || "temp".equals(type)) {
            autodel = true;
            if (ttl != null && !ttl.isEmpty()) {
                ttl_seconds = Long.valueOf(ttl);
            }
        } else if ("1".equals(type) || "resource".equals(type)) {
            if (id_string == null || id_string.isEmpty()) {
                return ServiceResponse.buildFailure(session, "10000", "\u4e0a\u4f20\u8d44\u6e90\u6587\u4ef6\u5fc5\u987b\u6307\u5b9a\u552f\u4e00\u6807\u8bc6(uri\u6216uuid)", new Object[0]);
            }
            autodel = false;
        }
        if (id_string == null || id_string.isEmpty()) {
            id_string = UUID.randomUUID().toString();
        }
        fo.setAutodel(autodel);
        fo.setTtl_seconds(ttl_seconds);
        fo.setUid(id_string);
        String uuid = fo.isAutodel() ? this.template.tempfileSave(fo.getFilename(), fo.getUid(), fo.getContentType(), fo.getTtl_seconds(), fo.getStream()) : this.template.resourceSave(fo.getFilename(), fo.getUid(), fo.getContentType(), fo.getStream());
        JSONObject rtn = new JSONObject();
        rtn.put("uuid", (Object)uuid);
        return ServiceResponse.buildSuccess(rtn);
    }

    public FileObject get(ServiceSession session, String param) {
        if (!StringUtils.hasLength((String)param)) {
            param = "{}";
        }
        JSONObject params = JSONObject.parseObject((String)param);
        String uuid = params.getString("uuid");
        FileObject file = null;
        if (StringUtils.hasLength((String)uuid)) {
            file = this.template.fileBrower(uuid);
        } else {
            String uid = params.getString("uid");
            file = this.template.fileBrowerByUid(uid);
        }
        return file;
    }

    public ServiceResponse list(ServiceSession session, String param) {
        if (!StringUtils.hasLength((String)param)) {
            param = "{}";
        }
        JSONObject params = JSONObject.parseObject((String)param);
        String _pageno = params.getString("pageno");
        String _pagesize = params.getString("pagesize");
        int pageno = !StringUtils.hasLength((String)_pageno) ? 1 : Integer.valueOf(_pageno);
        int pagesize = !StringUtils.hasLength((String)_pagesize) ? 40 : Integer.valueOf(_pagesize);
        int i = (pageno - 1) * pagesize;
        List list = this.template.fileBrower(false);
        ArrayList<FileObject> rs = new ArrayList<FileObject>();
        for (int n = 0; i < list.size() && n < pagesize; ++i, ++n) {
            rs.add((FileObject)list.get(i));
        }
        JSONObject data = new JSONObject();
        data.put("total", (Object)list.size());
        data.put("list", rs);
        return ServiceResponse.buildSuccess(data);
    }

    public ServiceResponse clear(ServiceSession session, String param) {
        this.template.cleanExpired();
        return ServiceResponse.buildSuccess("\u6210\u529f\u6e05\u7406\u8fc7\u671f\u6587\u4ef6");
    }

    public ServiceResponse remove(ServiceSession session, String param) {
        JSONArray list;
        JSONObject params = JSONObject.parseObject((String)param);
        String uuid = params.getString("uuid");
        if (uuid != null && uuid.length() > 0) {
            this.template.fileRemove(uuid);
        }
        if (params.containsKey((Object)"list") && (list = params.getJSONArray("list")) != null) {
            for (Object s : list) {
                uuid = String.valueOf(s);
                this.template.fileRemove(uuid);
            }
        }
        return ServiceResponse.buildSuccess("ok");
    }
}

