/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.filter;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class LogMybatisPlugin
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(LogMybatisPlugin.class);
    private Executor target;

    public Object intercept(Invocation invocation) throws Throwable {
        Environment env = (Environment)SpringBeanFactory.getContext().getBean(Environment.class);
        if ("n".equalsIgnoreCase(env.getProperty("efuture.log.logsql"))) {
            return invocation.proceed();
        }
        long starttime = System.currentTimeMillis();
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String[] strArr = mappedStatement.getId().split("\\.");
        String methodName = strArr[strArr.length - 2] + "." + strArr[strArr.length - 1];
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        Configuration configuration = mappedStatement.getConfiguration();
        String sql = this.showSql(configuration, boundSql);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        JSONObject logmsg = new JSONObject();
        logmsg.put("SqlMethodName", (Object)methodName);
        logmsg.put("Sqlstr", (Object)sql);
        Object returnObj = null;
        try {
            returnObj = invocation.proceed();
            ServiceLogs.debuglog("db_succ", logmsg.toJSONString(), starttime);
        }
        catch (Exception e) {
            ServiceLogs.debuglog("db_error", logmsg.toJSONString(), starttime);
            throw e;
        }
        return returnObj;
    }

    public String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                }
            }
        }
        return sql;
    }

    private String getParameterValue(Object obj) {
        Object value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format((Date)obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            this.target = (Executor)target;
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

