/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.FileServiceImpl;
import com.efuture.ocp.common.billservice.ReportServiceImpl;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.fileio.ImageTools;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.rest.userinterface.InitSession;
import com.efuture.ocp.common.sysparam.SystemParamUtil;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.RequestCopy;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.UrlEncoderUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.user.UserTokenInfo;
import com.efuture.omd.storage.FileObject;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.ibatis.session.RowBounds;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.server.ContainerRequest;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Path(value="/")
public class ServiceRestReflect {
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    private static ServiceMethodReflect rcm = new ServiceMethodReflect();
    private static final ThreadLocal<ServiceSession> locale = new ThreadLocal();

    public static ThreadLocal<ServiceSession> getLocale() {
        if (locale == null || locale.get() == null) {
            locale.set(new ServiceSession());
        }
        return locale;
    }

    public static void pushlocale(ServiceSession session) {
        locale.set(session);
    }

    public static void removeLocale(ServiceSession session) {
        if (session != null && !StringUtils.isEmpty((Object)session.getMethod()) && session.getStarttime() > 0L) {
            ServiceVersion.getInstance().writeElapsed(session.getMethod(), System.currentTimeMillis() - session.getStarttime());
        }
        locale.remove();
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/")
    public String test(@QueryParam(value="status") String status) {
        String uri = this.request.getRequestURI();
        if (uri.startsWith("/") || uri.startsWith("\\")) {
            uri = uri.substring(1);
        }
        if (uri.endsWith("/") || uri.endsWith("\\")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ("check".equalsIgnoreCase(status)) {
            return uri + " success";
        }
        if ("info".equalsIgnoreCase(status)) {
            JSONObject json = new JSONObject();
            RuntimeMXBean run = ManagementFactory.getRuntimeMXBean();
            json.put("pid", (Object)run.getName().split("@")[0]);
            json.put("server", (Object)run.getName().split("@")[1]);
            json.put("startTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(run.getStartTime()));
            return json.toJSONString();
        }
        if ("statis".equalsIgnoreCase(status)) {
            try {
                return ServiceVersion.getInstance().printElapsed();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("clear".equalsIgnoreCase(status)) {
            try {
                ServiceVersion.getInstance().cleanElapsed();
                return "ok";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("env".equalsIgnoreCase(status)) {
            try {
                return this.env(null, "*");
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("cfg".equalsIgnoreCase(status)) {
            try {
                return SystemParamUtil.printSystemParamList("PrintSystemParamList");
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("restcfg".equalsIgnoreCase(status)) {
            try {
                return SystemParamUtil.printRestServiceList("PrintRestServiceList");
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("commcfg".equalsIgnoreCase(status)) {
            try {
                return SystemParamUtil.printSystemParamList("PrintCommonParamList");
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("job".equalsIgnoreCase(status)) {
            try {
                return SystemParamUtil.printXxlJobList("PrintXxlJobList");
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        ServiceVersion sv = ServiceVersion.getInstance();
        if ("openlog".equalsIgnoreCase(status)) {
            sv.setLogstatus(true);
        }
        if ("closelog".equalsIgnoreCase(status)) {
            sv.setLogstatus(false);
        }
        String startup = sv.getStartupTime();
        long time = DateUtils.strDateTimeLong(startup);
        long now = System.currentTimeMillis();
        return uri + " version " + sv.getVer() + " (LogStatus: " + (sv.isLogstatus() ? "Y" : "N") + ") started at " + startup + " up " + DateUtils.getDateTimeDuration(now, time) + "\n";
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/health")
    public String health() {
        return "{\"status\":\"UP\"}";
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/montior/info")
    public String info() {
        JSONObject json = new JSONObject();
        RuntimeMXBean run = ManagementFactory.getRuntimeMXBean();
        json.put("pid", (Object)run.getName().split("@")[0]);
        json.put("server", (Object)run.getName().split("@")[1]);
        return json.toJSONString();
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/env")
    public String env(@QueryParam(value="key") String key, @QueryParam(value="group") String group) {
        if (StringUtils.isEmpty((Object)key) && StringUtils.isEmpty((Object)group)) {
            return "require key";
        }
        if (!StringUtils.isEmpty((Object)group)) {
            if ("*".equals(group)) {
                return EnviromentUtil.getAllPropertys(new String[0]).toJSONString();
            }
            return EnviromentUtil.getAllPropertys(group.split(",")).toJSONString();
        }
        String[] keys = key.split(",");
        JSONObject json = EnviromentUtil.followEnvironment(null, keys);
        if (json != null) {
            return json.toJSONString();
        }
        return "";
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/log4j")
    public String log4j(@QueryParam(value="level") String level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        if (StringUtils.isEmpty((Object)level)) {
            return "log4j level is [" + loggerConfig.getLevel().name() + "]";
        }
        loggerConfig.setLevel(Level.getLevel((String)level.toUpperCase()));
        ctx.updateLoggers();
        return "log4j level update to [" + loggerConfig.getLevel().name() + "]";
    }

    @POST
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/lang")
    public String lang(@QueryParam(value="locale") String locale, @QueryParam(value="action") String action, String postparam) {
        JSONObject jsonparam = null;
        if (!StringUtils.isEmpty((Object)postparam)) {
            try {
                jsonparam = JSON.parseObject((String)postparam);
                if (jsonparam.containsKey((Object)"locale")) {
                    locale = jsonparam.getString("locale");
                }
                if (jsonparam.containsKey((Object)"action")) {
                    action = jsonparam.getString("action");
                }
            }
            catch (Exception ex) {
                jsonparam = null;
            }
        }
        if (StringUtils.isEmpty((Object)locale)) {
            return "require locale";
        }
        if (StringUtils.isEmpty((Object)action)) {
            action = "show";
        }
        if ("get".equalsIgnoreCase(action) || "add".equalsIgnoreCase(action) || "del".equalsIgnoreCase(action)) {
            if (jsonparam == null || StringUtils.isEmpty((Object)jsonparam.getString("key"))) {
                return "require dict key";
            }
            String key = "language:" + locale + ":" + MD5Utils.MD5(jsonparam.getString("key"));
            if ("get".equalsIgnoreCase(action)) {
                return (String)CacheUtils.getCacheUtils().getData(key);
            }
            if ("add".equalsIgnoreCase(action)) {
                CacheUtils.getCacheUtils().putData(key, JSONObject.toJSONString((Object)jsonparam), 0);
                return key + " = " + JSONObject.toJSONString((Object)jsonparam);
            }
            CacheUtils.getCacheUtils().deleteData(key);
            return key + " delete success";
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("language:" + locale + ":*");
        Map<String, Object> map = CacheUtils.getCacheUtils().getBatchData(list);
        StringBuffer sb = new StringBuffer();
        if (map != null) {
            for (String key : map.keySet()) {
                String msg = (String)map.get(key);
                if (StringUtils.isEmpty((Object)msg) || !msg.startsWith("{")) continue;
                JSONObject json = JSONObject.parseObject((String)msg);
                String orikey = json.getString("key");
                String val = json.getString("value");
                if (StringUtils.isEmpty((Object)orikey)) continue;
                orikey = orikey.replace(" ", "\\ ");
                orikey = orikey.replace(":", "\\:");
                sb.append(orikey + "=" + val + "\r\n");
            }
        }
        return sb.toString();
    }

    private Map<String, String> getParameter() {
        HashMap<String, String> rtn = new HashMap<String, String>();
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] values = this.request.getParameterValues(key);
            if (values == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            rtn.put(key, value);
        }
        return rtn;
    }

    private void setSessionbycongou(ServiceSession session, String key, String value) {
        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
            UserDataRangeSrv.setlocaltoken(value);
            UserTokenInfo info = UserDataRangeSrv.getlocaluser();
            if (info != null) {
                session.setEnt_id(Long.parseLong(info.getEntid()));
                session.setUser_id(Long.parseLong(info.getUserid()));
                session.setUser_code(info.getUseraccount());
                session.setUser_name(info.getUsername());
                session.setDeptcode(info.getDeptid());
                session.setDeptrealcode(info.getDeptcode());
                session.setRoleid(info.getOrgid());
                session.setRolecode(info.getOrgcode());
                session.setPostid(info.getPostid());
            }
        }
        if ("ent_id".equalsIgnoreCase(key)) {
            session.setEnt_id(Long.parseLong(value));
        }
        if ("user_id".equalsIgnoreCase(key)) {
            session.setUser_id(Long.parseLong(value));
        }
        if ("user_code".equalsIgnoreCase(key)) {
            session.setUser_code(value);
        }
        if ("user_name".equalsIgnoreCase(key)) {
            session.setUser_name(value);
        }
        if ("locale".equalsIgnoreCase(key)) {
            session.setLocale(value);
        }
        if ("debug_status".equalsIgnoreCase(key)) {
            session.setDebug_status(value);
        }
        if ("parentkey".equalsIgnoreCase(key)) {
            session.setParentkey(value);
        }
        if ("rootkey".equalsIgnoreCase(key)) {
            session.setRootkey(value);
        }
        if ("market".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("shop_code".equalsIgnoreCase(key) || "shopCode".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("slice".equalsIgnoreCase(key)) {
            session.setSlice(value);
        }
    }

    private void setSession(ServiceSession session, String key, String value) {
        if ("ent_id".equalsIgnoreCase(key)) {
            session.setEnt_id(Long.parseLong(value));
        }
        if ("user_id".equalsIgnoreCase(key)) {
            session.setUser_id(Long.parseLong(value));
        }
        if ("user_code".equalsIgnoreCase(key)) {
            session.setUser_code(value);
        }
        if ("user_name".equalsIgnoreCase(key)) {
            session.setUser_name(value);
        }
        if ("locale".equalsIgnoreCase(key)) {
            session.setLocale(value);
        }
        if ("debug_status".equalsIgnoreCase(key)) {
            session.setDebug_status(value);
        }
        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
        }
        if ("postid".equalsIgnoreCase(key)) {
            session.setPostid(value);
        }
        if ("parentkey".equalsIgnoreCase(key)) {
            session.setParentkey(value);
        }
        if ("rootkey".equalsIgnoreCase(key)) {
            session.setRootkey(value);
        }
        if ("market".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("shop_code".equalsIgnoreCase(key) || "shopCode".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("slice".equalsIgnoreCase(key)) {
            session.setSlice(value);
        }
    }

    private String addQueryParamToJsonParam(ServiceSession session, String param, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey", "shopCode", "shop_code"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey2 = DataUtils.nvl(rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey2) && portalkey2.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (map != null && map.size() > 0) {
            JSONObject jsonparam = null;
            if (StringUtils.isEmpty((Object)param)) {
                jsonparam = new JSONObject();
            } else {
                try {
                    jsonparam = JSON.parseObject((String)param);
                }
                catch (Exception ex) {
                    return param;
                }
            }
            for (String key : map.keySet()) {
                if (jsonparam.containsKey((Object)key)) continue;
                jsonparam.put(key, map.get(key));
            }
            param = jsonparam.toJSONString();
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey2)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey2, InitSession.class);
            init.init(session);
        }
        return param;
    }

    private boolean isEffective(String remoteAddr) {
        return null != remoteAddr && !"".equals(remoteAddr.trim()) && !"unknown".equalsIgnoreCase(remoteAddr.trim());
    }

    private String getRemoteAddr() {
        try {
            String remoteAddr = this.request.getHeader("X-Forwarded-For");
            if (this.isEffective(remoteAddr) && remoteAddr.indexOf(",") > -1) {
                String[] array;
                for (String element : array = remoteAddr.split(",")) {
                    if (!this.isEffective(element)) continue;
                    remoteAddr = element;
                    break;
                }
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getHeader("X-Real-IP");
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getRemoteAddr();
            }
            if (remoteAddr != null && remoteAddr.indexOf(".") > 0) {
                return remoteAddr;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/restbypath/{method}")
    public String callRestServiceByPath(@PathParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context ContainerRequest req) {
        String postparam = req.getEntityStream().toString();
        return this.callRestService(method, session, param, postparam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String string;
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        long logkey = 0L;
        String url = "";
        ServiceSession sessionobj = null;
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            sessionobj.setStarttime(start_time);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            ServiceRestReflect.pushlocale(sessionobj);
            if (ServiceVersion.getInstance().isLogstatus()) {
                ServiceLogs.logRequest(postparam);
            }
            RequestCopy.copy(method, sessionobj, postparam);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
                rtncode = response.getReturncode();
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            string = result;
        }
        catch (ServiceException ex) {
            String string2;
            block22: {
                ex.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
                rtncode = ex.getErrorCode();
                string2 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block22;
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string2;
        }
        catch (Exception ex2) {
            String string3;
            block23: {
                ex2.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex2), new Object[0]));
                rtncode = "555";
                string3 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block23;
                {
                    catch (Throwable throwable) {
                        if (ServiceVersion.getInstance().isLogstatus()) {
                            ServiceLogs.logResponse(result, rtncode);
                        }
                        UserDataRangeSrv.setlocaltoken("");
                        ServiceRestReflect.removeLocale(sessionobj);
                        throw throwable;
                    }
                }
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string3;
        }
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logResponse(result, rtncode);
        }
        UserDataRangeSrv.setlocaltoken("");
        ServiceRestReflect.removeLocale(sessionobj);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/printRest")
    public String callPrintRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String string;
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        long logkey = 0L;
        String url = "";
        ServiceSession sessionobj = null;
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            JSONObject object = JSONObject.parseObject((String)postparam);
            object.remove((Object)"restUrl");
            object.remove((Object)"querydata");
            object.remove((Object)"dict_data");
            object.remove((Object)"temid");
            postparam = this.addQueryParamToJsonParam(sessionobj, object.toJSONString(), "method", "session", "param");
            sessionobj.setStarttime(start_time);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            ServiceRestReflect.pushlocale(sessionobj);
            if (ServiceVersion.getInstance().isLogstatus()) {
                ServiceLogs.logRequest(postparam);
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, object.toJSONString());
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                response.setLogkey(sessionobj.getLogkey());
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
                rtncode = response.getReturncode();
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            string = result;
        }
        catch (ServiceException ex) {
            String string2;
            block22: {
                ex.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
                rtncode = ex.getErrorCode();
                string2 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block22;
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string2;
        }
        catch (Exception ex2) {
            String string3;
            block23: {
                ex2.printStackTrace();
                result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex2), new Object[0]));
                rtncode = "555";
                string3 = result;
                if (!ServiceVersion.getInstance().isLogstatus()) break block23;
                {
                    catch (Throwable throwable) {
                        if (ServiceVersion.getInstance().isLogstatus()) {
                            ServiceLogs.logResponse(result, rtncode);
                        }
                        UserDataRangeSrv.setlocaltoken("");
                        ServiceRestReflect.removeLocale(sessionobj);
                        throw throwable;
                    }
                }
                ServiceLogs.logResponse(result, rtncode);
            }
            UserDataRangeSrv.setlocaltoken("");
            ServiceRestReflect.removeLocale(sessionobj);
            return string3;
        }
        if (ServiceVersion.getInstance().isLogstatus()) {
            ServiceLogs.logResponse(result, rtncode);
        }
        UserDataRangeSrv.setlocaltoken("");
        ServiceRestReflect.removeLocale(sessionobj);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/restomni")
    public String callRestService_omni(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            sessionobj.setEnt_id(0L);
            sessionobj.setToken("");
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;
            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            } else {
                if (retdata == null) {
                    retdata = "";
                }
                response = ServiceResponse.buildSuccess(retdata);
            }
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(response));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/ptrest")
    public String callRestService_pt(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;
            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            } else {
                if (retdata == null) {
                    retdata = "";
                }
                response = ServiceResponse.buildSuccess(retdata);
            }
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(response));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure_ex(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure_ex(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param) {
        return this.callRestService(method, session, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callImportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form) {
        String string;
        ArrayList<FileImportObject> list = new ArrayList<FileImportObject>();
        try {
            Object parts;
            ServiceVersion.getInstance().debugLog("start import.");
            Map mapFormData = form.getFields();
            Set sets = mapFormData.keySet();
            for (String key : sets) {
                parts = (List)mapFormData.get(key);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key + ":" + filename);
                    if (StringUtils.isEmpty((Object)filename)) continue;
                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream((InputStream)part.getValueAs(InputStream.class));
                    fio.setServletrequest(this.request);
                    list.add(fio);
                }
            }
            param = URLDecoder.decode(param);
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethodForListParam(method, sessionobj, param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param"), list);
            if (retdata == null) {
                parts = "";
                return parts;
            }
            if (retdata instanceof String) {
                parts = (String)retdata;
                return parts;
            }
            parts = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return parts;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception in) {}
            }
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportbyfile")
    public Response callExportByFileService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            String headType = "application/octet-stream";
            String s = String.valueOf(retdata);
            String name = s.substring(0, s.lastIndexOf("."));
            String suffix = s.substring(s.lastIndexOf("."), s.length()).toLowerCase();
            File fp = new File(name + suffix);
            filename = fp.getName();
            Response.ResponseBuilder builder = null;
            if (filename.endsWith(".xls") || filename.endsWith(".xlsx") || filename.endsWith(".rar") || filename.endsWith("txt")) {
                builder = Response.ok((Object)fp);
            } else {
                builder = Response.ok((Object)retdata);
                filename = "export.xls";
            }
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            if (retdata instanceof String) {
                this.response.setCharacterEncoding("UTF-8");
                this.response.setContentType("text/plain");
                builder.type("application/octet-stream");
            } else {
                builder.type("application/octet-stream");
            }
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            Response.ResponseBuilder builder;
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "export.xls";
            }
            String headType = "application/octet-stream";
            if (retdata instanceof String) {
                String s = String.valueOf(retdata).toLowerCase();
                if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                    headType = "application/ms-excel";
                }
                builder = Response.ok((Object)retdata);
            } else {
                StringReader stream = new StringReader(retdata.toString());
                builder = Response.ok((Object)stream);
            }
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            this.response.setCharacterEncoding("UTF-8");
            builder.type(headType);
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportocm")
    public Response callExportServiceOcm(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            InputStreamReader inputReader = null;
            FileInputStream inputStream = new FileInputStream(fp);
            inputReader = new InputStreamReader(inputStream);
            BufferedReader bufferReader = new BufferedReader(inputReader);
            String line = null;
            StringBuffer strBuffer = new StringBuffer();
            while ((line = bufferReader.readLine()) != null) {
                strBuffer.append(line).append("\r\n");
            }
            ((InputStream)inputStream).close();
            String retdata = strBuffer.toString();
            if (StringUtils.isEmpty((Object)filename)) {
                filename = postparam;
            }
            Response.ResponseBuilder builder = Response.ok((Object)retdata);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportTxt")
    public Response callExportServiceTxt(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "export.xls";
            }
            Response.ResponseBuilder builder = Response.ok((Object)retdata);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            if (retdata instanceof String) {
                this.response.setCharacterEncoding("UTF-8");
                this.response.setContentType("text/plain");
            } else {
                builder.type("application/octet-stream");
            }
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportService(method, session, param, null, filename, headers);
    }

    @GET
    @Produces(value={"text/plain;charset=GBK"})
    @Path(value="/exportrar")
    public Response callExportServiceOcmrar(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("GBK");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/getphoto")
    public Response callGetphotoService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            String postparam = null;
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata)).build();
            }
            Response.ResponseBuilder builder = (Response.ResponseBuilder)retdata;
            return builder.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.ok((Object)Utils.getLastExceptionMessage(ex), (String)"text/plain;charset=UTF-8").build();
        }
    }

    private Map<String, Object> getParameters(MultivaluedMap<String, String> form) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : form.entrySet()) {
            List value = (List)entry.getValue();
            if (value.isEmpty()) continue;
            if (value.size() == 1) {
                result.put((String)entry.getKey(), value.get(0));
                continue;
            }
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    private String addParamToJsonParams(ServiceSession session, MultivaluedMap<String, String> formParams, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey2 = DataUtils.nvl(rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey2) && portalkey2.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        Map<String, Object> rps = this.getParameters(formParams);
        map.putAll(rps);
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey2)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey2, InitSession.class);
            init.init(session);
        }
        return JSONObject.toJSONString(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/restful")
    public String callRestServiceful(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context MultivaluedMap<String, String> formParams) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            String postparam = this.addParamToJsonParams(sessionobj, formParams, "method", "session", "param");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            String string = result;
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportReport")
    public Response callExportReportExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            String fileaname = retdata.toString();
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportExcelReport")
    public Response callExportOnlyReportExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                retdata = this.ResponseToString(sessionobj, json, (ServiceResponse)retdata);
            }
            String fileaname = retdata.toString();
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportExcel")
    public Response callExportExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            FileServiceImpl temp = new FileServiceImpl();
            String head = "/opt/logs/";
            temp.setHead(head);
            String fileaname = temp.export(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportTemplate")
    public Response callExportTemplateService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            String fileaname = temp.exportTemplate(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportLC")
    public Response callExportLCService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            String fileaname = temp.exportLC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportNC")
    public Response callExportNCService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            String fileaname = temp.exportNC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportPrint")
    public Response callExportPrintService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            String fileaname = json.getString("data");
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/createExcel")
    public String callcreateExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String head = this.request.getSession().getServletContext().getRealPath("/");
            temp.setHead(head);
            String retdata = temp.exportExcelPrint(sessionobj, json);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("data", retdata);
            m.put("returncode", rtncode);
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(m));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            String string = result;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            rtncode = "555";
            String string = result;
            return string;
        }
        finally {
            locale.remove();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportgroup")
    public Response callExportServiceGrpGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportServiceGrpPost(method, session, param, null, filename, headers);
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportgroup")
    public Response callExportServiceGrpPost(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "custgroup.xls";
            }
            String headType = "application/octet-stream";
            String s = String.valueOf(retdata).toLowerCase();
            if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                headType = "application/ms-excel";
            }
            File fp = new File(s);
            filename = fp.getName();
            Response.ResponseBuilder builder = Response.ok((Object)fp);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            this.response.setCharacterEncoding("UTF-8");
            builder.type(headType);
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/captcha")
    @Produces(value={"application/octet-stream"})
    public Response previewCaptcha(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers, @Context MultivaluedMap<String, String> formParams) throws Exception {
        JSONObject data;
        long start_time = System.currentTimeMillis();
        ServiceSession sessionobj = null;
        sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        String postparam = this.addParamToJsonParam(sessionobj, formParams, "method", "session", "param");
        this.response.setDateHeader("Expires", 0L);
        this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        this.response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setContentType("image/jpeg");
        Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
        if (retdata instanceof ServiceResponse && ((ServiceResponse)retdata).getReturncode().equals("0") && (data = (JSONObject)((ServiceResponse)retdata).getData()).containsKey((Object)"capBuff") && data.get((Object)"capBuff") instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)data.get((Object)"capBuff");
            ServletOutputStream out = this.response.getOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
            try {
                out.flush();
            }
            finally {
                out.close();
            }
        }
        return null;
    }

    private String addParamToJsonParam(ServiceSession session, MultivaluedMap<String, String> formParams, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey2 = UserDataRangeSrv.getPortalkey();
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey2) && portalkey2.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        Map<String, Object> rps = this.getParameters(formParams);
        map.putAll(rps);
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey2)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey2, InitSession.class);
            init.init(session);
        }
        return JSONObject.toJSONString(map);
    }

    private String ResponseToString(ServiceSession session, JSONObject jsonparam, ServiceResponse ret) throws Exception {
        String excel;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        int rowMaxCount = 60000;
        int dbRowMaxCount = 20000;
        ReportServiceImpl report = new ReportServiceImpl();
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get((Object)key));
        }
        RowBounds rowBounds = new RowBounds(0, rowMaxCount);
        ArrayList<String> filelist = new ArrayList<String>();
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = sdfymdCard.format(new Date());
        String exceltype = null;
        exceltype = StringUtils.isEmpty(map.get("filetype")) ? "XLSX" : ("1".equals(excel = map.get("filetype").toString()) ? "XLS" : "XLSX");
        boolean flag = true;
        int row = 1;
        do {
            String file;
            Object tempfileName = fileName;
            List list = null;
            if (ret.getReturncode().equals("0")) {
                if (ret.getData() != null) {
                    Object data = ret.getData();
                    if (data instanceof JSONArray) {
                        list = (List)data;
                    } else if (data instanceof List) {
                        list = (List)data;
                    } else {
                        JSONObject dataobj = (JSONObject)ret.getData();
                        list = data != null && !StringUtils.isEmpty((Object)dataobj.get((Object)MapUtils.getString((Map)jsonparam, "datakey", "report"))) ? (List)dataobj.get((Object)MapUtils.getString((Map)jsonparam, "datakey", "report")) : new ArrayList();
                    }
                }
            } else {
                throw new Exception(ret.getData().toString());
            }
            if (list.size() < rowMaxCount) {
                if (row != 1) {
                    tempfileName = (String)tempfileName + "(" + row + ")";
                }
                file = report.createExcel(list, (String)tempfileName, fldlst, disps, fmts, exceltype);
                filelist.add(file);
                flag = false;
                continue;
            }
            tempfileName = (String)tempfileName + "(" + row + ")";
            file = report.createExcel(list, (String)tempfileName, fldlst, disps, fmts, exceltype);
            filelist.add(file);
            rowBounds = new RowBounds((++row - 1) * rowMaxCount, rowMaxCount);
        } while (flag);
        String reFile = "";
        reFile = filelist.size() > 1 ? report.makezip(filelist) : (String)filelist.get(0);
        return reFile;
    }

    protected void analyzeExportFields(String specfld, StringBuffer flds, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts) {
        String[] fields;
        for (String s : fields = specfld.split(",")) {
            String[] ss = s.split(":");
            flds.append(ss[0].trim() + ",");
            fldlst.add(ss[0].trim());
            if (ss.length > 1) {
                disps.put(ss[0].trim(), ss[1].trim());
                if (ss.length <= 2) continue;
                fmts.put(ss[0].trim(), ss[2].trim().replace(";", ","));
                continue;
            }
            disps.put(ss[0].trim(), ss[0].trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/filebrowers")
    public String callFileBrowersService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        ServiceSession sessionobj = null;
        sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        if (param == null) {
            param = "";
        }
        param = URLDecoder.decode(param);
        Object retdata = null;
        param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");
        String result = null;
        String rtncode = null;
        try {
            retdata = rcm.executeClassMethod(method, sessionobj, param);
            if (retdata == null) {
                return "";
            }
            result = retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            rtncode = "555";
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/filebrower")
    @Produces(value={"application/octet-stream"})
    public Response callFileBrowerService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        long start_time = System.currentTimeMillis();
        ServiceSession sessionobj = null;
        sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        if (param == null) {
            param = "";
        }
        param = URLDecoder.decode(param);
        param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");
        JSONObject params = JSONObject.parseObject((String)param);
        Object retdata = null;
        OutputStream out = null;
        try {
            String thumbnail = params.getString("thumbnail");
            String operate = params.getString("operate");
            String[] wh = null;
            if (StringUtils.hasLength((String)thumbnail)) {
                wh = thumbnail.indexOf(",") > 0 ? thumbnail.split(",") : thumbnail.split(":");
            }
            if ((retdata = rcm.executeClassMethod(method, sessionobj, param)) != null && retdata instanceof FileObject) {
                FileObject fo = (FileObject)retdata;
                String fn = fo.getFilename();
                this.response.setCharacterEncoding("UTF-8");
                String ext = ImageTools.isImage(fo.getFilename());
                if (StringUtils.hasLength((String)ext) && !"download".equals(operate)) {
                    this.response.setContentType("image/" + ext);
                } else {
                    this.response.setContentType(fo.getContentType());
                    this.response.setHeader("Content-Disposition", Utils.builderContentDispositionFileName(headers, fn));
                }
                out = this.response.getOutputStream();
                if (wh != null && wh.length > 0) {
                    try {
                        BufferedImage img = ImageIO.read(fo.getStream());
                        ImageTools.buildThumbnailImage(img, out, Integer.parseInt(wh[0]), wh.length > 1 && !wh[0].equals(wh[1]) ? Integer.parseInt(wh[1]) : -1);
                    }
                    catch (Exception ex2) {
                        InputStream in = fo.getStream();
                        byte[] buffer = new byte[4096];
                        int len = 0;
                        while ((len = in.read(buffer, 0, 4096)) != -1) {
                            out.write(buffer, 0, len);
                        }
                    }
                } else {
                    InputStream in = fo.getStream();
                    byte[] buffer = new byte[4096];
                    int len = 0;
                    while ((len = in.read(buffer, 0, 4096)) != -1) {
                        out.write(buffer, 0, len);
                    }
                }
                out.flush();
            }
        }
        finally {
            if (retdata != null && retdata instanceof FileObject) {
                FileObject fo = (FileObject)retdata;
                try {
                    fo.getStream().close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/fileupload")
    @Produces(value={"application/json;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callFileUploadService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form) {
        String string;
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        ServiceSession sessionobj = null;
        try {
            String key2;
            ServiceVersion.getInstance().debugLog("start uploading.");
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            if (param == null) {
                param = "";
            }
            param = URLDecoder.decode(param);
            param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");
            Map mapFormData = form.getFields();
            Set sets = mapFormData.keySet();
            for (String key2 : sets) {
                Iterator parts = (List)mapFormData.get(key2);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    String encoding = this.request.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    filename = new String(filename.getBytes("ISO-8859-1"), "GBK");
                    ServiceVersion.getInstance().debugLog("filename:" + key2 + "=" + filename);
                    if (ObjectUtils.isEmpty((Object)filename)) continue;
                    FileObject fio = new FileObject();
                    fio.setFiledKey(key2);
                    fio.setFilename(filename);
                    fio.setStream((InputStream)part.getValueAs(InputStream.class));
                    fio.setContentType(part.getMediaType().getType());
                    fio.setSize((long)fio.getStream().available());
                    list.add(fio);
                }
            }
            Object retdata = rcm.executeClassMethodForListParam(method, sessionobj, param, list);
            if (retdata == null) {
                key2 = "";
                return key2;
            }
            if (retdata instanceof String) {
                key2 = (String)retdata;
                return key2;
            }
            key2 = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return key2;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            for (FileObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception in) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/filerest")
    public String callFileRemoveService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        ServiceSession sessionobj = null;
        sessionobj = !StringUtils.hasLength((String)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        if (param == null) {
            param = "";
        }
        param = URLDecoder.decode(param, "UTF-8");
        Object retdata = null;
        param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param");
        String result = null;
        String rtncode = null;
        try {
            retdata = rcm.executeClassMethod(method, sessionobj, param);
            if (retdata == null) {
                return "";
            }
            result = retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return result;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            rtncode = "555";
            return result;
        }
    }
}

