/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.slice.filter;

import com.efuture.ocp.common.slice.filter.CollectionSQLWrapper;
import com.efuture.ocp.common.util.DataUtils;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CollectionSliceWrapper
extends CollectionSQLWrapper {
    public static final Logger logger = LoggerFactory.getLogger(CollectionSliceWrapper.class);

    protected boolean isWrapper(String sqlSelect, String organizationCode, String slice) {
        String message = "";
        if (CollectionSliceWrapper.getOrganizationMap().containsKey(organizationCode) || !StringUtils.isEmpty((Object)slice)) {
            message = String.format("\u7ec4\u7ec7\u673a\u6784\u3010%1$s\u3011\u5b58\u5728\u5206\u7247\u5b9a\u4e49", DataUtils.nvl(organizationCode, slice));
            String[] sqlKeys = sqlSelect.split("[\\s()]+");
            Set<String> collectionSet = CollectionSliceWrapper.getCollectionMap().keySet();
            for (String collectionName : collectionSet) {
                for (String key : sqlKeys) {
                    if (!key.toLowerCase().equals(collectionName)) continue;
                    CollectionSliceWrapper.sliceFilterLog("--->{},\u5339\u914d\u8868:{}", message, collectionName);
                    return true;
                }
            }
        }
        message = String.format("--->\u7ec4\u7ec7\u673a\u6784\u3010%1$s\u3011\u4e0d\u5b58\u5728\u5206\u7247\u5b9a\u4e49\u6216\u8005\u6ca1\u6709\u9700\u8981\u5206\u7247\u7684\u8868", DataUtils.nvl(organizationCode, slice));
        CollectionSliceWrapper.sliceFilterLog(message, new Object[0]);
        return false;
    }

    protected String getPartionWhere(String collectionName, String collectionAlias, String organizationCode, String sliceKey) {
        String response = "";
        String tableName = collectionName.toLowerCase();
        if (CollectionSliceWrapper.getCollectionMap().keySet().contains(tableName)) {
            String fieldName = CollectionSliceWrapper.getCollectionMap().get(tableName);
            String partionKey = null;
            if (CollectionSliceWrapper.getOrganizationMap().containsKey(organizationCode)) {
                partionKey = CollectionSliceWrapper.getOrganizationMap().get(organizationCode);
            } else if (!StringUtils.isEmpty((Object)sliceKey)) {
                partionKey = sliceKey;
            }
            if (!StringUtils.isEmpty((Object)partionKey)) {
                response = !StringUtils.isEmpty((Object)collectionAlias) ? String.format("%1$s.%2$s = '%3$s'", collectionAlias, fieldName, partionKey) : String.format("%1$s = '%2$s'", fieldName, partionKey);
            }
        }
        return response;
    }
}

