/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.slice.filter;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.slice.filter.CollectionInsertWrapper;
import com.efuture.ocp.common.slice.filter.ExecutorCallback;
import com.efuture.ocp.common.util.UniqueID;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class ExecutorSliceWrapper
extends CollectionInsertWrapper
implements Interceptor {
    public static final Logger logger = LoggerFactory.getLogger((String)"sliceLogger");

    private static String getParameterValue(Object obj) {
        Object value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", ExecutorSliceWrapper.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", ExecutorSliceWrapper.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", ExecutorSliceWrapper.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sqlId, long time) {
        String sql = ExecutorSliceWrapper.showSql(configuration, boundSql);
        StringBuilder str = new StringBuilder(100);
        str.append(sqlId);
        str.append(":");
        str.append(sql);
        str.append(": \u6267\u884c\u8017\u65f6");
        str.append(time);
        str.append("ms");
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (!ExecutorSliceWrapper.isEnableSlice()) {
            ExecutorSliceWrapper.sliceFilterLog("efuture.slice.enable is false!", new Object[0]);
            return invocation.proceed();
        }
        final long interceptID = UniqueID.getUniqueID();
        long startTime = System.currentTimeMillis();
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[MAPPED_STATEMENT_INDEX];
        String sqlStatement = "";
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        String sqlId = mappedStatement.getId();
        Configuration configuration = mappedStatement.getConfiguration();
        if (invocation.getArgs().length == 6) {
            boundSql = (BoundSql)invocation.getArgs()[BOUNDSQL_INDEX];
        }
        if (this.isParaTable(sqlStatement = boundSql.getSql())) {
            return invocation.proceed();
        }
        ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->1--->%2$s--->%3$s", interceptID, "\u8fdb\u5165\u5206\u7247\u62e6\u622a\u5668", sqlStatement.replaceAll("[\\s]+", " ")), new Object[0]);
        String organizationCode = ExecutorSliceWrapper.getCurrentEntMarket();
        String slice = null;
        JSONObject logJson = new JSONObject();
        if (StringUtils.isEmpty((Object)organizationCode) && StringUtils.isEmpty((Object)(slice = ExecutorSliceWrapper.getCurrentSlice()))) {
            ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->1--->%2$s--->%3$s", interceptID, "\u672a\u4f20\u5165\u5206\u7247\u4fe1\u606f", sqlStatement.replaceAll("[\\s]+", " ")), new Object[0]);
            if (this.isNoFindErrorTable(sqlStatement)) {
                throw new Exception("\u672a\u4f20\u5165\u5206\u7247\u4fe1\u606f");
            }
            return invocation.proceed();
        }
        ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->2--->\u53c2\u6570\u4e3aMap", interceptID), new Object[0]);
        ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->3--->organizationCode--->%2$s", interceptID, organizationCode), new Object[0]);
        boolean isexec = false;
        if (this.isWrapper(sqlStatement, organizationCode, slice)) {
            isexec = true;
            ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->4--->isWrapper--->%2$b", interceptID, isexec), new Object[0]);
        }
        if (!isexec) {
            if (this.isNoFindErrorTable(sqlStatement)) {
                throw new Exception("\u7ec4\u7ec7\u673a\u6784\u627e\u4e0d\u5230\u5206\u7247\u5b9a\u4e49");
            }
            return invocation.proceed();
        }
        ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->5--->organizationCode--->%2$s", interceptID, organizationCode), new Object[0]);
        final String partionKey = organizationCode;
        final String sliceKey = slice;
        ExecutorCallback callback = new ExecutorCallback(){

            @Override
            public void onAction(SQLSelectQueryBlock query, String collectionName, String collectionAlias) {
                SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
                String authWhereSql = ExecutorSliceWrapper.this.getPartionWhere(collectionName, collectionAlias, partionKey, sliceKey);
                if (!StringUtils.isEmpty((Object)authWhereSql)) {
                    ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->6--->partionKey authWhereSql--->1--->%2$s", interceptID, authWhereSql), new Object[0]);
                    SQLExpr authWhereExpr = ExecutorSliceWrapper.this.getWhereInfo(authWhereSql);
                    if (query.getWhere() != null && query.getWhere() instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)query.getWhere();
                        if (whereExpr != null) {
                            newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                            newWhereExpr.setLeft(authWhereExpr);
                            newWhereExpr.setRight((SQLExpr)whereExpr);
                        }
                    } else {
                        newWhereExpr = authWhereExpr;
                    }
                    query.setWhere((SQLExpr)newWhereExpr);
                }
            }
        };
        try {
            List statementList = SQLUtils.parseStatements((String)sqlStatement, (String)this.getDbType());
            for (SQLStatement stmt : statementList) {
                logJson.put("selectSql", (Object)sqlStatement);
                if (stmt instanceof SQLSelectStatement) {
                    ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->7--->SqlType--->1--->%2$s", interceptID, "SQLSelectStatement"), new Object[0]);
                    this.onSelectStatement(logger, sqlStatement, logJson, invocation, mappedStatement, boundSql, stmt, callback);
                    continue;
                }
                if (stmt instanceof SQLUpdateStatement) {
                    ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->8--->SqlType--->1--->%2$s", interceptID, "SQLUpdateStatement"), new Object[0]);
                    this.onUpdateStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey, sliceKey);
                    continue;
                }
                if (stmt instanceof SQLDeleteStatement) {
                    ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->9--->SqlType--->1--->%2$s", interceptID, "SQLDeleteStatement"), new Object[0]);
                    this.onDeleteStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey, sliceKey);
                    continue;
                }
                if (!(stmt instanceof SQLInsertStatement)) continue;
                ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->10--->SqlType--->1--->%2$s", interceptID, "SQLInsertStatement"), new Object[0]);
                this.onInsertStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey, sliceKey);
            }
            ExecutorSliceWrapper.sliceFilterLog(logJson.toJSONString(), new Object[0]);
        }
        catch (Exception e) {
            invocation.getArgs()[0] = mappedStatement;
            ExecutorSliceWrapper.sliceFilterLog(String.format("intercept(%1$d)--->11--->newSQL --->Faiure:%2$s ---> %3$s", interceptID, e.getMessage(), sqlStatement), new Object[0]);
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", (Object)sqlStatement);
        }
        long endTime = System.currentTimeMillis();
        ExecutorSliceWrapper.sliceFilterLog("mybatis\u5206\u7247\u7ec4\u88c5\u8017\u8d39\u65f6\u95f4:----{} --->{}", interceptID, startTime - endTime);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            String logSql = ExecutorSliceWrapper.showSql(configuration, ((MappedStatement)invocation.getArgs()[MAPPED_STATEMENT_INDEX]).getBoundSql(parameter));
            ServiceLogs.debuglog("db_succ", logSql, startTime);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dbType = properties.getProperty("dbType");
        if (dbType == null || dbType.equals("")) {
            this.setDbType("mysql");
        } else {
            this.setDbType(dbType);
        }
    }
}

