/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final DateFormat Format = new SimpleDateFormat("yyyy-MM-dd");

    public static String dateToString(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String getMaxMonthDate(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(Format.parse(date));
            calendar.set(5, calendar.getActualMaximum(5));
            return Format.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPreviousSunday() {
        int mondayPlus = DateUtils.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus + 6);
        Date monday = currentDate.getTime();
        String preMonday = Format.format(monday);
        return preMonday;
    }

    private static int getMondayPlus() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7);
        if (dayOfWeek == 1) {
            return -6;
        }
        return 2 - dayOfWeek;
    }

    public static String getCurrentMonday() {
        int mondayPlus = DateUtils.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus);
        Date monday = currentDate.getTime();
        String format = Format.format(monday);
        return format;
    }

    public static String getMinMonthDate(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(Format.parse(date));
            calendar.set(5, calendar.getActualMinimum(5));
            return Format.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDaySub(String beginDateStr, String endDateStr) {
        int day = 0;
        try {
            Date beginDate = Format.parse(beginDateStr);
            Date endDate = Format.parse(endDateStr);
            day = (int)((endDate.getTime() - beginDate.getTime()) / 86400000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    public static List<String> getDays(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        try {
            Date start = Format.parse(startTime);
            Date end = Format.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(Format.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static Date gettoday() {
        return DateUtils.trunctoday(new Date());
    }

    public static Date trunctoday(Date d) {
        return DateUtils.truncate((Date)d, (int)5);
    }

    public static long getDaysBetween(Date startDate, Date endDate) {
        return (DateUtils.trunctoday(startDate).getTime() - DateUtils.trunctoday(endDate).getTime()) / 86400000L + 1L;
    }

    public static long getDayOfWeek(Date date) {
        return DateUtils.toCalendar((Date)date).get(7);
    }

    public static Date getFirstDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return calendar.getTime();
    }

    public static String getWeek(Date date) {
        return String.valueOf(DateUtils.getDayOfWeek(date) - 1L);
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static String getTodayStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(DateUtils.gettoday());
    }

    public static String getDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String getDateTimeStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static long strDateTimeLong(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getDateTimeDuration(long endTime, long startTime) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        Object time = "";
        long diff = endTime - startTime;
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        String d = day + " day, " + hour + ":" + min + ":" + sec;
        String h = hour + ":" + min + ":" + sec;
        time = day == 0L ? h : d;
        return time;
    }

    public static String getNowStr() {
        return DateUtils.getDateTimeStr(new Date());
    }

    public static Date addQuarterStartDay(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int quarter = DateUtils.getQuarterFromMonth(month);
        int nextQuarter = quarter + amount;
        int y = nextQuarter / 4;
        int i = nextQuarter % 4;
        if (nextQuarter == 0) {
            nextQuarter = 4;
            y = -1;
            year += y;
        }
        if (y >= 1 && nextQuarter > 4) {
            nextQuarter = i;
            year += y;
        }
        month = DateUtils.getStartMonthFromQuarter(nextQuarter);
        calendar.set(year, month, 1);
        return calendar.getTime();
    }

    public static int getQuarterFromMonth(int month) {
        int quarter = 0;
        quarter = month <= 2 ? 1 : (month >= 3 && month <= 5 ? 2 : (month >= 6 && month <= 8 ? 3 : (month >= 9 && month <= 11 ? 4 : 0)));
        return quarter;
    }

    public static int getStartMonthFromQuarter(int quarter) {
        int startMonth = 0;
        switch (quarter) {
            case 1: {
                startMonth = 0;
                break;
            }
            case 2: {
                startMonth = 3;
                break;
            }
            case 3: {
                startMonth = 6;
                break;
            }
            case 4: {
                startMonth = 9;
            }
        }
        return startMonth;
    }
}

