/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.component.ResourceService;
import com.efuture.ocp.common.entity.FileInfo;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.ExcelUtils;
import com.efuture.ocp.common.util.IniReader;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.github.pagehelper.Page;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.ibatis.session.RowBounds;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class FileServiceImpl
extends BasicComponent {
    private static int rowMaxCount = 60000;
    private static int dbRowMaxCount = 20000;
    private SXSSFWorkbook xlsx = null;
    private HSSFWorkbook xls = null;
    final String ResouceBean = "amp.resource";
    private static final String STATIC_XLS = "XLS";
    private static final String STATIC_XLSX = "XLSX";
    private static final String STATIC_LEFT = "left";
    private static final String STATIC_CENTER = "center";
    private static final String STATIC_RIGHT = "right";
    private String filePath = this.getFilePath();
    private List<String> creatFileList = new ArrayList<String>();
    private List<CellStyle> stylelist = new ArrayList<CellStyle>();
    private Map<String, Integer> fldstyle = new HashMap<String, Integer>();
    SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
    ExecutorService exe = Executors.newFixedThreadPool(3);
    private int rowIndex = 0;
    private int cellIndex = 0;
    private int ROW_MAX = 20000;
    private int COLUMN_MAX = 106;
    private double defaultWidth = 0.67;
    private int defaultHigh = 25;
    private double defaultRangCell = 0.3;
    private double defaulttextCell = 0.1;
    private int defaultGreadCell = 0;

    public void addFile(String file) {
        this.creatFileList.add(file);
    }

    public String getFilePath() {
        Environment env = (Environment)SpringBeanFactory.getContext().getBean(Environment.class);
        String filePath = env.getProperty("efuture.temp.file", "");
        String osname = System.getProperties().getProperty("os.name").toLowerCase();
        if (StringUtils.isEmpty((Object)filePath)) {
            String head = "";
            if (osname.startsWith("win")) {
                head = "D:\\file\\";
                File dir = new File(head);
                if (!dir.exists() && !dir.mkdirs()) {
                    head = "C:\\file\\";
                }
            } else {
                head = "/opt/file/";
                File dir = new File(head);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
            }
            filePath = head;
        } else if (osname.startsWith("win")) {
            if (!filePath.endsWith("\\")) {
                filePath = filePath + "\\";
            }
        } else if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        return filePath;
    }

    /*
     * WARNING - void declaration
     */
    private void exportDataToExcel(List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, SXSSFWorkbook xlsx, HSSFWorkbook xls, String exceltype, String modelFileName) {
        Cell cell;
        Sheet sheet = null;
        CellStyle columnHeadStyle = null;
        CellStyle cellString = null;
        Font f = null;
        if (fldlst == null) {
            fldlst = new ArrayList<String>();
        }
        if (disps == null) {
            disps = new HashMap<String, String>();
        }
        if (fmts == null) {
            fmts = new HashMap<String, String>();
        }
        if (STATIC_XLSX.equals(exceltype)) {
            columnHeadStyle = xlsx.createCellStyle();
            cellString = xlsx.createCellStyle();
            f = xlsx.createFont();
            sheet = StringUtils.isEmpty((Object)modelFileName) ? xlsx.createSheet("Sheet1") : xlsx.getSheetAt(0);
        } else {
            columnHeadStyle = xls.createCellStyle();
            cellString = xls.createCellStyle();
            f = xls.createFont();
            sheet = StringUtils.isEmpty((Object)modelFileName) ? xls.createSheet("Sheet1") : xls.getSheetAt(0);
        }
        columnHeadStyle.setBorderBottom((short)1);
        columnHeadStyle.setBorderLeft((short)1);
        columnHeadStyle.setBorderRight((short)1);
        columnHeadStyle.setBorderTop((short)1);
        columnHeadStyle.setAlignment((short)2);
        columnHeadStyle.setVerticalAlignment((short)1);
        columnHeadStyle.setWrapText(true);
        f.setFontHeightInPoints((short)9);
        f.setBoldweight((short)700);
        columnHeadStyle.setFont(f);
        cellString.setBorderBottom((short)1);
        cellString.setBorderLeft((short)1);
        cellString.setBorderRight((short)1);
        cellString.setBorderTop((short)1);
        cellString.setVerticalAlignment((short)1);
        if (STATIC_XLSX.equals(exceltype)) {
            cellString.setDataFormat(xlsx.createDataFormat().getFormat("@"));
        } else {
            cellString.setDataFormat(xls.createDataFormat().getFormat("@"));
        }
        cellString.setAlignment((short)1);
        cellString.setWrapText(true);
        this.stylelist.add(cellString);
        Row row = sheet.createRow(0);
        sheet.createFreezePane(0, 1, 0, 1);
        int i = 0;
        for (String string : fldlst) {
            cell = row.createCell(i);
            cell.setCellStyle(columnHeadStyle);
            cell.setCellValue(disps.get(string));
            sheet.setColumnWidth(i, 7000);
            ++i;
        }
        HashMap<String, Object> cellstyle = new HashMap<String, Object>();
        for (String s : fldlst) {
            String style = fmts.get(s);
            cellstyle.put(s, this.getCellStyle(s, style, xlsx, xls, exceltype));
        }
        boolean bl = true;
        int index = 0;
        if (list != null) {
            for (int j = 0; j < list.size(); ++j) {
                void var17_20;
                row = sheet.createRow((int)(++var17_20));
                Map<String, Object> map = list.get(j);
                index = 0;
                for (String s : fldlst) {
                    cell = row.createCell(index++);
                    Object obj = map.get(s);
                    String style = fmts.get(s);
                    this.setCellsValueTyle(cellstyle, cell, obj, s, style, xlsx, xls, exceltype);
                }
            }
        }
    }

    protected void setCellsValueTyle(Map<String, Object> map, Cell cell, Object obj, String fld, String style, SXSSFWorkbook xlsx, HSSFWorkbook xls, String exceltype) {
        CellStyle cellStyle = (CellStyle)map.get(fld);
        if (obj != null) {
            if (!StringUtils.isEmpty((Object)style)) {
                if (style.startsWith("d")) {
                    Date date = null;
                    String datestyle = "yyyy-MM-dd";
                    if (obj.toString().length() > 10) {
                        datestyle = "yyyy-MM-dd HH:mm:ss";
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(datestyle);
                    if (obj instanceof Date) {
                        date = (Date)obj;
                    } else {
                        try {
                            date = sdf.parse(obj.toString());
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    cell.setCellValue(date);
                    cell.setCellStyle(cellStyle);
                } else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    cell.setCellValue(Double.parseDouble(obj.toString()));
                    cell.setCellStyle(cellStyle);
                }
            } else {
                cell.setCellValue(obj.toString());
                cell.setCellStyle(cellStyle);
            }
        } else {
            cell.setCellStyle(cellStyle);
        }
    }

    protected CellStyle getCellStyle(String fld, String style, SXSSFWorkbook xlsx, HSSFWorkbook xls, String exceltype) {
        Object cellStyle = null;
        cellStyle = STATIC_XLSX.equals(exceltype) ? xlsx.createCellStyle() : xls.createCellStyle();
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        int cellcul = -1;
        CreationHelper creationHelper = null;
        if (this.fldstyle.containsKey(fld)) {
            cellcul = this.fldstyle.get(fld);
        }
        if (cellcul == -1) {
            if (!StringUtils.isEmpty((Object)style)) {
                String excelstyle = "";
                String[] dformat = style.split("=");
                int align = 0;
                if (style.startsWith("d")) {
                    align = 2;
                    excelstyle = "yyyy\u5e74m\u6708d\u65e5";
                } else if (style.startsWith("n") || style.startsWith("c") || style.startsWith("p")) {
                    align = 3;
                    String numStyle = "";
                    if (dformat[0].length() > 1) {
                        numStyle = dformat[0].substring(1, dformat[0].length());
                    }
                    if (!StringUtils.isEmpty((Object)numStyle)) {
                        if (style.startsWith("n")) {
                            excelstyle = "0";
                        } else if (style.startsWith("c")) {
                            excelstyle = "\u00a5#,##0";
                        } else if (style.startsWith("p")) {
                            excelstyle = "0";
                        }
                        int count = Integer.valueOf(numStyle);
                        String tempStyle = "";
                        if (count > 0) {
                            for (int i = 0; i < count; ++i) {
                                tempStyle = tempStyle + "0";
                            }
                        }
                        if (!StringUtils.isEmpty((Object)tempStyle)) {
                            excelstyle = excelstyle + "." + tempStyle;
                        }
                        if (style.startsWith("p")) {
                            excelstyle = excelstyle + '%';
                        }
                    } else if (style.startsWith("n")) {
                        excelstyle = "0.00";
                    } else if (style.startsWith("c")) {
                        excelstyle = "\u00a5#,##0.00";
                    } else if (style.startsWith("p")) {
                        excelstyle = "0.00%";
                    }
                } else {
                    align = 1;
                    excelstyle = "@";
                }
                if (dformat.length > 1 && !StringUtils.isEmpty((Object)dformat[1])) {
                    excelstyle = dformat[1];
                }
                if (dformat.length > 2 && !StringUtils.isEmpty((Object)dformat[2])) {
                    if (STATIC_LEFT.equals(dformat[2].toLowerCase())) {
                        align = 1;
                    } else if (STATIC_CENTER.equals(dformat[2].toLowerCase())) {
                        align = 2;
                    } else if (STATIC_RIGHT.equals(dformat[2].toLowerCase())) {
                        align = 3;
                    }
                }
                if (STATIC_XLSX.equals(exceltype)) {
                    if (excelstyle.equals("yyyy-MM-dd") || excelstyle.equals("yyyy-MM-dd HH:mm:ss")) {
                        creationHelper = xlsx.getCreationHelper();
                        cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(excelstyle));
                    } else {
                        cellStyle.setDataFormat(xlsx.createDataFormat().getFormat(excelstyle));
                    }
                } else if (excelstyle.equals("yyyy-MM-dd") || excelstyle.equals("yyyy-MM-dd HH:mm:ss")) {
                    creationHelper = xls.getCreationHelper();
                    cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(excelstyle));
                } else {
                    cellStyle.setDataFormat(xls.createDataFormat().getFormat(excelstyle));
                }
                cellStyle.setVerticalAlignment((short)1);
                cellStyle.setAlignment((short)align);
            } else {
                if (STATIC_XLSX.equals(exceltype)) {
                    cellStyle.setDataFormat(xlsx.createDataFormat().getFormat("@"));
                } else {
                    cellStyle.setDataFormat(xls.createDataFormat().getFormat("@"));
                }
                cellStyle.setAlignment((short)1);
                cellStyle.setWrapText(true);
                cellStyle.setVerticalAlignment((short)1);
            }
        } else {
            if (STATIC_XLSX.equals(exceltype)) {
                cellStyle.setDataFormat(xlsx.createDataFormat().getFormat("@"));
            } else {
                cellStyle.setDataFormat(xls.createDataFormat().getFormat("@"));
            }
            cellStyle.setAlignment((short)1);
            cellStyle.setWrapText(true);
            cellStyle.setVerticalAlignment((short)1);
        }
        return cellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createExcel(List<Map<String, Object>> list, String fileName, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype, String modelFileName) throws Exception {
        SXSSFWorkbook xlsx = null;
        HSSFWorkbook xls = null;
        File dir = new File(this.filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String tempExcelFile = "";
        if (!StringUtils.isEmpty((Object)modelFileName)) {
            exceltype = modelFileName.endsWith("xlsx") ? STATIC_XLSX : STATIC_XLS;
        }
        tempExcelFile = STATIC_XLSX.equals(exceltype) ? this.filePath + fileName + ".xlsx" : this.filePath + fileName + ".xls";
        InputStream isin = null;
        if (!StringUtils.isEmpty((Object)modelFileName)) {
            isin = this.getModelFile(modelFileName);
        }
        int rowMemory = 1024;
        FileOutputStream fos = new FileOutputStream(tempExcelFile);
        if (STATIC_XLSX.equals(exceltype)) {
            try {
                if (isin != null) {
                    XSSFWorkbook tmp = new XSSFWorkbook(isin);
                    xlsx = new SXSSFWorkbook(tmp, rowMemory);
                } else {
                    xlsx = new SXSSFWorkbook(rowMemory);
                }
                this.exportDataToExcel(list, fldlst, disps, fmts, xlsx, null, STATIC_XLSX, modelFileName);
                xlsx.write((OutputStream)fos);
                fos.flush();
                fos.close();
            }
            finally {
                fos.flush();
                fos.close();
                if (list != null) {
                    list.clear();
                }
            }
        }
        try {
            xls = isin != null ? new HSSFWorkbook(isin) : new HSSFWorkbook();
            this.exportDataToExcel(list, fldlst, disps, fmts, null, xls, STATIC_XLS, modelFileName);
            xls.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        finally {
            fos.flush();
            fos.close();
            list.clear();
        }
        return tempExcelFile;
    }

    public String export(ServiceSession session, JSONObject jsonparam) throws Exception {
        String excel;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        String field = jsonparam.getString("fields");
        this.analyzeExportFields2(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        int maxRowNum = rowMaxCount;
        int maxDataNum = rowMaxCount;
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"maxrownum"))) {
            maxRowNum = Integer.valueOf(jsonparam.getString("maxrownum"));
        }
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"maxdatanum"))) {
            maxDataNum = Integer.valueOf(jsonparam.getString("maxdatanum"));
        }
        if (maxDataNum > rowMaxCount) {
            maxDataNum = rowMaxCount;
        }
        if (maxRowNum > maxDataNum) {
            maxRowNum = maxDataNum;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryid", jsonparam.getString("queryid"));
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            if ("maxrownum".equals(key) || "maxdatanum".equals(key)) continue;
            map.put(key, jsonparam.get((Object)key));
        }
        int sumNum = 0;
        if (!StringUtils.isEmpty(disps.get("totalCount"))) {
            sumNum = Integer.parseInt(((String)disps.get("totalCount")).toString());
            disps.remove("totalCount");
        }
        String modulecode = "";
        if (!StringUtils.isEmpty(disps.get("modulecode"))) {
            modulecode = (String)disps.get("modulecode");
            disps.remove("modulecode");
        }
        if (sumNum == 0) {
            long totalTimeS = System.currentTimeMillis();
            RowBounds sumrowBounds = new RowBounds(0, 1);
            StringBuffer total = new StringBuffer();
            this.doQuery(jsonparam.getString("queryid"), map, sumrowBounds, total);
            sumNum = Integer.parseInt(total.toString());
            long totalTimeE = System.currentTimeMillis();
            System.out.println("SQL(queryid:" + jsonparam.getString("queryid") + ")\u67e5\u8be2\u83b7\u53d6\u884c\u6570(" + sumNum + ")\u65f6\u95f4:" + (totalTimeE - totalTimeS));
        }
        this.creatFileList.clear();
        String modelFileName = "";
        if (!StringUtils.isEmpty((Object)jsonparam.getString("modelfilename"))) {
            modelFileName = jsonparam.getString("modelfilename");
        }
        String fileName = this.sdfymdCard.format(new Date());
        if (!StringUtils.isEmpty((Object)modulecode)) {
            fileName = modulecode + "_" + fileName;
        }
        String exceltype = null;
        exceltype = StringUtils.isEmpty(map.get("filetype")) ? STATIC_XLSX : ("1".equals(excel = map.get("filetype").toString()) ? STATIC_XLS : STATIC_XLSX);
        long startTime = System.currentTimeMillis();
        StringBuffer total = new StringBuffer();
        RowBounds rowBounds = new RowBounds(0, maxDataNum);
        List<Map<String, Object>> list = this.doQuery(map.get("queryid").toString(), map, rowBounds, total);
        this.calSummaryFld(jsonparam, list);
        if (sumNum <= maxRowNum) {
            String filename = fileName + "(\u5408\u8ba1" + sumNum + "\u6761)";
            String file = this.createExcel(list, filename, fldlst, disps, fmts, exceltype, modelFileName);
            this.addFile(file);
        } else {
            this.makeExcelFile(fileName, list, 1, maxRowNum, fldlst, disps, fmts, exceltype, modelFileName);
        }
        String reFile = "";
        reFile = this.creatFileList.size() > 1 ? this.makezip(this.creatFileList, String.valueOf(sumNum)) : this.creatFileList.get(0);
        long endTime = System.currentTimeMillis();
        System.out.println("\u6587\u4ef6(" + reFile + ")\u751f\u6210\u5b8c\u6210\u65f6\u95f4:" + (endTime - startTime));
        String[] temp = reFile.split("\\\\");
        String tempFileName = temp[temp.length - 1];
        this.createExportLog(session, jsonparam.toJSONString(), jsonparam.getString("modulecode"), tempFileName, sumNum);
        return reFile;
    }

    public ServiceResponse asyncExport(final ServiceSession session, final JSONObject jsonparam) throws Exception {
        this.exe.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String filetaskid = jsonparam.get((Object)"filetaskid").toString();
                    FMybatisTemplate storage = (FMybatisTemplate)FileServiceImpl.this.getStorageOperations();
                    Criteria criteria = Criteria.where((String)"ph_key").is((Object)filetaskid).and("filestatus").is((Object)"N");
                    Query query = new Query((CriteriaDefinition)criteria);
                    Map filelog = storage.selectOne(query, "dbusrpub.createexportfile");
                    if (filelog != null) {
                        String filepath = FileServiceImpl.this.export(session, jsonparam);
                        File fp = new File(filepath);
                        String fileName = fp.getName();
                        String[] split = fileName.split("\\.");
                        String fileSuffix = split[split.length - 1];
                        String key = MD5Utils.MD5(fileName + new Date());
                        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
                        byte[] total = new byte[((InputStream)fis).available()];
                        FileInfo item = new FileInfo();
                        item.setFileName(fileName);
                        item.setFileKey(key);
                        item.setFileType(fileSuffix);
                        item.setFileSize(total.length);
                        Map filelog2 = storage.selectOne(query, "dbusrpub.createexportfile");
                        if (filelog2 != null) {
                            ResourceService res = (ResourceService)SpringBeanFactory.getBean("amp.resource");
                            res.uploadFile2(fp, item);
                            Update update = new Update();
                            update.set("filestatus", (Object)"Y");
                            update.set("filekey", (Object)item.getFileKey());
                            update.set("filename", (Object)item.getFileName());
                            storage.update(query, update, "dbusrpub.createexportfile");
                        }
                        FileServiceImpl.this.delFile(fp);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        JSONObject result = new JSONObject();
        result.put("flag", (Object)"1");
        return ServiceResponse.buildSuccess(result);
    }

    private void calSummaryFld(JSONObject jsonparam, List<Map<String, Object>> list) {
        String summary_fld;
        if (jsonparam instanceof JSONObject && jsonparam.containsKey((Object)"summary_fld") && !StringUtils.isEmpty((Object)(summary_fld = jsonparam.getString("summary_fld")))) {
            String[] summary_flds;
            HashMap<String, Double> sumfld = new HashMap<String, Double>();
            for (String fld : summary_flds = summary_fld.split(",")) {
                BigDecimal fldsum = list.stream().filter(o -> !StringUtils.isEmpty(o.get(fld))).map(o -> new BigDecimal(String.valueOf(o.get(fld)))).reduce(BigDecimal.ZERO, BigDecimal::add);
                sumfld.put(fld, fldsum.doubleValue());
            }
            list.add(sumfld);
        }
    }

    public String exportComplex(ServiceSession session, JSONObject jsonparam, List<Map<String, Object>> list) throws Exception {
        String excel;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "fields");
        }
        StringBuffer flds = new StringBuffer();
        ArrayList<String> fldlst = new ArrayList<String>();
        HashMap<String, String> disps = new HashMap<String, String>();
        HashMap<String, String> fmts = new HashMap<String, String>();
        this.analyzeExportFields2(jsonparam.getString("fields"), flds, fldlst, disps, fmts);
        jsonparam.put("fields", (Object)flds.toString());
        int maxRowNum = rowMaxCount;
        int maxDataNum = rowMaxCount;
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"maxrownum"))) {
            maxRowNum = Integer.valueOf(jsonparam.getString("maxrownum"));
        }
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"maxdatanum"))) {
            maxDataNum = Integer.valueOf(jsonparam.getString("maxdatanum"));
        }
        if (maxDataNum > rowMaxCount) {
            maxDataNum = rowMaxCount;
        }
        if (maxRowNum > maxDataNum) {
            maxRowNum = maxDataNum;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());
        for (String key : jsonparam.keySet()) {
            if ("maxrownum".equals(key) || "maxdatanum".equals(key)) continue;
            map.put(key, jsonparam.get((Object)key));
        }
        long sumNum = 0L;
        sumNum = list.size();
        if (!StringUtils.isEmpty(disps.get("totalCount"))) {
            disps.remove("totalCount");
        }
        String modulecode = "";
        if (!StringUtils.isEmpty(disps.get("modulecode"))) {
            modulecode = (String)disps.get("modulecode");
            disps.remove("modulecode");
        }
        this.creatFileList.clear();
        String modelFileName = "";
        if (!StringUtils.isEmpty((Object)jsonparam.getString("modelfilename"))) {
            modelFileName = jsonparam.getString("modelfilename");
        }
        String fileName = this.sdfymdCard.format(new Date());
        if (!StringUtils.isEmpty((Object)modulecode)) {
            fileName = modulecode + "_" + fileName;
        }
        String exceltype = null;
        exceltype = StringUtils.isEmpty(map.get("filetype")) ? STATIC_XLSX : ("1".equals(excel = map.get("filetype").toString()) ? STATIC_XLS : STATIC_XLSX);
        long startTime = System.currentTimeMillis();
        if (sumNum <= (long)maxRowNum) {
            String filename = fileName + "(\u5408\u8ba1" + sumNum + "\u6761)";
            String file = this.createExcel(list, filename, fldlst, disps, fmts, exceltype, modelFileName);
            this.addFile(file);
        } else {
            this.makeExcelFile(fileName, list, 1, maxRowNum, fldlst, disps, fmts, exceltype, modelFileName);
        }
        String reFile = "";
        reFile = this.creatFileList.size() > 1 ? this.makezip(this.creatFileList, String.valueOf(sumNum)) : this.creatFileList.get(0);
        long endTime = System.currentTimeMillis();
        System.out.println("\u6587\u4ef6(" + reFile + ")\u751f\u6210\u5b8c\u6210\u65f6\u95f4:" + (endTime - startTime));
        String[] temp = reFile.split("\\\\");
        String tempFileName = temp[temp.length - 1];
        this.createExportLog(session, jsonparam.toJSONString(), jsonparam.getString("modulecode"), tempFileName, sumNum);
        return reFile;
    }

    private void generateExcelFile(String tempfileName, Map<String, Object> para, int startRowIndex, int maxRowNum, int total, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype) throws Exception {
        int fileNum = (int)Math.ceil((double)total / (double)maxRowNum);
        long startTime = System.currentTimeMillis();
        ExecutorService exe = Executors.newFixedThreadPool(fileNum);
        for (int x = 0; x < fileNum; ++x) {
            String tempfile;
            RowBounds rowBounds = new RowBounds(x * maxRowNum, maxRowNum);
            if (x == 0 && fileNum == 1) {
                tempfile = tempfileName + "(\u5171" + total + "\u6761)";
                exe.execute(new queryMakeFile(tempfile, para, rowBounds, fldlst, disps, fmts, exceltype, null));
                continue;
            }
            tempfile = tempfileName + "(" + x * maxRowNum + "-" + (total < (x + 1) * maxRowNum ? total : (x + 1) * maxRowNum) + "\u6761)";
            exe.execute(new queryMakeFile(tempfile, para, rowBounds, fldlst, disps, fmts, exceltype, null));
        }
        exe.shutdown();
        while (!exe.isTerminated()) {
            Thread.sleep(50L);
        }
        long endTime = System.currentTimeMillis();
        System.out.println(total + "\u884c\u6570\u636e\u5199\u5165\u6587\u4ef6\u5b8c\u6210\u65f6\u95f4:" + (endTime - startTime));
    }

    private void makeExcelFile(String tempfileName, List<Map<String, Object>> list, int startRowIndex, int maxRowNum, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype, String modelFileName) throws Exception {
        int size = list.size();
        int row = size % maxRowNum;
        int fileNum = (size - row) / maxRowNum;
        long startTime = System.currentTimeMillis();
        ArrayList tempList = new ArrayList();
        int fileNumS = 0;
        int fileNumE = 0;
        int thread = fileNum;
        for (int i = 0; i < fileNum; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> tempList1 = new ArrayList<Map<String, Object>>();
            fileNumS = startRowIndex + i * maxRowNum;
            for (int j = maxRowNum * i; j < maxRowNum * (i + 1); ++j) {
                tempList1.add(list.get(j));
            }
            fileNumE = startRowIndex + maxRowNum * (i + 1) - 1;
            map.put("filename", tempfileName + "(" + fileNumS + '-' + fileNumE + ")");
            map.put("data", tempList1);
            tempList.add(map);
        }
        if (row > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> tempList1 = new ArrayList<Map<String, Object>>();
            fileNumS = startRowIndex + maxRowNum * fileNum;
            for (int j = maxRowNum * fileNum; j < size; ++j) {
                tempList1.add(list.get(j));
            }
            fileNumE = startRowIndex + size - 1;
            map.put("filename", tempfileName + "(" + fileNumS + '-' + fileNumE + ")");
            map.put("data", tempList1);
            tempList.add(map);
            ++thread;
        }
        ExecutorService exe = Executors.newFixedThreadPool(thread);
        for (int x = 0; x < tempList.size(); ++x) {
            exe.execute(new writeFileClass((String)((Map)tempList.get(x)).get("filename"), (List)((Map)tempList.get(x)).get("data"), fldlst, disps, fmts, exceltype, modelFileName));
        }
        exe.shutdown();
        while (!exe.isTerminated()) {
            Thread.sleep(50L);
        }
        long endTime = System.currentTimeMillis();
        System.out.println(size + "\u884c\u6570\u636e\u5199\u5165\u6587\u4ef6\u5b8c\u6210\u65f6\u95f4:" + (endTime - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total) {
        FMybatisTemplate storage = null;
        List list = null;
        try {
            Map map;
            storage = this.getStorageOperations(FMybatisTemplate.class);
            if (param != null && (map = (Map)param).containsKey("ds")) {
                storage = this.getStorageOperations(map.get("ds").toString(), FMybatisTemplate.class);
            }
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            if (rowBounds == null) {
                List list2 = list = db.selectList(queryid, param);
                return list2;
            }
            list = db.selectList(queryid, param, rowBounds);
            if (total != null) {
                total.append(((Page)list).getTotal());
            }
            List list3 = list;
            return list3;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public String makezip(List<String> filelist, String sumNum) throws IOException {
        File file;
        String trackkey;
        String filename = trackkey = this.sdfymdCard.format(new Date());
        if (!StringUtils.isEmpty((Object)sumNum)) {
            filename = filename + "(\u5408\u8ba1" + sumNum + "\u6761)";
        }
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < filelist.size(); ++i) {
            file = new File(filelist.get(i));
            files.add(file);
        }
        String name = this.filePath + filename + ".rar";
        file = new File(name);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fous = new FileOutputStream(file);
        ZipOutputStream zipOut = new ZipOutputStream(fous);
        this.zipFile(files, zipOut);
        zipOut.close();
        fous.close();
        for (File temp : files) {
            if (!temp.isFile() || !temp.exists()) continue;
            temp.delete();
        }
        return name;
    }

    private void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            this.zipFile(file, outputStream);
        }
    }

    private void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block7: {
            try {
                if (!inputFile.exists()) break block7;
                if (inputFile.isFile()) {
                    int nNumber;
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                    bins.close();
                    IN.close();
                    break block7;
                }
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        this.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String exportTemplate(ServiceSession session, JSONObject jsonparam) throws Exception {
        String excel;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        String billmoduleid = jsonparam.getString("billmoduleid");
        Map<String, String> config = ExcelUtils.getimpconfig(billmoduleid);
        String filename = config.get("file");
        String head = config.get("head");
        ArrayList<String> fldlst = new ArrayList<String>();
        String[] headfield = head.split(",");
        HashMap<String, String> disps = new HashMap<String, String>();
        int i = 0;
        for (String s : headfield) {
            fldlst.add(String.valueOf(i));
            disps.put(String.valueOf(i), s);
            ++i;
        }
        String exceltype = null;
        exceltype = StringUtils.isEmpty((Object)jsonparam.getString("filetype")) ? STATIC_XLSX : ("1".equals(excel = jsonparam.getString("filetype")) ? STATIC_XLS : STATIC_XLSX);
        String modelFileName = "";
        if (!StringUtils.isEmpty((Object)jsonparam.getString("modelfilename"))) {
            modelFileName = jsonparam.getString("modelfilename");
        }
        filename = filename + this.sdfymdCard.format(new Date());
        return this.createExcel(null, filename, fldlst, disps, null, exceltype, modelFileName);
    }

    public String exportTxt(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        String queryid = jsonparam.getString("queryid");
        List<Map<String, Object>> list = this.doQuery(queryid, jsonparam, null, null);
        return this.createTxt(list, jsonparam.getString("filename"), jsonparam.getString("fields"));
    }

    private String createTxt(List<Map<String, Object>> list, String fileName, String fields) throws Exception {
        File dir = new File(this.filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        StringBuffer sb = new StringBuffer("");
        String tempTxtFile = "";
        tempTxtFile = fileName + ".txt";
        this.getFileContext(list, fields, sb);
        this.saveAsFileWriterGbk(sb.toString(), tempTxtFile);
        return tempTxtFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsFileWriterGbk(String content, String filename) {
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "GBK"));
            out.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsFileWriterUtf(String content, String filename) {
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            out.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private Object getValue(Object value) {
        return StringUtils.isEmpty((Object)value) ? "" : value;
    }

    private String getFileContext(List<Map<String, Object>> map, String fields, StringBuffer sb) {
        sb.setLength(0);
        String[] list = fields.split(",");
        for (Map<String, Object> temp : map) {
            for (int i = 0; i < list.length; ++i) {
                if (i + 1 == list.length) {
                    sb.append(this.getValue(temp.get(list[i])));
                    continue;
                }
                sb.append(this.getValue(temp.get(list[i]))).append("\t");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public String exportLC(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (jsonparam == null || jsonparam.equals((Object)"")) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        if (jsonparam.get((Object)"files") == null || jsonparam.get((Object)"files").equals("")) {
            throw new ServiceException("50000", "{0} {1} is empty", "", "files");
        }
        JSONArray files = jsonparam.getJSONArray("files");
        ArrayList<String> filelist = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            JSONObject json = files.getJSONObject(i);
            for (String key : jsonparam.keySet()) {
                if ("files".equals(key)) continue;
                json.put(key, (Object)jsonparam.getString(key));
            }
            json.put("ent_id", (Object)session.getEnt_id());
            String tempfilepath = this.exportTxt(session, json);
            filelist.add(tempfilepath);
        }
        return this.makezip(filelist, null);
    }

    public String exportNC(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (jsonparam == null || jsonparam.equals((Object)"")) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        String name = this.sdfymdCard.format(new Date());
        HashMap<String, String> param = new HashMap<String, String>();
        HashMap<String, String> param2 = new HashMap<String, String>();
        Iterator iterator = jsonparam.keySet().iterator();
        int i = 1;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            param.put(key, jsonparam.getString(key));
            param2.put(key, jsonparam.getString(key));
            if (i != true || StringUtils.isEmpty((Object)jsonparam.getString(key))) continue;
            name = jsonparam.getString(key);
            ++i;
        }
        param.put("o_filecontext", "");
        this.doQuery("select_ncdate", param, null, null);
        if ("1".equals(param.get("o_filecontext").toString())) {
            throw new ServiceException("10000", "[{0}]\u51ed\u8bc1\u6570\u636e\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!", name);
        }
        List<Map<String, Object>> list = this.doQuery("select_filecontext", param2, null, null);
        Map<String, Object> filecontext = null;
        if (list.size() == 0) {
            throw new ServiceException("10000", "[{0}]\u6ca1\u6709\u51ed\u8bc1\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!", name);
        }
        filecontext = list.get(0);
        if (filecontext.get("xmldata") == null || filecontext.get("xmldata").equals("")) {
            throw new ServiceException("10000", "[{0}]\u6ca1\u6709\u51ed\u8bc1\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!", name);
        }
        String filename = this.filePath + name + ".xml";
        this.saveAsFileWriterUtf(filecontext.get("xmldata").toString(), filename);
        return filename;
    }

    private HSSFSheet setSheetPaper(HSSFSheet sheet, String a4, String orientation) {
        sheet.setDisplayGridlines(false);
        if ("a4".equalsIgnoreCase(a4)) {
            this.defaultHigh = 25;
            this.defaultWidth = 4.0;
            sheet.setDefaultColumnWidth((short)this.defaultWidth);
            sheet.setDefaultRowHeightInPoints((float)this.defaultHigh);
            HSSFPrintSetup printSetup = sheet.getPrintSetup();
            printSetup.setPaperSize((short)9);
            if ("\u6a2a\u5411".equalsIgnoreCase(orientation)) {
                printSetup.setLandscape(true);
                this.COLUMN_MAX = 23;
            } else {
                printSetup.setLandscape(false);
                this.COLUMN_MAX = 15;
            }
        }
        return sheet;
    }

    private void changeRow(HSSFSheet sheet, int gread) {
        HSSFRow r = sheet.getRow(this.rowIndex);
        if (r != null) {
            r.setHeightInPoints((float)this.defaultHigh);
        }
        ++this.rowIndex;
        this.cellIndex = this.defaultGreadCell * gread;
        this.defaultHigh = 25;
    }

    private HSSFRow getRow(HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(this.rowIndex);
        if (row == null) {
            row = sheet.createRow(this.rowIndex);
        }
        return row;
    }

    private HSSFCellStyle title0Style(HSSFWorkbook xls, HSSFCellStyle cellStyle) {
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        HSSFFont ztFont = xls.createFont();
        ztFont.setItalic(false);
        ztFont.setColor((short)Short.MAX_VALUE);
        ztFont.setFontHeightInPoints((short)20);
        ztFont.setFontName("\u5b8b\u4f53");
        ztFont.setBoldweight((short)700);
        cellStyle.setFont((Font)ztFont);
        return cellStyle;
    }

    private HSSFCellStyle title1Style(HSSFWorkbook xls, HSSFCellStyle cellStyle) {
        cellStyle.setAlignment((short)1);
        cellStyle.setVerticalAlignment((short)1);
        HSSFFont ztFont = xls.createFont();
        ztFont.setItalic(false);
        ztFont.setColor((short)Short.MAX_VALUE);
        ztFont.setFontHeightInPoints((short)12);
        ztFont.setFontName("\u5b8b\u4f53");
        ztFont.setBoldweight((short)700);
        ztFont.setUnderline((byte)1);
        cellStyle.setFont((Font)ztFont);
        return cellStyle;
    }

    private Font setFont(HSSFWorkbook xls, String s) {
        HSSFFont ztFont = xls.createFont();
        switch (s) {
            case "default": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)10);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBoldweight((short)400);
                break;
            }
            case "title1": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)18);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBoldweight((short)700);
                break;
            }
            case "title2": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)16);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBoldweight((short)700);
                break;
            }
            case "title3": {
                ztFont.setItalic(false);
                ztFont.setColor((short)Short.MAX_VALUE);
                ztFont.setFontHeightInPoints((short)14);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBoldweight((short)700);
                break;
            }
            case "required": {
                ztFont.setItalic(false);
                ztFont.setColor((short)12);
                ztFont.setFontHeightInPoints((short)10);
                ztFont.setFontName("\u5b8b\u4f53");
                ztFont.setBoldweight((short)400);
                break;
            }
        }
        return ztFont;
    }

    private HSSFSheet setTilte(HSSFWorkbook xls, HSSFSheet sheet, String title, int gread) {
        HSSFRow row = null;
        HSSFCell cell = null;
        if (gread == 0) {
            row = sheet.createRow(this.rowIndex);
            cell = row.createCell(0);
            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(this.rowIndex, this.rowIndex, 0, this.COLUMN_MAX));
            cell = row.getCell(this.cellIndex);
            cell.setCellValue(title);
            cell.setCellStyle(this.title0Style(xls, xls.createCellStyle()));
        } else if (gread == 1) {
            row = sheet.createRow(this.rowIndex);
            cell = row.createCell(this.cellIndex);
            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(this.rowIndex, this.rowIndex, this.cellIndex, this.COLUMN_MAX));
            cell = row.getCell(this.cellIndex);
            cell.setCellValue(title);
            cell.setCellStyle(this.title1Style(xls, xls.createCellStyle()));
        }
        return sheet;
    }

    private HSSFCellStyle setCellDataFormate(HSSFWorkbook xls, HSSFCellStyle cellStyle, String s, String formate) {
        HSSFDataFormat format = xls.createDataFormat();
        switch (s) {
            case "\u6587\u672c": {
                cellStyle.setDataFormat(format.getFormat("@"));
                break;
            }
            case "\u8d27\u5e01": {
                cellStyle.setDataFormat(format.getFormat("\u00a5#,##0.00"));
                break;
            }
            case "\u65e5\u671f": {
                cellStyle.setDataFormat(format.getFormat(formate));
                break;
            }
            case "\u767e\u5206\u6bd4": {
                cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)formate));
                break;
            }
        }
        return cellStyle;
    }

    public float getregex(String charStr) {
        if (charStr == " ") {
            return 0.5f;
        }
        if (Pattern.compile("^[A-Za-z0-9]+$").matcher(charStr).matches()) {
            return 0.5f;
        }
        if (Pattern.compile("[\u4e00-\u9fa5]+$").matcher(charStr).matches()) {
            return 1.0f;
        }
        if (Pattern.compile("[^x00-xff]").matcher(charStr).matches()) {
            return 1.0f;
        }
        return 0.5f;
    }

    private HSSFSheet autoSetHeight(HSSFSheet sheet, Cell c, int length) {
        HSSFRow row = sheet.getRow(this.rowIndex);
        float fontCountInline = length * 5;
        float defaultRowHeight = 25.0f;
        float defaultCount = 0.0f;
        String str = c.toString();
        for (int i = 0; i < str.length(); ++i) {
            float ff = this.getregex(str.substring(i, i + 1));
            defaultCount += ff;
        }
        int rwsTemp = (int)((float)((int)(defaultCount / fontCountInline)) * defaultRowHeight);
        if (this.defaultHigh < rwsTemp) {
            this.defaultHigh = rwsTemp;
            row.setHeight((short)(rwsTemp * 25));
        }
        return sheet;
    }

    private HSSFSheet setFormCell(HSSFWorkbook xls, HSSFSheet sheet, String type, JSONObject column, int length) throws ParseException {
        HSSFCell cell = this.getRow(sheet).createCell(this.cellIndex);
        if (length > 0) {
            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(this.rowIndex, this.rowIndex, this.cellIndex, this.cellIndex + length));
            cell = this.getRow(sheet).getCell(this.cellIndex);
            this.cellIndex += length;
        }
        HSSFCellStyle cellStyle = xls.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setVerticalAlignment((short)1);
        if ("text".equals(type)) {
            String required = column.getString("required");
            if (required == null || required.equalsIgnoreCase("false")) {
                cellStyle.setFont(this.setFont(xls, "default"));
            } else {
                cellStyle.setFont(this.setFont(xls, "required"));
            }
            String labelAlign = column.getString("labelAlign");
            if (labelAlign == null || labelAlign.equalsIgnoreCase(STATIC_RIGHT)) {
                cellStyle.setAlignment((short)3);
            } else if (labelAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment((short)1);
            } else if (labelAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment((short)2);
            } else {
                cellStyle.setAlignment((short)3);
            }
            cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
            cell.setCellValue(column.getString("label"));
        } else if ("value".equals(type)) {
            cellStyle.setFont(this.setFont(xls, "default"));
            String dataAlign = column.getString("dataAlign");
            if (dataAlign == null || dataAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment((short)1);
            } else if (dataAlign.equalsIgnoreCase("rigth")) {
                cellStyle.setAlignment((short)3);
            } else if (dataAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment((short)2);
            }
            cellStyle.setVerticalAlignment((short)1);
            String fmt = column.getString("format");
            String datatype = column.getString("datatype");
            if (datatype.startsWith("s")) {
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
                cell.setCellValue(column.getString("data"));
            } else if (datatype.startsWith("d")) {
                Date date = null;
                String datestyle = "yyyy-MM-dd";
                if (fmt.length() > 10) {
                    datestyle = "yyyy-MM-dd HH:mm:ss";
                }
                HSSFDataFormat format = xls.createDataFormat();
                cellStyle.setDataFormat(format.getFormat(datestyle));
                SimpleDateFormat sdf = new SimpleDateFormat(datestyle);
                if (column.getString("data") != null) {
                    date = sdf.parse(column.getString("data"));
                    cell.setCellValue(date);
                }
            }
        }
        cell.setCellStyle(cellStyle);
        sheet = this.autoSetHeight(sheet, (Cell)cell, length + 1);
        ++this.cellIndex;
        return sheet;
    }

    private HSSFSheet setGridCell(HSSFWorkbook xls, HSSFSheet sheet, String type, JSONObject column, JSONObject data, int length) throws ParseException {
        HSSFCell cell = this.getRow(sheet).createCell(this.cellIndex);
        if (length > 0) {
            CellRangeAddress cra = new CellRangeAddress(this.rowIndex, this.rowIndex, this.cellIndex, this.cellIndex + length);
            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)cra);
            int border = 1;
            RegionUtil.setBorderBottom((int)border, (org.apache.poi.ss.util.CellRangeAddress)cra, (Sheet)sheet, (Workbook)xls);
            RegionUtil.setBorderLeft((int)border, (org.apache.poi.ss.util.CellRangeAddress)cra, (Sheet)sheet, (Workbook)xls);
            RegionUtil.setBorderTop((int)border, (org.apache.poi.ss.util.CellRangeAddress)cra, (Sheet)sheet, (Workbook)xls);
            RegionUtil.setBorderRight((int)border, (org.apache.poi.ss.util.CellRangeAddress)cra, (Sheet)sheet, (Workbook)xls);
            cell = this.getRow(sheet).getCell(this.cellIndex);
            this.cellIndex += length;
        }
        HSSFCellStyle cellStyle = xls.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setVerticalAlignment((short)1);
        if ("text".equals(type)) {
            String required = column.getString("required");
            if (required == null || required.equalsIgnoreCase("false")) {
                cellStyle.setFont(this.setFont(xls, "default"));
            } else {
                cellStyle.setFont(this.setFont(xls, "required"));
            }
            String labelAlign = column.getString("labelAlign");
            if (labelAlign == null || labelAlign.equalsIgnoreCase(STATIC_RIGHT)) {
                cellStyle.setAlignment((short)3);
            } else if (labelAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment((short)1);
            } else if (labelAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment((short)2);
            }
            cell.setCellValue(column.getString("label"));
            cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
        } else if ("value".equals(type)) {
            cellStyle.setFont(this.setFont(xls, "default"));
            String dataAlign = column.getString("dataAlign");
            if (dataAlign == null || dataAlign.equalsIgnoreCase(STATIC_LEFT)) {
                cellStyle.setAlignment((short)1);
            } else if (dataAlign.equalsIgnoreCase("rigth")) {
                cellStyle.setAlignment((short)3);
            } else if (dataAlign.equalsIgnoreCase(STATIC_CENTER)) {
                cellStyle.setAlignment((short)2);
            }
            String tp = column.getString("type");
            String datatype = column.getString("datatype");
            if (datatype.startsWith("s")) {
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u6587\u672c", null);
                if ("comboboxcolumn".equalsIgnoreCase(tp)) {
                    String s = null;
                    JSONArray j = column.getJSONArray("data");
                    for (int i = 0; i < j.size(); ++i) {
                        String ss = data.getString(column.getString("name"));
                        if (!ss.equals(j.getJSONObject(i).get((Object)"code"))) continue;
                        s = "[" + j.getJSONObject(i).get((Object)"code") + "]" + j.getJSONObject(i).get((Object)"name");
                    }
                    cell.setCellValue(s);
                } else {
                    cell.setCellValue(data.getString(column.getString("name")));
                }
            } else if (datatype.startsWith("d")) {
                String fmt = column.getString("format");
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u65e5\u671f", fmt.toLowerCase());
                SimpleDateFormat dateFormat = new SimpleDateFormat(fmt.toLowerCase());
                if (data.getString(column.getString("name")) != null) {
                    Date date = dateFormat.parse(data.getString(column.getString("name")));
                    cell.setCellValue(date);
                }
            } else if (datatype.startsWith("c")) {
                String fmt = column.getString("format");
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u8d27\u5e01", fmt);
                cell.setCellValue(data.getDouble(column.getString("name")).doubleValue());
            } else if (datatype.startsWith("p")) {
                String fmt = column.getString("format");
                if ("p2".equalsIgnoreCase(datatype)) {
                    fmt = "0.00%";
                } else if ("p4".equalsIgnoreCase(datatype)) {
                    fmt = "0.0000%";
                }
                cellStyle = this.setCellDataFormate(xls, cellStyle, "\u767e\u5206\u6bd4", fmt);
                cell.setCellValue(data.getDouble(column.getString("name")).doubleValue());
            }
        }
        cell.setCellStyle(cellStyle);
        sheet = this.autoSetHeight(sheet, (Cell)cell, length + 1);
        ++this.cellIndex;
        return sheet;
    }

    public String exportExcelPrint(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONArray jsona;
        if (session == null) {
            throw new ServiceException("50001", "session is empty", new Object[0]);
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            throw new ServiceException("50003", "param is empty", new Object[0]);
        }
        this.rowIndex = 0;
        this.cellIndex = 0;
        String a4 = jsonparam.getString("pagesize") == null ? "A4" : jsonparam.getString("pagesize");
        String orientation = jsonparam.getString("orientation") == null ? "\u6a2a\u5411" : jsonparam.getString("orientation");
        HSSFWorkbook xls = new HSSFWorkbook();
        HSSFSheet sheet = xls.createSheet("\u9ed8\u8ba4");
        sheet = this.setSheetPaper(sheet, a4, orientation);
        String bigtitle = jsonparam.getString("title");
        if (bigtitle != null && bigtitle != "") {
            sheet = this.setTilte(xls, sheet, bigtitle, 0);
            this.changeRow(sheet, 1);
        }
        if ((jsona = jsonparam.getJSONArray("items")) != null && jsona.size() > 0) {
            for (int i = 0; i < jsona.size(); ++i) {
                JSONArray columns;
                JSONArray ja;
                JSONObject jsono = jsona.getJSONObject(i);
                if (jsono == null) continue;
                String type = jsono.getString("type");
                if ("formgrid".equalsIgnoreCase(type)) {
                    ja = jsono.getJSONArray("items");
                    for (int j = 0; j < ja.size(); ++j) {
                        String title = ja.getJSONObject(j).getString("title");
                        if (title != null && title != "") {
                            sheet = this.setTilte(xls, sheet, title, 1);
                            this.changeRow(sheet, 1);
                        }
                        if ((columns = ja.getJSONObject(j).getJSONArray("columns")) == null || columns.size() <= 0) continue;
                        for (int k = 0; k < columns.size(); ++k) {
                            JSONObject col = columns.getJSONObject(k);
                            String visible = col.getString("visible");
                            if (visible != null && visible.equalsIgnoreCase("false")) continue;
                            int textcnt = (int)((double)this.COLUMN_MAX * this.defaulttextCell);
                            int valuecnt = (int)((double)this.COLUMN_MAX * (this.defaultRangCell - this.defaulttextCell));
                            if (this.COLUMN_MAX - this.cellIndex - textcnt - valuecnt < 0) {
                                this.changeRow(sheet, 1);
                            }
                            sheet = this.setFormCell(xls, sheet, "text", col, textcnt);
                            sheet = this.setFormCell(xls, sheet, "value", col, valuecnt);
                            if (!"100".equalsIgnoreCase(col.getString("width"))) continue;
                            this.changeRow(sheet, 1);
                        }
                        this.changeRow(sheet, 1);
                    }
                    continue;
                }
                if ("gridbox".equalsIgnoreCase(type)) {
                    ja = jsono.getJSONArray("items");
                    String title = jsono.getString("title");
                    if (title != null && title != "") {
                        sheet = this.setTilte(xls, sheet, title, 1);
                        this.changeRow(sheet, 1);
                    }
                    for (int j = 0; j < ja.size(); ++j) {
                        columns = ja.getJSONObject(j).getJSONArray("columns");
                        if (columns != null && columns.size() > 0) {
                            for (int k = 0; k < columns.size(); ++k) {
                                JSONObject col = columns.getJSONObject(k);
                                String visible = col.getString("visible");
                                String name = col.getString("label");
                                if (visible != null && visible.equalsIgnoreCase("false") || name == null) continue;
                                int textcnt = 2;
                                sheet = this.setGridCell(xls, sheet, "text", col, null, textcnt);
                            }
                            this.changeRow(sheet, 1);
                            JSONArray data = ja.getJSONObject(j).getJSONArray("data");
                            if (data != null && data.size() > 0) {
                                for (int k = 0; k < data.size(); ++k) {
                                    for (int m = 0; m < columns.size(); ++m) {
                                        String name;
                                        JSONObject col = columns.getJSONObject(m);
                                        String visible = col.getString("visible");
                                        if (visible != null && visible.equalsIgnoreCase("false") || (name = col.getString("label")) == null) continue;
                                        int textcnt = 2;
                                        sheet = this.setGridCell(xls, sheet, "value", col, data.getJSONObject(k), textcnt);
                                    }
                                    this.changeRow(sheet, 1);
                                }
                            }
                        }
                        this.changeRow(sheet, 1);
                    }
                    continue;
                }
                throw new Exception("type \u6ca1\u6709\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        String tempExcelFilename = this.filePath + UniqueID.getUniqueID() + ".xls";
        FileOutputStream fos = new FileOutputStream(tempExcelFilename);
        xls.write((OutputStream)fos);
        fos.flush();
        fos.close();
        return tempExcelFilename;
    }

    private void analyzeExportFields2(String specfld, StringBuffer flds, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts) {
        String[] fields;
        specfld = specfld.replace("%2B", "+");
        specfld = specfld.replace("%26", "&");
        specfld = specfld.replace("%23", "#");
        for (String s : fields = specfld.split(",")) {
            String[] ss = s.split("::");
            if (!"totalCount".equals(ss[0].trim()) && !"modulecode".equals(ss[0].trim())) {
                flds.append(ss[0].trim() + ",");
                fldlst.add(ss[0].trim());
            }
            if (ss.length > 1) {
                disps.put(ss[0].trim(), ss[1].trim());
                if (ss.length <= 2) continue;
                fmts.put(ss[0].trim(), ss[2].trim().replace(";", ","));
                continue;
            }
            disps.put(ss[0].trim(), ss[0].trim());
        }
    }

    public void createExportLog(ServiceSession session, String param, String modulecode, String fileName, long dataNum) throws Exception {
        try {
            FMybatisTemplate storage = this.getStorageOperations(FMybatisTemplate.class);
            String userid = Long.toString(session.getUser_id());
            String usercode = session.getUser_code();
            String postid = session.getPostid();
            HashMap<String, Object> exportlog = new HashMap<String, Object>();
            exportlog.put("opdate", new Date());
            exportlog.put("userid", userid);
            exportlog.put("usercode", usercode);
            exportlog.put("postid", postid);
            exportlog.put("moduleid", modulecode);
            exportlog.put("param", param);
            exportlog.put("total", dataNum);
            exportlog.put("expfilename", fileName);
            exportlog.put("ent_id", session.getEnt_id());
            storage.insert(exportlog, "dbusrsys.reportexplog");
            storage.getSqlDbSession().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getModelFile(String filename) throws IOException {
        File input = new File(filename);
        InputStream in = null;
        try {
            if (!input.exists()) {
                URL fps = new URL(filename);
                input = new File(fps.toURI());
            }
            in = new FileInputStream(input);
        }
        catch (Exception ex) {
            try {
                in = IniReader.class.getClassLoader().getResourceAsStream(filename);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        return in;
    }

    private void delFile(File fp) {
        try {
            if (fp.exists() && fp.isFile()) {
                boolean result = fp.delete();
                int tryCount = 0;
                while (!result && tryCount++ < 10) {
                    System.gc();
                    result = fp.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static interface PageSize {

        public static interface A4 {
            public static final int crosswiseColumnCnt = 23;
            public static final int lengthwaysColumnCnt = 15;
            public static final double defaultWidth = 4.0;
            public static final int defaultHigh = 25;
        }
    }

    class writeFileClass
    extends Thread {
        private List<Map<String, Object>> list = null;
        private List<String> fldlst = null;
        private Map<String, String> fmts = null;
        private String exceltype = "";
        private String fileName = "";
        private Map<String, String> disps = null;
        private String modelFileName = null;

        writeFileClass(String fileName, List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype, String modelFileName) {
            this.list = list;
            this.fileName = fileName;
            this.fldlst = fldlst;
            this.fmts = fmts;
            this.disps = disps;
            this.exceltype = exceltype;
            this.modelFileName = modelFileName;
        }

        @Override
        public void run() {
            try {
                String file = FileServiceImpl.this.createExcel(this.list, this.fileName, this.fldlst, this.disps, this.fmts, this.exceltype, this.modelFileName);
                FileServiceImpl.this.addFile(file);
                System.out.println("\u6587\u4ef6:" + file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class queryMakeFile
    extends Thread {
        private Map<String, Object> para = null;
        private List<String> fldlst = null;
        private Map<String, String> fmts = null;
        private String exceltype = "";
        private String fileName = "";
        private Map<String, String> disps = null;
        private RowBounds rowBounds = null;
        private String modelFileName = null;

        queryMakeFile(String fileName, Map<String, Object> para, RowBounds rowBounds, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype, String modelFileName) {
            this.para = para;
            this.rowBounds = rowBounds;
            this.fileName = fileName;
            this.fldlst = fldlst;
            this.fmts = fmts;
            this.disps = disps;
            this.exceltype = exceltype;
            this.modelFileName = modelFileName;
        }

        @Override
        public void run() {
            try {
                StringBuffer total = new StringBuffer();
                List<Map<String, Object>> list = FileServiceImpl.this.doQuery(this.para.get("queryid").toString(), this.para, this.rowBounds, total);
                String file = FileServiceImpl.this.createExcel(list, this.fileName, this.fldlst, this.disps, this.fmts, this.exceltype, this.modelFileName);
                FileServiceImpl.this.addFile(file);
                System.out.println("\u6587\u4ef6:" + file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class MultTreadClass
    extends Thread {
        private int maxDataNum = 0;
        private int maxRowNum = 0;
        private List<String> fldlst = null;
        private Map<String, String> fmts = null;
        private String exceltype = "";
        private int page = 1;
        private int endPage = 1;
        private String queryid = "";
        private Map<String, Object> search = null;
        private String fileName = "";
        private Map<String, String> disps = null;
        private String modelFileName = "";

        MultTreadClass(String fileName, String queryid, Map<String, Object> search, int page, int endPage, int maxDataNum, int maxRowNum, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, String exceltype, String modelFileName) {
            this.maxDataNum = maxDataNum;
            this.maxRowNum = maxRowNum;
            this.fldlst = fldlst;
            this.disps = disps;
            this.fmts = fmts;
            this.exceltype = exceltype;
            this.page = page;
            this.queryid = queryid;
            this.search = search;
            this.fileName = fileName;
            this.endPage = endPage;
            this.modelFileName = modelFileName;
        }

        @Override
        public void run() {
            RowBounds rowBounds = new RowBounds((this.page - 1) * this.maxDataNum, this.maxDataNum);
            int startRowIndex = 1 + (this.page - 1) * this.maxDataNum;
            long searchTimeS = System.currentTimeMillis();
            List<Map<String, Object>> list = FileServiceImpl.this.doQuery(this.queryid, this.search, rowBounds, null);
            long searchTimeE = System.currentTimeMillis();
            int size = list.size();
            System.out.println("SQL(queryid:" + this.queryid + ")\u67e5\u8be2\u83b7\u53d6\u884c\u6570(" + size + ")\u65f6\u95f4:" + (searchTimeE - searchTimeS));
            if (size > 0) {
                try {
                    FileServiceImpl.this.makeExcelFile(this.fileName, list, startRowIndex, this.maxRowNum, this.fldlst, this.disps, this.fmts, this.exceltype, this.modelFileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

