/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.ResourceService;
import com.efuture.ocp.common.entity.Convert;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.FileInfo;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.util.MD5Utils;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.StringUtils;

public class MongoDBResourceServiceImpl
implements ResourceService {
    private GridFsTemplate gridFs;
    private GridFS gridFS;
    private String accessUrl;

    public MongoDBResourceServiceImpl(MongoDbFactory dbFactory) {
        this(null, dbFactory, null);
    }

    public MongoDBResourceServiceImpl(String accessUrl, MongoDbFactory dbFactory) {
        this(accessUrl, dbFactory, null);
    }

    public MongoDBResourceServiceImpl(String accessUrl, MongoDbFactory dbFactory, MongoConverter converter) {
        this(accessUrl, dbFactory, converter, null);
    }

    public MongoDBResourceServiceImpl(String accessUrl, MongoDbFactory dbFactory, MongoConverter converter, String bucket) {
        this.accessUrl = accessUrl;
        this.gridFs = new GridFsTemplate(dbFactory, converter == null ? MongoDBResourceServiceImpl.getDefaultMongoConverter(dbFactory) : converter, bucket);
        this.gridFS = new GridFS(dbFactory.getDb(), "default");
    }

    private static final MongoConverter getDefaultMongoConverter(MongoDbFactory factory) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)new MongoMappingContext());
        converter.afterPropertiesSet();
        return converter;
    }

    @Override
    public JSONObject upload(List<FileImportObject> list) throws Exception {
        JSONArray respdata = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            FileImportObject fio = list.get(i);
            String key = MD5Utils.MD5(fio.getFilename() + new Date());
            GridFSFile result = this.gridFs.store(fio.getStream(), key, fio.getFilename());
            System.out.println("upload md5: " + result.getMD5());
            JSONObject json = new JSONObject();
            json.put("file", (Object)fio.getFilename());
            json.put("url", (Object)this.buildUrl(key, fio.getServletrequest().getRequestURL().toString()));
            json.put("md5", (Object)result.getMD5());
            json.put("filename", (Object)result.getFilename());
            respdata.add((Object)json);
        }
        JSONObject json = new JSONObject();
        json.put("returncode", (Object)"0");
        json.put("data", (Object)respdata);
        if (respdata.size() > 0) {
            json.put("error", (Object)0);
            json.put("url", ((JSONObject)respdata.get(0)).get((Object)"url"));
        } else {
            json.put("error", (Object)1);
            json.put("message", (Object)"upload error!");
        }
        return json;
    }

    @Override
    public void uploadFile(byte[] data, FileInfo item) {
        GridFSInputFile mongofile = this.gridFS.createFile(data);
        mongofile.setFilename(item.getFileKey());
        mongofile.setContentType(item.getFileType());
        mongofile.put("filepath", (Object)item.getFilePath());
        mongofile.put("filefullname", (Object)item.getFileName());
        mongofile.put("filetype", (Object)item.getFileType());
        mongofile.put("filesize", (Object)item.getFileSize());
        mongofile.put("updatetime", (Object)item.getUpdateTime());
        mongofile.put("useraccount", (Object)item.getUserAccount());
        mongofile.save();
        System.out.println("Upload File to MongoDB:" + item.getFileKey());
    }

    @Override
    public void uploadFile2(File file, FileInfo item) throws IOException {
        GridFSInputFile mongofile = this.gridFS.createFile(file);
        mongofile.setFilename(item.getFileKey());
        mongofile.setContentType(item.getFileType());
        mongofile.put("filepath", (Object)item.getFilePath());
        mongofile.put("filefullname", (Object)item.getFileName());
        mongofile.put("filetype", (Object)item.getFileType());
        mongofile.put("filesize", (Object)item.getFileSize());
        mongofile.put("updatetime", (Object)item.getUpdateTime());
        mongofile.put("useraccount", (Object)item.getUserAccount());
        mongofile.save();
        System.out.println("Upload File to MongoDB:" + item.getFileKey());
    }

    private String buildUrl(String key, String defaulturl) {
        String url = null;
        if (!StringUtils.isEmpty((Object)this.accessUrl)) {
            url = this.accessUrl;
        } else {
            url = defaulturl;
            int n = url.lastIndexOf("/upload");
            if (n > 0) {
                url = url.substring(0, n);
            } else {
                n = url.lastIndexOf("/browse");
                if (n > 0) {
                    url = url.substring(0, n);
                }
            }
        }
        if (url.indexOf("{filekey}") > 0) {
            url = url.replace("{filekey}", key);
        } else {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + key;
        }
        System.out.println("file key: " + key);
        System.out.println("file url: " + url);
        return url;
    }

    @Override
    public ServiceResponse delete(String data) throws Exception {
        if (StringUtils.isEmpty((Object)data)) {
            return ServiceResponse.buildFailure(null, "50000", "data key is empty", new Object[0]);
        }
        this.gridFs.delete(new Query((CriteriaDefinition)Criteria.where((String)"filename").is((Object)data)));
        return ServiceResponse.buildSuccess(data);
    }

    @Override
    public InputStream get(String data, StringBuffer name, StringBuffer length) throws Exception {
        if (StringUtils.isEmpty((Object)data)) {
            return null;
        }
        GridFSDBFile object = this.gridFs.findOne(new Query((CriteriaDefinition)Criteria.where((String)"filename").is((Object)data)));
        if (object == null) {
            return null;
        }
        if (name != null && !StringUtils.isEmpty((Object)object.getContentType())) {
            name.append(object.getContentType());
        }
        if (length != null) {
            length.append(object.getLength());
        }
        return object.getInputStream();
    }

    @Override
    public ServiceResponse browse(int pageno, int pagesize, HttpServletRequest request) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        List objlist = this.gridFs.find(new Query());
        int i = (pageno - 1) * pagesize;
        for (int n = 0; i < objlist.size() && n < pagesize; ++i, ++n) {
            urls.add(this.buildUrl(((GridFSDBFile)objlist.get(i)).getFilename(), request.getRequestURL().toString()));
        }
        JSONObject data = new JSONObject();
        data.put("total", (Object)objlist.size());
        data.put("list", urls);
        return ServiceResponse.buildSuccess(data);
    }

    @Override
    public byte[] downloadFileBytes(String fileKey) throws IOException {
        ByteArrayOutputStream by = new ByteArrayOutputStream();
        GridFSDBFile gFile = this.gridFS.findOne(fileKey);
        if (gFile == null) {
            throw new RuntimeException("file not found!");
        }
        gFile.writeTo((OutputStream)by);
        byte[] data = by.toByteArray();
        return data;
    }

    @Override
    public FileInfo getFileInfo(String fileKey, String bucket) {
        FileInfo item = new FileInfo();
        GridFSDBFile gFile = this.gridFS.findOne(fileKey);
        if (gFile == null) {
            item.setFileKey(gFile.getFilename());
        }
        if (gFile.containsField("filepath")) {
            item.setFilePath(Convert.ToString(gFile.get("filepath")));
        }
        if (gFile.containsField("filefullname")) {
            item.setFileName(Convert.ToString(gFile.get("filefullname")));
        }
        if (gFile.containsField("filetype")) {
            item.setFileType(Convert.ToString(gFile.get("filetype")));
        }
        if (gFile.containsField("filesize")) {
            item.setFileSize(Convert.ToInt64(gFile.get("filesize")));
        }
        if (gFile.containsField("updatetime")) {
            item.setFilePath(Convert.ToString(gFile.get("updatetime")));
        }
        if (gFile.containsField("useraccount")) {
            item.setFilePath(Convert.ToString(gFile.get("useraccount")));
        }
        return item;
    }

    @Override
    public void deleteFile(String fileKey) {
        GridFSDBFile gFile = this.gridFS.findOne(fileKey);
        if (gFile == null) {
            return;
        }
        this.gridFS.remove((DBObject)gFile);
    }
}

