/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.bpm;

import com.alibaba.fastjson.JSON;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;
import java.util.Map;
import org.springframework.util.StringUtils;

public class BpmService {
    public static BpmService getBpmService() {
        return SpringBeanFactory.getBean("BpmService", BpmService.class);
    }

    public ServiceResponse submit(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.submit");
    }

    public ServiceResponse reject(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.reject");
    }

    public ServiceResponse approval(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.approval");
    }

    public ServiceResponse repeal(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.repeal");
    }

    public ServiceResponse gettask(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getusertask");
    }

    public ServiceResponse auditlog(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.sheetAuditLog");
    }

    public ServiceResponse getuserlist(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getuserlist");
    }

    public ServiceResponse getgrouplist(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getusergrouplist");
    }

    public ServiceResponse addtask(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.addTask");
    }

    public ServiceResponse getsubmitter(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getSubmitter");
    }

    public ServiceResponse processList(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getprocesslist");
    }

    public ServiceResponse getTaskByStarter(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getTaskByStarter");
    }

    public ServiceResponse getTaskByApprover(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getTaskByApprover");
    }

    public ServiceResponse getTaskByCc(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getTaskByCc");
    }

    public ServiceResponse getTaskListByApprover(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getTaskListByApprover");
    }

    public ServiceResponse callBpmService(Map<String, Object> bpmdata, String service) throws Exception {
        ServiceSession session = new ServiceSession();
        String bpmpara = JSON.toJSONString((Object)Utils.toNormalJSONObject(bpmdata));
        String processdefkey = StringUtils.isEmpty((Object)bpmdata.get("processdefkey")) ? "" : bpmdata.get("processdefkey").toString();
        String url = RestClientUtils.getRestUtils().queryServiceURI(service + "." + processdefkey);
        if (StringUtils.isEmpty((Object)url)) {
            url = service;
        }
        if (!StringUtils.isEmpty((Object)processdefkey) && "WYC".equalsIgnoreCase(processdefkey)) {
            String auth = bpmdata.get("auth").toString();
            bpmpara = bpmdata.get("sheet").toString();
            String rtn = HttpUtils.doPost(url, '[' + bpmpara + ']', auth);
            return null;
        }
        return RestClientUtils.getRestUtils().sendRequest(session, url, bpmpara);
    }

    static interface bpmservice {
        public static final String APPROVAL = "mss.bpm.approval";
        public static final String REJECT = "mss.bpm.reject";
        public static final String SUBMIT = "mss.bpm.submit";
        public static final String REPEAL = "mss.bpm.repeal";
        public static final String GETTASK = "mss.bpm.getusertask";
        public static final String GETSUBMITTER = "mss.bpm.getSubmitter";
        public static final String AUDITLOG = "mss.bpm.sheetAuditLog";
        public static final String GETUSERLIST = "mss.bpm.getuserlist";
        public static final String GETGROUPLIST = "mss.bpm.getusergrouplist";
        public static final String GETPROCESSLIST = "mss.bpm.getprocesslist";
        public static final String ADDTASK = "mss.bpm.addTask";
        public static final String TASKBYSTARTER = "mss.bpm.getTaskByStarter";
        public static final String TASKBYAPPROVER = "mss.bpm.getTaskByApprover";
        public static final String TASKBYCC = "mss.bpm.getTaskByCc";
        public static final String TASKLISTBYAPPROVER = "mss.bpm.getTaskListByApprover";
    }
}

