/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache;

import com.efuture.ocp.common.cache.CacheConfig;
import com.efuture.ocp.common.cache.CacheUtilsInMemory;
import com.efuture.ocp.common.cache.CacheUtilsInMemoryObject;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.rubyeye.xmemcached.GetsResponse;
import org.springframework.util.StringUtils;

public abstract class CacheUtils {
    protected CacheConfig config;

    public CacheConfig getConfig() {
        return this.config;
    }

    public void setConfig(CacheConfig config) {
        this.config = config;
    }

    public abstract String putData(String var1, Object var2, int var3);

    public abstract Object getData(String var1);

    public abstract Object getCacheData(String var1);

    public abstract boolean deleteData(String var1);

    public abstract long getCasValue(String var1);

    public abstract GetsResponse getCasData(String var1);

    public abstract boolean putbyCas(String var1, Object var2, int var3, long var4);

    public abstract Object getCacheType();

    public abstract boolean pushQueue(String var1, String var2);

    public abstract String pullQueue(String var1);

    protected long addElapsed(List<String> elapsed, String msg, long start_time, long end_time) {
        elapsed.add(msg + ": " + (end_time - start_time) + " ms");
        return System.currentTimeMillis();
    }

    public String putDataByElapsed(String key, Object object, int timeout, List<String> elapsed) {
        return this.putData(key, object, timeout);
    }

    public Object getDataByElapsed(String key, List<String> elapsed) {
        return this.getData(key);
    }

    public String buildCachedKey(String prefix) {
        String key = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        if (StringUtils.isEmpty((Object)prefix)) {
            return key;
        }
        return prefix.concat(key);
    }

    public String putData(Object object) {
        return this.putData(object, 86400);
    }

    public String putData(Object object, int timeout) {
        String key = this.buildCachedKey(null);
        return CacheUtils.getCacheUtils().putData(key, object, timeout);
    }

    public String putDataPrefix(String prefix, Object object, int timeout) {
        String key = this.buildCachedKey(prefix);
        return CacheUtils.getCacheUtils().putData(key, object, timeout);
    }

    public Map<String, Object> getBatchData(List<String> keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            result.put(key, this.getData(key));
        }
        return result;
    }

    public static CacheUtils getCacheUtils() {
        return SpringBeanFactory.getBean("CacheUtils", CacheUtils.class);
    }

    public static CacheUtils getCacheUtils(String cacheLevel) {
        if ("MEM".equalsIgnoreCase(cacheLevel)) {
            return CacheUtils.getInMemUtils();
        }
        return CacheUtils.getCacheUtils();
    }

    public static CacheUtils getInMemUtils(String cacheMemoryMode) {
        if ("BIN".equalsIgnoreCase(cacheMemoryMode)) {
            return (CacheUtils)SpringBeanFactory.getContext().getBean(CacheUtilsInMemory.class);
        }
        return (CacheUtils)SpringBeanFactory.getContext().getBean(CacheUtilsInMemoryObject.class);
    }

    public static CacheUtils getInMemUtils() {
        return CacheUtils.getInMemUtils("BIN");
    }

    public static CacheUtilsRediscached getRedisUtils() {
        return SpringBeanFactory.getBean("CacheRedis", CacheUtilsRediscached.class);
    }

    public boolean AddData(String key, Object object, int timeout) {
        return false;
    }

    public int deleteBatch(String key) {
        return 0;
    }

    public abstract Long incr(String var1);

    public static interface MemoryMode {
        public static final String BIN = "BIN";
        public static final String OBJ = "OBJ";
    }

    public static interface CacheType {
        public static final String INMEMORY = "memory";
        public static final String MEMCACHED = "memcached";
        public static final String REDIS = "redis";
        public static final String REDIS_SINGLE = "single";
        public static final String REDIS_SENTINEL = "sentinel";
        public static final String REDIS_CLUSTER = "cluster";
    }

    public static interface CacheLevel {
        public static final String Cache = "CACHE";
        public static final String Memory = "MEM";
    }

    public static interface CacheTimeOut {
        public static final int Min = 60;
        public static final int HalfHour = 1800;
        public static final int Hour = 3600;
        public static final int Day = 86400;
    }
}

