/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.proxy.EnterpriseConfigBean;
import com.efuture.ocp.common.util.MD5Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class HttpJStore {
    private static final Logger logger = Logger.getLogger(HttpJStore.class);

    public static JSONObject invoke(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes, JSONArray valDatas, boolean isArray) throws Exception {
        String sign = null;
        String client = ent.getSrvConfig("appId", true);
        String exeinfo = "";
        String para = "";
        String compression = "0";
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        JSONObject json = new JSONObject();
        json.put("SHOPID", (Object)ent.getSrvConfig("shop_id", false));
        json.put("USERID", (Object)ent.getSrvConfig("user_id", false));
        exeinfo = json.toJSONString();
        JSONObject jsonpara = new JSONObject();
        jsonpara.put("COLUMNTYPE", (Object)valTypes);
        jsonpara.put("PARAMETER", (Object)valDatas);
        json.clear();
        json.put(apiKey, (Object)jsonpara);
        para = json.toJSONString();
        String md5Str = ent.getSrvConfig("appKey", true).concat("apiid").concat(apiid).concat("client").concat(client).concat("compression").concat(compression).concat("exeinfo").concat(exeinfo).concat("para").concat(para).concat("timestamp").concat(timestamp).concat(ent.getSrvConfig("appKey", true));
        sign = MD5Utils.MD5(md5Str);
        long time = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append("apiid=");
        sb.append(apiid);
        sb.append("&");
        sb.append("client=");
        sb.append(client);
        sb.append("&");
        sb.append("compression=");
        sb.append(compression);
        sb.append("&");
        sb.append("exeinfo=");
        sb.append(exeinfo);
        sb.append("&");
        sb.append("para=");
        sb.append(URLEncoder.encode(para, "UTF-8"));
        sb.append("&");
        sb.append("sign=");
        sb.append(sign);
        sb.append("&");
        sb.append("timestamp=");
        sb.append(timestamp);
        String content = sb.toString();
        logger.info((Object)("jstore.client.url: " + ent.getBase_url()));
        logger.info((Object)("jstore.client.data: " + content));
        String result = HttpJStore.getResult(ent.getBase_url(), content, "UTF-8");
        logger.info((Object)("jstore.client.result: " + result));
        logger.info((Object)("jstore.client.elapsed: " + (System.currentTimeMillis() - time) + " ms"));
        if (result != null) {
            json = JSON.parseObject((String)result);
            if (!"1".equals(json.getString("status"))) {
                throw new ServiceException("10000", json.getString("info"), new Object[0]);
            }
        } else {
            throw new RuntimeException("No result!");
        }
        JSONObject jsonData = HttpJStore.parseJStoreData(json = JSON.parseObject((String)json.getString("value")), apiKey);
        if (jsonData.containsKey((Object)apiKey)) {
            int code;
            if (jsonData.getJSONArray(apiKey).size() > 0 && jsonData.getJSONArray(apiKey).getJSONObject(0).containsKey((Object)"code") && (code = jsonData.getJSONArray(apiKey).getJSONObject(0).getInteger("code").intValue()) != 0) {
                String msg = jsonData.getJSONArray(apiKey).getJSONObject(0).containsKey((Object)"msg") ? jsonData.getJSONArray(apiKey).getJSONObject(0).getString("msg") : "unknow error!";
                throw new ServiceException("10000", "\u8c03\u7528\u5931\u8d25\uff1a{0}-{1}", String.valueOf(code), msg);
            }
        } else {
            throw new ServiceException("10000", "\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff01", new Object[0]);
        }
        if (isArray) {
            return jsonData;
        }
        if (jsonData.getJSONArray(apiKey).size() > 0) {
            return jsonData.getJSONArray(apiKey).getJSONObject(0);
        }
        return new JSONObject();
    }

    public static JSONArray invoke(ServiceSession session, EnterpriseConfigBean ent, String apiid, String apiKey, JSONArray valTypes, JSONArray valDatas) throws Exception {
        JSONObject result = HttpJStore.invoke(session, ent, apiid, apiKey, valTypes, valDatas, true);
        return result.getJSONArray(apiKey);
    }

    protected static String getResult(String urlStr, String content, String encoding) throws IOException {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes(encoding));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static JSONObject parseJStoreData(JSONObject jsonData, String key) {
        List fields = (List)jsonData.getJSONObject(key).get((Object)"fieldName");
        JSONArray exec0 = jsonData.getJSONObject(key).getJSONArray("exec0");
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < exec0.size(); ++i) {
            JSONArray row = exec0.getJSONArray(i);
            JSONObject data = new JSONObject();
            for (int j = 0; j < row.size(); ++j) {
                data.put(((String)fields.get(j)).toLowerCase(), row.get(j));
            }
            resultArray.add((Object)data);
        }
        JSONObject result = new JSONObject();
        result.put(key, (Object)resultArray);
        return result;
    }
}

