/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.restclientext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.MD5Utils;
import com.efuture.ocp.common.util.RestClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Lazy(value=true)
@Component(value="RestClientUtils_OCMVX")
public class RestClientUtils_OCMVX
extends RestClientUtils {
    @Override
    public Map<String, Object> doOverWrite(Object session, String method, String url, Object param) throws Exception {
        if (!method.startsWith("http")) {
            return super.doOverWrite(session, method, url, param);
        }
        long entId = 0L;
        if (session != null && session instanceof ServiceSession) {
            entId = ((ServiceSession)session).getEnt_id();
        } else if (session != null && session instanceof Long) {
            entId = (Long)session;
        } else {
            throw new ServiceException("50000", "\u672a\u4f20\u5165\u4f01\u4e1a\u7f16\u53f7", new Object[0]);
        }
        String token = this.getVXToken(entId);
        String signStr = this.ent.getSrvConfig("vxAppKey", true) + "=" + this.ent.getSrvConfig("vxSecret", true) + "&body=" + param.toString();
        String sign = MD5Utils.MD5(signStr);
        url = url.concat("&app_key=").concat(this.ent.getSrvConfig("vxAppKey", true)).concat("&token=").concat(token).concat("&sign=").concat(sign);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", method);
        map.put("url", url);
        map.put("param", param);
        return map;
    }

    @AutoCache(Service="HGO", KeyArgIndex=0)
    public String getVXToken(long ent_id) throws Exception {
        String token_Url = this.ent.getSrvConfig("vxAuthUrl", true);
        JSONObject result = JSONObject.parseObject((String)HttpUtils.getRequest(token_Url));
        return DataUtils.getJsonData(result, "apiToken", true, "");
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception {
        return this.sendRequest(session, method, param, "");
    }

    @Override
    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = this.sendRequest(session, method, param, new RestClientUtils.defaultRequestCallback(), traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = null;
            try {
                json = JSON.parseObject((String)((String)result));
            }
            catch (Exception ex) {
                json = new JSONObject();
                json.put("returncode", (Object)"50000");
                json.put("data", (Object)((String)result));
            }
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + traceprex + "]: ");
                sb.append(method + " , ");
                sb.append("RESPONSE: " + json.toJSONString());
                this.logger.info((Object)sb.toString());
            }
        }
        if (response == null) {
            throw new ServiceException("50000", (String)result, new Object[0]);
        }
        if (!"0".equals(response.getReturncode())) {
            throw new ServiceException(response.getReturncode(), response.getData().toString(), new Object[0]);
        }
        return response;
    }
}

